<?php
if (!defined('ABSPATH')) exit;

class ACE_BLP_Frontend {

    public function __construct() {
        add_action('wp_enqueue_scripts', array($this, 'dequeue_theme_assets'), 999);
        add_action('wp_head', array($this, 'output_meta'), 1);
    }

    public function dequeue_theme_assets() {
        if (!is_ace_backyard_lp()) return;

        // Dequeue theme styles and scripts to prevent visual conflicts
        // but keep tracking/analytics scripts intact
        wp_dequeue_style('ace-theme-style');
        wp_dequeue_style('ace-theme-main');
        wp_dequeue_style('ace-main-style');
        wp_dequeue_script('ace-theme-scripts');
        wp_dequeue_script('ace-theme-main');
        wp_dequeue_script('ace-main-js');

        // Dequeue common page builders if active
        wp_dequeue_style('elementor-frontend');
        wp_dequeue_style('elementor-common');
        wp_dequeue_script('elementor-frontend');
    }

    public function output_meta() {
        if (!is_ace_backyard_lp()) return;

        $s = get_option('ace_backyard_lp_settings', array());
        $title = !empty($s['seo_title']) ? esc_attr($s['seo_title']) : 'Backyard Remodeling - ACE Design & Build';
        $desc = !empty($s['seo_description']) ? esc_attr($s['seo_description']) : '';
        $og_image = !empty($s['og_image']) ? esc_url($s['og_image']) : '';

        echo '<title>' . $title . '</title>' . "\n";
        if ($desc) echo '<meta name="description" content="' . $desc . '">' . "\n";

        // Open Graph
        echo '<meta property="og:title" content="' . $title . '">' . "\n";
        echo '<meta property="og:type" content="website">' . "\n";
        if ($desc) echo '<meta property="og:description" content="' . $desc . '">' . "\n";
        if ($og_image) echo '<meta property="og:image" content="' . $og_image . '">' . "\n";
        echo '<meta property="og:url" content="' . esc_url(home_url('/' . ($s['slug'] ?? 'backyard') . '/')) . '">' . "\n";
    }

    public static function get_settings() {
        $settings = get_option('ace_backyard_lp_settings', array());
        if (empty($settings)) {
            $settings = ace_blp_get_defaults();
        }
        return $settings;
    }
}
