<?php
/**
 * Email notification template for new lead submissions.
 *
 * Variables available:
 *   $lead_data (array) - Associative array of lead field values.
 *
 * @package ACE_Theme_Manager
 * @since   1.0.0
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<title><?php esc_html_e( 'New Lead Notification', 'ace-theme-manager' ); ?></title>
</head>
<body style="margin: 0; padding: 0; background-color: #f4f5f7; font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif; -webkit-font-smoothing: antialiased;">

	<!-- Wrapper Table -->
	<table role="presentation" width="100%" cellpadding="0" cellspacing="0" border="0" style="background-color: #f4f5f7;">
		<tr>
			<td align="center" style="padding: 40px 20px;">

				<!-- Main Container -->
				<table role="presentation" width="600" cellpadding="0" cellspacing="0" border="0" style="max-width: 600px; width: 100%; background-color: #ffffff; border-radius: 8px; overflow: hidden; box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);">

					<!-- Header -->
					<tr>
						<td style="background-color: #1b2a4a; padding: 30px 40px; text-align: center;">
							<h1 style="margin: 0; font-size: 24px; font-weight: 700; color: #ffffff; letter-spacing: 1px;">
								ACE DESIGN + BUILD
							</h1>
							<p style="margin: 8px 0 0 0; font-size: 13px; color: #8b9dc3; letter-spacing: 0.5px;">
								<?php esc_html_e( 'New Lead Notification', 'ace-theme-manager' ); ?>
							</p>
						</td>
					</tr>

					<!-- Intro -->
					<tr>
						<td style="padding: 32px 40px 16px 40px;">
							<p style="margin: 0; font-size: 15px; color: #333333; line-height: 1.6;">
								<?php
								printf(
									/* translators: %s: Lead full name. */
									esc_html__( 'A new lead has been submitted by %s. Details are below.', 'ace-theme-manager' ),
									'<strong>' . esc_html( $lead_data['full_name'] ) . '</strong>'
								);
								?>
							</p>
						</td>
					</tr>

					<!-- Lead Details Table -->
					<tr>
						<td style="padding: 8px 40px 32px 40px;">
							<table role="presentation" width="100%" cellpadding="0" cellspacing="0" border="0" style="border: 1px solid #e2e6ed; border-radius: 6px; overflow: hidden;">

								<!-- Name -->
								<tr>
									<td style="padding: 12px 16px; background-color: #f8f9fb; font-size: 13px; font-weight: 600; color: #5a6577; width: 140px; border-bottom: 1px solid #e2e6ed; vertical-align: top;">
										<?php esc_html_e( 'Name', 'ace-theme-manager' ); ?>
									</td>
									<td style="padding: 12px 16px; font-size: 14px; color: #1a1a1a; border-bottom: 1px solid #e2e6ed; vertical-align: top;">
										<?php echo esc_html( $lead_data['full_name'] ); ?>
									</td>
								</tr>

								<!-- Phone -->
								<tr>
									<td style="padding: 12px 16px; background-color: #f8f9fb; font-size: 13px; font-weight: 600; color: #5a6577; border-bottom: 1px solid #e2e6ed; vertical-align: top;">
										<?php esc_html_e( 'Phone', 'ace-theme-manager' ); ?>
									</td>
									<td style="padding: 12px 16px; font-size: 14px; color: #1a1a1a; border-bottom: 1px solid #e2e6ed; vertical-align: top;">
										<a href="tel:<?php echo esc_attr( $lead_data['phone'] ); ?>" style="color: #1b2a4a; text-decoration: none;">
											<?php echo esc_html( $lead_data['phone'] ); ?>
										</a>
									</td>
								</tr>

								<!-- Email -->
								<tr>
									<td style="padding: 12px 16px; background-color: #f8f9fb; font-size: 13px; font-weight: 600; color: #5a6577; border-bottom: 1px solid #e2e6ed; vertical-align: top;">
										<?php esc_html_e( 'Email', 'ace-theme-manager' ); ?>
									</td>
									<td style="padding: 12px 16px; font-size: 14px; color: #1a1a1a; border-bottom: 1px solid #e2e6ed; vertical-align: top;">
										<a href="mailto:<?php echo esc_attr( $lead_data['email'] ); ?>" style="color: #1b2a4a; text-decoration: none;">
											<?php echo esc_html( $lead_data['email'] ); ?>
										</a>
									</td>
								</tr>

								<!-- Service -->
								<?php if ( ! empty( $lead_data['service'] ) ) : ?>
								<tr>
									<td style="padding: 12px 16px; background-color: #f8f9fb; font-size: 13px; font-weight: 600; color: #5a6577; border-bottom: 1px solid #e2e6ed; vertical-align: top;">
										<?php esc_html_e( 'Service', 'ace-theme-manager' ); ?>
									</td>
									<td style="padding: 12px 16px; font-size: 14px; color: #1a1a1a; border-bottom: 1px solid #e2e6ed; vertical-align: top;">
										<?php echo esc_html( $lead_data['service'] ); ?>
									</td>
								</tr>
								<?php endif; ?>

								<!-- Preferred Contact -->
								<?php if ( ! empty( $lead_data['preferred_contact'] ) ) : ?>
								<tr>
									<td style="padding: 12px 16px; background-color: #f8f9fb; font-size: 13px; font-weight: 600; color: #5a6577; border-bottom: 1px solid #e2e6ed; vertical-align: top;">
										<?php esc_html_e( 'Preferred Contact', 'ace-theme-manager' ); ?>
									</td>
									<td style="padding: 12px 16px; font-size: 14px; color: #1a1a1a; border-bottom: 1px solid #e2e6ed; vertical-align: top;">
										<?php echo esc_html( ucfirst( $lead_data['preferred_contact'] ) ); ?>
									</td>
								</tr>
								<?php endif; ?>

								<!-- Message -->
								<?php if ( ! empty( $lead_data['message'] ) ) : ?>
								<tr>
									<td style="padding: 12px 16px; background-color: #f8f9fb; font-size: 13px; font-weight: 600; color: #5a6577; border-bottom: 1px solid #e2e6ed; vertical-align: top;">
										<?php esc_html_e( 'Message', 'ace-theme-manager' ); ?>
									</td>
									<td style="padding: 12px 16px; font-size: 14px; color: #1a1a1a; line-height: 1.6; border-bottom: 1px solid #e2e6ed; vertical-align: top;">
										<?php echo nl2br( esc_html( $lead_data['message'] ) ); ?>
									</td>
								</tr>
								<?php endif; ?>

								<!-- Source Page -->
								<?php if ( ! empty( $lead_data['source_page'] ) ) : ?>
								<tr>
									<td style="padding: 12px 16px; background-color: #f8f9fb; font-size: 13px; font-weight: 600; color: #5a6577; border-bottom: 1px solid #e2e6ed; vertical-align: top;">
										<?php esc_html_e( 'Source Page', 'ace-theme-manager' ); ?>
									</td>
									<td style="padding: 12px 16px; font-size: 14px; color: #1a1a1a; border-bottom: 1px solid #e2e6ed; vertical-align: top;">
										<?php
										if ( ! empty( $lead_data['source_url'] ) ) {
											echo '<a href="' . esc_url( $lead_data['source_url'] ) . '" style="color: #1b2a4a;">' . esc_html( $lead_data['source_page'] ) . '</a>';
										} else {
											echo esc_html( $lead_data['source_page'] );
										}
										?>
									</td>
								</tr>
								<?php endif; ?>

								<!-- Submitted At -->
								<tr>
									<td style="padding: 12px 16px; background-color: #f8f9fb; font-size: 13px; font-weight: 600; color: #5a6577; vertical-align: top;">
										<?php esc_html_e( 'Submitted', 'ace-theme-manager' ); ?>
									</td>
									<td style="padding: 12px 16px; font-size: 14px; color: #1a1a1a; vertical-align: top;">
										<?php echo esc_html( $lead_data['created_at'] ); ?>
									</td>
								</tr>

							</table>
						</td>
					</tr>

					<!-- CTA Button -->
					<tr>
						<td align="center" style="padding: 0 40px 32px 40px;">
							<?php
							$admin_leads_url = admin_url( 'admin.php?page=ace-leads' );
							if ( ! empty( $lead_data['id'] ) ) {
								$admin_leads_url = add_query_arg( 'lead_id', (int) $lead_data['id'], $admin_leads_url );
							}
							?>
							<a href="<?php echo esc_url( $admin_leads_url ); ?>" style="display: inline-block; padding: 12px 32px; background-color: #1b2a4a; color: #ffffff; font-size: 14px; font-weight: 600; text-decoration: none; border-radius: 5px; letter-spacing: 0.3px;">
								<?php esc_html_e( 'View in Dashboard', 'ace-theme-manager' ); ?>
							</a>
						</td>
					</tr>

					<!-- Footer -->
					<tr>
						<td style="background-color: #f8f9fb; padding: 24px 40px; border-top: 1px solid #e2e6ed;">
							<p style="margin: 0; font-size: 12px; color: #8b95a5; text-align: center; line-height: 1.6;">
								<?php esc_html_e( 'This is an automated notification from your ACE website.', 'ace-theme-manager' ); ?>
								<br>
								<?php esc_html_e( 'Please do not reply directly to this email.', 'ace-theme-manager' ); ?>
							</p>
						</td>
					</tr>

				</table>
				<!-- End Main Container -->

			</td>
		</tr>
	</table>
	<!-- End Wrapper Table -->

</body>
</html>
