<?php
/**
 * 404 Template
 * @package ACE_Theme
 */
get_header();
?>

<section class="section bg-white error-404-section">
    <div class="container">
        <div class="error-404-content text-center">
            <h1 class="error-404-title"><?php esc_html_e( 'Page Not Found', 'ace-theme' ); ?></h1>
            <p class="error-404-message"><?php esc_html_e( 'Sorry, the page you\'re looking for doesn\'t exist or has been moved. Let\'s get you back on track.', 'ace-theme' ); ?></p>
            <div class="error-404-actions">
                <a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="btn btn-primary"><?php esc_html_e( 'Back to Homepage', 'ace-theme' ); ?></a>
                <a href="<?php echo esc_url( home_url( '/services/' ) ); ?>" class="btn btn-secondary"><?php esc_html_e( 'View Our Services', 'ace-theme' ); ?></a>
            </div>
            <div class="error-404-search">
                <p><?php esc_html_e( 'Or try searching:', 'ace-theme' ); ?></p>
                <?php get_search_form(); ?>
            </div>
            <div class="error-404-services">
                <h3><?php esc_html_e( 'Popular Services', 'ace-theme' ); ?></h3>
                <div class="error-404-links">
                    <?php
                    $popular = array( 'kitchen-remodeling', 'bathroom-remodeling', 'full-home-remodeling', 'adu-accessory-dwelling-unit', 'swimming-pools', 'backyard-remodeling' );
                    $services = ace_get_services();
                    foreach ( $services as $s ) :
                        if ( in_array( $s['slug'], $popular, true ) ) : ?>
                            <a href="<?php echo esc_url( home_url( '/services/' . $s['slug'] . '/' ) ); ?>"><?php echo esc_html( $s['title'] ); ?></a>
                        <?php endif;
                    endforeach; ?>
                </div>
            </div>
        </div>
    </div>
</section>

<?php get_footer(); ?>
