<?php
/**
 * Blog Archive Template
 * @package ACE_Theme
 */
get_header();
?>

<section class="page-hero page-hero-sm">
    <div class="page-hero-overlay">
        <div class="container">
            <h1 class="page-hero-title">
                <?php
                if ( is_category() ) {
                    single_cat_title();
                } elseif ( is_tag() ) {
                    single_tag_title();
                } elseif ( is_search() ) {
                    printf( esc_html__( 'Search Results for: %s', 'ace-theme' ), get_search_query() );
                } else {
                    esc_html_e( 'Blog', 'ace-theme' );
                }
                ?>
            </h1>
        </div>
    </div>
</section>

<section class="section bg-white">
    <div class="container">
        <div class="blog-layout">
            <div class="blog-main">
                <?php if ( have_posts() ) : ?>
                    <div class="blog-grid-2col">
                        <?php while ( have_posts() ) : the_post(); ?>
                            <?php get_template_part( 'template-parts/blog-card' ); ?>
                        <?php endwhile; ?>
                    </div>

                    <!-- Pagination -->
                    <div class="pagination">
                        <?php
                        the_posts_pagination( array(
                            'mid_size'  => 2,
                            'prev_text' => '&laquo; ' . esc_html__( 'Previous', 'ace-theme' ),
                            'next_text' => esc_html__( 'Next', 'ace-theme' ) . ' &raquo;',
                        ) );
                        ?>
                    </div>
                <?php else : ?>
                    <div class="no-results">
                        <h2><?php esc_html_e( 'No Posts Found', 'ace-theme' ); ?></h2>
                        <p><?php esc_html_e( 'It seems we can\'t find what you\'re looking for. Try searching or browse our services.', 'ace-theme' ); ?></p>
                        <?php get_search_form(); ?>
                    </div>
                <?php endif; ?>
            </div>
            <?php get_sidebar(); ?>
        </div>
    </div>
</section>

<?php get_footer(); ?>
