<?php
/**
 * Footer template for ACE Theme
 *
 * Renders the closing main tag, optional CTA section, 4-column footer,
 * bottom bar with copyright, floating mobile CTA bar, and wp_footer().
 *
 * @package ACE_Theme
 * @since 1.0.0
 */
?>
</main><!-- #main-content -->

<?php
// Final CTA Section (skip on contact and thank-you pages).
if ( ! is_page( array( 'contact', 'thank-you' ) ) && ace_is_section_visible( 'footer_cta' ) ) : ?>
<section class="footer-cta bg-navy" aria-label="<?php esc_attr_e( 'Call to action', 'ace-theme' ); ?>">
	<div class="container">
		<div class="footer-cta-inner">
			<h2><?php echo esc_html( ace_get_option( 'cta_headline', 'Ready to Build Something Extraordinary?' ) ); ?></h2>
			<p><?php echo esc_html( ace_get_option( 'cta_subheadline', 'Schedule your free in-home consultation today. Let\'s turn your vision into reality.' ) ); ?></p>
			<div class="footer-cta-actions">
				<a href="<?php echo esc_url( home_url( '/contact/' ) ); ?>" class="btn btn-primary">
					<?php echo esc_html( ace_get_option( 'cta_button_text', 'Get Your Free Consultation' ) ); ?>
				</a>
				<a href="<?php echo esc_url( ace_get_phone_link() ); ?>" class="btn btn-phone" aria-label="<?php /* translators: %s: phone number */ printf( esc_attr__( 'Call us at %s', 'ace-theme' ), ace_get_phone() ); ?>">
					<?php echo ace_icon( 'phone', 18 ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
					<?php esc_html_e( 'Or Call Us Now: ', 'ace-theme' ); ?>
					<?php echo esc_html( ace_get_phone() ); ?>
				</a>
			</div>
		</div>
	</div>
</section>
<?php endif; ?>

<!-- Site Footer -->
<footer class="site-footer" role="contentinfo">
	<div class="container">
		<div class="footer-grid">

			<!-- Column 1: About -->
			<div class="footer-col footer-about">
				<a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="footer-logo" aria-label="<?php echo esc_attr( ace_get_company_name() ); ?> &mdash; <?php esc_attr_e( 'Home', 'ace-theme' ); ?>">
					<?php
					$logo_white = ace_get_logo_white_url();
					if ( $logo_white && strpos( $logo_white, 'placeholder' ) === false ) : ?>
						<img src="<?php echo esc_url( $logo_white ); ?>" alt="<?php echo esc_attr( ace_get_company_name() ); ?>" width="200" height="55" loading="lazy">
					<?php else : ?>
						<span class="footer-logo-text"><?php echo esc_html( ace_get_company_name() ); ?></span>
					<?php endif; ?>
				</a>
				<p class="footer-description">
					<?php echo esc_html( ace_get_option( 'footer_description', 'Los Angeles\' premier design-build firm. 15 years of transforming homes with precision, transparency, and unmatched craftsmanship.' ) ); ?>
				</p>
				<div class="footer-social" aria-label="<?php esc_attr_e( 'Social media links', 'ace-theme' ); ?>">
					<?php
					$social = ace_get_social_links();
					$social_icons = array(
						'facebook'  => 'facebook',
						'instagram' => 'instagram',
						'youtube'   => 'youtube',
						'yelp'      => 'yelp',
					);
					foreach ( $social_icons as $network => $icon_name ) :
						if ( ! empty( $social[ $network ] ) ) : ?>
							<a href="<?php echo esc_url( $social[ $network ] ); ?>" target="_blank" rel="noopener noreferrer" aria-label="<?php /* translators: %s: social network name */ printf( esc_attr__( 'Follow us on %s', 'ace-theme' ), ucfirst( $network ) ); ?>">
								<?php echo ace_icon( $icon_name, 20 ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
							</a>
						<?php endif;
					endforeach; ?>
				</div>
			</div>

			<!-- Column 2: Services -->
			<div class="footer-col footer-services">
				<h4><?php esc_html_e( 'Our Services', 'ace-theme' ); ?></h4>
				<ul>
					<?php
					$services = ace_get_services();
					if ( ! empty( $services ) ) :
						foreach ( $services as $service ) : ?>
							<li>
								<a href="<?php echo esc_url( home_url( '/services/' . $service['slug'] . '/' ) ); ?>">
									<?php echo esc_html( $service['title'] ); ?>
								</a>
							</li>
						<?php endforeach;
					endif; ?>
				</ul>
			</div>

			<!-- Column 3: Company -->
			<div class="footer-col footer-company">
				<h4><?php esc_html_e( 'Company', 'ace-theme' ); ?></h4>
				<ul>
					<li><a href="<?php echo esc_url( home_url( '/about/' ) ); ?>"><?php esc_html_e( 'About Us', 'ace-theme' ); ?></a></li>
					<li><a href="<?php echo esc_url( home_url( '/our-work/' ) ); ?>"><?php esc_html_e( 'Our Work', 'ace-theme' ); ?></a></li>
					<li><a href="<?php echo esc_url( home_url( '/blog/' ) ); ?>"><?php esc_html_e( 'Blog', 'ace-theme' ); ?></a></li>
					<li><a href="<?php echo esc_url( home_url( '/contact/' ) ); ?>"><?php esc_html_e( 'Contact', 'ace-theme' ); ?></a></li>
					<li><a href="<?php echo esc_url( home_url( '/privacy-policy/' ) ); ?>"><?php esc_html_e( 'Privacy Policy', 'ace-theme' ); ?></a></li>
					<li><a href="<?php echo esc_url( home_url( '/terms-of-service/' ) ); ?>"><?php esc_html_e( 'Terms of Service', 'ace-theme' ); ?></a></li>
				</ul>
			</div>

			<!-- Column 4: Contact -->
			<div class="footer-col footer-contact">
				<h4><?php esc_html_e( 'Contact Us', 'ace-theme' ); ?></h4>
				<ul class="contact-list">
					<li>
						<?php echo ace_icon( 'map-pin', 18 ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
						<a href="<?php echo esc_url( 'https://maps.google.com/?q=' . rawurlencode( ace_get_address() ) ); ?>" target="_blank" rel="noopener noreferrer">
							<?php echo esc_html( ace_get_address() ); ?>
						</a>
					</li>
					<li>
						<?php echo ace_icon( 'phone', 18 ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
						<a href="<?php echo esc_url( ace_get_phone_link() ); ?>">
							<?php echo esc_html( ace_get_phone() ); ?>
						</a>
					</li>
					<li>
						<?php echo ace_icon( 'email', 18 ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
						<a href="mailto:<?php echo esc_attr( ace_get_email() ); ?>">
							<?php echo esc_html( ace_get_email() ); ?>
						</a>
					</li>
					<li>
						<?php echo ace_icon( 'clock', 18 ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
						<span><?php echo esc_html( ace_get_hours() ); ?></span>
					</li>
				</ul>
			</div>

		</div>
	</div>

	<!-- Footer Bottom Bar -->
	<div class="footer-bottom">
		<div class="container footer-bottom-inner">
			<p>&copy; <?php echo esc_html( gmdate( 'Y' ) ); ?> <?php echo esc_html( ace_get_company_name() ); ?>. <?php esc_html_e( 'All rights reserved. Licensed, Bonded & Insured.', 'ace-theme' ); ?></p>
			<div class="footer-bottom-links">
				<a href="<?php echo esc_url( home_url( '/privacy-policy/' ) ); ?>"><?php esc_html_e( 'Privacy Policy', 'ace-theme' ); ?></a>
				<a href="<?php echo esc_url( home_url( '/terms-of-service/' ) ); ?>"><?php esc_html_e( 'Terms of Service', 'ace-theme' ); ?></a>
			</div>
		</div>
	</div>
</footer>

<!-- Floating Mobile CTA Bar -->
<div class="mobile-cta-bar" aria-label="<?php esc_attr_e( 'Quick actions', 'ace-theme' ); ?>">
	<a href="<?php echo esc_url( ace_get_phone_link() ); ?>" class="mobile-cta-phone" aria-label="<?php /* translators: %s: phone number */ printf( esc_attr__( 'Call us at %s', 'ace-theme' ), ace_get_phone() ); ?>">
		<?php echo ace_icon( 'phone', 20 ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
		<span><?php esc_html_e( 'Call Now', 'ace-theme' ); ?></span>
	</a>
	<a href="<?php echo esc_url( home_url( '/contact/' ) ); ?>" class="mobile-cta-quote">
		<?php esc_html_e( 'Free Quote', 'ace-theme' ); ?>
	</a>
</div>

<button class="back-to-top" id="back-to-top" aria-label="Back to top">
    <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2.5" stroke-linecap="round" stroke-linejoin="round"><polyline points="18 15 12 9 6 15"/></svg>
</button>

<?php wp_footer(); ?>
</body>
</html>
