<?php
/**
 * Homepage Template
 *
 * The flagship front page for ACE Design & Build. Each section pulls content
 * from plugin options via ace_get_option() with sensible defaults. Sections
 * are individually toggleable through ace_is_section_visible() and use
 * semantic IDs for smooth-scroll anchor targeting.
 *
 * @package ACE_Theme
 */

get_header();
?>

<!-- SECTION 1: HERO -->
<?php if ( ace_is_section_visible( 'home_hero' ) ) : ?>
<section id="hero" class="hero-section">
	<?php
	$hero_bg  = ace_get_option( 'hero_image', '' );
	$bg_style = $hero_bg ? 'background-image: url(' . esc_url( $hero_bg ) . ');' : '';
	?>
	<div class="hero-overlay" style="<?php echo esc_attr( $bg_style ); ?>">
		<div class="container hero-content">
			<h1 class="hero-title fade-in-up">
				<?php echo esc_html( ace_get_option( 'hero_headline', "Los Angeles' Premier Design & Build Firm" ) ); ?>
			</h1>
			<p class="hero-subtitle fade-in-up" style="animation-delay: 0.2s">
				<?php echo esc_html( ace_get_option( 'hero_subheadline', 'From dream kitchens to complete home transformations - we design, build, and deliver with precision. 15 years. Thousands of happy homeowners. Zero compromises.' ) ); ?>
			</p>
			<div class="hero-ctas fade-in-up" style="animation-delay: 0.4s">
				<a href="<?php echo esc_url( home_url( '/contact/' ) ); ?>" class="btn btn-primary btn-lg">
					<?php echo esc_html( ace_get_option( 'hero_cta_primary_text', 'Schedule Your Free Consultation' ) ); ?>
				</a>
				<a href="<?php echo esc_url( home_url( '/our-work/' ) ); ?>" class="btn btn-ghost btn-lg">
					<?php echo esc_html( ace_get_option( 'hero_cta_secondary_text', 'View Our Work' ) ); ?>
				</a>
			</div>
			<!-- Trust Bar -->
			<div class="trust-bar fade-in-up" style="animation-delay: 0.6s">
				<div class="trust-item">
					<?php echo ace_icon( 'star', 20 ); ?>
					<span><?php esc_html_e( '4.9 Google Rating', 'ace-theme' ); ?></span>
				</div>
				<div class="trust-item">
					<?php echo ace_icon( 'check-circle', 20 ); ?>
					<span><?php esc_html_e( 'Licensed, Bonded & Insured', 'ace-theme' ); ?></span>
				</div>
				<div class="trust-item">
					<?php echo ace_icon( 'award', 20 ); ?>
					<span><?php esc_html_e( '15+ Years of Excellence', 'ace-theme' ); ?></span>
				</div>
				<div class="trust-item">
					<?php echo ace_icon( 'map-pin', 20 ); ?>
					<span><?php esc_html_e( 'Serving All of Greater LA', 'ace-theme' ); ?></span>
				</div>
			</div>
		</div>
	</div>
</section>
<?php endif; ?>

<!-- SECTION 2: SERVICES OVERVIEW -->
<?php if ( ace_is_section_visible( 'home_services' ) ) : ?>
<section id="services" class="section bg-light">
	<div class="container">
		<div class="section-header text-center fade-in-up">
			<h2><?php echo esc_html( ace_get_option( 'services_title', 'What We Build' ) ); ?></h2>
			<p class="section-subtitle"><?php echo esc_html( ace_get_option( 'services_subtitle', 'Comprehensive residential construction and remodeling services, from concept to completion.' ) ); ?></p>
		</div>
		<div class="services-grid fade-in-up" style="animation-delay: 0.2s">
			<?php
			$services = ace_get_services();
			if ( ! empty( $services ) ) :
				foreach ( $services as $service ) :
					$service_image = isset( $service['hero_image'] ) ? $service['hero_image'] : '';
					?>
					<a href="<?php echo esc_url( home_url( '/services/' . $service['slug'] . '/' ) ); ?>" class="service-card">
						<div class="service-card-image">
							<?php if ( $service_image ) : ?>
								<img src="<?php echo esc_url( $service_image ); ?>" alt="<?php echo esc_attr( $service['title'] ); ?>" loading="lazy">
							<?php else : ?>
								<div class="service-card-placeholder">
									<?php echo ace_icon( 'home', 48 ); ?>
								</div>
							<?php endif; ?>
							<div class="service-card-overlay">
								<h3><?php echo esc_html( $service['title'] ); ?></h3>
							</div>
						</div>
					</a>
				<?php endforeach;
			endif; ?>
		</div>
		<div class="text-center fade-in-up" style="margin-top: 40px; animation-delay: 0.4s">
			<a href="<?php echo esc_url( home_url( '/services/' ) ); ?>" class="link-arrow">
				<?php esc_html_e( 'Explore All Services', 'ace-theme' ); ?> <?php echo ace_icon( 'arrow-right', 16 ); ?>
			</a>
		</div>
	</div>
</section>
<?php endif; ?>

<!-- SECTION 3: WHY ACE -->
<?php if ( ace_is_section_visible( 'home_why_ace' ) ) : ?>
<section id="why-ace" class="section bg-white">
	<div class="container">
		<div class="section-header text-center fade-in-up">
			<h2><?php echo esc_html( ace_get_option( 'why_ace_title', 'Why Los Angeles Homeowners Choose ACE' ) ); ?></h2>
		</div>
		<div class="why-ace-grid">
			<div class="why-ace-features fade-in-up" style="animation-delay: 0.2s">
				<?php
				$features = ace_get_why_ace_features();
				$default_features = array(
					array(
						'icon'        => 'home',
						'title'       => 'Design-Build Under One Roof',
						'description' => 'No middlemen. Our architects, designers, and builders work as one team - saving you time, money, and headaches.',
					),
					array(
						'icon'        => 'dollar-sign',
						'title'       => 'Transparent Pricing, No Surprises',
						'description' => 'Detailed estimates upfront. Fixed-price contracts. You\'ll never get an unexpected bill from us.',
					),
					array(
						'icon'        => 'shield',
						'title'       => 'Licensed, Bonded & Fully Insured',
						'description' => 'Your investment is protected at every stage. We carry full liability coverage and workers\' comp.',
					),
					array(
						'icon'        => 'award',
						'title'       => '15 Years of Proven Excellence',
						'description' => 'With over 2,000 completed projects across LA, our track record speaks for itself.',
					),
				);
				$features = ! empty( $features ) ? $features : $default_features;

				foreach ( $features as $feature ) : ?>
					<div class="feature-block">
						<div class="feature-icon">
							<?php echo ace_icon( isset( $feature['icon'] ) ? $feature['icon'] : 'check-circle', 32 ); ?>
						</div>
						<div class="feature-content">
							<h3><?php echo esc_html( $feature['title'] ); ?></h3>
							<p><?php echo esc_html( $feature['description'] ); ?></p>
						</div>
					</div>
				<?php endforeach; ?>
			</div>
			<div class="why-ace-image fade-in-up" style="animation-delay: 0.4s">
				<?php $why_image = ace_get_option( 'why_ace_image', '' ); ?>
				<?php if ( $why_image ) : ?>
					<img src="<?php echo esc_url( $why_image ); ?>" alt="<?php esc_attr_e( 'ACE Design & Build craftsmanship', 'ace-theme' ); ?>" loading="lazy">
				<?php else : ?>
					<div class="image-placeholder">
						<?php echo ace_icon( 'home', 64 ); ?>
						<span><?php esc_html_e( 'Premium Craftsmanship', 'ace-theme' ); ?></span>
					</div>
				<?php endif; ?>
			</div>
		</div>
	</div>
</section>
<?php endif; ?>

<!-- SECTION 4: STATS COUNTER -->
<?php if ( ace_is_section_visible( 'home_stats' ) ) : ?>
<section id="stats" class="section bg-navy stats-section">
	<div class="container">
		<div class="stats-grid fade-in-up">
			<?php
			$stats = ace_get_stats();
			$default_stats = array(
				array(
					'number' => '2000',
					'suffix' => '+',
					'label'  => 'Projects Completed',
				),
				array(
					'number' => '15',
					'suffix' => '+',
					'label'  => 'Years of Experience',
				),
				array(
					'number' => '4.9',
					'suffix' => '',
					'label'  => 'Google Rating',
				),
				array(
					'number' => '98',
					'suffix' => '%',
					'label'  => 'Client Satisfaction',
				),
			);
			$stats = ! empty( $stats ) ? $stats : $default_stats;

			foreach ( $stats as $stat ) : ?>
				<div class="stat-item">
					<div class="stat-number" data-target="<?php echo esc_attr( $stat['number'] ); ?>" data-suffix="<?php echo esc_attr( isset( $stat['suffix'] ) ? $stat['suffix'] : '' ); ?>">
						0<?php echo esc_html( isset( $stat['suffix'] ) ? $stat['suffix'] : '' ); ?>
					</div>
					<div class="stat-label"><?php echo esc_html( $stat['label'] ); ?></div>
				</div>
			<?php endforeach; ?>
		</div>
	</div>
</section>
<?php endif; ?>

<!-- SECTION 5: FEATURED PROJECTS -->
<?php if ( ace_is_section_visible( 'home_projects' ) ) : ?>
<section id="featured-projects" class="section bg-white">
	<div class="container">
		<div class="section-header text-center fade-in-up">
			<h2><?php echo esc_html( ace_get_option( 'featured_title', 'Our Recent Work' ) ); ?></h2>
			<p class="section-subtitle"><?php echo esc_html( ace_get_option( 'featured_subtitle', 'See the craftsmanship and attention to detail that defines every ACE project.' ) ); ?></p>
		</div>
		<div class="projects-grid fade-in-up" style="animation-delay: 0.2s">
			<?php
			$projects = new WP_Query( array(
				'post_type'      => 'ace_project',
				'posts_per_page' => 6,
				'meta_key'       => '_ace_featured',
				'meta_value'     => '1',
				'orderby'        => 'date',
				'order'          => 'DESC',
			) );

			if ( $projects->have_posts() ) :
				while ( $projects->have_posts() ) :
					$projects->the_post();
					$categories    = get_the_terms( get_the_ID(), 'project_category' );
					$category_name = $categories && ! is_wp_error( $categories ) ? $categories[0]->name : '';
					?>
					<div class="project-card">
						<div class="project-card-image">
							<?php if ( has_post_thumbnail() ) : ?>
								<?php the_post_thumbnail( 'ace-portfolio', array( 'loading' => 'lazy' ) ); ?>
							<?php else : ?>
								<div class="image-placeholder">
									<?php echo ace_icon( 'home', 48 ); ?>
								</div>
							<?php endif; ?>
							<div class="project-card-overlay">
								<?php if ( $category_name ) : ?>
									<span class="project-category"><?php echo esc_html( $category_name ); ?></span>
								<?php endif; ?>
								<h3><?php the_title(); ?></h3>
							</div>
						</div>
					</div>
				<?php endwhile;
				wp_reset_postdata();
			else :
				// Show placeholder project cards when no projects exist yet.
				$placeholder_projects = array(
					array(
						'title'    => 'Modern Kitchen Transformation',
						'category' => 'Kitchen Remodel',
					),
					array(
						'title'    => 'Complete Home Renovation',
						'category' => 'Full Home Remodel',
					),
					array(
						'title'    => 'Luxury ADU Build',
						'category' => 'ADU Construction',
					),
					array(
						'title'    => 'Resort-Style Backyard',
						'category' => 'Outdoor Living',
					),
					array(
						'title'    => 'Spa-Inspired Bathroom',
						'category' => 'Bathroom Remodel',
					),
					array(
						'title'    => 'Custom Swimming Pool',
						'category' => 'Pool Construction',
					),
				);
				foreach ( $placeholder_projects as $project ) : ?>
					<div class="project-card">
						<div class="project-card-image">
							<div class="image-placeholder">
								<?php echo ace_icon( 'home', 48 ); ?>
							</div>
							<div class="project-card-overlay">
								<span class="project-category"><?php echo esc_html( $project['category'] ); ?></span>
								<h3><?php echo esc_html( $project['title'] ); ?></h3>
							</div>
						</div>
					</div>
				<?php endforeach;
			endif; ?>
		</div>
		<div class="text-center fade-in-up" style="margin-top: 40px; animation-delay: 0.4s">
			<a href="<?php echo esc_url( home_url( '/our-work/' ) ); ?>" class="link-arrow">
				<?php esc_html_e( 'View Full Portfolio', 'ace-theme' ); ?> <?php echo ace_icon( 'arrow-right', 16 ); ?>
			</a>
		</div>
	</div>
</section>
<?php endif; ?>

<!-- SECTION 6: TESTIMONIALS -->
<?php if ( ace_is_section_visible( 'home_testimonials' ) ) : ?>
<section id="testimonials" class="section bg-light">
	<div class="container">
		<div class="section-header text-center fade-in-up">
			<h2><?php echo esc_html( ace_get_option( 'testimonials_title', 'What Our Clients Say' ) ); ?></h2>
		</div>
		<div class="testimonials-slider fade-in-up" style="animation-delay: 0.2s">
			<?php
			$testimonials = ace_get_testimonials();
			if ( ! empty( $testimonials ) ) :
				foreach ( $testimonials as $index => $testimonial ) : ?>
					<div class="testimonial-card<?php echo $index < 3 ? ' active' : ''; ?>" data-index="<?php echo intval( $index ); ?>">
						<div class="testimonial-quote-icon">
							<?php echo ace_icon( 'quote', 32 ); ?>
						</div>
						<blockquote class="testimonial-text">
							<?php echo esc_html( $testimonial['text'] ); ?>
						</blockquote>
						<div class="testimonial-rating">
							<?php
							$rating = isset( $testimonial['rating'] ) ? intval( $testimonial['rating'] ) : 5;
							for ( $i = 0; $i < $rating; $i++ ) {
								echo ace_icon( 'star', 16, 'star-filled' );
							}
							?>
						</div>
						<div class="testimonial-author">
							<?php if ( ! empty( $testimonial['avatar'] ) ) : ?>
								<img src="<?php echo esc_url( $testimonial['avatar'] ); ?>" alt="<?php echo esc_attr( $testimonial['name'] ); ?>" class="testimonial-avatar" loading="lazy">
							<?php endif; ?>
							<div class="testimonial-info">
								<strong><?php echo esc_html( $testimonial['name'] ); ?></strong>
								<?php if ( ! empty( $testimonial['location'] ) ) : ?>
									<span><?php echo esc_html( $testimonial['location'] ); ?></span>
								<?php endif; ?>
								<?php if ( ! empty( $testimonial['project_type'] ) ) : ?>
									<span class="testimonial-project"><?php echo esc_html( $testimonial['project_type'] ); ?></span>
								<?php endif; ?>
							</div>
						</div>
					</div>
				<?php endforeach;
			endif; ?>
		</div>
		<!-- Slider Navigation -->
		<div class="testimonials-nav fade-in-up" style="animation-delay: 0.3s">
			<button class="testimonial-prev" aria-label="<?php esc_attr_e( 'Previous testimonial', 'ace-theme' ); ?>">
				<?php echo ace_icon( 'arrow-right', 20 ); ?>
			</button>
			<div class="testimonials-dots">
				<?php
				if ( ! empty( $testimonials ) ) :
					$total = count( $testimonials );
					for ( $i = 0; $i < $total; $i++ ) : ?>
						<button class="dot<?php echo 0 === $i ? ' active' : ''; ?>" data-slide="<?php echo intval( $i ); ?>" aria-label="<?php echo esc_attr( sprintf( __( 'Go to testimonial %d', 'ace-theme' ), $i + 1 ) ); ?>"></button>
					<?php endfor;
				endif; ?>
			</div>
			<button class="testimonial-next" aria-label="<?php esc_attr_e( 'Next testimonial', 'ace-theme' ); ?>">
				<?php echo ace_icon( 'arrow-right', 20 ); ?>
			</button>
		</div>
	</div>
</section>
<?php endif; ?>

<!-- SECTION 7: HOW IT WORKS / PROCESS -->
<?php if ( ace_is_section_visible( 'home_process' ) ) : ?>
<section id="process" class="section bg-white">
	<div class="container">
		<div class="section-header text-center fade-in-up">
			<h2><?php echo esc_html( ace_get_option( 'process_title', 'How It Works' ) ); ?></h2>
			<p class="section-subtitle"><?php echo esc_html( ace_get_option( 'process_subtitle', "From your first call to your final walkthrough - here's what working with ACE looks like." ) ); ?></p>
		</div>
		<div class="process-timeline fade-in-up" style="animation-delay: 0.2s">
			<?php
			$steps = ace_get_process_steps();
			$default_steps = array(
				array(
					'title'       => 'Free Consultation',
					'description' => 'We visit your home, listen to your vision, assess the space, and discuss your goals and budget. No pressure. No obligation.',
				),
				array(
					'title'       => 'Custom Design & Proposal',
					'description' => "Our design team creates detailed plans, 3D renderings, and a transparent, line-item proposal. You'll know exactly what you're getting and what it costs.",
				),
				array(
					'title'       => 'Expert Construction',
					'description' => "Our licensed crew brings your project to life with premium materials and meticulous craftsmanship. We manage every detail so you don't have to.",
				),
				array(
					'title'       => 'Final Walkthrough & Warranty',
					'description' => "We walk through every inch together. Nothing is complete until you're 100% satisfied. Plus, every project comes with our comprehensive warranty.",
				),
			);
			$steps = ! empty( $steps ) ? $steps : $default_steps;

			foreach ( $steps as $index => $step ) : ?>
				<div class="process-step">
					<div class="step-number"><?php echo intval( $index + 1 ); ?></div>
					<div class="step-content">
						<h3><?php echo esc_html( $step['title'] ); ?></h3>
						<p><?php echo esc_html( $step['description'] ); ?></p>
					</div>
				</div>
			<?php endforeach; ?>
		</div>
	</div>
</section>
<?php endif; ?>

<!-- SECTION 8: CTA BANNER -->
<?php if ( ace_is_section_visible( 'home_cta' ) ) : ?>
	<?php get_template_part( 'template-parts/cta-banner' ); ?>
<?php endif; ?>

<!-- SECTION 9: SERVICE AREA -->
<?php if ( ace_is_section_visible( 'home_service_area' ) ) : ?>
<section id="service-area" class="section bg-light">
	<div class="container">
		<div class="section-header text-center fade-in-up">
			<h2><?php echo esc_html( ace_get_option( 'service_area_title', 'Proudly Serving Los Angeles & Surrounding Areas' ) ); ?></h2>
		</div>
		<?php $map_embed = ace_get_option( 'google_maps_embed', '' ); ?>
		<?php if ( $map_embed ) : ?>
			<div class="map-container fade-in-up" style="animation-delay: 0.2s">
				<?php echo $map_embed; // phpcs:ignore WordPress.Security.EscapeOutput -- Embed code from admin settings. ?>
			</div>
		<?php endif; ?>
		<div class="service-areas-list fade-in-up" style="animation-delay: 0.3s">
			<?php
			$areas = ace_get_service_areas();
			if ( ! empty( $areas ) ) :
				foreach ( $areas as $area ) : ?>
					<span class="area-tag"><?php echo esc_html( $area ); ?></span>
				<?php endforeach;
			endif; ?>
		</div>
	</div>
</section>
<?php endif; ?>

<!-- SECTION 10: BLOG PREVIEW -->
<?php if ( ace_is_section_visible( 'home_blog' ) ) : ?>
<section id="blog-preview" class="section bg-white">
	<div class="container">
		<div class="section-header text-center fade-in-up">
			<h2><?php echo esc_html( ace_get_option( 'blog_title', 'Expert Insights & Remodeling Tips' ) ); ?></h2>
		</div>
		<div class="blog-grid fade-in-up" style="animation-delay: 0.2s">
			<?php
			$blog_count = intval( ace_get_option( 'blog_count', 3 ) );
			$blog_query = new WP_Query( array(
				'post_type'      => 'post',
				'posts_per_page' => $blog_count,
				'orderby'        => 'date',
				'order'          => 'DESC',
			) );

			if ( $blog_query->have_posts() ) :
				while ( $blog_query->have_posts() ) :
					$blog_query->the_post(); ?>
					<article class="blog-card">
						<a href="<?php the_permalink(); ?>" class="blog-card-image">
							<?php if ( has_post_thumbnail() ) : ?>
								<?php the_post_thumbnail( 'ace-blog-card', array( 'loading' => 'lazy' ) ); ?>
							<?php else : ?>
								<div class="image-placeholder">
									<?php echo ace_icon( 'home', 48 ); ?>
								</div>
							<?php endif; ?>
							<?php
							$categories = get_the_category();
							if ( $categories ) : ?>
								<span class="blog-card-category"><?php echo esc_html( $categories[0]->name ); ?></span>
							<?php endif; ?>
						</a>
						<div class="blog-card-content">
							<h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
							<p><?php echo esc_html( wp_trim_words( get_the_excerpt(), 18, '...' ) ); ?></p>
							<a href="<?php the_permalink(); ?>" class="link-arrow">
								<?php esc_html_e( 'Read More', 'ace-theme' ); ?> <?php echo ace_icon( 'arrow-right', 14 ); ?>
							</a>
						</div>
					</article>
				<?php endwhile;
				wp_reset_postdata();
			else :
				// Placeholder blog posts when no posts exist.
				$placeholder_posts = array(
					array(
						'title'    => '10 Kitchen Remodeling Trends for Los Angeles Homeowners',
						'category' => 'Kitchen',
					),
					array(
						'title'    => 'ADU Construction in LA: Everything You Need to Know',
						'category' => 'ADU',
					),
					array(
						'title'    => 'How to Plan Your Backyard Renovation Budget',
						'category' => 'Outdoor Living',
					),
				);
				foreach ( $placeholder_posts as $post_data ) : ?>
					<article class="blog-card">
						<div class="blog-card-image">
							<div class="image-placeholder">
								<?php echo ace_icon( 'home', 48 ); ?>
							</div>
							<span class="blog-card-category"><?php echo esc_html( $post_data['category'] ); ?></span>
						</div>
						<div class="blog-card-content">
							<h3><a href="#"><?php echo esc_html( $post_data['title'] ); ?></a></h3>
							<p><?php esc_html_e( 'Expert insights and tips from the ACE Design & Build team to help you plan your next home improvement project.', 'ace-theme' ); ?></p>
							<span class="link-arrow">
								<?php esc_html_e( 'Read More', 'ace-theme' ); ?> <?php echo ace_icon( 'arrow-right', 14 ); ?>
							</span>
						</div>
					</article>
				<?php endforeach;
			endif; ?>
		</div>
	</div>
</section>
<?php endif; ?>

<!-- SECTION 11: FINAL CTA + LEAD FORM -->
<?php if ( ace_is_section_visible( 'home_lead_form' ) ) : ?>
<section id="lead-form" class="section bg-white">
	<div class="container">
		<div class="lead-form-grid">
			<div class="lead-form-info fade-in-up">
				<h2><?php echo esc_html( ace_get_option( 'final_cta_headline', "Let's Start Your Project" ) ); ?></h2>
				<p><?php echo esc_html( ace_get_option( 'final_cta_description', 'Get a free, no-obligation estimate for your remodeling or construction project. Our team responds within 2 hours during business hours.' ) ); ?></p>
				<div class="lead-form-trust">
					<div class="trust-badge">
						<?php echo ace_icon( 'shield', 24 ); ?>
						<span><?php esc_html_e( 'Licensed & Bonded', 'ace-theme' ); ?></span>
					</div>
					<div class="trust-badge">
						<?php echo ace_icon( 'dollar-sign', 24 ); ?>
						<span><?php esc_html_e( 'Free Estimates', 'ace-theme' ); ?></span>
					</div>
					<div class="trust-badge">
						<?php echo ace_icon( 'award', 24 ); ?>
						<span><?php esc_html_e( '15+ Years', 'ace-theme' ); ?></span>
					</div>
					<div class="trust-badge">
						<?php echo ace_icon( 'check-circle', 24 ); ?>
						<span><?php esc_html_e( 'Satisfaction Guaranteed', 'ace-theme' ); ?></span>
					</div>
				</div>
			</div>
			<div class="lead-form-container fade-in-up" style="animation-delay: 0.2s">
				<?php get_template_part( 'template-parts/lead-form' ); ?>
			</div>
		</div>
	</div>
</section>
<?php endif; ?>

<?php get_footer(); ?>
