<?php
/**
 * ACE Theme functions and definitions
 *
 * @package ACE_Theme
 * @since 1.0.0
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Theme version constant.
define( 'ACE_THEME_VERSION', '1.0.0' );
define( 'ACE_THEME_DIR', get_template_directory() );
define( 'ACE_THEME_URI', get_template_directory_uri() );

/**
 * Include theme files.
 */
require_once ACE_THEME_DIR . '/inc/theme-setup.php';
require_once ACE_THEME_DIR . '/inc/enqueue.php';
require_once ACE_THEME_DIR . '/inc/template-functions.php';
require_once ACE_THEME_DIR . '/inc/custom-post-types.php';
require_once ACE_THEME_DIR . '/inc/schema.php';
require_once ACE_THEME_DIR . '/inc/seo.php';
require_once ACE_THEME_DIR . '/inc/walker-nav-mega.php';
require_once ACE_THEME_DIR . '/inc/service-routing.php';
