<?php
/**
 * Header template for ACE Theme
 *
 * Renders the full site header including announcement bar, sticky navigation,
 * mega menu for services, mobile overlay navigation, and breadcrumbs.
 *
 * @package ACE_Theme
 * @since 1.0.0
 */
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<?php wp_body_open(); ?>

<a class="skip-link screen-reader-text" href="#main-content">
	<?php esc_html_e( 'Skip to content', 'ace-theme' ); ?>
</a>

<?php
// Announcement Bar.
$announcement_enabled = ace_get_option( 'announcement_bar', false );
$announcement_text    = ace_get_option( 'announcement_text', '' );
if ( $announcement_enabled && $announcement_text ) : ?>
<div class="announcement-bar" role="banner" style="background-color: <?php echo esc_attr( ace_get_option( 'announcement_bg', '#C8A35A' ) ); ?>;">
	<div class="container">
		<p>
			<?php echo wp_kses_post( $announcement_text ); ?>
			<?php
			$announcement_link = ace_get_option( 'announcement_link', '' );
			if ( $announcement_link ) : ?>
				<a href="<?php echo esc_url( $announcement_link ); ?>"><?php esc_html_e( 'Learn More', 'ace-theme' ); ?></a>
			<?php endif; ?>
		</p>
		<button class="announcement-close" aria-label="<?php esc_attr_e( 'Close announcement', 'ace-theme' ); ?>" type="button">
			<?php echo ace_icon( 'x', 16 ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
		</button>
	</div>
</div>
<?php endif; ?>

<?php
// Gather data used in both desktop and mobile navigation.
$logo_url = ace_get_logo_url();
$has_real_logo = ( $logo_url && strpos( $logo_url, 'placeholder' ) === false );
$services = ace_get_services();
?>

<!-- Site Header -->
<header id="site-header" class="site-header<?php echo is_front_page() ? ' header-transparent' : ''; ?>" role="banner">
	<div class="container header-inner">

		<!-- Logo -->
		<a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="site-logo" aria-label="<?php echo esc_attr( ace_get_company_name() ); ?> &mdash; <?php esc_attr_e( 'Home', 'ace-theme' ); ?>">
			<?php if ( $has_real_logo ) : ?>
				<img src="<?php echo esc_url( $logo_url ); ?>" alt="<?php echo esc_attr( ace_get_company_name() ); ?>" class="logo-img" width="200" height="55">
			<?php else : ?>
				<div class="logo-text">
					<span class="logo-name"><?php echo esc_html( ace_get_company_name() ); ?></span>
					<span class="logo-tagline"><?php echo esc_html( ace_get_tagline() ); ?></span>
				</div>
			<?php endif; ?>
		</a>

		<!-- Desktop Navigation -->
		<nav class="main-nav" aria-label="<?php esc_attr_e( 'Primary Navigation', 'ace-theme' ); ?>">
			<ul class="nav-menu" role="menubar">
				<li class="menu-item<?php echo is_front_page() ? ' current' : ''; ?>" role="none">
					<a href="<?php echo esc_url( home_url( '/' ) ); ?>" role="menuitem"><?php esc_html_e( 'Home', 'ace-theme' ); ?></a>
				</li>

				<li class="menu-item has-mega-menu nav-item-services<?php echo is_page( 'services' ) || is_singular( 'ace_service' ) ? ' current' : ''; ?>" role="none">
					<a href="<?php echo esc_url( home_url( '/services/' ) ); ?>" role="menuitem" aria-haspopup="true" aria-expanded="false">
						<?php esc_html_e( 'Services', 'ace-theme' ); ?>
						<?php echo ace_icon( 'chevron-down', 14 ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
					</a>
					<?php if ( ! empty( $services ) ) :
						$mega_icons = array(
							'kitchen-remodeling'        => array( 'fa-utensils',     'Custom layouts, cabinetry, countertops, and open-concept conversions.' ),
							'bathroom-remodeling'       => array( 'fa-shower',       'Spa-inspired bathrooms with tile, fixtures, and heated floors.' ),
							'full-home-remodeling'      => array( 'fa-hammer',       'Complete renovations that transform every room in your home.' ),
							'adu'                       => array( 'fa-building',     'Fully permitted units for rental income or multigenerational living.' ),
							'home-additions'            => array( 'fa-maximize',     'Seamless room additions that match your existing architecture.' ),
							'backyard-remodeling'       => array( 'fa-tree',         'Outdoor living spaces with patios, fire pits, and full landscaping.' ),
							'swimming-pools'            => array( 'fa-water-ladder', 'Custom pools, heated spas, and resort-style water features.' ),
							'outdoor-kitchens'          => array( 'fa-fire-burner',  'Built-in BBQ islands, countertops, and alfresco dining areas.' ),
							'landscape-and-hardscaping' => array( 'fa-seedling',     'Drought-tolerant planting, hardscaping, and lighting design.' ),
							'concrete'                  => array( 'fa-cube',         'Foundations, stamped finishes, and decorative concrete work.' ),
							'driveways'                 => array( 'fa-road',         'Paver, stamped, and decorative concrete driveways.' ),
							'pavers'                    => array( 'fa-border-all',   'Travertine, porcelain, and interlocking paver installations.' ),
							'patio-covers'              => array( 'fa-umbrella',     'Insulated roofs, wood pergolas, and shade structures.' ),
							'artificial-turf'           => array( 'fa-spa',          'Realistic, maintenance-free lawns and putting greens.' ),
							'front-yard-renovation'     => array( 'fa-house',        'Curb appeal upgrades with walkways, planting, and lighting.' ),
						);
					?>
					<!-- MEGA MENU V2 -->
					<div class="mega-menu" role="menu" aria-label="<?php esc_attr_e( 'Services submenu', 'ace-theme' ); ?>">
						<div class="mega-menu-layout">
							<!-- Left: Featured consultation CTA -->
							<div class="mega-menu-featured">
								<div class="mega-menu-featured-badge"><?php esc_html_e( 'Expert Guidance', 'ace-theme' ); ?></div>
								<h3><?php esc_html_e( 'Not Sure Where to Start?', 'ace-theme' ); ?></h3>
								<p><?php esc_html_e( 'Walk us through your vision. Our experts will assess your space, discuss options, and map out a plan tailored to your home and budget — completely free, no strings attached.', 'ace-theme' ); ?></p>
								<a href="<?php echo esc_url( home_url( '/contact/' ) ); ?>" class="mega-menu-featured-cta">
									<?php esc_html_e( 'Book Free Consultation', 'ace-theme' ); ?> <i class="fas fa-arrow-right"></i>
								</a>
								<div class="mega-menu-featured-phone">
									<?php esc_html_e( 'or call us directly:', 'ace-theme' ); ?> <a href="<?php echo esc_url( ace_get_phone_link() ); ?>"><?php echo esc_html( ace_get_phone() ); ?></a>
								</div>
							</div>
							<!-- Right: Service cards with descriptions -->
							<div class="mega-menu-services">
								<div class="mega-menu-grid">
									<?php foreach ( $services as $svc ) :
										$svc_slug = $svc['slug'];
										$svc_icon = isset( $mega_icons[ $svc_slug ] ) ? $mega_icons[ $svc_slug ][0] : 'fa-wrench';
										$svc_desc = isset( $mega_icons[ $svc_slug ] ) ? $mega_icons[ $svc_slug ][1] : '';
									?>
									<a href="<?php echo esc_url( home_url( '/services/' . $svc_slug . '/' ) ); ?>" class="mega-menu-card" role="menuitem">
										<div class="mega-menu-card-top">
											<span class="mega-menu-card-icon"><i class="fas <?php echo esc_attr( $svc_icon ); ?>"></i></span>
											<span class="mega-menu-card-title"><?php echo esc_html( $svc['title'] ); ?></span>
										</div>
										<?php if ( $svc_desc ) : ?>
										<span class="mega-menu-card-desc"><?php echo esc_html( $svc_desc ); ?></span>
										<?php endif; ?>
									</a>
									<?php endforeach; ?>
								</div>
							</div>
						</div>
						<div class="mega-menu-footer">
							<a href="<?php echo esc_url( home_url( '/services/' ) ); ?>"><?php esc_html_e( 'View All Services', 'ace-theme' ); ?> <i class="fas fa-arrow-right"></i></a>
						</div>
					</div>
					<?php endif; ?>
				</li>

				<li class="menu-item<?php echo is_page( 'about' ) ? ' current' : ''; ?>" role="none">
					<a href="<?php echo esc_url( home_url( '/about/' ) ); ?>" role="menuitem"><?php esc_html_e( 'About Us', 'ace-theme' ); ?></a>
				</li>

				<li class="menu-item<?php echo is_page( 'our-work' ) || is_singular( 'ace_project' ) ? ' current' : ''; ?>" role="none">
					<a href="<?php echo esc_url( home_url( '/our-work/' ) ); ?>" role="menuitem"><?php esc_html_e( 'Our Work', 'ace-theme' ); ?></a>
				</li>

				<li class="menu-item<?php echo is_home() || is_singular( 'post' ) || is_category() || is_tag() ? ' current' : ''; ?>" role="none">
					<a href="<?php echo esc_url( home_url( '/blog/' ) ); ?>" role="menuitem"><?php esc_html_e( 'Blog', 'ace-theme' ); ?></a>
				</li>

				<li class="menu-item<?php echo is_page( 'contact' ) ? ' current' : ''; ?>" role="none">
					<a href="<?php echo esc_url( home_url( '/contact/' ) ); ?>" role="menuitem"><?php esc_html_e( 'Contact', 'ace-theme' ); ?></a>
				</li>
			</ul>
		</nav>

		<!-- Header Actions (desktop) -->
		<div class="header-actions">
			<a href="<?php echo esc_url( ace_get_phone_link() ); ?>" class="header-phone" aria-label="<?php /* translators: %s: phone number */ printf( esc_attr__( 'Call us at %s', 'ace-theme' ), ace_get_phone() ); ?>">
				<?php echo ace_icon( 'phone', 18 ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
				<span><?php echo esc_html( ace_get_phone() ); ?></span>
			</a>
			<a href="<?php echo esc_url( home_url( '/contact/' ) ); ?>" class="btn btn-primary header-cta">
				<?php esc_html_e( 'Free Consultation', 'ace-theme' ); ?>
			</a>
		</div>

		<!-- Mobile Menu Toggle -->
		<button class="mobile-menu-toggle" type="button" aria-label="<?php esc_attr_e( 'Open navigation menu', 'ace-theme' ); ?>" aria-expanded="false" aria-controls="mobile-nav-overlay">
			<span class="hamburger-icon" aria-hidden="true">
				<span></span>
				<span></span>
				<span></span>
			</span>
		</button>

	</div>
</header>

<!-- Mobile Navigation Overlay -->
<div id="mobile-nav-overlay" class="mobile-nav-overlay" aria-hidden="true" role="dialog" aria-modal="true" aria-label="<?php esc_attr_e( 'Mobile Navigation', 'ace-theme' ); ?>">
	<div class="mobile-nav-content">

		<!-- Mobile Nav Header -->
		<div class="mobile-nav-header">
			<a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="site-logo" aria-label="<?php echo esc_attr( ace_get_company_name() ); ?> &mdash; <?php esc_attr_e( 'Home', 'ace-theme' ); ?>">
				<?php if ( $has_real_logo ) : ?>
					<img src="<?php echo esc_url( $logo_url ); ?>" alt="<?php echo esc_attr( ace_get_company_name() ); ?>" class="logo-img" width="200" height="55">
				<?php else : ?>
					<div class="logo-text">
						<span class="logo-name"><?php echo esc_html( ace_get_company_name() ); ?></span>
					</div>
				<?php endif; ?>
			</a>
			<button class="mobile-nav-close" type="button" aria-label="<?php esc_attr_e( 'Close navigation menu', 'ace-theme' ); ?>">
				<?php echo ace_icon( 'x', 24 ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
			</button>
		</div>

		<!-- Mobile Nav Menu -->
		<nav aria-label="<?php esc_attr_e( 'Mobile Navigation', 'ace-theme' ); ?>">
			<ul class="mobile-nav-menu">
				<li>
					<a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php esc_html_e( 'Home', 'ace-theme' ); ?></a>
				</li>
				<li class="has-submenu">
					<button class="submenu-toggle" type="button" aria-expanded="false" aria-label="<?php esc_attr_e( 'Toggle Services submenu', 'ace-theme' ); ?>">
						<?php esc_html_e( 'Services', 'ace-theme' ); ?>
						<?php echo ace_icon( 'chevron-down', 16 ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
					</button>
					<ul class="mobile-submenu" role="list">
						<?php if ( ! empty( $services ) ) :
							foreach ( $services as $service ) : ?>
								<li>
									<a href="<?php echo esc_url( home_url( '/services/' . $service['slug'] . '/' ) ); ?>">
										<?php echo esc_html( $service['title'] ); ?>
									</a>
								</li>
							<?php endforeach;
						endif; ?>
						<li>
							<a href="<?php echo esc_url( home_url( '/services/' ) ); ?>" class="view-all-link">
								<?php esc_html_e( 'View All Services', 'ace-theme' ); ?>
							</a>
						</li>
					</ul>
				</li>
				<li>
					<a href="<?php echo esc_url( home_url( '/about/' ) ); ?>"><?php esc_html_e( 'About Us', 'ace-theme' ); ?></a>
				</li>
				<li>
					<a href="<?php echo esc_url( home_url( '/our-work/' ) ); ?>"><?php esc_html_e( 'Our Work', 'ace-theme' ); ?></a>
				</li>
				<li>
					<a href="<?php echo esc_url( home_url( '/blog/' ) ); ?>"><?php esc_html_e( 'Blog', 'ace-theme' ); ?></a>
				</li>
				<li>
					<a href="<?php echo esc_url( home_url( '/contact/' ) ); ?>"><?php esc_html_e( 'Contact', 'ace-theme' ); ?></a>
				</li>
			</ul>
		</nav>

		<!-- Mobile Nav Footer -->
		<div class="mobile-nav-footer">
			<a href="<?php echo esc_url( ace_get_phone_link() ); ?>" class="btn btn-phone" aria-label="<?php /* translators: %s: phone number */ printf( esc_attr__( 'Call us at %s', 'ace-theme' ), ace_get_phone() ); ?>">
				<?php echo ace_icon( 'phone', 18 ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
				<?php echo esc_html( ace_get_phone() ); ?>
			</a>
			<a href="<?php echo esc_url( home_url( '/contact/' ) ); ?>" class="btn btn-primary">
				<?php esc_html_e( 'Free Consultation', 'ace-theme' ); ?>
			</a>
		</div>

	</div>
</div>

<?php
// Breadcrumbs (inner pages only).
if ( ! is_front_page() ) :
	ace_breadcrumbs();
endif;
?>

<main id="main-content" class="site-content" role="main">
