<?php
/**
 * SEO Meta Tags
 */

function ace_output_meta_tags() {
    // Don't output if an SEO plugin is active
    if ( defined( 'WPSEO_VERSION' ) || defined( 'RANK_MATH_VERSION' ) || defined( 'AIOSEO_VERSION' ) ) {
        return;
    }

    $seo = get_option( 'ace_seo', array() );
    $title = '';
    $description = '';
    $og_image = ace_get_option( 'og_image', '' );

    // Determine page-specific meta
    if ( is_front_page() ) {
        // Check both formats: nested array and flat keys
        if ( isset( $seo['home']['meta_title'] ) ) {
            $title = $seo['home']['meta_title'];
        } elseif ( isset( $seo['home_title'] ) ) {
            $title = $seo['home_title'];
        } else {
            $title = 'ACE Design & Build | Premier Home Remodeling Contractor in Los Angeles';
        }
        if ( isset( $seo['home']['meta_description'] ) ) {
            $description = $seo['home']['meta_description'];
        } elseif ( isset( $seo['home_description'] ) ) {
            $description = $seo['home_description'];
        } else {
            $description = 'ACE Design & Build is Los Angeles\' trusted design-build firm. Kitchen remodeling, bathroom renovation, ADUs, home additions, and outdoor living. 15+ years. Free consultations. Call (310) 438-6866.';
        }
    } elseif ( is_page() ) {
        $page_slug = get_post_field( 'post_name', get_the_ID() );
        $seo_key = str_replace( '-', '_', $page_slug );

        // Map common page slugs to SEO keys
        $slug_map = array(
            'about'   => 'about',
            'our_work' => 'portfolio',
        );
        $lookup = isset( $slug_map[ $seo_key ] ) ? $slug_map[ $seo_key ] : $seo_key;

        // Check nested array format first, then flat keys
        if ( isset( $seo[ $lookup ]['meta_title'] ) ) {
            $title = $seo[ $lookup ]['meta_title'];
        } elseif ( isset( $seo[ $seo_key . '_title' ] ) ) {
            $title = $seo[ $seo_key . '_title' ];
        } else {
            $title = get_the_title() . ' | ' . ace_get_company_name();
        }

        if ( isset( $seo[ $lookup ]['meta_description'] ) ) {
            $description = $seo[ $lookup ]['meta_description'];
        } elseif ( isset( $seo[ $seo_key . '_description' ] ) ) {
            $description = $seo[ $seo_key . '_description' ];
        }
    } elseif ( is_singular( 'post' ) ) {
        $title = get_the_title() . ' | ' . ace_get_company_name() . ' Blog';
        $description = wp_trim_words( get_the_excerpt(), 30, '...' );
        if ( has_post_thumbnail() ) {
            $og_image = get_the_post_thumbnail_url( null, 'large' );
        }
    } elseif ( is_home() ) {
        if ( isset( $seo['blog']['meta_title'] ) ) {
            $title = $seo['blog']['meta_title'];
        } elseif ( isset( $seo['blog_title'] ) ) {
            $title = $seo['blog_title'];
        } else {
            $title = 'Remodeling Tips & Expert Insights | ACE Design & Build Blog';
        }
        if ( isset( $seo['blog']['meta_description'] ) ) {
            $description = $seo['blog']['meta_description'];
        } elseif ( isset( $seo['blog_description'] ) ) {
            $description = $seo['blog_description'];
        } else {
            $description = 'Expert home remodeling tips, design inspiration, and construction insights from ACE Design & Build in Los Angeles.';
        }
    } elseif ( is_archive() ) {
        $title = 'Remodeling Tips & Expert Insights | ACE Design & Build Blog';
        $description = 'Expert home remodeling tips, design inspiration, and construction insights from ACE Design & Build in Los Angeles.';
    }

    // Output meta description
    if ( $description ) {
        echo '<meta name="description" content="' . esc_attr( $description ) . '">' . "\n";
    }

    // Open Graph tags
    echo '<meta property="og:type" content="website">' . "\n";
    echo '<meta property="og:title" content="' . esc_attr( $title ?: get_the_title() ) . '">' . "\n";
    if ( $description ) {
        echo '<meta property="og:description" content="' . esc_attr( $description ) . '">' . "\n";
    }
    echo '<meta property="og:url" content="' . esc_url( get_permalink() ?: home_url( '/' ) ) . '">' . "\n";
    echo '<meta property="og:site_name" content="' . esc_attr( ace_get_company_name() ) . '">' . "\n";
    if ( $og_image ) {
        echo '<meta property="og:image" content="' . esc_url( $og_image ) . '">' . "\n";
    }

    // Twitter Card
    echo '<meta name="twitter:card" content="summary_large_image">' . "\n";
    echo '<meta name="twitter:title" content="' . esc_attr( $title ?: get_the_title() ) . '">' . "\n";
    if ( $description ) {
        echo '<meta name="twitter:description" content="' . esc_attr( $description ) . '">' . "\n";
    }
    if ( $og_image ) {
        echo '<meta name="twitter:image" content="' . esc_url( $og_image ) . '">' . "\n";
    }

    // Canonical URL
    echo '<link rel="canonical" href="' . esc_url( get_permalink() ?: home_url( '/' ) ) . '">' . "\n";
}
add_action( 'wp_head', 'ace_output_meta_tags', 1 );

/**
 * Replace WordPress default en-dash separator in document title with a hyphen.
 */
function ace_title_separator( $sep ) {
    return '-';
}
add_filter( 'document_title_separator', 'ace_title_separator' );
