<?php
/**
 * Theme setup and configuration.
 *
 * @package ACE_Theme
 * @since 1.0.0
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * @since 1.0.0
 * @return void
 */
function ace_theme_setup() {
	// Add theme support for title tag.
	add_theme_support( 'title-tag' );

	// Add theme support for post thumbnails.
	add_theme_support( 'post-thumbnails' );

	// Add theme support for HTML5 markup.
	add_theme_support( 'html5', array(
		'search-form',
		'comment-form',
		'comment-list',
		'gallery',
		'caption',
		'style',
		'script',
	) );

	// Add theme support for custom logo.
	add_theme_support( 'custom-logo', array(
		'height'      => 55,
		'width'       => 200,
		'flex-height' => true,
		'flex-width'  => true,
	) );

	// Add theme support for automatic feed links.
	add_theme_support( 'automatic-feed-links' );

	// Register navigation menus.
	register_nav_menus( array(
		'primary'  => __( 'Primary Menu', 'ace-theme' ),
		'footer'   => __( 'Footer Menu', 'ace-theme' ),
		'services' => __( 'Services Menu', 'ace-theme' ),
	) );

	// Custom image sizes.
	add_image_size( 'ace-hero', 1920, 900, true );
	add_image_size( 'ace-service-card', 600, 400, true );
	add_image_size( 'ace-portfolio', 800, 600, true );
	add_image_size( 'ace-blog-card', 600, 400, true );
	add_image_size( 'ace-testimonial-avatar', 80, 80, true );
	add_image_size( 'ace-about', 800, 1000, true );

	// Set content width.
	if ( ! isset( $content_width ) ) {
		$content_width = 1280;
	}
}
add_action( 'after_setup_theme', 'ace_theme_setup' );

/**
 * Register widget areas.
 *
 * @since 1.0.0
 * @return void
 */
function ace_widgets_init() {
	register_sidebar( array(
		'name'          => __( 'Blog Sidebar', 'ace-theme' ),
		'id'            => 'blog-sidebar',
		'description'   => __( 'Widgets for the blog sidebar', 'ace-theme' ),
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );
}
add_action( 'widgets_init', 'ace_widgets_init' );
