<?php
/**
 * Template Name: Thank You Page
 * @package ACE_Theme
 */
get_header();
?>

<section class="section bg-white thank-you-section">
    <div class="container">
        <div class="thank-you-content text-center">
            <div class="thank-you-icon">
                <?php echo ace_icon( 'check-circle', 64 ); ?>
            </div>
            <h1><?php esc_html_e( 'Thank You! We\'ve Received Your Request.', 'ace-theme' ); ?></h1>
            <p class="thank-you-intro"><?php esc_html_e( 'One of our project consultants will reach out within 2 hours during business hours. In the meantime, here\'s what you can expect:', 'ace-theme' ); ?></p>

            <div class="thank-you-steps">
                <div class="thank-you-step">
                    <div class="step-number">1</div>
                    <h3><?php esc_html_e( 'We\'ll Review Your Project Details', 'ace-theme' ); ?></h3>
                    <p><?php esc_html_e( 'Our team will carefully review the information you provided to understand your project needs.', 'ace-theme' ); ?></p>
                </div>
                <div class="thank-you-step">
                    <div class="step-number">2</div>
                    <h3><?php esc_html_e( 'We\'ll Call to Schedule Your Consultation', 'ace-theme' ); ?></h3>
                    <p><?php esc_html_e( 'A project consultant will contact you using your preferred method to schedule a free in-home consultation.', 'ace-theme' ); ?></p>
                </div>
                <div class="thank-you-step">
                    <div class="step-number">3</div>
                    <h3><?php esc_html_e( 'We\'ll Prepare Your Custom Proposal', 'ace-theme' ); ?></h3>
                    <p><?php esc_html_e( 'After visiting your home, we\'ll create a detailed proposal with design concepts, timeline, and transparent pricing.', 'ace-theme' ); ?></p>
                </div>
            </div>

            <div class="thank-you-cta">
                <a href="<?php echo esc_url( home_url( '/our-work/' ) ); ?>" class="btn btn-primary btn-lg">
                    <?php esc_html_e( 'Explore Our Recent Work', 'ace-theme' ); ?>
                </a>
            </div>

            <div class="trust-bar trust-bar-centered">
                <div class="trust-item">
                    <?php echo ace_icon( 'shield', 20 ); ?>
                    <span><?php esc_html_e( 'Licensed & Bonded', 'ace-theme' ); ?></span>
                </div>
                <div class="trust-item">
                    <?php echo ace_icon( 'dollar-sign', 20 ); ?>
                    <span><?php esc_html_e( 'Free Estimates', 'ace-theme' ); ?></span>
                </div>
                <div class="trust-item">
                    <?php echo ace_icon( 'award', 20 ); ?>
                    <span><?php esc_html_e( '15+ Years', 'ace-theme' ); ?></span>
                </div>
                <div class="trust-item">
                    <?php echo ace_icon( 'check-circle', 20 ); ?>
                    <span><?php esc_html_e( 'Satisfaction Guaranteed', 'ace-theme' ); ?></span>
                </div>
            </div>
        </div>
    </div>
</section>

<?php get_footer(); ?>
