<?php
/**
 * Single Project Template
 * @package ACE_Theme
 */
get_header();
$categories = get_the_terms( get_the_ID(), 'project_category' );
$category_name = $categories && ! is_wp_error( $categories ) ? $categories[0]->name : '';
$location = get_post_meta( get_the_ID(), '_ace_project_location', true );
?>

<section class="page-hero page-hero-sm">
    <div class="page-hero-overlay">
        <div class="container">
            <h1 class="page-hero-title"><?php the_title(); ?></h1>
            <div class="project-meta-bar">
                <?php if ( $category_name ) : ?>
                    <span class="project-meta-item"><?php echo ace_icon( 'home', 16 ); ?> <?php echo esc_html( $category_name ); ?></span>
                <?php endif; ?>
                <?php if ( $location ) : ?>
                    <span class="project-meta-item"><?php echo ace_icon( 'map-pin', 16 ); ?> <?php echo esc_html( $location ); ?></span>
                <?php endif; ?>
            </div>
        </div>
    </div>
</section>

<section class="section bg-white">
    <div class="container">
        <?php if ( has_post_thumbnail() ) : ?>
            <div class="project-featured-image">
                <?php the_post_thumbnail( 'ace-hero' ); ?>
            </div>
        <?php endif; ?>

        <div class="project-content">
            <?php the_content(); ?>
        </div>

        <?php
        // Additional project images from gallery meta
        $gallery = get_post_meta( get_the_ID(), '_ace_project_gallery', true );
        if ( ! empty( $gallery ) && is_array( $gallery ) ) : ?>
            <div class="project-gallery">
                <h2><?php esc_html_e( 'Project Gallery', 'ace-theme' ); ?></h2>
                <div class="gallery-grid">
                    <?php foreach ( $gallery as $image_id ) : ?>
                        <div class="gallery-item">
                            <?php echo wp_get_attachment_image( $image_id, 'ace-portfolio', false, array( 'loading' => 'lazy' ) ); ?>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        <?php endif; ?>
    </div>
</section>

<!-- CTA -->
<?php get_template_part( 'template-parts/cta-banner' ); ?>

<?php get_footer(); ?>
