<?php
/**
 * Service Card Template Part
 *
 * @package ACE_Theme
 */

$service = isset( $args['service'] ) ? $args['service'] : array();
if ( empty( $service ) ) return;
$image = isset( $service['hero_image'] ) ? $service['hero_image'] : '';
?>
<a href="<?php echo esc_url( home_url( '/services/' . $service['slug'] . '/' ) ); ?>" class="service-card">
    <div class="service-card-image">
        <?php if ( $image ) : ?>
            <img src="<?php echo esc_url( $image ); ?>" alt="<?php echo esc_attr( $service['title'] ); ?>" loading="lazy">
        <?php else : ?>
            <div class="service-card-placeholder">
                <?php echo ace_icon( 'home', 48 ); ?>
            </div>
        <?php endif; ?>
        <div class="service-card-overlay">
            <h3><?php echo esc_html( $service['title'] ); ?></h3>
        </div>
    </div>
</a>
