<?php
/**
 * Stats Counter Template Part
 *
 * @package ACE_Theme
 */

$stats = ace_get_stats();
$default_stats = array(
    array( 'number' => '2000', 'suffix' => '+', 'label' => 'Projects Completed' ),
    array( 'number' => '15', 'suffix' => '+', 'label' => 'Years of Experience' ),
    array( 'number' => '4.9', 'suffix' => '', 'label' => 'Google Rating' ),
    array( 'number' => '98', 'suffix' => '%', 'label' => 'Client Satisfaction' ),
);
$stats = ! empty( $stats ) ? $stats : $default_stats;
?>
<section class="stats-section bg-navy">
    <div class="container">
        <div class="stats-grid">
            <?php foreach ( $stats as $stat ) : ?>
                <div class="stat-item">
                    <div class="stat-number" data-target="<?php echo esc_attr( $stat['number'] ); ?>" data-suffix="<?php echo esc_attr( isset( $stat['suffix'] ) ? $stat['suffix'] : '' ); ?>">
                        0<?php echo esc_html( isset( $stat['suffix'] ) ? $stat['suffix'] : '' ); ?>
                    </div>
                    <div class="stat-label"><?php echo esc_html( $stat['label'] ); ?></div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>
