<?php
/**
 * Testimonial Card Template Part
 *
 * Expects $args['testimonial'] to be passed
 *
 * @package ACE_Theme
 */

$testimonial = isset( $args['testimonial'] ) ? $args['testimonial'] : array();
if ( empty( $testimonial ) ) return;
?>
<div class="testimonial-card">
    <div class="testimonial-quote-icon">
        <?php echo ace_icon( 'quote', 32 ); ?>
    </div>
    <blockquote class="testimonial-text">
        <?php echo esc_html( $testimonial['text'] ); ?>
    </blockquote>
    <div class="testimonial-rating">
        <?php
        $rating = isset( $testimonial['rating'] ) ? intval( $testimonial['rating'] ) : 5;
        for ( $i = 0; $i < $rating; $i++ ) {
            echo ace_icon( 'star', 16, 'star-filled' );
        }
        ?>
    </div>
    <div class="testimonial-author">
        <?php if ( ! empty( $testimonial['avatar'] ) ) : ?>
            <img src="<?php echo esc_url( $testimonial['avatar'] ); ?>" alt="<?php echo esc_attr( $testimonial['name'] ); ?>" class="testimonial-avatar" loading="lazy">
        <?php endif; ?>
        <div class="testimonial-info">
            <strong><?php echo esc_html( $testimonial['name'] ); ?></strong>
            <?php if ( ! empty( $testimonial['location'] ) ) : ?>
                <span><?php echo esc_html( $testimonial['location'] ); ?></span>
            <?php endif; ?>
            <?php if ( ! empty( $testimonial['project_type'] ) ) : ?>
                <span class="testimonial-project"><?php echo esc_html( $testimonial['project_type'] ); ?></span>
            <?php endif; ?>
        </div>
    </div>
</div>
