<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
require_once('wp-load.php');

echo "WordPress loaded<br>";

// Test decryption
$enc = get_option('ace_gemini_api_key_enc');
$salt = AUTH_SALT;
$method = 'aes-256-cbc';

$data = base64_decode($enc);
$iv_len = openssl_cipher_iv_length($method);
$iv = substr($data, 0, $iv_len);
$encrypted = substr($data, $iv_len);
$key_hash = hash('sha256', $salt, true);
$decrypted = openssl_decrypt($encrypted, $method, $key_hash, OPENSSL_RAW_DATA, $iv);

echo "Decryption result: " . (!empty($decrypted) ? 'SUCCESS (key length: ' . strlen($decrypted) . ')' : 'FAILED') . "<br>";

// Test API call
if (!empty($decrypted)) {
    $url = 'https://generativelanguage.googleapis.com/v1beta/models/gemini-2.0-flash-exp:generateContent?key=' . $decrypted;
    $response = wp_remote_post($url, [
        'headers' => ['Content-Type' => 'application/json'],
        'timeout' => 30,
        'body' => json_encode([
            'contents' => [['parts' => [['text' => 'Say hello']]]]
        ])
    ]);
    
    if (is_wp_error($response)) {
        echo "API Error: " . $response->get_error_message() . "<br>";
    } else {
        $code = wp_remote_retrieve_response_code($response);
        echo "API Response Code: " . $code . "<br>";
        if ($code !== 200) {
            echo "API Body: " . wp_remote_retrieve_body($response) . "<br>";
        } else {
            echo "API call SUCCESS<br>";
        }
    }
}