<?php
if (!defined('ABSPATH')) exit;

$settings = get_option('ace_backyard_lp_settings', array());
if (empty($settings)) {
    $settings = ace_blp_get_defaults();
}

// Helper to get setting with fallback
function blp_get($settings, $key, $default = '') {
    return isset($settings[$key]) ? $settings[$key] : $default;
}

$defaults = ace_blp_get_defaults();
?>

<div class="wrap ace-blp-admin">
    <h1>Backyard Landing Page</h1>

    <?php if (isset($_GET['settings-updated'])): ?>
    <div class="notice notice-success is-dismissible"><p>Settings saved.</p></div>
    <?php endif; ?>

    <div class="ace-blp-tabs">
        <nav class="ace-blp-tab-nav">
            <button class="tab-btn active" data-tab="general">General</button>
            <button class="tab-btn" data-tab="hero">Hero</button>
            <button class="tab-btn" data-tab="proof">Proof Strip</button>
            <button class="tab-btn" data-tab="transform">Transformation</button>
            <button class="tab-btn" data-tab="calculator">Calculator</button>
            <button class="tab-btn" data-tab="services">Services</button>
            <button class="tab-btn" data-tab="projects">Projects</button>
            <button class="tab-btn" data-tab="cta">CTA Bar</button>
            <button class="tab-btn" data-tab="reviews">Reviews</button>
            <button class="tab-btn" data-tab="why">Why ACE</button>
            <button class="tab-btn" data-tab="process">Process</button>
            <button class="tab-btn" data-tab="faq">FAQ</button>
            <button class="tab-btn" data-tab="final">Final CTA</button>
            <button class="tab-btn" data-tab="leads">Leads</button>
        </nav>

        <form method="post" action="options.php" id="ace-blp-settings-form">
            <?php settings_fields('ace_backyard_lp_group'); ?>

            <!-- ==================== TAB 1: GENERAL ==================== -->
            <div class="tab-panel active" id="tab-general">
                <h3 class="section-header">General Settings</h3>

                <div class="ace-blp-info">
                    Tracking codes from your theme's Header/Body/Footer script settings and analytics plugins are automatically included on this landing page. No need to add them again here.
                </div>

                <div class="ace-blp-field">
                    <label for="blp-slug">Page Slug</label>
                    <input type="text" id="blp-slug" name="ace_backyard_lp_settings[slug]" value="<?php echo esc_attr(blp_get($settings, 'slug', $defaults['slug'])); ?>">
                    <p class="description">The URL will be: <?php echo esc_url(home_url('/')); ?><strong>[slug]</strong>/</p>
                </div>

                <div class="ace-blp-field">
                    <label for="blp-phone">Phone Number</label>
                    <input type="text" id="blp-phone" name="ace_backyard_lp_settings[phone]" value="<?php echo esc_attr(blp_get($settings, 'phone', $defaults['phone'])); ?>">
                </div>

                <div class="ace-blp-field">
                    <label for="blp-email">Email Address</label>
                    <input type="email" id="blp-email" name="ace_backyard_lp_settings[email]" value="<?php echo esc_attr(blp_get($settings, 'email', $defaults['email'])); ?>">
                    <p class="description">Lead notification emails will be sent here.</p>
                </div>

                <div class="ace-blp-field">
                    <label>Logo</label>
                    <?php $logo_url = blp_get($settings, 'logo', ''); ?>
                    <div class="media-field">
                        <input type="hidden" name="ace_backyard_lp_settings[logo]" value="<?php echo esc_attr($logo_url); ?>">
                        <div class="media-preview"><?php if ($logo_url): ?><img src="<?php echo esc_url($logo_url); ?>" style="max-width:200px;"><?php endif; ?></div>
                        <button type="button" class="button upload-image-btn">Upload Image</button>
                        <button type="button" class="button remove-image-btn" <?php if (!$logo_url) echo 'style="display:none;"'; ?>>Remove</button>
                    </div>
                    <p class="description">Upload the logo for the landing page top bar. Recommended: PNG with transparency.</p>
                </div>

                <div class="ace-blp-field">
                    <label for="blp-logo-height">Logo Height (px)</label>
                    <input type="range" id="blp-logo-height" name="ace_backyard_lp_settings[logo_height]" min="30" max="120" value="<?php echo intval(blp_get($settings, 'logo_height', 50)); ?>" oninput="document.getElementById('blp-logo-height-val').textContent=this.value">
                    <span id="blp-logo-height-val"><?php echo intval(blp_get($settings, 'logo_height', 50)); ?></span>px
                    <p class="description">Header logo display height (30–120px, default 50).</p>
                </div>

                <div class="ace-blp-field">
                    <label for="blp-logo-link">Logo Click Link</label>
                    <input type="text" id="blp-logo-link" name="ace_backyard_lp_settings[logo_link]" value="<?php echo esc_attr(blp_get($settings, 'logo_link', '#hero')); ?>">
                    <p class="description">Where the header logo links to. Use <code>#hero</code> for smooth scroll to top, or a full URL.</p>
                </div>

                <h3 class="section-header">Footer White Logo</h3>

                <div class="ace-blp-field">
                    <label>White Logo (Footer)</label>
                    <?php $logo_white_url = blp_get($settings, 'logo_white', ''); ?>
                    <div class="media-field">
                        <input type="hidden" name="ace_backyard_lp_settings[logo_white]" value="<?php echo esc_attr($logo_white_url); ?>">
                        <div class="media-preview"><?php if ($logo_white_url): ?><img src="<?php echo esc_url($logo_white_url); ?>" style="max-width:200px; background:#333; padding:8px;"><?php endif; ?></div>
                        <button type="button" class="button upload-image-btn">Upload Image</button>
                        <button type="button" class="button remove-image-btn" <?php if (!$logo_white_url) echo 'style="display:none;"'; ?>>Remove</button>
                    </div>
                    <p class="description">White/light version of the logo for the dark footer. If empty, no logo shows in footer.</p>
                </div>

                <div class="ace-blp-field">
                    <label for="blp-logo-white-height">Footer Logo Height (px)</label>
                    <input type="range" id="blp-logo-white-height" name="ace_backyard_lp_settings[logo_white_height]" min="20" max="100" value="<?php echo intval(blp_get($settings, 'logo_white_height', 40)); ?>" oninput="document.getElementById('blp-logo-white-height-val').textContent=this.value">
                    <span id="blp-logo-white-height-val"><?php echo intval(blp_get($settings, 'logo_white_height', 40)); ?></span>px
                    <p class="description">Footer logo display height (20–100px, default 40).</p>
                </div>

                <div class="ace-blp-field">
                    <label for="blp-logo-white-link">Footer Logo Click Link</label>
                    <input type="text" id="blp-logo-white-link" name="ace_backyard_lp_settings[logo_white_link]" value="<?php echo esc_attr(blp_get($settings, 'logo_white_link', '#hero')); ?>">
                    <p class="description">Where the footer logo links to. Use <code>#hero</code> for smooth scroll to top, or a full URL.</p>
                </div>

                <div class="ace-blp-field">
                    <div class="ace-blp-toggle">
                        <input type="hidden" name="ace_backyard_lp_settings[enabled]" value="0">
                        <input type="checkbox" id="blp-enabled" name="ace_backyard_lp_settings[enabled]" value="1" <?php checked(blp_get($settings, 'enabled', $defaults['enabled']), 1); ?>>
                        <label for="blp-enabled">Enable Landing Page</label>
                    </div>
                </div>

                <div class="ace-blp-field">
                    <div class="ace-blp-toggle">
                        <input type="hidden" name="ace_backyard_lp_settings[scroll_nav_enabled]" value="0">
                        <input type="checkbox" id="blp-scroll-nav" name="ace_backyard_lp_settings[scroll_nav_enabled]" value="1" <?php checked(blp_get($settings, 'scroll_nav_enabled', $defaults['scroll_nav_enabled']), 1); ?>>
                        <label for="blp-scroll-nav">Enable Scroll Navigation</label>
                    </div>
                </div>

                <h3 class="section-header">Scroll Navigation Labels</h3>
                <?php $scroll_labels = blp_get($settings, 'scroll_nav_labels', $defaults['scroll_nav_labels']); ?>
                <div class="repeater" data-name="scroll_nav_labels">
                    <div class="repeater-items">
                        <?php foreach ($scroll_labels as $i => $item): ?>
                        <div class="repeater-item" data-index="<?php echo $i; ?>">
                            <div class="repeater-handle"><span class="dashicons dashicons-menu"></span></div>
                            <div class="repeater-fields">
                                <div class="field-group">
                                    <label>Target (CSS selector)</label>
                                    <input type="text" name="ace_backyard_lp_settings[scroll_nav_labels][<?php echo $i; ?>][target]" value="<?php echo esc_attr($item['target']); ?>" placeholder="#section-id">
                                </div>
                                <div class="field-group">
                                    <label>Label</label>
                                    <input type="text" name="ace_backyard_lp_settings[scroll_nav_labels][<?php echo $i; ?>][label]" value="<?php echo esc_attr($item['label']); ?>" placeholder="Nav Label">
                                </div>
                            </div>
                            <button type="button" class="button repeater-remove">Remove</button>
                        </div>
                        <?php endforeach; ?>
                    </div>
                    <button type="button" class="button repeater-add">Add Item</button>
                </div>

                <h3 class="section-header">SEO Settings</h3>

                <div class="ace-blp-field">
                    <label for="blp-seo-title">SEO Title</label>
                    <input type="text" id="blp-seo-title" name="ace_backyard_lp_settings[seo_title]" value="<?php echo esc_attr(blp_get($settings, 'seo_title', $defaults['seo_title'])); ?>">
                </div>

                <div class="ace-blp-field">
                    <label for="blp-seo-desc">SEO Description</label>
                    <textarea id="blp-seo-desc" name="ace_backyard_lp_settings[seo_description]"><?php echo esc_textarea(blp_get($settings, 'seo_description', $defaults['seo_description'])); ?></textarea>
                </div>

                <div class="ace-blp-field">
                    <label>OG Image</label>
                    <?php $og_image = blp_get($settings, 'og_image', ''); ?>
                    <div class="media-field">
                        <input type="hidden" name="ace_backyard_lp_settings[og_image]" value="<?php echo esc_attr($og_image); ?>">
                        <div class="media-preview"><?php if ($og_image): ?><img src="<?php echo esc_url($og_image); ?>" style="max-width:200px;"><?php endif; ?></div>
                        <button type="button" class="button upload-image-btn">Upload Image</button>
                        <button type="button" class="button remove-image-btn" <?php if (!$og_image) echo 'style="display:none;"'; ?>>Remove</button>
                    </div>
                </div>
            </div>

            <!-- ==================== TAB 2: HERO ==================== -->
            <div class="tab-panel" id="tab-hero">
                <h3 class="section-header">Hero Section</h3>

                <div class="ace-blp-field">
                    <div class="ace-blp-toggle">
                        <input type="hidden" name="ace_backyard_lp_settings[hero_enabled]" value="0">
                        <input type="checkbox" id="blp-hero-enabled" name="ace_backyard_lp_settings[hero_enabled]" value="1" <?php checked(blp_get($settings, 'hero_enabled', $defaults['hero_enabled']), 1); ?>>
                        <label for="blp-hero-enabled">Enable Hero Section</label>
                    </div>
                </div>

                <div class="ace-blp-field">
                    <label for="blp-hero-badge">Badge Text</label>
                    <input type="text" id="blp-hero-badge" name="ace_backyard_lp_settings[hero_badge]" value="<?php echo esc_attr(blp_get($settings, 'hero_badge', $defaults['hero_badge'])); ?>">
                </div>

                <div class="ace-blp-field">
                    <label for="blp-hero-headline">Headline</label>
                    <input type="text" id="blp-hero-headline" name="ace_backyard_lp_settings[hero_headline]" value="<?php echo esc_attr(blp_get($settings, 'hero_headline', $defaults['hero_headline'])); ?>">
                </div>

                <div class="ace-blp-field">
                    <label for="blp-hero-gold">Gold Word</label>
                    <input type="text" id="blp-hero-gold" name="ace_backyard_lp_settings[hero_gold_word]" value="<?php echo esc_attr(blp_get($settings, 'hero_gold_word', $defaults['hero_gold_word'])); ?>">
                    <p class="description">This word in the headline will be highlighted in gold.</p>
                </div>

                <div class="ace-blp-field">
                    <label for="blp-hero-sub">Subheadline</label>
                    <textarea id="blp-hero-sub" name="ace_backyard_lp_settings[hero_subheadline]"><?php echo esc_textarea(blp_get($settings, 'hero_subheadline', $defaults['hero_subheadline'])); ?></textarea>
                </div>

                <div class="ace-blp-field">
                    <label>Background Image</label>
                    <?php $hero_bg = blp_get($settings, 'hero_bg_image', ''); ?>
                    <div class="media-field">
                        <input type="hidden" name="ace_backyard_lp_settings[hero_bg_image]" value="<?php echo esc_attr($hero_bg); ?>">
                        <div class="media-preview"><?php if ($hero_bg): ?><img src="<?php echo esc_url($hero_bg); ?>" style="max-width:200px;"><?php endif; ?></div>
                        <button type="button" class="button upload-image-btn">Upload Image</button>
                        <button type="button" class="button remove-image-btn" <?php if (!$hero_bg) echo 'style="display:none;"'; ?>>Remove</button>
                    </div>
                </div>

                <h3 class="section-header">Hero Form</h3>

                <div class="ace-blp-field">
                    <label for="blp-hero-form-title">Form Title</label>
                    <input type="text" id="blp-hero-form-title" name="ace_backyard_lp_settings[hero_form_title]" value="<?php echo esc_attr(blp_get($settings, 'hero_form_title', $defaults['hero_form_title'])); ?>">
                </div>

                <div class="ace-blp-field">
                    <label for="blp-hero-form-sub">Form Subtitle</label>
                    <input type="text" id="blp-hero-form-sub" name="ace_backyard_lp_settings[hero_form_subtitle]" value="<?php echo esc_attr(blp_get($settings, 'hero_form_subtitle', $defaults['hero_form_subtitle'])); ?>">
                </div>

                <div class="ace-blp-field">
                    <label for="blp-hero-form-btn">Form Button Text</label>
                    <input type="text" id="blp-hero-form-btn" name="ace_backyard_lp_settings[hero_form_button]" value="<?php echo esc_attr(blp_get($settings, 'hero_form_button', $defaults['hero_form_button'])); ?>">
                </div>

                <h3 class="section-header">Trust Indicators</h3>
                <?php $hero_trust = blp_get($settings, 'hero_trust', $defaults['hero_trust']); ?>
                <div class="repeater" data-name="hero_trust">
                    <div class="repeater-items">
                        <?php foreach ($hero_trust as $i => $item): ?>
                        <div class="repeater-item" data-index="<?php echo $i; ?>">
                            <div class="repeater-handle"><span class="dashicons dashicons-menu"></span></div>
                            <div class="repeater-fields">
                                <div class="field-group">
                                    <label>Icon Class</label>
                                    <input type="text" name="ace_backyard_lp_settings[hero_trust][<?php echo $i; ?>][icon]" value="<?php echo esc_attr($item['icon']); ?>" placeholder="fas fa-star">
                                </div>
                                <div class="field-group">
                                    <label>Text</label>
                                    <input type="text" name="ace_backyard_lp_settings[hero_trust][<?php echo $i; ?>][text]" value="<?php echo esc_attr($item['text']); ?>" placeholder="Trust text">
                                </div>
                            </div>
                            <button type="button" class="button repeater-remove">Remove</button>
                        </div>
                        <?php endforeach; ?>
                    </div>
                    <button type="button" class="button repeater-add">Add Item</button>
                </div>
            </div>

            <!-- ==================== TAB 3: PROOF STRIP ==================== -->
            <div class="tab-panel" id="tab-proof">
                <h3 class="section-header">Proof Strip</h3>

                <div class="ace-blp-field">
                    <div class="ace-blp-toggle">
                        <input type="hidden" name="ace_backyard_lp_settings[proof_enabled]" value="0">
                        <input type="checkbox" id="blp-proof-enabled" name="ace_backyard_lp_settings[proof_enabled]" value="1" <?php checked(blp_get($settings, 'proof_enabled', $defaults['proof_enabled']), 1); ?>>
                        <label for="blp-proof-enabled">Enable Proof Strip</label>
                    </div>
                </div>

                <div class="ace-blp-field">
                    <label for="blp-proof-speed">Scroll Speed (seconds)</label>
                    <input type="number" id="blp-proof-speed" name="ace_backyard_lp_settings[proof_speed]" value="<?php echo esc_attr(blp_get($settings, 'proof_speed', $defaults['proof_speed'])); ?>" min="5" max="120" step="1">
                    <p class="description">Duration in seconds for one full scroll cycle.</p>
                </div>

                <h3 class="section-header">Proof Images</h3>
                <?php $proof_images = blp_get($settings, 'proof_images', $defaults['proof_images']); ?>
                <?php if (empty($proof_images)) $proof_images = array(''); ?>
                <div class="repeater" data-name="proof_images">
                    <div class="repeater-items">
                        <?php foreach ($proof_images as $i => $img): ?>
                        <div class="repeater-item" data-index="<?php echo $i; ?>">
                            <div class="repeater-handle"><span class="dashicons dashicons-menu"></span></div>
                            <div class="repeater-fields">
                                <div class="field-group" style="width:100%;">
                                    <label>Image</label>
                                    <div class="media-field">
                                        <input type="hidden" name="ace_backyard_lp_settings[proof_images][<?php echo $i; ?>]" value="<?php echo esc_attr($img); ?>">
                                        <div class="media-preview"><?php if ($img): ?><img src="<?php echo esc_url($img); ?>" style="max-width:200px;"><?php endif; ?></div>
                                        <button type="button" class="button upload-image-btn">Upload Image</button>
                                        <button type="button" class="button remove-image-btn" <?php if (!$img) echo 'style="display:none;"'; ?>>Remove</button>
                                    </div>
                                </div>
                            </div>
                            <button type="button" class="button repeater-remove">Remove</button>
                        </div>
                        <?php endforeach; ?>
                    </div>
                    <button type="button" class="button repeater-add">Add Item</button>
                </div>
            </div>

            <!-- ==================== TAB 4: TRANSFORMATION ==================== -->
            <div class="tab-panel" id="tab-transform">
                <h3 class="section-header">Transformation Section</h3>

                <div class="ace-blp-field">
                    <div class="ace-blp-toggle">
                        <input type="hidden" name="ace_backyard_lp_settings[transform_enabled]" value="0">
                        <input type="checkbox" id="blp-transform-enabled" name="ace_backyard_lp_settings[transform_enabled]" value="1" <?php checked(blp_get($settings, 'transform_enabled', $defaults['transform_enabled']), 1); ?>>
                        <label for="blp-transform-enabled">Enable Transformation Section</label>
                    </div>
                </div>

                <div class="ace-blp-field">
                    <label for="blp-transform-label">Section Label</label>
                    <input type="text" id="blp-transform-label" name="ace_backyard_lp_settings[transform_label]" value="<?php echo esc_attr(blp_get($settings, 'transform_label', $defaults['transform_label'])); ?>">
                </div>

                <div class="ace-blp-field">
                    <label for="blp-transform-headline">Headline</label>
                    <input type="text" id="blp-transform-headline" name="ace_backyard_lp_settings[transform_headline]" value="<?php echo esc_attr(blp_get($settings, 'transform_headline', $defaults['transform_headline'])); ?>">
                </div>

                <div class="ace-blp-field">
                    <label for="blp-transform-gold">Gold Word</label>
                    <input type="text" id="blp-transform-gold" name="ace_backyard_lp_settings[transform_gold_word]" value="<?php echo esc_attr(blp_get($settings, 'transform_gold_word', $defaults['transform_gold_word'])); ?>">
                </div>

                <div class="ace-blp-field">
                    <label for="blp-transform-sub">Subheadline</label>
                    <textarea id="blp-transform-sub" name="ace_backyard_lp_settings[transform_subheadline]"><?php echo esc_textarea(blp_get($settings, 'transform_subheadline', $defaults['transform_subheadline'])); ?></textarea>
                </div>

                <div class="ace-blp-field">
                    <label>Before Image</label>
                    <?php $before_img = blp_get($settings, 'transform_before_image', ''); ?>
                    <div class="media-field">
                        <input type="hidden" name="ace_backyard_lp_settings[transform_before_image]" value="<?php echo esc_attr($before_img); ?>">
                        <div class="media-preview"><?php if ($before_img): ?><img src="<?php echo esc_url($before_img); ?>" style="max-width:200px;"><?php endif; ?></div>
                        <button type="button" class="button upload-image-btn">Upload Image</button>
                        <button type="button" class="button remove-image-btn" <?php if (!$before_img) echo 'style="display:none;"'; ?>>Remove</button>
                    </div>
                </div>

                <div class="ace-blp-field">
                    <label>After Image</label>
                    <?php $after_img = blp_get($settings, 'transform_after_image', ''); ?>
                    <div class="media-field">
                        <input type="hidden" name="ace_backyard_lp_settings[transform_after_image]" value="<?php echo esc_attr($after_img); ?>">
                        <div class="media-preview"><?php if ($after_img): ?><img src="<?php echo esc_url($after_img); ?>" style="max-width:200px;"><?php endif; ?></div>
                        <button type="button" class="button upload-image-btn">Upload Image</button>
                        <button type="button" class="button remove-image-btn" <?php if (!$after_img) echo 'style="display:none;"'; ?>>Remove</button>
                    </div>
                </div>

                <h3 class="section-header">Pain Points</h3>
                <?php $pain_points = blp_get($settings, 'transform_pain_points', $defaults['transform_pain_points']); ?>
                <div class="repeater" data-name="transform_pain_points">
                    <div class="repeater-items">
                        <?php foreach ($pain_points as $i => $item): ?>
                        <div class="repeater-item" data-index="<?php echo $i; ?>">
                            <div class="repeater-handle"><span class="dashicons dashicons-menu"></span></div>
                            <div class="repeater-fields">
                                <div class="field-group">
                                    <label>Icon Class</label>
                                    <input type="text" name="ace_backyard_lp_settings[transform_pain_points][<?php echo $i; ?>][icon]" value="<?php echo esc_attr($item['icon']); ?>" placeholder="fas fa-eye-slash">
                                </div>
                                <div class="field-group" style="flex:1;">
                                    <label>Text</label>
                                    <input type="text" name="ace_backyard_lp_settings[transform_pain_points][<?php echo $i; ?>][text]" value="<?php echo esc_attr($item['text']); ?>" placeholder="Pain point text">
                                </div>
                            </div>
                            <button type="button" class="button repeater-remove">Remove</button>
                        </div>
                        <?php endforeach; ?>
                    </div>
                    <button type="button" class="button repeater-add">Add Item</button>
                </div>
            </div>

            <!-- ==================== TAB 5: CALCULATOR ==================== -->
            <div class="tab-panel" id="tab-calculator">
                <h3 class="section-header" style="margin-top:0;">Mode Selection</h3>

                <?php $active_mode = get_option('ace_active_mode', 'calculator'); ?>
                <div class="ace-mode-toggle">
                    <label class="ace-mode-option <?php echo $active_mode === 'calculator' ? 'active' : ''; ?>">
                        <input type="radio" name="ace_active_mode" value="calculator" <?php checked($active_mode, 'calculator'); ?>>
                        <span class="ace-mode-icon"><i class="dashicons dashicons-calculator"></i></span>
                        <span class="ace-mode-label">Calculator</span>
                        <span class="ace-mode-desc">Interactive price calculator with size, features &amp; finish controls</span>
                    </label>
                    <label class="ace-mode-option <?php echo $active_mode === 'visualizer' ? 'active' : ''; ?>">
                        <input type="radio" name="ace_active_mode" value="visualizer" <?php checked($active_mode, 'visualizer'); ?>>
                        <span class="ace-mode-icon"><i class="dashicons dashicons-art"></i></span>
                        <span class="ace-mode-label">AI Visualizer</span>
                        <span class="ace-mode-desc">Photo upload → AI rendering with quiz &amp; price estimate</span>
                    </label>
                </div>

                <!-- ===== Calculator Settings Panel ===== -->
                <div id="calc-settings-panel" style="<?php echo $active_mode === 'visualizer' ? 'display:none;' : ''; ?>">
                    <h3 class="section-header">Calculator Section</h3>

                    <input type="hidden" name="ace_backyard_lp_settings[calc_enabled]" value="1">

                    <div class="ace-blp-field">
                        <label for="blp-calc-headline">Headline</label>
                        <input type="text" id="blp-calc-headline" name="ace_backyard_lp_settings[calc_headline]" value="<?php echo esc_attr(blp_get($settings, 'calc_headline', $defaults['calc_headline'])); ?>">
                    </div>

                    <div class="ace-blp-field">
                        <label for="blp-calc-sub">Subheadline</label>
                        <textarea id="blp-calc-sub" name="ace_backyard_lp_settings[calc_subheadline]"><?php echo esc_textarea(blp_get($settings, 'calc_subheadline', $defaults['calc_subheadline'])); ?></textarea>
                    </div>

                    <div class="ace-blp-field">
                        <label for="blp-calc-low">Low Multiplier</label>
                        <input type="number" id="blp-calc-low" name="ace_backyard_lp_settings[calc_low_mult]" value="<?php echo esc_attr(blp_get($settings, 'calc_low_mult', $defaults['calc_low_mult'])); ?>" step="0.01" min="0" max="2">
                        <p class="description">Multiplied against the base price for the low end of the range (e.g. 0.85 = 85%).</p>
                    </div>

                    <div class="ace-blp-field">
                        <label for="blp-calc-high">High Multiplier</label>
                        <input type="number" id="blp-calc-high" name="ace_backyard_lp_settings[calc_high_mult]" value="<?php echo esc_attr(blp_get($settings, 'calc_high_mult', $defaults['calc_high_mult'])); ?>" step="0.01" min="0" max="2">
                        <p class="description">Multiplied against the base price for the high end of the range (e.g. 1.15 = 115%).</p>
                    </div>

                    <div class="ace-blp-field">
                        <label for="blp-calc-note">Result Note</label>
                        <textarea id="blp-calc-note" name="ace_backyard_lp_settings[calc_result_note]"><?php echo esc_textarea(blp_get($settings, 'calc_result_note', $defaults['calc_result_note'])); ?></textarea>
                        <p class="description">Displayed below the calculator result.</p>
                    </div>

                    <div class="ace-blp-field">
                        <label for="blp-calc-form-btn">Form Button Text</label>
                        <input type="text" id="blp-calc-form-btn" name="ace_backyard_lp_settings[calc_form_button]" value="<?php echo esc_attr(blp_get($settings, 'calc_form_button', $defaults['calc_form_button'])); ?>">
                    </div>

                    <div class="ace-blp-field">
                        <label for="blp-calc-default-size">Default Size</label>
                        <select id="blp-calc-default-size" name="ace_backyard_lp_settings[calc_default_size]">
                            <?php $calc_sizes = blp_get($settings, 'calc_sizes', $defaults['calc_sizes']); ?>
                            <?php foreach ($calc_sizes as $si => $sz): ?>
                            <option value="<?php echo $si; ?>" <?php selected(blp_get($settings, 'calc_default_size', $defaults['calc_default_size']), $si); ?>><?php echo esc_html($sz['name']); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <div class="ace-blp-field">
                        <label for="blp-calc-default-finish">Default Finish</label>
                        <select id="blp-calc-default-finish" name="ace_backyard_lp_settings[calc_default_finish]">
                            <?php $calc_finishes = blp_get($settings, 'calc_finishes', $defaults['calc_finishes']); ?>
                            <?php foreach ($calc_finishes as $fi => $fn): ?>
                            <option value="<?php echo $fi; ?>" <?php selected(blp_get($settings, 'calc_default_finish', $defaults['calc_default_finish']), $fi); ?>><?php echo esc_html($fn['name']); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <h3 class="section-header">Size Options</h3>
                <div class="repeater" data-name="calc_sizes">
                    <div class="repeater-items">
                        <?php foreach ($calc_sizes as $i => $item): ?>
                        <div class="repeater-item" data-index="<?php echo $i; ?>">
                            <div class="repeater-handle"><span class="dashicons dashicons-menu"></span></div>
                            <div class="repeater-fields">
                                <div class="field-group">
                                    <label>Name</label>
                                    <input type="text" name="ace_backyard_lp_settings[calc_sizes][<?php echo $i; ?>][name]" value="<?php echo esc_attr($item['name']); ?>" placeholder="Small">
                                </div>
                                <div class="field-group">
                                    <label>Description</label>
                                    <input type="text" name="ace_backyard_lp_settings[calc_sizes][<?php echo $i; ?>][desc]" value="<?php echo esc_attr($item['desc']); ?>" placeholder="< 500 sq ft">
                                </div>
                                <div class="field-group">
                                    <label>Multiplier</label>
                                    <input type="number" name="ace_backyard_lp_settings[calc_sizes][<?php echo $i; ?>][multiplier]" value="<?php echo esc_attr($item['multiplier']); ?>" step="0.1" min="0" placeholder="1.0">
                                </div>
                            </div>
                            <button type="button" class="button repeater-remove">Remove</button>
                        </div>
                        <?php endforeach; ?>
                    </div>
                    <button type="button" class="button repeater-add">Add Item</button>
                </div>

                <h3 class="section-header">Feature Toggles</h3>
                <?php $calc_features = blp_get($settings, 'calc_features', $defaults['calc_features']); ?>
                <div class="repeater" data-name="calc_features">
                    <div class="repeater-items">
                        <?php foreach ($calc_features as $i => $item): ?>
                        <div class="repeater-item" data-index="<?php echo $i; ?>">
                            <div class="repeater-handle"><span class="dashicons dashicons-menu"></span></div>
                            <div class="repeater-fields">
                                <div class="field-group">
                                    <label>Name</label>
                                    <input type="text" name="ace_backyard_lp_settings[calc_features][<?php echo $i; ?>][name]" value="<?php echo esc_attr($item['name']); ?>" placeholder="Feature name">
                                </div>
                                <div class="field-group">
                                    <label>Icon</label>
                                    <input type="text" name="ace_backyard_lp_settings[calc_features][<?php echo $i; ?>][icon]" value="<?php echo esc_attr($item['icon']); ?>" placeholder="fas fa-icon">
                                </div>
                                <div class="field-group">
                                    <label>Std Price</label>
                                    <input type="number" name="ace_backyard_lp_settings[calc_features][<?php echo $i; ?>][std]" value="<?php echo esc_attr($item['std']); ?>" step="100" min="0">
                                </div>
                                <div class="field-group">
                                    <label>Prem Price</label>
                                    <input type="number" name="ace_backyard_lp_settings[calc_features][<?php echo $i; ?>][prem]" value="<?php echo esc_attr($item['prem']); ?>" step="100" min="0">
                                </div>
                                <div class="field-group">
                                    <label>Lux Price</label>
                                    <input type="number" name="ace_backyard_lp_settings[calc_features][<?php echo $i; ?>][lux]" value="<?php echo esc_attr($item['lux']); ?>" step="100" min="0">
                                </div>
                            </div>
                            <button type="button" class="button repeater-remove">Remove</button>
                        </div>
                        <?php endforeach; ?>
                    </div>
                    <button type="button" class="button repeater-add">Add Item</button>
                </div>

                <h3 class="section-header">Finish Levels</h3>
                <div class="repeater" data-name="calc_finishes">
                    <div class="repeater-items">
                        <?php foreach ($calc_finishes as $i => $item): ?>
                        <div class="repeater-item" data-index="<?php echo $i; ?>">
                            <div class="repeater-handle"><span class="dashicons dashicons-menu"></span></div>
                            <div class="repeater-fields">
                                <div class="field-group">
                                    <label>Name</label>
                                    <input type="text" name="ace_backyard_lp_settings[calc_finishes][<?php echo $i; ?>][name]" value="<?php echo esc_attr($item['name']); ?>" placeholder="Standard">
                                </div>
                                <div class="field-group">
                                    <label>Description</label>
                                    <input type="text" name="ace_backyard_lp_settings[calc_finishes][<?php echo $i; ?>][desc]" value="<?php echo esc_attr($item['desc']); ?>" placeholder="Quality materials">
                                </div>
                                <div class="field-group">
                                    <label>Key</label>
                                    <input type="text" name="ace_backyard_lp_settings[calc_finishes][<?php echo $i; ?>][key]" value="<?php echo esc_attr($item['key']); ?>" placeholder="std">
                                </div>
                            </div>
                            <button type="button" class="button repeater-remove">Remove</button>
                        </div>
                        <?php endforeach; ?>
                    </div>
                    <button type="button" class="button repeater-add">Add Item</button>
                </div>

                <h3 class="section-header">Default Active Features</h3>
                <p class="description">Check the features that should be active by default when the calculator loads.</p>
                <?php $default_features = blp_get($settings, 'calc_default_features', $defaults['calc_default_features']); ?>
                <?php foreach ($calc_features as $i => $feat): ?>
                <div class="ace-blp-toggle" style="margin-bottom:6px;">
                    <input type="checkbox" id="blp-default-feat-<?php echo $i; ?>" name="ace_backyard_lp_settings[calc_default_features][]" value="<?php echo $i; ?>" <?php if (in_array($i, (array)$default_features)) echo 'checked'; ?>>
                    <label for="blp-default-feat-<?php echo $i; ?>"><?php echo esc_html($feat['name']); ?></label>
                </div>
                <?php endforeach; ?>

                </div><!-- /#calc-settings-panel -->

                <!-- ===== Visualizer Settings Panel ===== -->
                <div id="viz-settings-panel" style="<?php echo $active_mode === 'calculator' ? 'display:none;' : ''; ?>">
                    <div class="ace-blp-info">
                        Configure the AI-powered backyard visualizer. Visitors upload a photo, answer quiz questions, and receive an AI-generated rendering of their transformed backyard with a price estimate.
                    </div>

                    <?php
                    $viz_enabled    = get_option('ace_visualizer_enabled', 0);
                    $viz_has_key    = (bool) get_option('ace_gemini_api_key_enc', '');
                    $viz_model      = get_option('ace_visualizer_model', 'gemini-2.5-flash-image');
                    $viz_prompt     = get_option('ace_visualizer_base_prompt', ace_viz_get_default_prompt());
                    $viz_retries    = get_option('ace_visualizer_max_retries', 1);
                    $viz_daily      = get_option('ace_visualizer_daily_limit', 5);
                    $viz_gate       = get_option('ace_visualizer_lead_gate', 'blur');
                    $viz_email      = get_option('ace_visualizer_admin_email', '');
                    $viz_phone      = get_option('ace_visualizer_phone', '');
                    $viz_promo_on   = get_option('ace_visualizer_promo_popup', 1);
                    $viz_promo_pct  = get_option('ace_visualizer_promo_scroll_pct', 15);
                    $viz_style_mod  = get_option('ace_style_modern_image', '');
                    $viz_style_med  = get_option('ace_style_mediterranean_image', '');
                    $viz_style_tro  = get_option('ace_style_tropical_image', '');
                    $viz_style_cla  = get_option('ace_style_classic_image', '');
                    ?>

                    <div id="viz-settings-form">

                        <!-- ===== API & Core Settings ===== -->
                        <h4 class="viz-sub-header">API &amp; Core Settings</h4>

                        <div class="ace-blp-field" style="display:none;">
                            <div class="ace-blp-toggle">
                                <input type="checkbox" id="viz-enabled" value="1" <?php checked($viz_enabled, 1); ?>>
                                <label for="viz-enabled">Enable AI Backyard Visualizer</label>
                            </div>
                        </div>

                        <div class="ace-blp-field">
                            <label for="viz-api-key">Gemini API Key</label>
                            <input type="password" id="viz-api-key" value="<?php echo $viz_has_key ? '************************************' : ''; ?>" placeholder="AIza..." style="width:100%;max-width:500px;">
                            <p class="description">Get one at <a href="https://aistudio.google.com/" target="_blank">aistudio.google.com</a> &rarr; Get API key. Keys start with "AIza".</p>
                        </div>

                        <div class="ace-blp-field">
                            <button type="button" class="button" id="viz-test-connection">Test Connection</button>
                            <span id="viz-test-result" style="margin-left:10px;"></span>
                        </div>

                        <div class="ace-blp-field">
                            <label for="viz-model">Image Generation Model</label>
                            <select id="viz-model">
                                <option value="gemini-2.5-flash-image" <?php selected($viz_model, 'gemini-2.5-flash-image'); ?>>Nano Banana - Fast ($0.04/image)</option>
                                <option value="gemini-3-pro-image-preview" <?php selected($viz_model, 'gemini-3-pro-image-preview'); ?>>Nano Banana Pro - Quality ($0.13/image)</option>
                            </select>
                        </div>

                        <div class="ace-blp-field">
                            <label for="viz-base-prompt">Base Prompt Template</label>
                            <textarea id="viz-base-prompt" rows="15" style="width:100%;font-family:monospace;font-size:12px;"><?php echo esc_textarea($viz_prompt); ?></textarea>
                            <p class="description">Placeholders: <code>{ORIENTATION_INSTRUCTION}</code>, <code>{SIZE_DESCRIPTION}</code>, <code>{FEATURES_LIST}</code>, <code>{FINISH_DESCRIPTION}</code>, <code>{STYLE_NAME}</code>, <code>{STYLE_DETAILS}</code>, <code>{FEATURE_DETAILS}</code>, <code>{EXCLUDED_FEATURES}</code></p>
                            <button type="button" class="button button-link" id="viz-reset-prompt" style="margin-top:4px;">Reset to Default Prompt</button>
                        </div>

                        <div class="ace-blp-field">
                            <label for="viz-max-retries">Max Free Retries per Visitor</label>
                            <input type="number" id="viz-max-retries" value="<?php echo intval($viz_retries); ?>" min="0" max="3" step="1" style="width:80px;">
                        </div>

                        <div class="ace-blp-field">
                            <label for="viz-daily-limit">Max Generations per IP per Day</label>
                            <input type="number" id="viz-daily-limit" value="<?php echo intval($viz_daily); ?>" min="1" max="20" step="1" style="width:80px;">
                        </div>

                        <div class="ace-blp-field">
                            <label for="viz-lead-gate">Lead Gate Type</label>
                            <select id="viz-lead-gate">
                                <option value="blur" <?php selected($viz_gate, 'blur'); ?>>Blurred image until details provided</option>
                                <option value="watermark" <?php selected($viz_gate, 'watermark'); ?>>Full image with ACE watermark</option>
                                <option value="none" <?php selected($viz_gate, 'none'); ?>>No gate (show immediately)</option>
                            </select>
                        </div>

                        <!-- ===== Visualizer Size Options ===== -->
                        <h4 class="viz-sub-header">Size Options (Visualizer Quiz)</h4>
                        <p class="description" style="margin-bottom:12px;">Configure the yard size options shown in Step 2 of the visualizer quiz. The <strong>key</strong> must be unique (lowercase, no spaces).</p>
                        <?php $viz_sizes = get_option('ace_viz_sizes', function_exists('ace_blp_get_viz_size_defaults') ? ace_blp_get_viz_size_defaults() : []); ?>
                        <div class="viz-repeater" data-type="viz_sizes">
                            <div class="viz-repeater-items">
                                <?php foreach ($viz_sizes as $i => $item): ?>
                                <div class="viz-repeater-item" data-index="<?php echo $i; ?>">
                                    <div class="repeater-handle"><span class="dashicons dashicons-menu"></span></div>
                                    <div class="repeater-fields">
                                        <div class="field-group">
                                            <label>Key</label>
                                            <input type="text" data-field="key" value="<?php echo esc_attr($item['key'] ?? ''); ?>" placeholder="small">
                                        </div>
                                        <div class="field-group">
                                            <label>Name</label>
                                            <input type="text" data-field="name" value="<?php echo esc_attr($item['name'] ?? ''); ?>" placeholder="Small">
                                        </div>
                                        <div class="field-group">
                                            <label>Description</label>
                                            <input type="text" data-field="desc" value="<?php echo esc_attr($item['desc'] ?? ''); ?>" placeholder="Under 500 sq ft">
                                        </div>
                                        <div class="field-group">
                                            <label>Icon</label>
                                            <input type="text" data-field="icon" value="<?php echo esc_attr($item['icon'] ?? ''); ?>" placeholder="fas fa-seedling">
                                        </div>
                                        <div class="field-group">
                                            <label>Multiplier</label>
                                            <input type="number" data-field="multiplier" value="<?php echo esc_attr($item['multiplier'] ?? '1.0'); ?>" step="0.1" min="0" placeholder="1.0">
                                        </div>
                                        <div class="field-group" style="flex:1;min-width:200px;">
                                            <label>Prompt Detail</label>
                                            <textarea data-field="prompt_detail" rows="2" placeholder="Description for AI prompt"><?php echo esc_textarea($item['prompt_detail'] ?? ''); ?></textarea>
                                        </div>
                                    </div>
                                    <button type="button" class="button viz-repeater-remove">Remove</button>
                                </div>
                                <?php endforeach; ?>
                            </div>
                            <button type="button" class="button viz-repeater-add">Add Size</button>
                        </div>

                        <!-- ===== Visualizer Feature Options ===== -->
                        <h4 class="viz-sub-header">Feature Options (Visualizer Quiz)</h4>
                        <p class="description" style="margin-bottom:12px;">Configure the features shown in Step 3 (multi-select). Each feature has pricing at 3 finish levels and an AI prompt detail.</p>
                        <?php $viz_features = get_option('ace_viz_features', function_exists('ace_blp_get_viz_feature_defaults') ? ace_blp_get_viz_feature_defaults() : []); ?>
                        <div class="viz-repeater" data-type="viz_features">
                            <div class="viz-repeater-items">
                                <?php foreach ($viz_features as $i => $item): ?>
                                <div class="viz-repeater-item" data-index="<?php echo $i; ?>">
                                    <div class="repeater-handle"><span class="dashicons dashicons-menu"></span></div>
                                    <div class="repeater-fields">
                                        <div class="field-group">
                                            <label>Key</label>
                                            <input type="text" data-field="key" value="<?php echo esc_attr($item['key'] ?? ''); ?>" placeholder="patio">
                                        </div>
                                        <div class="field-group">
                                            <label>Name</label>
                                            <input type="text" data-field="name" value="<?php echo esc_attr($item['name'] ?? ''); ?>" placeholder="Patio / Hardscape">
                                        </div>
                                        <div class="field-group">
                                            <label>Icon</label>
                                            <input type="text" data-field="icon" value="<?php echo esc_attr($item['icon'] ?? ''); ?>" placeholder="fas fa-border-all">
                                        </div>
                                        <div class="field-group">
                                            <label>Std Price</label>
                                            <input type="number" data-field="price_std" value="<?php echo esc_attr($item['price_std'] ?? 0); ?>" step="100" min="0">
                                        </div>
                                        <div class="field-group">
                                            <label>Prem Price</label>
                                            <input type="number" data-field="price_prem" value="<?php echo esc_attr($item['price_prem'] ?? 0); ?>" step="100" min="0">
                                        </div>
                                        <div class="field-group">
                                            <label>Lux Price</label>
                                            <input type="number" data-field="price_lux" value="<?php echo esc_attr($item['price_lux'] ?? 0); ?>" step="100" min="0">
                                        </div>
                                        <div class="field-group" style="flex:1;min-width:200px;">
                                            <label>AI Prompt Detail</label>
                                            <textarea data-field="detail" rows="2" placeholder="Description for AI prompt"><?php echo esc_textarea($item['detail'] ?? ''); ?></textarea>
                                        </div>
                                        <div class="field-group" style="flex:1;min-width:200px;">
                                            <label>Exclude Text (when not selected)</label>
                                            <textarea data-field="exclude" rows="2" placeholder="No new patio, hardscape, or paver area"><?php echo esc_textarea($item['exclude'] ?? ''); ?></textarea>
                                        </div>
                                    </div>
                                    <button type="button" class="button viz-repeater-remove">Remove</button>
                                </div>
                                <?php endforeach; ?>
                            </div>
                            <button type="button" class="button viz-repeater-add">Add Feature</button>
                        </div>

                        <!-- ===== Visualizer Finish Levels ===== -->
                        <h4 class="viz-sub-header">Finish Levels (Visualizer Quiz)</h4>
                        <p class="description" style="margin-bottom:12px;">Configure the finish levels shown in Step 4. The badge field adds a label like "Most Popular".</p>
                        <?php $viz_finishes = get_option('ace_viz_finishes', function_exists('ace_blp_get_viz_finish_defaults') ? ace_blp_get_viz_finish_defaults() : []); ?>
                        <div class="viz-repeater" data-type="viz_finishes">
                            <div class="viz-repeater-items">
                                <?php foreach ($viz_finishes as $i => $item): ?>
                                <div class="viz-repeater-item" data-index="<?php echo $i; ?>">
                                    <div class="repeater-handle"><span class="dashicons dashicons-menu"></span></div>
                                    <div class="repeater-fields">
                                        <div class="field-group">
                                            <label>Key</label>
                                            <input type="text" data-field="key" value="<?php echo esc_attr($item['key'] ?? ''); ?>" placeholder="standard">
                                        </div>
                                        <div class="field-group">
                                            <label>Name</label>
                                            <input type="text" data-field="name" value="<?php echo esc_attr($item['name'] ?? ''); ?>" placeholder="Standard">
                                        </div>
                                        <div class="field-group" style="flex:1;">
                                            <label>Description</label>
                                            <input type="text" data-field="desc" value="<?php echo esc_attr($item['desc'] ?? ''); ?>" placeholder="Quality materials, clean design">
                                        </div>
                                        <div class="field-group">
                                            <label>Badge</label>
                                            <input type="text" data-field="badge" value="<?php echo esc_attr($item['badge'] ?? ''); ?>" placeholder="Most Popular">
                                        </div>
                                        <div class="field-group" style="flex:1;min-width:200px;">
                                            <label>Prompt Detail</label>
                                            <textarea data-field="prompt_detail" rows="2" placeholder="Description for AI prompt"><?php echo esc_textarea($item['prompt_detail'] ?? ''); ?></textarea>
                                        </div>
                                    </div>
                                    <button type="button" class="button viz-repeater-remove">Remove</button>
                                </div>
                                <?php endforeach; ?>
                            </div>
                            <button type="button" class="button viz-repeater-add">Add Finish Level</button>
                        </div>

                        <!-- ===== Style Images ===== -->
                        <h4 class="viz-sub-header">Style Selection Images</h4>
                        <p class="description" style="margin-bottom:12px;">Upload images shown during the style selection step (Step 5). Recommended: 400x300px landscape photos.</p>

                        <?php
                        $style_images = [
                            'modern'        => ['label' => 'Modern Style Image',         'value' => $viz_style_mod],
                            'mediterranean' => ['label' => 'Mediterranean Style Image',  'value' => $viz_style_med],
                            'tropical'      => ['label' => 'Tropical Style Image',       'value' => $viz_style_tro],
                            'classic'       => ['label' => 'Classic Style Image',        'value' => $viz_style_cla],
                        ];
                        foreach ($style_images as $style_key => $img_data):
                        ?>
                        <div class="ace-blp-field">
                            <label><?php echo esc_html($img_data['label']); ?></label>
                            <div class="media-field">
                                <input type="hidden" id="viz-style-<?php echo $style_key; ?>-image" value="<?php echo esc_attr($img_data['value']); ?>">
                                <div class="media-preview"><?php if ($img_data['value']): ?><img src="<?php echo esc_url($img_data['value']); ?>" style="max-width:200px;"><?php endif; ?></div>
                                <button type="button" class="button upload-image-btn">Upload Image</button>
                                <button type="button" class="button remove-image-btn" <?php if (!$img_data['value']) echo 'style="display:none;"'; ?>>Remove</button>
                            </div>
                        </div>
                        <?php endforeach; ?>

                        <!-- ===== Notifications ===== -->
                        <h4 class="viz-sub-header">Notifications</h4>

                        <div class="ace-blp-field">
                            <label for="viz-admin-email">Admin Notification Email</label>
                            <input type="email" id="viz-admin-email" value="<?php echo esc_attr($viz_email); ?>" placeholder="Leave empty to use the General tab email" style="width:100%;max-width:400px;">
                        </div>

                        <div class="ace-blp-field">
                            <label for="viz-phone">CTA Phone Number</label>
                            <input type="text" id="viz-phone" value="<?php echo esc_attr($viz_phone); ?>" placeholder="Leave empty to use the General tab phone" style="width:100%;max-width:300px;">
                        </div>

                        <!-- ===== Promo Popup ===== -->
                        <h4 class="viz-sub-header">Promo Popup Settings</h4>

                        <div class="ace-blp-field">
                            <div class="ace-blp-toggle">
                                <input type="checkbox" id="viz-promo-popup" value="1" <?php checked($viz_promo_on, 1); ?>>
                                <label for="viz-promo-popup">Enable Promo Popup</label>
                            </div>
                            <p class="description">Show a promotional popup inviting visitors to try the AI Visualizer after scrolling.</p>
                        </div>

                        <div class="ace-blp-field">
                            <label for="viz-promo-scroll-pct">Promo Popup Scroll %</label>
                            <input type="number" id="viz-promo-scroll-pct" value="<?php echo intval($viz_promo_pct); ?>" min="5" max="90" step="1" style="width:80px;">
                            <p class="description">Percentage of page the visitor must scroll before the popup appears.</p>
                        </div>

                        <?php
                        // Load all visualizer text options with defaults
                        $vt = [
                            'promo_title'      => get_option('ace_viz_promo_title', 'See Your Dream Backyard in 60 Seconds'),
                            'promo_text'       => get_option('ace_viz_promo_text', 'Upload a photo of your yard, pick your favorite features, and our AI creates a photorealistic design — matched to your budget.'),
                            'promo_bullet1'    => get_option('ace_viz_promo_bullet1', 'Free — no credit card, no commitment'),
                            'promo_bullet2'    => get_option('ace_viz_promo_bullet2', 'See exactly what your backyard could look like'),
                            'promo_cta'        => get_option('ace_viz_promo_cta', 'Try It Now — It\'s Free'),
                            'promo_dismiss'    => get_option('ace_viz_promo_dismiss', 'Maybe later'),
                            'promo_fine'       => get_option('ace_viz_promo_fine', 'Takes less than 60 seconds'),
                        ];
                        ?>

                        <div class="ace-blp-field">
                            <label for="viz-promo-title">Promo Popup Title</label>
                            <input type="text" id="viz-promo-title" value="<?php echo esc_attr($vt['promo_title']); ?>">
                        </div>
                        <div class="ace-blp-field">
                            <label for="viz-promo-text">Promo Popup Description</label>
                            <textarea id="viz-promo-text" rows="3"><?php echo esc_textarea($vt['promo_text']); ?></textarea>
                        </div>
                        <div class="ace-blp-field">
                            <label for="viz-promo-bullet1">Promo Bullet 1</label>
                            <input type="text" id="viz-promo-bullet1" value="<?php echo esc_attr($vt['promo_bullet1']); ?>">
                        </div>
                        <div class="ace-blp-field">
                            <label for="viz-promo-bullet2">Promo Bullet 2</label>
                            <input type="text" id="viz-promo-bullet2" value="<?php echo esc_attr($vt['promo_bullet2']); ?>">
                        </div>
                        <div class="ace-blp-field">
                            <label for="viz-promo-cta">Promo CTA Button Text</label>
                            <input type="text" id="viz-promo-cta" value="<?php echo esc_attr($vt['promo_cta']); ?>">
                        </div>
                        <div class="ace-blp-field">
                            <label for="viz-promo-dismiss">Promo Dismiss Text</label>
                            <input type="text" id="viz-promo-dismiss" value="<?php echo esc_attr($vt['promo_dismiss']); ?>">
                        </div>
                        <div class="ace-blp-field">
                            <label for="viz-promo-fine">Promo Fine Print</label>
                            <input type="text" id="viz-promo-fine" value="<?php echo esc_attr($vt['promo_fine']); ?>">
                        </div>

                        <!-- ===== Hero CTA ===== -->
                        <h4 class="viz-sub-header">Hero CTA (Visualizer)</h4>

                        <?php
                        $vt['hero_btn']  = get_option('ace_viz_hero_btn', 'See Your Backyard Transformed');
                        $vt['hero_sub']  = get_option('ace_viz_hero_sub', 'Upload a photo. Get an AI design in 60 seconds — free.');
                        ?>

                        <div class="ace-blp-field">
                            <label for="viz-hero-btn">Hero Button Text</label>
                            <input type="text" id="viz-hero-btn" value="<?php echo esc_attr($vt['hero_btn']); ?>">
                        </div>
                        <div class="ace-blp-field">
                            <label for="viz-hero-sub">Hero Sub-text</label>
                            <input type="text" id="viz-hero-sub" value="<?php echo esc_attr($vt['hero_sub']); ?>">
                        </div>

                        <!-- ===== Quiz Step Titles ===== -->
                        <h4 class="viz-sub-header">Quiz Step Titles &amp; Subtitles</h4>

                        <?php
                        $step_defaults = [
                            1 => ['title' => 'See Your Backyard <em>Transformed</em>', 'subtitle' => 'Upload a photo. Pick your dream features. Our AI does the rest.'],
                            2 => ['title' => 'How Big Is Your Backyard?', 'subtitle' => 'This helps us scale the design to your space.'],
                            3 => ['title' => 'What Do You Want In Your Backyard?', 'subtitle' => 'Select all that interest you. You can always adjust later.'],
                            4 => ['title' => 'Select Your Finish Level', 'subtitle' => 'This affects materials, details, and your estimate.'],
                            5 => ['title' => 'Pick Your Style', 'subtitle' => 'Choose what speaks to you. This is the final step before the magic happens.'],
                        ];
                        foreach ($step_defaults as $sn => $sd):
                            $vt['step'.$sn.'_title']    = get_option('ace_viz_step'.$sn.'_title', $sd['title']);
                            $vt['step'.$sn.'_subtitle'] = get_option('ace_viz_step'.$sn.'_subtitle', $sd['subtitle']);
                        ?>
                        <div class="ace-blp-field">
                            <label for="viz-step<?php echo $sn; ?>-title">Step <?php echo $sn; ?> Title</label>
                            <input type="text" id="viz-step<?php echo $sn; ?>-title" value="<?php echo esc_attr($vt['step'.$sn.'_title']); ?>">
                            <p class="description">Step <?php echo $sn; ?>: <?php echo esc_html($sd['title']); ?> (supports &lt;em&gt; tags)</p>
                        </div>
                        <div class="ace-blp-field">
                            <label for="viz-step<?php echo $sn; ?>-subtitle">Step <?php echo $sn; ?> Subtitle</label>
                            <input type="text" id="viz-step<?php echo $sn; ?>-subtitle" value="<?php echo esc_attr($vt['step'.$sn.'_subtitle']); ?>">
                        </div>
                        <?php endforeach; ?>

                        <!-- ===== Upload UI Text ===== -->
                        <h4 class="viz-sub-header">Upload UI Text</h4>

                        <?php
                        $vt['upload_text']    = get_option('ace_viz_upload_text', 'Drag & drop your backyard photo here');
                        $vt['upload_btn']     = get_option('ace_viz_upload_btn', 'Choose Photo');
                        $vt['upload_tip']     = get_option('ace_viz_upload_tip', 'For best results, use a landscape photo taken from your back door');
                        $vt['success_msg']    = get_option('ace_viz_success_msg', 'Beautiful! Now let\'s design your dream backyard.');
                        $vt['start_btn']      = get_option('ace_viz_start_btn', 'Start Designing');
                        ?>

                        <div class="ace-blp-field">
                            <label for="viz-upload-text">Drop Zone Text</label>
                            <input type="text" id="viz-upload-text" value="<?php echo esc_attr($vt['upload_text']); ?>">
                        </div>
                        <div class="ace-blp-field">
                            <label for="viz-upload-btn">Upload Button Text</label>
                            <input type="text" id="viz-upload-btn" value="<?php echo esc_attr($vt['upload_btn']); ?>">
                        </div>
                        <div class="ace-blp-field">
                            <label for="viz-upload-tip">Upload Tip</label>
                            <input type="text" id="viz-upload-tip" value="<?php echo esc_attr($vt['upload_tip']); ?>">
                        </div>
                        <div class="ace-blp-field">
                            <label for="viz-success-msg">Upload Success Message</label>
                            <input type="text" id="viz-success-msg" value="<?php echo esc_attr($vt['success_msg']); ?>">
                        </div>
                        <div class="ace-blp-field">
                            <label for="viz-start-btn">Start Button Text</label>
                            <input type="text" id="viz-start-btn" value="<?php echo esc_attr($vt['start_btn']); ?>">
                        </div>

                        <!-- ===== Lead Gate Text ===== -->
                        <h4 class="viz-sub-header">Lead Gate Text</h4>

                        <?php
                        $vt['gate_title']    = get_option('ace_viz_gate_title', 'Your Design Is Ready!');
                        $vt['gate_subtitle'] = get_option('ace_viz_gate_subtitle', 'Enter your details to unlock the full rendering');
                        $vt['gate_btn']      = get_option('ace_viz_gate_btn', 'Unlock My Design');
                        ?>

                        <div class="ace-blp-field">
                            <label for="viz-gate-title">Gate Title</label>
                            <input type="text" id="viz-gate-title" value="<?php echo esc_attr($vt['gate_title']); ?>">
                        </div>
                        <div class="ace-blp-field">
                            <label for="viz-gate-subtitle">Gate Subtitle</label>
                            <input type="text" id="viz-gate-subtitle" value="<?php echo esc_attr($vt['gate_subtitle']); ?>">
                        </div>
                        <div class="ace-blp-field">
                            <label for="viz-gate-btn">Gate Button Text</label>
                            <input type="text" id="viz-gate-btn" value="<?php echo esc_attr($vt['gate_btn']); ?>">
                        </div>

                        <!-- ===== Result & CTA Text ===== -->
                        <h4 class="viz-sub-header">Result &amp; CTA Text</h4>

                        <?php
                        $vt['result_title']      = get_option('ace_viz_result_title', 'Here\'s Your New Backyard');
                        $vt['price_label']       = get_option('ace_viz_price_label', 'YOUR ESTIMATED INVESTMENT');
                        $vt['price_disclaimer']  = get_option('ace_viz_price_disclaimer', 'Estimate based on typical projects. Final pricing determined during your free in-home consultation.');
                        $vt['cta_btn']           = get_option('ace_viz_cta_btn', 'Book Your Free In-Home Consultation');
                        $vt['retry_text']        = get_option('ace_viz_retry_text', 'Not quite right? Try different options');
                        $vt['label_before']      = get_option('ace_viz_label_before', 'YOUR BACKYARD');
                        $vt['label_after']       = get_option('ace_viz_label_after', 'ACE DESIGN');
                        ?>

                        <div class="ace-blp-field">
                            <label for="viz-result-title">Result Title</label>
                            <input type="text" id="viz-result-title" value="<?php echo esc_attr($vt['result_title']); ?>">
                        </div>
                        <div class="ace-blp-field">
                            <label for="viz-price-label">Price Label</label>
                            <input type="text" id="viz-price-label" value="<?php echo esc_attr($vt['price_label']); ?>">
                        </div>
                        <div class="ace-blp-field">
                            <label for="viz-price-disclaimer">Price Disclaimer</label>
                            <textarea id="viz-price-disclaimer" rows="2"><?php echo esc_textarea($vt['price_disclaimer']); ?></textarea>
                        </div>
                        <div class="ace-blp-field">
                            <label for="viz-cta-btn">CTA Button Text</label>
                            <input type="text" id="viz-cta-btn" value="<?php echo esc_attr($vt['cta_btn']); ?>">
                        </div>
                        <div class="ace-blp-field">
                            <label for="viz-retry-text">Retry Button Text</label>
                            <input type="text" id="viz-retry-text" value="<?php echo esc_attr($vt['retry_text']); ?>">
                        </div>
                        <div class="ace-blp-field">
                            <label for="viz-label-before">Before/After Label: Before</label>
                            <input type="text" id="viz-label-before" value="<?php echo esc_attr($vt['label_before']); ?>">
                        </div>
                        <div class="ace-blp-field">
                            <label for="viz-label-after">Before/After Label: After</label>
                            <input type="text" id="viz-label-after" value="<?php echo esc_attr($vt['label_after']); ?>">
                        </div>

                        <!-- ===== Loading Messages ===== -->
                        <h4 class="viz-sub-header">Loading Screen</h4>

                        <?php
                        $vt['loading_messages'] = get_option('ace_viz_loading_messages', "Analyzing your backyard layout...\nMapping property boundaries...\nSelecting your design elements...\nApplying your style preferences...\nRendering hardscape and structures...\nAdding landscaping and greenery...\nFine-tuning lighting and shadows...\nAlmost ready...");
                        $vt['loading_tips']     = get_option('ace_viz_loading_tips', "A swimming pool can add 5-8% to your home value\nProfessional landscaping returns 100-200% ROI at resale\nOutdoor kitchens are the #1 requested feature in LA\nA well-designed patio can add 300-500 sq ft of living space\nLED landscape lighting uses 80% less energy than traditional");
                        ?>

                        <div class="ace-blp-field">
                            <label for="viz-loading-messages">Loading Messages (one per line)</label>
                            <textarea id="viz-loading-messages" rows="8"><?php echo esc_textarea($vt['loading_messages']); ?></textarea>
                            <p class="description">Rotate every 3.5 seconds during AI generation.</p>
                        </div>
                        <div class="ace-blp-field">
                            <label for="viz-loading-tips">Loading Tips (one per line)</label>
                            <textarea id="viz-loading-tips" rows="5"><?php echo esc_textarea($vt['loading_tips']); ?></textarea>
                            <p class="description">Displayed as fun facts during generation.</p>
                        </div>

                        <!-- Save Button (AJAX) -->
                        <p class="submit">
                            <button type="button" class="button button-primary" id="viz-save-settings">Save Visualizer Settings</button>
                            <span id="viz-save-result" style="margin-left:10px;"></span>
                        </p>
                    </div>
                </div><!-- /#viz-settings-panel -->

            </div>

            <!-- ==================== TAB 6: SERVICES ==================== -->
            <div class="tab-panel" id="tab-services">
                <h3 class="section-header">Services Section</h3>

                <div class="ace-blp-field">
                    <div class="ace-blp-toggle">
                        <input type="hidden" name="ace_backyard_lp_settings[services_enabled]" value="0">
                        <input type="checkbox" id="blp-services-enabled" name="ace_backyard_lp_settings[services_enabled]" value="1" <?php checked(blp_get($settings, 'services_enabled', $defaults['services_enabled']), 1); ?>>
                        <label for="blp-services-enabled">Enable Services Section</label>
                    </div>
                </div>

                <div class="ace-blp-field">
                    <label for="blp-services-label">Section Label</label>
                    <input type="text" id="blp-services-label" name="ace_backyard_lp_settings[services_label]" value="<?php echo esc_attr(blp_get($settings, 'services_label', $defaults['services_label'])); ?>">
                </div>

                <div class="ace-blp-field">
                    <label for="blp-services-headline">Headline</label>
                    <input type="text" id="blp-services-headline" name="ace_backyard_lp_settings[services_headline]" value="<?php echo esc_attr(blp_get($settings, 'services_headline', $defaults['services_headline'])); ?>">
                </div>

                <div class="ace-blp-field">
                    <label for="blp-services-gold">Gold Word</label>
                    <input type="text" id="blp-services-gold" name="ace_backyard_lp_settings[services_gold_word]" value="<?php echo esc_attr(blp_get($settings, 'services_gold_word', $defaults['services_gold_word'])); ?>">
                </div>

                <h3 class="section-header">Service Items</h3>
                <?php $services_items = blp_get($settings, 'services_items', $defaults['services_items']); ?>
                <div class="repeater" data-name="services_items">
                    <div class="repeater-items">
                        <?php foreach ($services_items as $i => $item): ?>
                        <div class="repeater-item" data-index="<?php echo $i; ?>">
                            <div class="repeater-handle"><span class="dashicons dashicons-menu"></span></div>
                            <div class="repeater-fields">
                                <div class="field-group" style="width:100%;">
                                    <label>Image</label>
                                    <?php $svc_img = isset($item['image']) ? $item['image'] : ''; ?>
                                    <div class="media-field">
                                        <input type="hidden" name="ace_backyard_lp_settings[services_items][<?php echo $i; ?>][image]" value="<?php echo esc_attr($svc_img); ?>">
                                        <div class="media-preview"><?php if ($svc_img): ?><img src="<?php echo esc_url($svc_img); ?>" style="max-width:200px;"><?php endif; ?></div>
                                        <button type="button" class="button upload-image-btn">Upload Image</button>
                                        <button type="button" class="button remove-image-btn" <?php if (!$svc_img) echo 'style="display:none;"'; ?>>Remove</button>
                                    </div>
                                </div>
                                <div class="field-group">
                                    <label>Icon Class</label>
                                    <input type="text" name="ace_backyard_lp_settings[services_items][<?php echo $i; ?>][icon]" value="<?php echo esc_attr($item['icon']); ?>" placeholder="fas fa-icon">
                                </div>
                                <div class="field-group">
                                    <label>Title</label>
                                    <input type="text" name="ace_backyard_lp_settings[services_items][<?php echo $i; ?>][title]" value="<?php echo esc_attr($item['title']); ?>" placeholder="Service title">
                                </div>
                                <div class="field-group" style="flex:1;">
                                    <label>Description</label>
                                    <textarea name="ace_backyard_lp_settings[services_items][<?php echo $i; ?>][desc]" rows="2" placeholder="Service description"><?php echo esc_textarea($item['desc']); ?></textarea>
                                </div>
                            </div>
                            <button type="button" class="button repeater-remove">Remove</button>
                        </div>
                        <?php endforeach; ?>
                    </div>
                    <button type="button" class="button repeater-add">Add Item</button>
                </div>
            </div>

            <!-- ==================== TAB 7: PROJECTS ==================== -->
            <div class="tab-panel" id="tab-projects">
                <h3 class="section-header">Projects Section</h3>

                <div class="ace-blp-field">
                    <div class="ace-blp-toggle">
                        <input type="hidden" name="ace_backyard_lp_settings[projects_enabled]" value="0">
                        <input type="checkbox" id="blp-projects-enabled" name="ace_backyard_lp_settings[projects_enabled]" value="1" <?php checked(blp_get($settings, 'projects_enabled', $defaults['projects_enabled']), 1); ?>>
                        <label for="blp-projects-enabled">Enable Projects Section</label>
                    </div>
                </div>

                <div class="ace-blp-field">
                    <label for="blp-projects-label">Section Label</label>
                    <input type="text" id="blp-projects-label" name="ace_backyard_lp_settings[projects_label]" value="<?php echo esc_attr(blp_get($settings, 'projects_label', $defaults['projects_label'])); ?>">
                </div>

                <div class="ace-blp-field">
                    <label for="blp-projects-headline">Headline</label>
                    <input type="text" id="blp-projects-headline" name="ace_backyard_lp_settings[projects_headline]" value="<?php echo esc_attr(blp_get($settings, 'projects_headline', $defaults['projects_headline'])); ?>">
                </div>

                <div class="ace-blp-field">
                    <label for="blp-projects-gold">Gold Word</label>
                    <input type="text" id="blp-projects-gold" name="ace_backyard_lp_settings[projects_gold_word]" value="<?php echo esc_attr(blp_get($settings, 'projects_gold_word', $defaults['projects_gold_word'])); ?>">
                </div>

                <div class="ace-blp-field">
                    <label for="blp-projects-sub">Subheadline</label>
                    <input type="text" id="blp-projects-sub" name="ace_backyard_lp_settings[projects_subheadline]" value="<?php echo esc_attr(blp_get($settings, 'projects_subheadline', $defaults['projects_subheadline'])); ?>">
                </div>

                <div class="ace-blp-field">
                    <label for="blp-projects-cta">CTA Text</label>
                    <input type="text" id="blp-projects-cta" name="ace_backyard_lp_settings[projects_cta_text]" value="<?php echo esc_attr(blp_get($settings, 'projects_cta_text', $defaults['projects_cta_text'])); ?>">
                </div>

                <h3 class="section-header">Project Items</h3>
                <?php $projects_items = blp_get($settings, 'projects_items', $defaults['projects_items']); ?>
                <div class="repeater" data-name="projects_items">
                    <div class="repeater-items">
                        <?php foreach ($projects_items as $i => $item): ?>
                        <div class="repeater-item" data-index="<?php echo $i; ?>">
                            <div class="repeater-handle"><span class="dashicons dashicons-menu"></span></div>
                            <div class="repeater-fields">
                                <div class="field-group" style="width:100%;">
                                    <label>Image</label>
                                    <?php $proj_img = isset($item['image']) ? $item['image'] : ''; ?>
                                    <div class="media-field">
                                        <input type="hidden" name="ace_backyard_lp_settings[projects_items][<?php echo $i; ?>][image]" value="<?php echo esc_attr($proj_img); ?>">
                                        <div class="media-preview"><?php if ($proj_img): ?><img src="<?php echo esc_url($proj_img); ?>" style="max-width:200px;"><?php endif; ?></div>
                                        <button type="button" class="button upload-image-btn">Upload Image</button>
                                        <button type="button" class="button remove-image-btn" <?php if (!$proj_img) echo 'style="display:none;"'; ?>>Remove</button>
                                    </div>
                                </div>
                                <div class="field-group">
                                    <label>Project Name</label>
                                    <input type="text" name="ace_backyard_lp_settings[projects_items][<?php echo $i; ?>][name]" value="<?php echo esc_attr($item['name']); ?>" placeholder="The Smith Family Retreat">
                                </div>
                                <div class="field-group">
                                    <label>Location</label>
                                    <input type="text" name="ace_backyard_lp_settings[projects_items][<?php echo $i; ?>][location]" value="<?php echo esc_attr($item['location']); ?>" placeholder="Encino, CA">
                                </div>
                                <div class="field-group" style="flex:1;">
                                    <label>Scope</label>
                                    <input type="text" name="ace_backyard_lp_settings[projects_items][<?php echo $i; ?>][scope]" value="<?php echo esc_attr($item['scope']); ?>" placeholder="Pool + Patio + Landscaping">
                                </div>
                                <div class="field-group">
                                    <label>Budget</label>
                                    <input type="text" name="ace_backyard_lp_settings[projects_items][<?php echo $i; ?>][budget]" value="<?php echo esc_attr($item['budget']); ?>" placeholder="$80K - $90K">
                                </div>
                                <div class="field-group">
                                    <label>Timeline</label>
                                    <input type="text" name="ace_backyard_lp_settings[projects_items][<?php echo $i; ?>][timeline]" value="<?php echo esc_attr($item['timeline']); ?>" placeholder="10 Weeks">
                                </div>
                                <div class="field-group">
                                    <label>Area</label>
                                    <input type="text" name="ace_backyard_lp_settings[projects_items][<?php echo $i; ?>][area]" value="<?php echo esc_attr($item['area']); ?>" placeholder="1,200 sq ft">
                                </div>
                            </div>
                            <button type="button" class="button repeater-remove">Remove</button>
                        </div>
                        <?php endforeach; ?>
                    </div>
                    <button type="button" class="button repeater-add">Add Item</button>
                </div>
            </div>

            <!-- ==================== TAB 8: CTA BAR ==================== -->
            <div class="tab-panel" id="tab-cta">
                <h3 class="section-header">CTA Bar Section</h3>

                <div class="ace-blp-field">
                    <div class="ace-blp-toggle">
                        <input type="hidden" name="ace_backyard_lp_settings[cta_enabled]" value="0">
                        <input type="checkbox" id="blp-cta-enabled" name="ace_backyard_lp_settings[cta_enabled]" value="1" <?php checked(blp_get($settings, 'cta_enabled', $defaults['cta_enabled']), 1); ?>>
                        <label for="blp-cta-enabled">Enable CTA Bar</label>
                    </div>
                </div>

                <div class="ace-blp-field">
                    <label for="blp-cta-text">CTA Text</label>
                    <input type="text" id="blp-cta-text" name="ace_backyard_lp_settings[cta_text]" value="<?php echo esc_attr(blp_get($settings, 'cta_text', $defaults['cta_text'])); ?>">
                </div>

                <div class="ace-blp-field">
                    <label for="blp-cta-gold">Gold Text</label>
                    <input type="text" id="blp-cta-gold" name="ace_backyard_lp_settings[cta_gold_text]" value="<?php echo esc_attr(blp_get($settings, 'cta_gold_text', $defaults['cta_gold_text'])); ?>">
                    <p class="description">This text appears after the main CTA text, highlighted in gold.</p>
                </div>

                <div class="ace-blp-field">
                    <label for="blp-cta-button">Button Text</label>
                    <input type="text" id="blp-cta-button" name="ace_backyard_lp_settings[cta_button]" value="<?php echo esc_attr(blp_get($settings, 'cta_button', $defaults['cta_button'])); ?>">
                </div>
            </div>

            <!-- ==================== TAB 9: REVIEWS ==================== -->
            <div class="tab-panel" id="tab-reviews">
                <h3 class="section-header">Reviews Section</h3>

                <div class="ace-blp-field">
                    <div class="ace-blp-toggle">
                        <input type="hidden" name="ace_backyard_lp_settings[reviews_enabled]" value="0">
                        <input type="checkbox" id="blp-reviews-enabled" name="ace_backyard_lp_settings[reviews_enabled]" value="1" <?php checked(blp_get($settings, 'reviews_enabled', $defaults['reviews_enabled']), 1); ?>>
                        <label for="blp-reviews-enabled">Enable Reviews Section</label>
                    </div>
                </div>

                <div class="ace-blp-field">
                    <label for="blp-reviews-label">Section Label</label>
                    <input type="text" id="blp-reviews-label" name="ace_backyard_lp_settings[reviews_label]" value="<?php echo esc_attr(blp_get($settings, 'reviews_label', $defaults['reviews_label'])); ?>">
                </div>

                <div class="ace-blp-field">
                    <label for="blp-reviews-headline">Headline</label>
                    <input type="text" id="blp-reviews-headline" name="ace_backyard_lp_settings[reviews_headline]" value="<?php echo esc_attr(blp_get($settings, 'reviews_headline', $defaults['reviews_headline'])); ?>">
                </div>

                <div class="ace-blp-field">
                    <label for="blp-reviews-score">Google Score</label>
                    <input type="text" id="blp-reviews-score" name="ace_backyard_lp_settings[reviews_google_score]" value="<?php echo esc_attr(blp_get($settings, 'reviews_google_score', $defaults['reviews_google_score'])); ?>">
                </div>

                <div class="ace-blp-field">
                    <label for="blp-reviews-count">Google Count</label>
                    <input type="text" id="blp-reviews-count" name="ace_backyard_lp_settings[reviews_google_count]" value="<?php echo esc_attr(blp_get($settings, 'reviews_google_count', $defaults['reviews_google_count'])); ?>">
                    <p class="description">e.g. "120+" - displayed next to the Google score.</p>
                </div>

                <h3 class="section-header">Review Items</h3>
                <?php $reviews_items = blp_get($settings, 'reviews_items', $defaults['reviews_items']); ?>
                <div class="repeater" data-name="reviews_items">
                    <div class="repeater-items">
                        <?php foreach ($reviews_items as $i => $item): ?>
                        <div class="repeater-item" data-index="<?php echo $i; ?>">
                            <div class="repeater-handle"><span class="dashicons dashicons-menu"></span></div>
                            <div class="repeater-fields">
                                <div class="field-group">
                                    <label>Stars</label>
                                    <select name="ace_backyard_lp_settings[reviews_items][<?php echo $i; ?>][stars]">
                                        <?php for ($s = 1; $s <= 5; $s++): ?>
                                        <option value="<?php echo $s; ?>" <?php selected($item['stars'], $s); ?>><?php echo $s; ?> Star<?php echo $s > 1 ? 's' : ''; ?></option>
                                        <?php endfor; ?>
                                    </select>
                                </div>
                                <div class="field-group" style="flex:1;">
                                    <label>Quote</label>
                                    <textarea name="ace_backyard_lp_settings[reviews_items][<?php echo $i; ?>][quote]" rows="3" placeholder="Review text"><?php echo esc_textarea($item['quote']); ?></textarea>
                                </div>
                                <div class="field-group">
                                    <label>Name</label>
                                    <input type="text" name="ace_backyard_lp_settings[reviews_items][<?php echo $i; ?>][name]" value="<?php echo esc_attr($item['name']); ?>" placeholder="John D.">
                                </div>
                                <div class="field-group">
                                    <label>Location</label>
                                    <input type="text" name="ace_backyard_lp_settings[reviews_items][<?php echo $i; ?>][location]" value="<?php echo esc_attr($item['location']); ?>" placeholder="Encino, CA">
                                </div>
                            </div>
                            <button type="button" class="button repeater-remove">Remove</button>
                        </div>
                        <?php endforeach; ?>
                    </div>
                    <button type="button" class="button repeater-add">Add Item</button>
                </div>
            </div>

            <!-- ==================== TAB 10: WHY ACE ==================== -->
            <div class="tab-panel" id="tab-why">
                <h3 class="section-header">Why ACE Section</h3>

                <div class="ace-blp-field">
                    <div class="ace-blp-toggle">
                        <input type="hidden" name="ace_backyard_lp_settings[why_enabled]" value="0">
                        <input type="checkbox" id="blp-why-enabled" name="ace_backyard_lp_settings[why_enabled]" value="1" <?php checked(blp_get($settings, 'why_enabled', $defaults['why_enabled']), 1); ?>>
                        <label for="blp-why-enabled">Enable Why ACE Section</label>
                    </div>
                </div>

                <div class="ace-blp-field">
                    <label for="blp-why-label">Section Label</label>
                    <input type="text" id="blp-why-label" name="ace_backyard_lp_settings[why_label]" value="<?php echo esc_attr(blp_get($settings, 'why_label', $defaults['why_label'])); ?>">
                </div>

                <div class="ace-blp-field">
                    <label for="blp-why-headline">Headline</label>
                    <input type="text" id="blp-why-headline" name="ace_backyard_lp_settings[why_headline]" value="<?php echo esc_attr(blp_get($settings, 'why_headline', $defaults['why_headline'])); ?>">
                </div>

                <div class="ace-blp-field">
                    <label for="blp-why-gold">Gold Word</label>
                    <input type="text" id="blp-why-gold" name="ace_backyard_lp_settings[why_gold_word]" value="<?php echo esc_attr(blp_get($settings, 'why_gold_word', $defaults['why_gold_word'])); ?>">
                </div>

                <div class="ace-blp-field">
                    <label for="blp-why-sub">Subheadline</label>
                    <textarea id="blp-why-sub" name="ace_backyard_lp_settings[why_subheadline]"><?php echo esc_textarea(blp_get($settings, 'why_subheadline', $defaults['why_subheadline'])); ?></textarea>
                </div>

                <div class="ace-blp-field">
                    <label>Image</label>
                    <?php $why_img = blp_get($settings, 'why_image', ''); ?>
                    <div class="media-field">
                        <input type="hidden" name="ace_backyard_lp_settings[why_image]" value="<?php echo esc_attr($why_img); ?>">
                        <div class="media-preview"><?php if ($why_img): ?><img src="<?php echo esc_url($why_img); ?>" style="max-width:200px;"><?php endif; ?></div>
                        <button type="button" class="button upload-image-btn">Upload Image</button>
                        <button type="button" class="button remove-image-btn" <?php if (!$why_img) echo 'style="display:none;"'; ?>>Remove</button>
                    </div>
                </div>

                <h3 class="section-header">Advantages</h3>
                <?php $why_items = blp_get($settings, 'why_items', $defaults['why_items']); ?>
                <div class="repeater" data-name="why_items">
                    <div class="repeater-items">
                        <?php foreach ($why_items as $i => $item): ?>
                        <div class="repeater-item" data-index="<?php echo $i; ?>">
                            <div class="repeater-handle"><span class="dashicons dashicons-menu"></span></div>
                            <div class="repeater-fields">
                                <div class="field-group">
                                    <label>Icon Class</label>
                                    <input type="text" name="ace_backyard_lp_settings[why_items][<?php echo $i; ?>][icon]" value="<?php echo esc_attr($item['icon']); ?>" placeholder="fas fa-icon">
                                </div>
                                <div class="field-group">
                                    <label>Title</label>
                                    <input type="text" name="ace_backyard_lp_settings[why_items][<?php echo $i; ?>][title]" value="<?php echo esc_attr($item['title']); ?>" placeholder="Advantage title">
                                </div>
                                <div class="field-group" style="flex:1;">
                                    <label>Description</label>
                                    <textarea name="ace_backyard_lp_settings[why_items][<?php echo $i; ?>][desc]" rows="2" placeholder="Advantage description"><?php echo esc_textarea($item['desc']); ?></textarea>
                                </div>
                            </div>
                            <button type="button" class="button repeater-remove">Remove</button>
                        </div>
                        <?php endforeach; ?>
                    </div>
                    <button type="button" class="button repeater-add">Add Item</button>
                </div>
            </div>

            <!-- ==================== TAB 11: PROCESS ==================== -->
            <div class="tab-panel" id="tab-process">
                <h3 class="section-header">Process Section</h3>

                <div class="ace-blp-field">
                    <div class="ace-blp-toggle">
                        <input type="hidden" name="ace_backyard_lp_settings[process_enabled]" value="0">
                        <input type="checkbox" id="blp-process-enabled" name="ace_backyard_lp_settings[process_enabled]" value="1" <?php checked(blp_get($settings, 'process_enabled', $defaults['process_enabled']), 1); ?>>
                        <label for="blp-process-enabled">Enable Process Section</label>
                    </div>
                </div>

                <div class="ace-blp-field">
                    <label for="blp-process-label">Section Label</label>
                    <input type="text" id="blp-process-label" name="ace_backyard_lp_settings[process_label]" value="<?php echo esc_attr(blp_get($settings, 'process_label', $defaults['process_label'])); ?>">
                </div>

                <div class="ace-blp-field">
                    <label for="blp-process-headline">Headline</label>
                    <input type="text" id="blp-process-headline" name="ace_backyard_lp_settings[process_headline]" value="<?php echo esc_attr(blp_get($settings, 'process_headline', $defaults['process_headline'])); ?>">
                </div>

                <div class="ace-blp-field">
                    <label for="blp-process-gold">Gold Word</label>
                    <input type="text" id="blp-process-gold" name="ace_backyard_lp_settings[process_gold_word]" value="<?php echo esc_attr(blp_get($settings, 'process_gold_word', $defaults['process_gold_word'])); ?>">
                </div>

                <h3 class="section-header">Steps</h3>
                <?php $process_items = blp_get($settings, 'process_items', $defaults['process_items']); ?>
                <div class="repeater" data-name="process_items">
                    <div class="repeater-items">
                        <?php foreach ($process_items as $i => $item): ?>
                        <div class="repeater-item" data-index="<?php echo $i; ?>">
                            <div class="repeater-handle"><span class="dashicons dashicons-menu"></span></div>
                            <div class="repeater-fields">
                                <div class="field-group">
                                    <label>Icon Class</label>
                                    <input type="text" name="ace_backyard_lp_settings[process_items][<?php echo $i; ?>][icon]" value="<?php echo esc_attr($item['icon']); ?>" placeholder="fas fa-icon">
                                </div>
                                <div class="field-group">
                                    <label>Title</label>
                                    <input type="text" name="ace_backyard_lp_settings[process_items][<?php echo $i; ?>][title]" value="<?php echo esc_attr($item['title']); ?>" placeholder="Step title">
                                </div>
                                <div class="field-group" style="flex:1;">
                                    <label>Description</label>
                                    <textarea name="ace_backyard_lp_settings[process_items][<?php echo $i; ?>][desc]" rows="2" placeholder="Step description"><?php echo esc_textarea($item['desc']); ?></textarea>
                                </div>
                            </div>
                            <button type="button" class="button repeater-remove">Remove</button>
                        </div>
                        <?php endforeach; ?>
                    </div>
                    <button type="button" class="button repeater-add">Add Item</button>
                </div>
            </div>

            <!-- ==================== TAB 12: FAQ ==================== -->
            <div class="tab-panel" id="tab-faq">
                <h3 class="section-header">FAQ Section</h3>

                <div class="ace-blp-field">
                    <div class="ace-blp-toggle">
                        <input type="hidden" name="ace_backyard_lp_settings[faq_enabled]" value="0">
                        <input type="checkbox" id="blp-faq-enabled" name="ace_backyard_lp_settings[faq_enabled]" value="1" <?php checked(blp_get($settings, 'faq_enabled', $defaults['faq_enabled']), 1); ?>>
                        <label for="blp-faq-enabled">Enable FAQ Section</label>
                    </div>
                </div>

                <div class="ace-blp-field">
                    <label for="blp-faq-label">Section Label</label>
                    <input type="text" id="blp-faq-label" name="ace_backyard_lp_settings[faq_label]" value="<?php echo esc_attr(blp_get($settings, 'faq_label', $defaults['faq_label'])); ?>">
                </div>

                <div class="ace-blp-field">
                    <label for="blp-faq-headline">Headline</label>
                    <input type="text" id="blp-faq-headline" name="ace_backyard_lp_settings[faq_headline]" value="<?php echo esc_attr(blp_get($settings, 'faq_headline', $defaults['faq_headline'])); ?>">
                </div>

                <div class="ace-blp-field">
                    <label for="blp-faq-gold">Gold Word</label>
                    <input type="text" id="blp-faq-gold" name="ace_backyard_lp_settings[faq_gold_word]" value="<?php echo esc_attr(blp_get($settings, 'faq_gold_word', $defaults['faq_gold_word'])); ?>">
                </div>

                <h3 class="section-header">FAQ Items</h3>
                <?php $faq_items = blp_get($settings, 'faq_items', $defaults['faq_items']); ?>
                <div class="repeater" data-name="faq_items">
                    <div class="repeater-items">
                        <?php foreach ($faq_items as $i => $item): ?>
                        <div class="repeater-item" data-index="<?php echo $i; ?>">
                            <div class="repeater-handle"><span class="dashicons dashicons-menu"></span></div>
                            <div class="repeater-fields">
                                <div class="field-group" style="width:100%;">
                                    <label>Question</label>
                                    <input type="text" name="ace_backyard_lp_settings[faq_items][<?php echo $i; ?>][q]" value="<?php echo esc_attr($item['q']); ?>" placeholder="Question text" style="width:100%;">
                                </div>
                                <div class="field-group" style="width:100%;">
                                    <label>Answer</label>
                                    <textarea name="ace_backyard_lp_settings[faq_items][<?php echo $i; ?>][a]" rows="3" placeholder="Answer text" style="width:100%;"><?php echo esc_textarea($item['a']); ?></textarea>
                                </div>
                            </div>
                            <button type="button" class="button repeater-remove">Remove</button>
                        </div>
                        <?php endforeach; ?>
                    </div>
                    <button type="button" class="button repeater-add">Add Item</button>
                </div>
            </div>

            <!-- ==================== TAB 13: FINAL CTA ==================== -->
            <div class="tab-panel" id="tab-final">
                <h3 class="section-header">Final CTA Section</h3>

                <div class="ace-blp-field">
                    <div class="ace-blp-toggle">
                        <input type="hidden" name="ace_backyard_lp_settings[final_enabled]" value="0">
                        <input type="checkbox" id="blp-final-enabled" name="ace_backyard_lp_settings[final_enabled]" value="1" <?php checked(blp_get($settings, 'final_enabled', $defaults['final_enabled']), 1); ?>>
                        <label for="blp-final-enabled">Enable Final CTA Section</label>
                    </div>
                </div>

                <div class="ace-blp-field">
                    <label for="blp-final-badge">Badge Text</label>
                    <input type="text" id="blp-final-badge" name="ace_backyard_lp_settings[final_badge]" value="<?php echo esc_attr(blp_get($settings, 'final_badge', $defaults['final_badge'])); ?>">
                </div>

                <div class="ace-blp-field">
                    <label for="blp-final-headline">Headline</label>
                    <input type="text" id="blp-final-headline" name="ace_backyard_lp_settings[final_headline]" value="<?php echo esc_attr(blp_get($settings, 'final_headline', $defaults['final_headline'])); ?>">
                </div>

                <div class="ace-blp-field">
                    <label for="blp-final-gold">Gold Word</label>
                    <input type="text" id="blp-final-gold" name="ace_backyard_lp_settings[final_gold_word]" value="<?php echo esc_attr(blp_get($settings, 'final_gold_word', $defaults['final_gold_word'])); ?>">
                </div>

                <div class="ace-blp-field">
                    <label for="blp-final-sub">Subheadline</label>
                    <textarea id="blp-final-sub" name="ace_backyard_lp_settings[final_subheadline]"><?php echo esc_textarea(blp_get($settings, 'final_subheadline', $defaults['final_subheadline'])); ?></textarea>
                </div>

                <div class="ace-blp-field">
                    <label for="blp-final-form-btn">Form Button Text</label>
                    <input type="text" id="blp-final-form-btn" name="ace_backyard_lp_settings[final_form_button]" value="<?php echo esc_attr(blp_get($settings, 'final_form_button', $defaults['final_form_button'])); ?>">
                </div>

                <h3 class="section-header">"How Did You Hear About Us" Options</h3>
                <?php $heard_options = blp_get($settings, 'final_heard_options', $defaults['final_heard_options']); ?>
                <div class="repeater" data-name="final_heard_options">
                    <div class="repeater-items">
                        <?php foreach ($heard_options as $i => $option): ?>
                        <div class="repeater-item" data-index="<?php echo $i; ?>">
                            <div class="repeater-handle"><span class="dashicons dashicons-menu"></span></div>
                            <div class="repeater-fields">
                                <div class="field-group" style="flex:1;">
                                    <label>Option Text</label>
                                    <input type="text" name="ace_backyard_lp_settings[final_heard_options][<?php echo $i; ?>]" value="<?php echo esc_attr($option); ?>" placeholder="Google Search">
                                </div>
                            </div>
                            <button type="button" class="button repeater-remove">Remove</button>
                        </div>
                        <?php endforeach; ?>
                    </div>
                    <button type="button" class="button repeater-add">Add Item</button>
                </div>

                <h3 class="section-header">Popup Form</h3>

                <div class="ace-blp-field">
                    <label for="blp-popup-headline">Popup Headline</label>
                    <input type="text" id="blp-popup-headline" name="ace_backyard_lp_settings[popup_headline]" value="<?php echo esc_attr(blp_get($settings, 'popup_headline', $defaults['popup_headline'])); ?>">
                </div>

                <div class="ace-blp-field">
                    <label for="blp-popup-subtitle">Popup Subtitle</label>
                    <input type="text" id="blp-popup-subtitle" name="ace_backyard_lp_settings[popup_subtitle]" value="<?php echo esc_attr(blp_get($settings, 'popup_subtitle', $defaults['popup_subtitle'])); ?>">
                </div>

                <div class="ace-blp-field">
                    <label for="blp-popup-button">Popup Button Text</label>
                    <input type="text" id="blp-popup-button" name="ace_backyard_lp_settings[popup_button]" value="<?php echo esc_attr(blp_get($settings, 'popup_button', $defaults['popup_button'])); ?>">
                </div>
            </div>

            <p class="submit"><button type="submit" class="button button-primary">Save Settings</button></p>
        </form>

        <!-- AI Visualizer tab removed — settings merged into Calculator tab -->

        <!-- ==================== TAB 14: LEADS (outside form) ==================== -->
        <div class="tab-panel" id="tab-leads">
            <h3 class="section-header">Lead Management</h3>

            <div class="leads-stats">
                <div class="leads-stat">
                    <div class="stat-number" id="stat-total">0</div>
                    <div class="stat-label">Total Leads</div>
                </div>
                <div class="leads-stat">
                    <div class="stat-number" id="stat-week">0</div>
                    <div class="stat-label">This Week</div>
                </div>
                <div class="leads-stat">
                    <div class="stat-number" id="stat-month">0</div>
                    <div class="stat-label">This Month</div>
                </div>
            </div>

            <div class="leads-filters">
                <div>
                    <label for="leads-filter-from">From</label>
                    <input type="date" id="leads-filter-from">
                </div>
                <div>
                    <label for="leads-filter-to">To</label>
                    <input type="date" id="leads-filter-to">
                </div>
                <div>
                    <label for="leads-filter-source">Source</label>
                    <select id="leads-filter-source">
                        <option value="">All Sources</option>
                        <option value="hero">Hero</option>
                        <option value="calculator">Calculator</option>
                        <option value="final">Final</option>
                        <option value="popup">Popup</option>
                        <option value="visualizer">Visualizer</option>
                    </select>
                </div>
                <div>
                    <button type="button" class="button" id="leads-filter-btn">Apply Filter</button>
                </div>
            </div>

            <div class="leads-actions">
                <a href="<?php echo admin_url('admin-ajax.php?action=ace_blp_export_csv'); ?>" class="button">Export CSV</a>
            </div>

            <table class="leads-table">
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Name</th>
                        <th>Phone</th>
                        <th>Email</th>
                        <th>Source</th>
                        <th>Calculator Data</th>
                        <th>Message</th>
                        <th>Contacted</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody id="leads-table-body">
                    <tr><td colspan="9" style="text-align:center;padding:20px;">Loading leads...</td></tr>
                </tbody>
            </table>
        </div>

    </div><!-- .ace-blp-tabs -->
</div><!-- .wrap -->
