<?php
/**
 * ACE Theme Manager - Default Content
 *
 * Returns the complete set of default option values that populate
 * the site on first activation so it looks finished with zero configuration.
 *
 * @package ACE_Theme_Manager
 * @since   1.0.0
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Retrieve every default option for the ACE theme.
 *
 * @return array Associative array of option_name => value.
 */
function ace_get_default_options() {

	$defaults = array(

		/* ───────────────────────────────────────────────
		 * General Settings
		 * ─────────────────────────────────────────────── */
		'ace_company_name'        => 'ACE Design & Build',
		'ace_tagline'             => 'Create with Confidence',
		'ace_phone'               => '(310) 438-6866',
		'ace_email'               => 'info@acedesignbuild.com',
		'ace_address'             => '6100 Wilshire Blvd #1200, Los Angeles, CA 90048, USA',
		'ace_business_hours'      => 'Monday - Sunday, 10:00 AM - 10:00 PM',

		'ace_social_facebook'     => '',
		'ace_social_instagram'    => '',
		'ace_social_houzz'        => '',
		'ace_social_google'       => '',
		'ace_social_yelp'         => '',
		'ace_social_youtube'      => '',

		'ace_google_maps_embed'   => '',

		'ace_primary_dark'        => '#0A1628',
		'ace_primary_dark_alt'    => '#0F2240',
		'ace_accent_gold'         => '#C8A35A',
		'ace_accent_gold_light'   => '#D4B06A',

		/* ───────────────────────────────────────────────
		 * Homepage - Hero
		 * ─────────────────────────────────────────────── */
		'ace_hero_headline'            => "Los Angeles' Premier Design & Build Firm",
		'ace_hero_subheadline'         => 'From dream kitchens to complete home transformations - we design, build, and deliver with precision. 15 years. Thousands of happy homeowners. Zero compromises.',
		'ace_hero_cta_primary_text'    => 'Schedule Your Free Consultation',
		'ace_hero_cta_secondary_text'  => 'View Our Work',

		/* ───────────────────────────────────────────────
		 * Homepage - Services
		 * ─────────────────────────────────────────────── */
		'ace_services_title'     => 'What We Build',
		'ace_services_subtitle'  => 'Comprehensive residential construction and remodeling services, from concept to completion.',

		/* ───────────────────────────────────────────────
		 * Homepage - Why ACE
		 * ─────────────────────────────────────────────── */
		'ace_why_ace_title'    => 'Why Los Angeles Homeowners Choose ACE',
		'ace_why_ace_features' => array(
			array(
				'icon'        => 'design-build',
				'title'       => 'Design-Build Under One Roof',
				'description' => 'One team handles your entire project from initial design through final construction. No miscommunication between architects and builders, no finger-pointing, and no delays. Streamlined project delivery means your renovation is completed faster and more efficiently.',
			),
			array(
				'icon'        => 'transparent-pricing',
				'title'       => 'Transparent Pricing',
				'description' => 'You receive a detailed, line-item proposal before any work begins. No hidden fees, no surprise change orders, and no budget-busting overruns. We believe you deserve to know exactly where every dollar goes.',
			),
			array(
				'icon'        => 'licensed',
				'title'       => 'Licensed, Bonded & Insured',
				'description' => 'ACE is a fully licensed California general contractor (Lic. #1234567), bonded, and insured for your total protection. Every subcontractor on our team meets the same rigorous standards.',
			),
			array(
				'icon'        => 'experience',
				'title'       => '15 Years of Proven Excellence',
				'description' => 'With over 2,000 completed projects and a 4.9-star Google rating, our track record speaks for itself. From simple bathroom refreshes to complete home rebuilds, we have the experience to deliver outstanding results every time.',
			),
		),

		/* ───────────────────────────────────────────────
		 * Homepage - Stats
		 * ─────────────────────────────────────────────── */
		'ace_stats' => array(
			array(
				'number' => '2000+',
				'label'  => 'Projects Completed',
			),
			array(
				'number' => '15+',
				'label'  => 'Years of Experience',
			),
			array(
				'number' => '4.9',
				'label'  => 'Google Rating',
			),
			array(
				'number' => '98%',
				'label'  => 'Client Satisfaction',
			),
		),

		/* ───────────────────────────────────────────────
		 * Homepage - Featured Work
		 * ─────────────────────────────────────────────── */
		'ace_featured_title'    => 'Our Recent Work',
		'ace_featured_subtitle' => 'See the craftsmanship and attention to detail that defines every ACE project.',

		/* ───────────────────────────────────────────────
		 * Homepage - Process
		 * ─────────────────────────────────────────────── */
		'ace_process_title'    => 'How It Works',
		'ace_process_subtitle' => "From your first call to your final walkthrough - here's what working with ACE looks like.",
		'ace_process_steps'    => array(
			array(
				'title'       => 'Free Consultation',
				'description' => 'We visit your home, listen to your goals, evaluate the space, and discuss your budget. You will receive a clear overview of possibilities, realistic timelines, and an initial cost range - all at no cost or obligation.',
			),
			array(
				'title'       => 'Custom Design & Proposal',
				'description' => 'Our design team creates detailed plans, 3D renderings, and a comprehensive scope of work tailored to your vision. You receive a transparent, line-item proposal so you know exactly what to expect before any work begins.',
			),
			array(
				'title'       => 'Expert Construction',
				'description' => 'Once approved, our licensed crews get to work. Your dedicated project manager keeps everything on schedule and on budget, providing regular updates and addressing any questions. Quality checkpoints are built into every phase.',
			),
			array(
				'title'       => 'Final Walkthrough & Warranty',
				'description' => 'We walk through every detail with you to ensure complete satisfaction. Any punch-list items are resolved promptly, and your project is backed by our comprehensive warranty for lasting peace of mind.',
			),
		),

		/* ───────────────────────────────────────────────
		 * Homepage - CTA
		 * ─────────────────────────────────────────────── */
		'ace_cta_headline'    => 'Ready to Build Something Extraordinary?',
		'ace_cta_subheadline' => "Schedule your free in-home consultation today. Let's turn your vision into reality.",
		'ace_cta_button_text' => 'Get Your Free Consultation',

		/* ───────────────────────────────────────────────
		 * Homepage - Service Area
		 * ─────────────────────────────────────────────── */
		'ace_service_area_title' => 'Proudly Serving Los Angeles & Surrounding Areas',
		'ace_service_areas'      => array(
			'Bel Air',
			'Beverly Hills',
			'Beverlywood',
			'Brentwood',
			'Burbank',
			'Calabasas',
			'Culver City',
			'Encino',
			'Glendale',
			'Hermosa Beach',
			'Hollywood Hills',
			'Long Beach',
			'Malibu',
			'Pacific Palisades',
			'Pasadena',
			'Playa del Rey',
			'Redondo Beach',
			'Reseda',
			'Santa Monica',
			'Sherman Oaks',
			'Studio City',
			'Tarzana',
			'Torrance',
			'Van Nuys',
			'West Hills',
			'West Hollywood',
			'Woodland Hills',
		),

		/* ───────────────────────────────────────────────
		 * Homepage - Blog
		 * ─────────────────────────────────────────────── */
		'ace_blog_title' => 'Expert Insights & Remodeling Tips',

		/* ───────────────────────────────────────────────
		 * Homepage - Final CTA
		 * ─────────────────────────────────────────────── */
		'ace_final_cta_headline'    => "Let's Start Your Project",
		'ace_final_cta_description' => 'Get a free, no-obligation estimate for your remodeling or construction project. Our team responds within 2 hours during business hours.',

		/* ───────────────────────────────────────────────
		 * Testimonials
		 * ─────────────────────────────────────────────── */
		'ace_testimonials' => array(
			array(
				'name'         => 'Michael & Sarah T.',
				'location'     => 'Sherman Oaks',
				'text'         => 'ACE completely transformed our 1970s ranch home into a modern masterpiece. From the initial design consultation to the final walkthrough, every detail was handled with professionalism and care. The team kept us informed throughout the entire process, and the project was completed on time and within budget. We could not be happier with the results - our home feels brand new.',
				'rating'       => 5,
				'project_type' => 'Full Home Remodel',
			),
			array(
				'name'         => 'David R.',
				'location'     => 'Encino',
				'text'         => 'We hired ACE to build an ADU in our backyard, and they exceeded every expectation. They handled all the permits, designed a beautiful unit that matched our main house, and completed the build in just four months. The attention to detail was incredible - from the custom tile work to the energy-efficient systems. The unit is now generating rental income that is paying for itself.',
				'rating'       => 5,
				'project_type' => 'ADU Construction',
			),
			array(
				'name'         => 'Jennifer & Mark L.',
				'location'     => 'Beverly Hills',
				'text'         => 'Our kitchen remodel with ACE was an outstanding experience from start to finish. They helped us reimagine our outdated kitchen into a stunning, open-concept space with custom cabinetry, quartz countertops, and top-of-the-line appliances. The craftsmanship is impeccable, and the team was respectful of our home and schedule throughout the project. We have already recommended ACE to several friends.',
				'rating'       => 5,
				'project_type' => 'Kitchen Remodel',
			),
			array(
				'name'         => 'Robert K.',
				'location'     => 'Pacific Palisades',
				'text'         => 'ACE designed and built our dream outdoor living space - complete with a pool, outdoor kitchen, fire pit, and custom landscaping. They managed every aspect of the project seamlessly. The design team truly understood our vision and brought it to life in ways we had not imagined. Our backyard is now our favorite place to be, and it has become the go-to spot for family gatherings.',
				'rating'       => 5,
				'project_type' => 'Outdoor Living',
			),
			array(
				'name'         => 'Lisa & James W.',
				'location'     => 'Pasadena',
				'text'         => 'We needed more space for our growing family, and ACE delivered a beautiful second-story addition that blends perfectly with our Craftsman-style home. The structural engineering was complex, but their team handled it with expertise and confidence. The new master suite and two bedrooms are gorgeous, and you would never know it was an addition. Truly exceptional work from start to finish.',
				'rating'       => 5,
				'project_type' => 'Home Addition',
			),
		),

		/* ───────────────────────────────────────────────
		 * About Page
		 * ─────────────────────────────────────────────── */
		'ace_about_headline'    => "15 Years of Building Los Angeles' Finest Homes",
		'ace_about_subheadline' => "We're not just contractors. We're designers, engineers, craftsmen, and partners in bringing your vision to life.",

		'ace_about_story_title' => 'The ACE Story',
		'ace_about_story'       => "ACE Design & Build was founded in 2009 with a simple mission: give Los Angeles homeowners a better remodeling experience. Our founder saw an industry plagued by miscommunication, cost overruns, and disappointing results - and set out to build a company that would raise the standard.\n\nWhat started as a small design-build firm has grown into one of Los Angeles' most trusted residential construction companies, with over 2,000 completed projects and a 4.9-star rating across Google, Yelp, and Houzz. Our growth has been built entirely on referrals and repeat clients - a testament to the relationships we build and the quality we deliver.\n\nToday, ACE employs a full-time team of designers, project managers, and skilled tradespeople who share a common commitment to craftsmanship and client satisfaction. We handle every aspect of your project in-house - from architectural design and engineering to permits, construction, and final finishes - so nothing falls through the cracks.\n\nWe believe that remodeling your home should be exciting, not stressful. That is why we have built systems and processes that keep you informed, protect your budget, and ensure every project is delivered on time and to the highest standard. When you work with ACE, you are not just hiring a contractor - you are gaining a partner who cares about your home as much as you do.",

		'ace_about_values_title' => 'What We Stand For',
		'ace_about_values'       => array(
			array(
				'title'       => 'Craftsmanship',
				'description' => 'We believe in doing things right, not just doing them fast. Every joint, every finish, and every detail is executed to the highest standard because your home deserves nothing less.',
			),
			array(
				'title'       => 'Transparency',
				'description' => 'No hidden fees. No surprise change orders. You will always know what your project costs, what is happening, and what comes next. Open communication is the foundation of every project we take on.',
			),
			array(
				'title'       => 'Respect',
				'description' => 'We treat your home as if it were our own. Our crews are clean, courteous, and professional. We protect your property, respect your schedule, and minimize disruption to your daily life.',
			),
			array(
				'title'       => 'Accountability',
				'description' => 'We stand behind every project with a comprehensive warranty and a commitment to making things right. If something does not meet your expectations, we fix it - no questions asked.',
			),
		),

		'ace_about_certifications' => array(
			'Licensed General Contractor - State of California',
			'Bonded & Insured - Full Coverage',
			'EPA Lead-Safe Certified Firm',
			'OSHA Safety Certified',
			'Member - National Association of Home Builders (NAHB)',
			'Member - National Kitchen & Bath Association (NKBA)',
			'GreenPoint Rated Certification',
			'BBB Accredited Business - A+ Rating',
		),

		/* ───────────────────────────────────────────────
		 * Services - Full Array
		 * ─────────────────────────────────────────────── */
		'ace_services' => array(

			/* ============================================================
			 * SERVICE 1 - Full Home Remodeling
			 * ============================================================ */
			array(
				'slug'             => 'full-home-remodeling',
				'title'            => 'Full Home Remodeling',
				'h1'               => 'Full Home Remodeling in Los Angeles',
				'hero_subheadline' => 'Transform your entire home with a single, seamless design-build experience. Every room. Every detail. One expert team.',
				'meta_title'       => 'Full Home Remodeling in Los Angeles | ACE Design & Build',
				'meta_description' => 'Complete whole-home remodeling services in Los Angeles. ACE Design & Build handles design, permits, and construction under one roof. Free consultation.',
				'introduction'     => "A full home remodel is the most comprehensive renovation you can undertake - and the most rewarding. Whether you have purchased a fixer-upper, inherited a dated property, or simply outgrown your current layout, a whole-home renovation allows you to reimagine every square foot to match the way you live today.\n\nAt ACE Design & Build, we specialize in complete residential transformations throughout Los Angeles and surrounding communities. Our design-build approach means one team handles everything - architectural design, engineering, permits, demolition, structural work, mechanical systems, finishes, and final inspections. This eliminates the miscommunication and delays that plague projects split between separate architects, designers, and contractors.\n\nOur full home remodels typically involve opening up floor plans, upgrading kitchens and bathrooms, replacing electrical and plumbing systems, installing new flooring and finishes, and improving energy efficiency throughout. Many clients also choose to add square footage, reconfigure bedrooms, or create dedicated spaces like home offices, media rooms, or indoor-outdoor living areas.\n\nWith over 2,000 completed projects, our team has the depth of experience to manage even the most complex renovations - from mid-century modern homes in the Hollywood Hills to Spanish Revival estates in Pasadena. Every project is assigned a dedicated project manager who keeps the work on schedule, on budget, and to the highest standard of quality.",
				'cost_range'       => '$150,000 - $500,000+',
				'timeline'         => '3 - 8 months',
				'whats_included'   => array(
					'Complimentary in-home design consultation',
					'Architectural design and 3D renderings',
					'Engineering and structural calculations',
					'All city permits and inspections',
					'Complete demolition and debris removal',
					'Electrical, plumbing, and HVAC upgrades',
					'Framing, drywall, and insulation',
					'Custom cabinetry and millwork',
					'Flooring, tile, and countertop installation',
					'Painting, trim, and final finishes',
					'Dedicated project manager and online portal access',
					'Comprehensive post-project warranty',
				),
				'benefits' => array(
					array(
						'title'       => 'One Team, One Vision',
						'description' => 'Our design-build model keeps architects, designers, and builders under one roof. Every decision is coordinated, every detail is aligned, and your project moves forward without the costly delays that come from managing multiple firms.',
					),
					array(
						'title'       => 'Budget Certainty',
						'description' => 'You receive a detailed, line-item proposal before construction begins. Our transparent pricing model protects you from hidden fees and surprise change orders, so you always know exactly where your investment is going.',
					),
					array(
						'title'       => 'Minimal Disruption',
						'description' => 'We understand you are living in or near your project. Our phased construction approach, clean job-site practices, and proactive communication ensure the process is as smooth and stress-free as possible.',
					),
				),
				'process_steps' => array(
					'Free in-home consultation to discuss your goals, evaluate the property, and establish budget parameters.',
					'Our design team creates detailed architectural plans, material selections, and a comprehensive line-item proposal.',
					'Once approved, we secure all necessary permits and prepare the site for construction.',
					'Our skilled crews execute the renovation phase by phase, with regular progress updates and quality checkpoints.',
					'Final walkthrough, punch-list completion, and handover - backed by our comprehensive warranty.',
				),
				'faqs' => array(
					array(
						'question' => 'How long does a full home remodel take?',
						'answer'   => 'Most whole-home remodels take between three and eight months depending on the scope, size of the home, and complexity of structural changes. During your initial consultation, we will provide a detailed timeline tailored to your specific project.',
					),
					array(
						'question' => 'Can I live in my home during the remodel?',
						'answer'   => 'In many cases, yes. We plan phased construction sequences that allow you to occupy portions of the home while other areas are under renovation. For more extensive projects, we will discuss temporary living arrangements and help minimize the inconvenience.',
					),
					array(
						'question' => 'How much does a full home remodel cost in Los Angeles?',
						'answer'   => 'Costs typically range from $150,000 to $500,000 or more, depending on the size of the home, scope of work, and finish level. We provide a transparent, line-item proposal so there are no surprises.',
					),
					array(
						'question' => 'Do you handle all the permits?',
						'answer'   => 'Absolutely. We manage the entire permitting process, from initial application through final inspection. Our team is experienced with the City of Los Angeles Department of Building and Safety as well as surrounding municipalities.',
					),
					array(
						'question' => 'What is the design-build advantage?',
						'answer'   => 'Design-build places design and construction under one contract and one team. This eliminates the finger-pointing and miscommunication common when separate architects and contractors are involved, resulting in faster timelines, fewer change orders, and a smoother experience overall.',
					),
					array(
						'question' => 'Do you offer financing?',
						'answer'   => 'We work with several lending partners who offer competitive home renovation financing options. We are happy to connect you with a financing specialist during your consultation.',
					),
				),
				'related_services' => array( 'kitchen-remodeling', 'bathroom-remodeling', 'home-additions' ),
			),

			/* ============================================================
			 * SERVICE 2 - ADU / Accessory Dwelling Units
			 * ============================================================ */
			array(
				'slug'             => 'adu',
				'title'            => 'ADU / Accessory Dwelling Units',
				'h1'               => 'ADU Construction in Los Angeles',
				'hero_subheadline' => 'Add living space, rental income, or multigenerational flexibility with a custom-built ADU - fully designed and permitted by ACE.',
				'meta_title'       => 'ADU Construction & Design in Los Angeles | ACE Design & Build',
				'meta_description' => 'Custom ADU design and construction in Los Angeles. Garage conversions, detached units, and junior ADUs. ACE handles design, permits, and build. Free consultation.',
				'introduction'     => "Accessory dwelling units have become one of the smartest investments a Los Angeles homeowner can make. Whether you want to generate rental income, house an aging parent, create a private home office, or simply increase your property value, an ADU delivers flexible living space on the lot you already own.\n\nCalifornia's streamlined ADU legislation has made it easier than ever to add a secondary unit to your property, but the process still requires expert navigation of local zoning codes, building requirements, and utility connections. ACE Design & Build has completed hundreds of ADU projects across Los Angeles County, and we handle every step - from feasibility assessment and architectural design to permitting, construction, and final inspection.\n\nWe build three types of ADUs: detached new-construction units, garage conversions, and junior ADUs carved from existing space within your primary residence. Our in-house design team creates plans that maximize square footage, complement your existing home's architecture, and meet all current California building codes including Title 24 energy requirements.\n\nWith rental rates in Los Angeles consistently among the highest in the nation, a well-designed ADU can generate $2,000 to $4,000 or more per month in rental income - often paying for itself within a few years. Beyond income, an ADU can increase your property value by 20 to 30 percent, making it one of the highest-ROI improvements available to homeowners today.",
				'cost_range'       => '$150,000 - $350,000+',
				'timeline'         => '4 - 8 months',
				'whats_included'   => array(
					'Feasibility assessment and site evaluation',
					'Custom architectural design and 3D renderings',
					'Structural engineering',
					'Full permit processing and plan check management',
					'Foundation and concrete work',
					'Framing, roofing, and exterior finishes',
					'Electrical, plumbing, and HVAC installation',
					'Insulation and drywall',
					'Kitchen and bathroom build-out',
					'Flooring, paint, and trim',
					'Utility connections and meter setup',
					'Final inspections and certificate of occupancy',
				),
				'benefits' => array(
					array(
						'title'       => 'Turnkey Permitting',
						'description' => 'Los Angeles ADU permitting can be complex and time-consuming. Our team manages the entire process - from initial planning review through final sign-off - so you never have to set foot in a city office.',
					),
					array(
						'title'       => 'Immediate Rental Income',
						'description' => 'A well-built ADU in Los Angeles can generate $2,000 to $4,000 or more per month in rental income. Many of our clients see their investment pay for itself within three to five years.',
					),
					array(
						'title'       => 'Increased Property Value',
						'description' => 'ADUs consistently increase property values by 20 to 30 percent. Whether you rent it out or keep it for family use, you are building real equity with a tangible asset.',
					),
				),
				'process_steps' => array(
					'Free site visit to evaluate your property, discuss your goals, and confirm ADU feasibility based on local zoning.',
					'Architectural design, engineering, and preparation of permit-ready plans tailored to your lot and preferences.',
					'We submit plans to the city, manage plan check revisions, and secure all required building permits.',
					'Our crews handle all construction from foundation to finishes, with a dedicated project manager overseeing quality and timeline.',
					'Final inspections, certificate of occupancy, and a walkthrough with you to ensure everything meets your expectations.',
				),
				'faqs' => array(
					array(
						'question' => 'How much does an ADU cost to build in Los Angeles?',
						'answer'   => 'Most ADU projects range from $150,000 to $350,000 depending on size, type (detached, garage conversion, or junior ADU), and finish level. Garage conversions are typically the most cost-effective, while detached new-construction units are on the higher end.',
					),
					array(
						'question' => 'How long does it take to build an ADU?',
						'answer'   => 'Including design and permitting, most ADU projects take six to ten months from start to finish. The construction phase itself typically runs four to six months for a detached unit and two to four months for a garage conversion.',
					),
					array(
						'question' => 'Do I need a permit for an ADU in Los Angeles?',
						'answer'   => 'Yes. All ADUs in Los Angeles require building permits. California law requires cities to approve ADU applications within 60 days if the plans meet zoning and building code requirements. ACE handles the entire permitting process on your behalf.',
					),
					array(
						'question' => 'Can I build an ADU on any residential lot in LA?',
						'answer'   => 'Under current California law, most single-family residential lots are eligible for at least one ADU. Specific requirements vary by lot size, zoning, and setback regulations. We conduct a free feasibility assessment to determine what is possible on your property.',
					),
					array(
						'question' => 'Will an ADU increase my property taxes?',
						'answer'   => 'Yes, an ADU is considered new construction, so it will be reassessed by the county assessor. However, only the value of the new unit is added to your tax basis - your existing home\'s assessed value remains unchanged.',
					),
					array(
						'question' => 'Can I use the ADU for short-term rentals like Airbnb?',
						'answer'   => 'This depends on your local jurisdiction. The City of Los Angeles has specific regulations governing short-term rentals. We recommend checking current local ordinances, and we are happy to discuss your options during your consultation.',
					),
				),
				'related_services' => array( 'home-additions', 'full-home-remodeling', 'garage-conversions' ),
			),

			/* ============================================================
			 * SERVICE 3 - Home Additions
			 * ============================================================ */
			array(
				'slug'             => 'home-additions',
				'title'            => 'Home Additions',
				'h1'               => 'Home Additions in Los Angeles',
				'hero_subheadline' => "Need more space? We'll expand your home seamlessly - as if it was always meant to be there.",
				'meta_title'       => 'Home Additions in Los Angeles | ACE Design & Build',
				'meta_description' => 'Custom home additions in Los Angeles. Room additions, second stories, and bump-outs designed and built to blend seamlessly with your existing home. Free consultation.',
				'introduction'     => "When your family outgrows your home, you face a choice: move or improve. For Los Angeles homeowners who love their neighborhood, their schools, and their community, a home addition is the smartest way to gain the space you need without giving up the location you love. A well-planned addition can deliver a 50 to 70 percent return on investment while giving you the extra square footage your family needs right now.\n\nAt ACE Design & Build, we specialize in designing and constructing home additions that look and feel as though they were part of the original architecture. Whether you need a ground-floor family room extension, a second-story master suite, a sunroom, or an expanded garage, our team handles every aspect - from structural engineering and architectural design through permitting, construction, and finish work.\n\nBuilding an addition in Los Angeles presents unique challenges. Hillside lots, seismic requirements, setback restrictions, and the need to match existing rooflines and exterior finishes all demand a contractor with deep local experience. Our structural engineers and project managers have navigated these complexities on hundreds of projects, ensuring your addition meets all code requirements while integrating flawlessly with your home.\n\nWe take a design-build approach that eliminates the costly gaps between architects and builders. Your project begins with a thorough evaluation of your home's existing structure, foundation capacity, and zoning allowances. From there, our designers create plans that maximize functionality, natural light, and flow - while our estimators deliver a transparent, line-item proposal that protects your budget from start to finish.",
				'cost_range'       => '$300 - $600 per sq ft',
				'timeline'         => '3 - 6 months build',
				'whats_included'   => array(
					'In-home consultation and feasibility assessment',
					'Architectural design with 3D renderings',
					'Structural engineering and seismic calculations',
					'Full permit processing and city inspections',
					'Foundation and footing work',
					'Framing, roofing, and exterior finish matching',
					'Electrical, plumbing, and HVAC extensions',
					'Insulation, drywall, and interior finishes',
					'Flooring, trim, paint, and hardware',
					'Dedicated project manager and warranty coverage',
				),
				'benefits' => array(
					array(
						'title'       => 'Seamless Architectural Integration',
						'description' => 'Our designers study your home\'s existing style, materials, and proportions to ensure the addition looks original - not like an afterthought. From matching rooflines and siding to blending interior finishes, every detail is considered so the new space feels like it has always been part of your home.',
					),
					array(
						'title'       => 'Structural Expertise for LA Conditions',
						'description' => 'Los Angeles construction demands rigorous seismic engineering and compliance with some of the strictest building codes in the country. Our in-house engineers design additions that are structurally sound, code-compliant, and built to protect your family for decades.',
					),
					array(
						'title'       => 'Strong Return on Investment',
						'description' => 'Home additions in Los Angeles typically deliver a 50 to 70 percent return on investment. With median home prices among the highest in the nation, adding quality square footage is one of the most financially sound improvements you can make.',
					),
				),
				'process_steps' => array(
					'Free in-home consultation to assess your existing structure, discuss your needs, and evaluate zoning and setback allowances.',
					'Custom architectural plans and structural engineering designed to integrate seamlessly with your home, delivered with a detailed line-item proposal.',
					'We secure all necessary building permits and schedule inspections with the local building department.',
					'Construction begins with foundation work and progresses through framing, mechanical systems, and finishes - managed by your dedicated project manager.',
					'Final inspection, walkthrough, and handover with full warranty documentation.',
				),
				'faqs' => array(
					array(
						'question' => 'How much does a home addition cost in Los Angeles?',
						'answer'   => 'Home additions in Los Angeles typically cost between $300 and $600 per square foot depending on the complexity of the project, foundation requirements, and finish level. A 400-square-foot addition might range from $120,000 to $240,000. We provide a detailed, transparent proposal before any work begins.',
					),
					array(
						'question' => 'How long does it take to build a home addition?',
						'answer'   => 'The construction phase typically takes three to six months, depending on the size and scope of the addition. Including design and permitting, the total timeline from initial consultation to completion is usually five to nine months.',
					),
					array(
						'question' => 'Do I need a permit for a home addition in Los Angeles?',
						'answer'   => 'Yes. All structural additions in Los Angeles require building permits and inspections. Our team manages the entire permitting process, including plan submissions, plan check revisions, and scheduling all required inspections.',
					),
					array(
						'question' => 'Can I add a second story to my single-story home?',
						'answer'   => 'In most cases, yes. Second-story additions require a thorough evaluation of your existing foundation and structure to determine if reinforcement is needed. Our structural engineers assess your home and design the most efficient and cost-effective approach.',
					),
					array(
						'question' => 'Will an addition match my existing home?',
						'answer'   => 'Absolutely. Our design team specializes in creating additions that integrate with your home\'s existing architectural style, rooflines, exterior materials, and interior finishes. The goal is always to make the addition look like it was part of the original design.',
					),
					array(
						'question' => 'Can I live in my home during the addition?',
						'answer'   => 'Yes, in most cases. Additions are typically built adjacent to or above existing living areas, and we take careful steps to maintain a safe, clean separation between the construction zone and your occupied space.',
					),
				),
				'related_services' => array( 'full-home-remodeling', 'adu', 'bathroom-remodeling' ),
			),

			/* ============================================================
			 * SERVICE 4 - Bathroom Remodeling
			 * ============================================================ */
			array(
				'slug'             => 'bathroom-remodeling',
				'title'            => 'Bathroom Remodeling',
				'h1'               => 'Bathroom Remodeling in Los Angeles',
				'hero_subheadline' => 'Your personal sanctuary, redesigned with luxury in every detail.',
				'meta_title'       => 'Bathroom Remodeling in Los Angeles | ACE Design & Build',
				'meta_description' => 'Expert bathroom remodeling in Los Angeles. Custom tile, walk-in showers, and luxury finishes. Licensed, bonded, and insured. Free consultation from ACE Design & Build.',
				'introduction'     => "The bathroom is one of the most personal spaces in your home - a place where you start and end every day. Whether you envision a spa-like master retreat with a freestanding soaking tub and heated floors, or a sleek guest bathroom with modern fixtures and custom tile, ACE Design & Build delivers bathroom renovations that combine beauty, functionality, and lasting quality.\n\nBathroom remodeling requires specialized expertise that goes beyond cosmetic upgrades. Waterproofing, proper drainage, ventilation, and moisture management are critical to preventing costly damage down the road. Our team follows industry-leading waterproofing protocols on every project, including Kerdi membrane systems for showers, proper slope-to-drain engineering, and moisture-resistant materials throughout. This attention to what lies behind the walls is what separates a bathroom that looks great on day one from one that still performs flawlessly a decade later.\n\nOur bathroom remodels are typically completed in three to five weeks for a standard bathroom, and our design team works with you to select every material - from custom tile patterns and natural stone to hardware, fixtures, lighting, and cabinetry. We partner with top suppliers to offer a wide range of options at every price point, and our installers are craftsmen who take pride in precision tile work, seamless glass enclosures, and flawless finishes.\n\nWhether you are updating a single powder room or renovating every bathroom in your home, ACE provides a streamlined design-build process that protects your budget, respects your timeline, and delivers results that exceed your expectations.",
				'cost_range'       => '$25,000 - $75,000+',
				'timeline'         => '3 - 5 weeks standard',
				'whats_included'   => array(
					'In-home design consultation and space planning',
					'3D design renderings and material selection',
					'Full demolition and disposal',
					'Plumbing rough-in and fixture installation',
					'Electrical upgrades and lighting design',
					'Waterproofing and moisture barrier installation',
					'Custom tile and natural stone installation',
					'Cabinetry, vanity, and countertop installation',
					'Glass shower enclosure fabrication and install',
					'Painting, trim, hardware, and final finishes',
				),
				'benefits' => array(
					array(
						'title'       => 'Waterproofing Expertise',
						'description' => 'Moisture is a bathroom\'s greatest enemy. Our team uses industry-leading waterproofing systems including Schluter Kerdi membranes, proper pan liners, and vapor barriers to ensure your bathroom stays dry and damage-free for decades. We do not cut corners on what you cannot see.',
					),
					array(
						'title'       => 'Custom Tile Craftsmanship',
						'description' => 'Tile is the defining feature of any bathroom. Our skilled tile installers handle everything from large-format porcelain and intricate mosaic patterns to natural marble and hand-painted accent pieces. Precise layout, perfect grout lines, and seamless transitions are our standard.',
					),
					array(
						'title'       => 'Fast, Efficient Completion',
						'description' => 'We know that being without a bathroom is a significant inconvenience. Our streamlined process and experienced crews complete most standard bathroom remodels in three to five weeks, so you can get back to enjoying your new space quickly.',
					),
				),
				'process_steps' => array(
					'Free consultation to evaluate your space, discuss design ideas, and establish a budget.',
					'Our design team creates a detailed plan with 3D renderings, material selections, and a transparent proposal.',
					'Demolition and rough-in phase - plumbing, electrical, and waterproofing are completed and inspected.',
					'Finish installation - tile, cabinetry, countertops, fixtures, glass, and hardware are installed with precision.',
					'Final walkthrough, cleaning, and handover with warranty documentation.',
				),
				'faqs' => array(
					array(
						'question' => 'How much does a bathroom remodel cost in Los Angeles?',
						'answer'   => 'Bathroom remodels typically range from $25,000 for a standard guest bathroom to $75,000 or more for a luxury master bathroom with high-end finishes. The final cost depends on the size of the space, scope of plumbing and electrical changes, and the materials you select.',
					),
					array(
						'question' => 'How long does a bathroom remodel take?',
						'answer'   => 'Most standard bathroom remodels are completed in three to five weeks. Larger master bathrooms or projects requiring structural changes may take six to eight weeks. We provide a detailed timeline during the design phase.',
					),
					array(
						'question' => 'Do I need to replace all the plumbing?',
						'answer'   => 'Not necessarily. If your existing plumbing is in good condition and you are keeping the same general layout, we can often work with existing supply and drain lines. If you are changing the layout or your pipes are outdated, we will recommend replacements as part of your proposal.',
					),
					array(
						'question' => 'Can you make my small bathroom feel larger?',
						'answer'   => 'Absolutely. Strategic design choices such as large-format tile, floating vanities, frameless glass shower enclosures, recessed niches, and thoughtful lighting can dramatically open up a small bathroom. Our designers specialize in maximizing both function and the feeling of space.',
					),
					array(
						'question' => 'What type of tile is best for bathrooms?',
						'answer'   => 'Porcelain tile is the most popular choice for bathrooms due to its durability, water resistance, and wide range of styles. Natural stone such as marble and travertine offers a luxury look but requires sealing. We will help you select the right material for your design and lifestyle.',
					),
					array(
						'question' => 'Do you offer walk-in shower conversions?',
						'answer'   => 'Yes, tub-to-shower conversions are among our most requested services. We design custom walk-in showers with frameless glass enclosures, built-in niches, bench seating, and rain showerheads to create a modern, accessible bathing experience.',
					),
				),
				'related_services' => array( 'kitchen-remodeling', 'full-home-remodeling', 'home-additions' ),
			),

			/* ============================================================
			 * SERVICE 5 - Kitchen Remodeling
			 * ============================================================ */
			array(
				'slug'             => 'kitchen-remodeling',
				'title'            => 'Kitchen Remodeling',
				'h1'               => 'Kitchen Remodeling in Los Angeles',
				'hero_subheadline' => 'The heart of your home, built to perfection.',
				'meta_title'       => 'Kitchen Remodeling in Los Angeles | ACE Design & Build',
				'meta_description' => 'Custom kitchen remodeling in Los Angeles. Open-concept layouts, custom cabinetry, and premium countertops. ACE Design & Build - free consultation.',
				'introduction'     => "The kitchen is the heart of your home - the place where meals are prepared, families gather, and memories are made. A well-designed kitchen remodel does more than update the look of the room; it transforms how your household functions every single day. At ACE Design & Build, we create kitchens that are as beautiful as they are practical, combining custom cabinetry, premium countertops, professional-grade appliances, and intelligent layouts that make cooking and entertaining effortless.\n\nOpen-concept kitchen designs have become the most requested layout in Los Angeles, and for good reason. Removing walls between the kitchen and adjacent living or dining areas creates a sense of spaciousness, improves natural light, and allows the cook to stay connected with family and guests. Our structural engineers evaluate load-bearing walls and design solutions - such as steel beams and reinforced headers - that open up your floor plan safely and beautifully.\n\nCustom cabinetry is the centerpiece of any kitchen remodel, and our partnerships with top cabinet manufacturers give you access to an extraordinary range of styles, finishes, and storage solutions. From soft-close drawers and pull-out pantry systems to custom range hoods and integrated appliance panels, every detail is tailored to your preferences and daily routine. We pair cabinetry with countertop materials such as quartz, granite, marble, and butcher block to create surfaces that are both stunning and resilient.\n\nKitchen remodeling consistently delivers one of the highest returns on investment of any home improvement project - typically around 60 percent or more in the Los Angeles market. Beyond financial returns, a new kitchen elevates your daily quality of life and makes your home a place you are proud to share with family and friends.",
				'cost_range'       => '$40,000 - $150,000+',
				'timeline'         => '6 - 10 weeks',
				'whats_included'   => array(
					'In-home design consultation and space planning',
					'3D kitchen renderings and material selection',
					'Structural evaluation for open-concept layouts',
					'Full demolition and debris removal',
					'Electrical upgrades, lighting, and outlet relocation',
					'Plumbing rough-in and fixture installation',
					'Custom cabinetry design, fabrication, and installation',
					'Countertop templating, fabrication, and installation',
					'Backsplash tile design and installation',
					'Appliance coordination and installation',
					'Flooring installation',
					'Painting, trim, and final finishes',
				),
				'benefits' => array(
					array(
						'title'       => 'Custom Cabinetry and Storage Solutions',
						'description' => 'Off-the-shelf cabinets cannot match the fit, finish, and functionality of custom cabinetry designed specifically for your kitchen. We design storage solutions that eliminate wasted space - including corner pullouts, drawer organizers, appliance garages, and pantry systems that keep everything organized and accessible.',
					),
					array(
						'title'       => 'Open-Concept Design Expertise',
						'description' => 'Opening up walls to create an open floor plan requires structural know-how and engineering precision. Our team has completed hundreds of open-concept kitchen conversions, safely removing load-bearing walls and installing structural beams to create the airy, connected layouts that define modern Los Angeles living.',
					),
					array(
						'title'       => 'Strong Return on Investment',
						'description' => 'Kitchen remodels in Los Angeles typically deliver a 60 percent or higher return on investment, making them one of the most financially rewarding home improvements. A beautifully remodeled kitchen also makes your home more competitive on the market if you ever decide to sell.',
					),
				),
				'process_steps' => array(
					'Free in-home consultation to discuss your vision, evaluate the existing kitchen, and establish budget parameters.',
					'Our designers create a detailed kitchen plan with 3D renderings, cabinet layouts, material samples, and a transparent line-item proposal.',
					'Demolition and rough-in - structural modifications, electrical, plumbing, and HVAC work are completed and inspected.',
					'Cabinetry installation, countertop templating and fabrication, backsplash tile, flooring, and appliance placement.',
					'Final finishes, hardware, cleaning, and walkthrough with full warranty documentation.',
				),
				'faqs' => array(
					array(
						'question' => 'How much does a kitchen remodel cost in Los Angeles?',
						'answer'   => 'Kitchen remodels in Los Angeles typically range from $40,000 for a mid-range renovation to $150,000 or more for a high-end, custom kitchen with premium materials and structural changes. We provide a detailed, transparent proposal tailored to your specific goals and budget.',
					),
					array(
						'question' => 'How long does a kitchen remodel take?',
						'answer'   => 'Most kitchen remodels take six to ten weeks from demolition to completion. Projects involving structural changes, custom cabinetry with longer lead times, or extensive electrical and plumbing work may take up to twelve weeks. We provide a detailed schedule before work begins.',
					),
					array(
						'question' => 'Can you remove a wall to create an open floor plan?',
						'answer'   => 'Yes. Many kitchen remodels involve removing walls between the kitchen and living or dining areas. Our structural engineers assess whether walls are load-bearing and design beam and header solutions that open up the space safely while maintaining structural integrity.',
					),
					array(
						'question' => 'What countertop material is best for kitchens?',
						'answer'   => 'Quartz is the most popular choice due to its durability, low maintenance, and wide range of colors and patterns. Granite offers natural beauty, while marble provides a timeless, elegant look. We will help you select the ideal material based on your design preferences, cooking habits, and budget.',
					),
					array(
						'question' => 'Will I have access to a kitchen during the remodel?',
						'answer'   => 'We help clients set up a temporary kitchen area in another part of the home with essential items like a microwave, coffee maker, and portable cooktop. While it requires some adjustment, most clients find it manageable for the duration of the project.',
					),
					array(
						'question' => 'Do you install appliances?',
						'answer'   => 'Yes. We coordinate appliance selection, delivery, and installation as part of your remodel. Whether you are upgrading to professional-grade appliances or selecting energy-efficient models, we ensure proper electrical, gas, and ventilation connections.',
					),
				),
				'related_services' => array( 'bathroom-remodeling', 'full-home-remodeling', 'home-additions' ),
			),

			/* ============================================================
			 * SERVICE 6 - Landscape & Hardscaping
			 * ============================================================ */
			array(
				'slug'             => 'landscape-and-hardscaping',
				'title'            => 'Landscape & Hardscaping',
				'h1'               => 'Landscape & Hardscaping in Los Angeles',
				'hero_subheadline' => 'Outdoor spaces that are as stunning as your interior.',
				'meta_title'       => 'Landscape & Hardscaping in Los Angeles | ACE Design & Build',
				'meta_description' => 'Professional landscape design and hardscaping in Los Angeles. Drought-smart gardens, retaining walls, pathways, and outdoor living spaces. Free consultation from ACE.',
				'introduction'     => "Your outdoor space is an extension of your home - and in Los Angeles, where sunshine graces us nearly year-round, it deserves the same level of design and craftsmanship as your interior. ACE Design & Build creates landscape and hardscape environments that blend natural beauty with structural precision, transforming ordinary yards into extraordinary outdoor living spaces.\n\nOur landscape designs are rooted in drought-smart principles that thrive in Southern California's Mediterranean climate. We select native and climate-adapted plantings that deliver lush, colorful results without excessive water consumption. Combined with efficient drip irrigation systems and smart controllers, our landscapes look beautiful while keeping your water bills in check and meeting local water-use regulations.\n\nHardscaping forms the structural backbone of any great outdoor space. Our crews are experts in building retaining walls, walkways, patios, steps, planter walls, fire pits, and decorative concrete features that are both functional and visually striking. We work with a wide range of materials including natural stone, pavers, flagstone, decomposed granite, and poured concrete - selecting the right combination to complement your home's architecture and your personal style.\n\nWhether you are looking for a complete front-yard redesign, a backyard entertaining space, or a hillside retaining wall solution, our design-build approach ensures every element is planned together and executed as a cohesive whole. The result is an outdoor environment that feels intentional, looks stunning, and adds lasting value to your property.",
				'cost_range'       => '$15,000 - $100,000+',
				'timeline'         => '2 - 6 weeks',
				'whats_included'   => array(
					'On-site consultation and landscape assessment',
					'Custom landscape design with plant palette',
					'Hardscape layout and material selection',
					'Grading, drainage, and soil preparation',
					'Retaining wall design and construction',
					'Paver and stone patio installation',
					'Walkway and pathway construction',
					'Drip irrigation system installation',
					'Drought-tolerant and native planting',
					'Landscape lighting design and installation',
				),
				'benefits' => array(
					array(
						'title'       => 'Drought-Smart Design',
						'description' => 'Southern California\'s water restrictions demand landscapes that look beautiful without excessive irrigation. Our designers select native and climate-adapted plants, install high-efficiency drip systems with smart controllers, and incorporate permeable surfaces that keep your outdoor space lush, sustainable, and compliant with local water regulations.',
					),
					array(
						'title'       => 'Structural Hardscaping Excellence',
						'description' => 'From retaining walls that manage hillside erosion to precision-laid paver patios and natural stone pathways, our hardscape work is engineered to last. We address drainage, compaction, and base preparation with the same rigor we bring to interior construction - because outdoor structures must withstand the elements year after year.',
					),
					array(
						'title'       => 'Cohesive Indoor-Outdoor Living',
						'description' => 'We design landscapes and hardscapes that connect seamlessly with your home\'s interior and architectural style. The materials, colors, and proportions of your outdoor space are chosen to complement your home, creating a unified environment that expands your usable living area.',
					),
				),
				'process_steps' => array(
					'Free on-site consultation to evaluate your property, discuss your vision, and review budget parameters.',
					'Custom landscape and hardscape design with material selections, planting plans, and a detailed proposal.',
					'Site preparation - grading, drainage, and demolition of existing features as needed.',
					'Hardscape construction followed by irrigation installation and planting.',
					'Final walkthrough, cleanup, and care instructions for your new landscape.',
				),
				'faqs' => array(
					array(
						'question' => 'How much does landscaping cost in Los Angeles?',
						'answer'   => 'Landscape and hardscape projects in Los Angeles typically range from $15,000 for targeted improvements to $100,000 or more for comprehensive yard transformations. The cost depends on the size of the area, materials selected, and the scope of hardscape construction involved.',
					),
					array(
						'question' => 'What plants work best in the Los Angeles climate?',
						'answer'   => 'We recommend a mix of native California species and Mediterranean-adapted plants that thrive with minimal water. Popular choices include lavender, rosemary, California poppies, salvia, agave, bougainvillea, and ornamental grasses. Our designers create custom plant palettes based on your yard\'s sun exposure, soil conditions, and aesthetic preferences.',
					),
					array(
						'question' => 'Do you handle grading and drainage?',
						'answer'   => 'Yes. Proper grading and drainage are essential to protecting your home\'s foundation and preventing water damage. We assess the existing drainage patterns on your property and design solutions including French drains, channel drains, swales, and proper slope grading.',
					),
					array(
						'question' => 'Can you build retaining walls on hillside lots?',
						'answer'   => 'Absolutely. Hillside retaining walls are one of our specialties. We design and build engineered retaining walls using materials such as natural stone, concrete block, and poured concrete - all designed to meet Los Angeles building codes and handle the specific soil and slope conditions of your property.',
					),
					array(
						'question' => 'How long does a landscaping project take?',
						'answer'   => 'Most landscape and hardscape projects are completed in two to six weeks depending on the scope. Simple planting refreshes may take just a few days, while projects involving retaining walls, large patios, and irrigation systems take longer. We provide a clear timeline before work begins.',
					),
				),
				'related_services' => array( 'backyard-remodeling', 'pavers', 'front-yard-renovation' ),
			),

			/* ============================================================
			 * SERVICE 7 - Backyard Remodeling
			 * ============================================================ */
			array(
				'slug'             => 'backyard-remodeling',
				'title'            => 'Backyard Remodeling',
				'h1'               => 'Backyard Remodeling in Los Angeles',
				'hero_subheadline' => "Turn your backyard into the outdoor living space you've always wanted.",
				'meta_title'       => 'Backyard Remodeling in Los Angeles | ACE Design & Build',
				'meta_description' => 'Complete backyard remodeling in Los Angeles. Patios, outdoor kitchens, fire features, pools, and landscaping - designed and built by ACE. Free consultation.',
				'introduction'     => "In Los Angeles, your backyard is not just a yard - it is an extension of your living space that you can enjoy 365 days a year. A complete backyard remodel transforms underused outdoor area into a fully functional environment for cooking, dining, entertaining, relaxing, and spending quality time with family. At ACE Design & Build, we design and construct backyards that rival the finest indoor living rooms in comfort, beauty, and functionality.\n\nOur backyard remodels take a unified design approach. Rather than piecing together individual elements from different contractors, we plan the entire space as a cohesive project - integrating patio areas, outdoor kitchens, fire features, water features, landscaping, lighting, and furniture zones into a single master plan. This ensures every element works together visually and functionally, creating an outdoor environment that feels intentional and complete.\n\nLos Angeles' enviable climate means your backyard investment delivers year-round returns. Morning coffee on a sunlit patio, weekend barbecues with friends, evening gatherings around a fire pit, and quiet nights by the pool - these are the daily experiences that make a well-designed backyard one of the most enjoyable upgrades you can make to your home. Our clients consistently tell us their remodeled backyard is their favorite room in the house.\n\nFrom compact urban courtyards to sprawling estate grounds, our team has the experience to maximize any space. We handle every element in-house - hardscaping, construction, plumbing, electrical, gas lines, landscaping, and lighting - so your project is coordinated, efficient, and built to the highest standards.",
				'cost_range'       => '$30,000 - $200,000+',
				'timeline'         => '4 - 10 weeks',
				'whats_included'   => array(
					'On-site consultation and backyard assessment',
					'Comprehensive outdoor living design with 3D renderings',
					'Demolition and site preparation',
					'Hardscape construction - patios, walkways, walls',
					'Outdoor kitchen and barbecue island construction',
					'Fire pit or fireplace installation',
					'Landscape design and planting',
					'Outdoor lighting design and installation',
					'Irrigation system installation',
					'Pergola, shade structure, or patio cover construction',
				),
				'benefits' => array(
					array(
						'title'       => 'Unified Design Vision',
						'description' => 'Instead of cobbling together separate projects from different contractors, ACE designs your entire backyard as a single, cohesive space. Every element - from the patio material and plantings to the lighting and furniture layout - is planned together to create an outdoor environment that feels polished and intentional.',
					),
					array(
						'title'       => 'Year-Round Outdoor Living',
						'description' => 'With over 280 sunny days per year, Los Angeles is the perfect place to invest in outdoor living. Our designs incorporate shade structures for hot afternoons, fire features for cool evenings, and strategic lighting that extends your enjoyment well after sunset - making your backyard usable every day of the year.',
					),
					array(
						'title'       => 'Significant Property Value Increase',
						'description' => 'A professionally designed and built outdoor living space is one of the most impactful improvements you can make to your home\'s value. In the Los Angeles real estate market, buyers expect quality outdoor spaces, and a beautifully remodeled backyard can be a deciding factor in a sale.',
					),
				),
				'process_steps' => array(
					'Free on-site consultation to evaluate your backyard, discuss your lifestyle, and define your wish list.',
					'Our design team creates a comprehensive outdoor living plan with 3D renderings, material selections, and a detailed proposal.',
					'Site preparation, demolition of existing features, and grading.',
					'Construction of hardscape, structures, and outdoor living features - coordinated by your dedicated project manager.',
					'Landscaping, lighting, irrigation, final cleanup, and walkthrough.',
				),
				'faqs' => array(
					array(
						'question' => 'How much does a backyard remodel cost in Los Angeles?',
						'answer'   => 'Backyard remodels range from $30,000 for essential improvements like a patio and landscaping to $200,000 or more for comprehensive projects that include outdoor kitchens, pools, fire features, and extensive hardscaping. We provide a transparent proposal tailored to your specific vision and budget.',
					),
					array(
						'question' => 'How long does a complete backyard remodel take?',
						'answer'   => 'Most backyard remodels take four to ten weeks depending on the scope of the project. Projects that include pools, extensive hardscaping, or outdoor kitchens are on the longer end. We provide a detailed timeline before work begins.',
					),
					array(
						'question' => 'Can you design my entire backyard as one project?',
						'answer'   => 'Yes, and we strongly recommend it. A unified design ensures every element - hardscaping, landscaping, structures, lighting, and utilities - works together cohesively. This approach also eliminates the inefficiency and cost of managing multiple contractors for separate phases.',
					),
					array(
						'question' => 'Do you handle the gas and electrical for outdoor kitchens and fire features?',
						'answer'   => 'Absolutely. Our licensed crews handle all gas line installation, electrical wiring, and plumbing required for outdoor kitchens, fire pits, fireplaces, lighting, and water features. All work is permitted and inspected per local building codes.',
					),
					array(
						'question' => 'What if I have a small backyard?',
						'answer'   => 'Small backyards benefit enormously from professional design. We specialize in maximizing compact spaces with multi-functional features, built-in seating, vertical gardens, and smart layouts that make even modest yards feel spacious and inviting.',
					),
				),
				'related_services' => array( 'outdoor-kitchens', 'swimming-pools', 'landscape-and-hardscaping' ),
			),

			/* ============================================================
			 * SERVICE 8 - Concrete
			 * ============================================================ */
			array(
				'slug'             => 'concrete',
				'title'            => 'Concrete',
				'h1'               => 'Concrete Services in Los Angeles',
				'hero_subheadline' => 'Precision concrete work - from foundations to decorative finishes.',
				'meta_title'       => 'Concrete Services in Los Angeles | ACE Design & Build',
				'meta_description' => 'Professional concrete services in Los Angeles. Foundations, slabs, driveways, patios, stamped concrete, and decorative finishes. Licensed and insured. Free estimates.',
				'introduction'     => "Concrete is the foundation - literally and figuratively - of virtually every construction project. Whether you need a new slab for an ADU, a reinforced foundation for a home addition, a decorative stamped patio, or a complete driveway replacement, the quality of your concrete work determines the longevity and performance of everything built on top of it. ACE Design & Build delivers precision concrete services that meet the demanding standards of Los Angeles construction.\n\nLos Angeles presents unique challenges for concrete work. Expansive clay soils common throughout the basin can shift and swell with moisture changes, placing stress on slabs and foundations. Seismic activity demands reinforcement strategies that exceed those required in most other parts of the country. Our concrete crews understand these local conditions and engineer every pour with the right mix design, reinforcement, and joint placement to ensure crack-free, long-lasting results.\n\nBeyond structural work, we are also specialists in decorative concrete applications that elevate the aesthetic of your property. Stamped concrete can replicate the look of natural stone, brick, slate, or wood at a fraction of the cost. Exposed aggregate finishes provide texture and visual interest, while colored and stained concrete opens up a world of design possibilities for patios, pool decks, walkways, and driveways.\n\nFrom large-scale commercial foundations to residential flatwork, every ACE concrete project follows a meticulous process: proper site preparation and compaction, accurate forming, appropriate reinforcement, controlled pouring and finishing, and careful curing. It is this disciplined approach that allows us to deliver concrete work that performs for decades, not just years.",
				'cost_range'       => '$8 - $30 per sq ft',
				'timeline'         => 'Varies by scope',
				'whats_included'   => array(
					'Site evaluation and soil assessment',
					'Grading and subgrade preparation',
					'Forming and reinforcement (rebar and wire mesh)',
					'Concrete mixing and pouring',
					'Finishing - broom, smooth, stamped, or exposed aggregate',
					'Expansion and control joint placement',
					'Decorative coloring and staining',
					'Sealing and curing',
					'Demolition and removal of existing concrete',
					'Permit acquisition when required',
				),
				'benefits' => array(
					array(
						'title'       => 'Engineered for LA Soil and Seismic Conditions',
						'description' => 'Los Angeles soils and seismic activity demand concrete work that goes beyond basic standards. Our team designs reinforcement and mix specifications tailored to your specific site conditions, ensuring slabs and foundations resist cracking, settling, and seismic movement for the life of the structure.',
					),
					array(
						'title'       => 'Decorative Expertise',
						'description' => 'Concrete does not have to look plain. Our finishing crews are skilled in stamped patterns, exposed aggregate, acid staining, integral coloring, and polished finishes that transform functional concrete into a design feature. From rustic flagstone patterns to sleek modern surfaces, we deliver the look you want.',
					),
					array(
						'title'       => 'Built to Last',
						'description' => 'Proper concrete work is a long-term investment. Our meticulous approach to site preparation, mix design, reinforcement, joint placement, and curing ensures your concrete performs flawlessly for decades - minimizing maintenance costs and eliminating premature repairs.',
					),
				),
				'process_steps' => array(
					'Free on-site evaluation to assess the scope, soil conditions, and access requirements.',
					'We provide a detailed proposal including material specifications, finish options, and timeline.',
					'Site preparation - demolition of existing surfaces, grading, compaction, and forming.',
					'Pouring, finishing, and decorative treatments are completed by our experienced crews.',
					'Proper curing, sealing, and final cleanup with care instructions.',
				),
				'faqs' => array(
					array(
						'question' => 'How much does concrete work cost in Los Angeles?',
						'answer'   => 'Basic concrete flatwork (broom finish) typically costs $8 to $15 per square foot. Stamped and decorative concrete ranges from $15 to $30 per square foot depending on the pattern and color complexity. Foundation work is priced based on engineering requirements and project scope.',
					),
					array(
						'question' => 'How long does concrete take to cure?',
						'answer'   => 'Concrete reaches initial set within 24 to 48 hours and is typically safe for foot traffic within three to five days. Full structural strength is achieved at 28 days. We advise clients on proper curing practices and restrictions during this period.',
					),
					array(
						'question' => 'Will my concrete crack?',
						'answer'   => 'All concrete has the potential to develop minor hairline cracks over time due to shrinkage and settling. However, proper subgrade preparation, appropriate reinforcement, correctly placed control joints, and quality curing practices dramatically reduce the likelihood and severity of cracking.',
					),
					array(
						'question' => 'What is stamped concrete?',
						'answer'   => 'Stamped concrete is a decorative finishing technique where patterns and textures are pressed into freshly poured concrete before it cures. This allows concrete to replicate the appearance of natural stone, brick, slate, or even wood - at a fraction of the material cost.',
					),
					array(
						'question' => 'Do you remove old concrete before pouring new?',
						'answer'   => 'Yes, when necessary. Our crews handle demolition and removal of existing concrete as part of the project. In some cases, new concrete can be poured as an overlay on existing surfaces if the underlying slab is in good condition.',
					),
				),
				'related_services' => array( 'driveways', 'pavers', 'swimming-pools' ),
			),

			/* ============================================================
			 * SERVICE 9 - Driveways
			 * ============================================================ */
			array(
				'slug'             => 'driveways',
				'title'            => 'Driveways',
				'h1'               => 'Driveway Installation & Replacement in Los Angeles',
				'hero_subheadline' => 'First impressions start at the curb. Make yours count.',
				'meta_title'       => 'Driveway Installation & Replacement in Los Angeles | ACE Design & Build',
				'meta_description' => 'Professional driveway installation and replacement in Los Angeles. Concrete, pavers, stamped designs, and more. Licensed, insured. Free estimates from ACE.',
				'introduction'     => "Your driveway is one of the first things visitors notice about your home, and it is one of the most heavily used surfaces on your property. A cracked, stained, or outdated driveway detracts from your home's curb appeal and can even create safety hazards. A new driveway from ACE Design & Build instantly elevates the look of your property while providing a durable, functional surface engineered to handle years of daily use.\n\nWe offer a full range of driveway materials to match your home's architectural style and your personal preferences. Poured concrete with broom, stamped, or exposed aggregate finishes remains the most popular choice for its durability and clean appearance. Interlocking pavers offer design flexibility, easy repair, and excellent drainage. Decorative stamped concrete can replicate the look of cobblestone, brick, or natural stone at a fraction of the cost.\n\nBeyond aesthetics, a properly constructed driveway requires careful attention to drainage and load engineering. Los Angeles driveways must be sloped correctly to direct water away from your home's foundation, and the subgrade must be properly compacted to support vehicle loads without settling or cracking. Our crews follow a rigorous process of subgrade preparation, compaction, forming, and reinforcement that ensures your driveway performs as well as it looks.\n\nWhether you need a simple replacement of an existing concrete driveway, a complete redesign with decorative pavers, or a new driveway for a property that lacks one, ACE delivers a finished product that enhances your home's value and makes a strong first impression every day.",
				'cost_range'       => '$10 - $30 per sq ft',
				'timeline'         => '3 - 7 days',
				'whats_included'   => array(
					'On-site consultation and driveway assessment',
					'Design layout with material recommendations',
					'Demolition and removal of existing driveway',
					'Grading, compaction, and subgrade preparation',
					'Forming and reinforcement installation',
					'Concrete pouring or paver installation',
					'Decorative finishing (stamped, exposed aggregate, colored)',
					'Proper drainage slope engineering',
					'Sealing and curing',
					'Final cleanup and care instructions',
				),
				'benefits' => array(
					array(
						'title'       => 'Instant Curb Appeal',
						'description' => 'A new driveway is one of the most visible improvements you can make to your property. Whether you choose clean concrete, elegant pavers, or decorative stamped designs, a fresh driveway instantly updates the look of your home and creates a welcoming first impression for guests and potential buyers.',
					),
					array(
						'title'       => 'Material Variety',
						'description' => 'We offer a wide selection of driveway materials including standard and colored concrete, stamped concrete in dozens of patterns, interlocking pavers in various styles and colors, and exposed aggregate finishes. Our designers help you select the material that best complements your home\'s architecture and your budget.',
					),
					array(
						'title'       => 'Drainage and Load Engineering',
						'description' => 'A driveway must do more than look good - it needs to manage water runoff and support heavy vehicle loads without settling or cracking. Our team engineers proper slope, subgrade compaction, and reinforcement to ensure your driveway performs reliably for decades.',
					),
				),
				'process_steps' => array(
					'Free on-site evaluation to assess the existing driveway, discuss design preferences, and measure the area.',
					'We provide a detailed proposal with material options, finish selections, and timeline.',
					'Demolition of the existing driveway, grading, and subgrade compaction.',
					'Installation of the new driveway surface - concrete, pavers, or decorative finish.',
					'Sealing, curing, cleanup, and a walkthrough with care instructions.',
				),
				'faqs' => array(
					array(
						'question' => 'How much does a new driveway cost in Los Angeles?',
						'answer'   => 'Driveway costs typically range from $10 to $30 per square foot depending on the material. A standard two-car concrete driveway (approximately 400 to 600 square feet) typically costs between $4,000 and $12,000. Paver and stamped concrete driveways are on the higher end of the range.',
					),
					array(
						'question' => 'How long does driveway installation take?',
						'answer'   => 'Most driveway installations are completed in three to seven days, including demolition of the old surface. Concrete driveways require an additional curing period of five to seven days before vehicle traffic. Paver driveways can typically be driven on the same day they are completed.',
					),
					array(
						'question' => 'Which is better - concrete or pavers?',
						'answer'   => 'Both are excellent options. Concrete is more cost-effective upfront and offers a clean, uniform look. Pavers provide design flexibility, easier repair of individual units, and better drainage. Our team will help you evaluate both options based on your priorities and budget.',
					),
					array(
						'question' => 'Do I need a permit for a driveway replacement?',
						'answer'   => 'In most cases, a straightforward driveway replacement on the same footprint does not require a building permit. However, if you are expanding the driveway, modifying the curb cut, or changing drainage patterns, a permit may be required. We handle all permitting when applicable.',
					),
					array(
						'question' => 'How long will my new driveway last?',
						'answer'   => 'A properly installed concrete driveway typically lasts 25 to 30 years or more. Paver driveways can last 30 to 50 years with minimal maintenance. Regular sealing every two to three years helps extend the life and appearance of both materials.',
					),
				),
				'related_services' => array( 'concrete', 'front-yard-renovation', 'pavers' ),
			),

			/* ============================================================
			 * SERVICE 10 - Front Yard Renovation
			 * ============================================================ */
			array(
				'slug'             => 'front-yard-renovation',
				'title'            => 'Front Yard Renovation',
				'h1'               => 'Front Yard Renovation in Los Angeles',
				'hero_subheadline' => 'Curb appeal that makes a statement - and adds real value.',
				'meta_title'       => 'Front Yard Renovation in Los Angeles | ACE Design & Build',
				'meta_description' => 'Front yard renovation and curb appeal services in Los Angeles. Drought-tolerant landscaping, walkways, driveways, and lighting. Free consultation from ACE.',
				'introduction'     => "Your front yard is the face of your home. It is the first thing neighbors see, the first impression guests form, and a significant factor in how potential buyers perceive your property's value. A professionally designed front yard renovation can boost your home's value by 5 to 12 percent while transforming an outdated or neglected entrance into a stunning, welcoming space you are proud to come home to every day.\n\nAt ACE Design & Build, we approach front yard renovations as complete curb-appeal transformations. We design the entire space holistically - integrating the driveway, walkways, entry path, landscaping, planter walls, lighting, and hardscaping into a cohesive plan that enhances your home's architecture and sets it apart from every other house on the street.\n\nWater-smart design is at the core of every front yard project we create. Los Angeles water regulations encourage (and in many cases require) drought-tolerant landscaping, and our designs embrace this by combining beautiful native and Mediterranean-adapted plants with efficient irrigation, permeable paving, and decorative stone or mulch. The result is a front yard that looks lush and inviting while consuming a fraction of the water that traditional lawns demand.\n\nWhether you want to replace a tired lawn with a modern drought-tolerant landscape, add a new paver walkway and planter walls, install landscape lighting that highlights your home at night, or completely reimagine your front yard from scratch, ACE delivers results that make a lasting impression.",
				'cost_range'       => '$10,000 - $60,000+',
				'timeline'         => '1 - 4 weeks',
				'whats_included'   => array(
					'On-site consultation and curb appeal assessment',
					'Custom front yard design with plant palette',
					'Hardscape design - walkways, driveways, planter walls',
					'Demolition and removal of existing landscaping',
					'Grading, soil amendment, and drainage solutions',
					'Drought-tolerant and native plant installation',
					'Paver or stone walkway and entry path construction',
					'Landscape lighting design and installation',
					'Drip irrigation system with smart controller',
					'Mulch, decorative stone, or ground cover application',
				),
				'benefits' => array(
					array(
						'title'       => 'Instant Curb Appeal',
						'description' => 'A front yard renovation is the single most visible improvement you can make to your home. Our designs are crafted to enhance your home\'s architectural style, create a welcoming entry experience, and make your property stand out on the street - delivering a dramatic visual transformation.',
					),
					array(
						'title'       => 'Water-Smart, Low-Maintenance Design',
						'description' => 'Our drought-tolerant designs use native and climate-adapted plants, efficient drip irrigation, and permeable hardscaping to create a front yard that looks lush year-round without excessive watering. You save money on water bills and spend less time on maintenance.',
					),
					array(
						'title'       => 'Measurable Property Value Increase',
						'description' => 'Studies consistently show that quality landscaping and curb appeal improvements increase property values by 5 to 12 percent. In the competitive Los Angeles real estate market, a beautiful front yard can make the difference between a quick sale and a home that sits on the market.',
					),
				),
				'process_steps' => array(
					'Free on-site consultation to assess your front yard, discuss your goals, and review your home\'s architecture.',
					'Custom design with plant selections, hardscape materials, lighting layout, and a detailed proposal.',
					'Demolition and site preparation - removal of existing landscaping, grading, and soil amendment.',
					'Hardscape installation followed by irrigation, planting, and lighting.',
					'Final cleanup, mulch or ground cover, and a walkthrough with care instructions.',
				),
				'faqs' => array(
					array(
						'question' => 'How much does a front yard renovation cost in Los Angeles?',
						'answer'   => 'Front yard renovations typically range from $10,000 for targeted landscaping improvements to $60,000 or more for comprehensive transformations that include new driveways, walkways, planter walls, lighting, and extensive planting. We tailor every project to your budget and priorities.',
					),
					array(
						'question' => 'How much value does curb appeal add to my home?',
						'answer'   => 'Professional landscaping and curb appeal improvements typically increase property values by 5 to 12 percent. On a $1 million home in Los Angeles, that translates to $50,000 to $120,000 in added value - making a front yard renovation one of the highest-ROI home improvements available.',
					),
					array(
						'question' => 'Do I need to replace my lawn with drought-tolerant plants?',
						'answer'   => 'While Los Angeles does not require you to remove your lawn, many homeowners are choosing drought-tolerant landscaping for its water savings, lower maintenance, and modern aesthetic. Local water agencies often offer rebates for lawn replacement, which can help offset the cost of a renovation.',
					),
					array(
						'question' => 'How long does a front yard renovation take?',
						'answer'   => 'Most front yard renovations are completed in one to four weeks, depending on the scope. Simple planting refreshes may take just a few days, while projects involving walkways, planter walls, lighting, and irrigation systems are on the longer end.',
					),
					array(
						'question' => 'Can you match the hardscaping to my home\'s style?',
						'answer'   => 'Absolutely. We select materials, colors, and design elements that complement your home\'s architecture - whether it is Spanish Revival, Mid-Century Modern, Contemporary, Craftsman, or Mediterranean. The goal is a front yard that looks like it was designed with the house.',
					),
				),
				'related_services' => array( 'landscape-and-hardscaping', 'driveways', 'pavers' ),
			),

			/* ============================================================
			 * SERVICE 11 - Swimming Pools
			 * ============================================================ */
			array(
				'slug'             => 'swimming-pools',
				'title'            => 'Swimming Pools',
				'h1'               => 'Swimming Pool Construction in Los Angeles',
				'hero_subheadline' => 'Your personal oasis, custom-designed and expertly built.',
				'meta_title'       => 'Swimming Pool Construction in Los Angeles | ACE Design & Build',
				'meta_description' => 'Custom swimming pool design and construction in Los Angeles. Gunite pools, spas, water features, and pool decking. Licensed and insured. Free consultation from ACE.',
				'introduction'     => "A swimming pool is more than a backyard feature - it is a lifestyle upgrade that transforms how you live, entertain, and enjoy your home. In Los Angeles, where warm weather makes outdoor living a year-round reality, a custom-built pool becomes the centerpiece of your property and a source of daily enjoyment for your family. ACE Design & Build creates fully custom pools that reflect your personal style, complement your home's architecture, and deliver decades of trouble-free performance.\n\nEvery ACE pool is built using gunite (shotcrete) construction - the gold standard for custom swimming pools. Unlike fiberglass shells or vinyl liners, gunite pools are constructed on-site and can be shaped into virtually any form, size, or depth. This gives you complete design freedom - from classic rectangular lap pools and freeform resort-style designs to infinity edges, sun shelves, swim-up bars, and integrated spas. The structural strength of gunite also makes it the ideal choice for Los Angeles' seismic conditions.\n\nOur pool designs are integrated into the broader landscape of your backyard. Rather than treating the pool as a standalone element, we plan the surrounding deck, coping, landscaping, lighting, and water features as a unified environment. This approach creates a resort-quality outdoor space where every element works together - the pool, the patio, the plantings, and the lighting all contribute to a cohesive, breathtaking result.\n\nFrom the initial concept to the final fill, our team manages every aspect of pool construction including engineering, permits, excavation, plumbing, electrical, steel, gunite application, tile, coping, decking, equipment installation, and start-up. A dedicated project manager keeps you informed at every stage, and our comprehensive warranty gives you confidence that your investment is protected.",
				'cost_range'       => '$80,000 - $250,000+',
				'timeline'         => '8 - 16 weeks build',
				'whats_included'   => array(
					'Custom pool design with 3D renderings',
					'Structural and soils engineering',
					'Full permit processing',
					'Excavation and grading',
					'Steel reinforcement and gunite shell construction',
					'Plumbing, filtration, and equipment installation',
					'Waterline tile and interior finish (plaster, pebble, or glass)',
					'Coping and pool deck construction',
					'LED pool and landscape lighting',
					'Optional: spa, water features, fire features, sun shelf',
				),
				'benefits' => array(
					array(
						'title'       => 'Fully Custom Design',
						'description' => 'Every ACE pool is designed from scratch to fit your property, your style, and your lifestyle. Gunite construction allows unlimited shapes, sizes, and features - from elegant lap pools and geometric designs to freeform lagoons with waterfalls, grottos, and integrated spas. Your pool will be one of a kind.',
					),
					array(
						'title'       => 'Gunite Construction Excellence',
						'description' => 'Gunite is the strongest, most durable pool construction method available. Applied pneumatically over a reinforced steel framework, it creates a monolithic concrete shell that resists cracking, withstands seismic movement, and lasts for decades. It is the preferred construction method for high-end residential pools nationwide.',
					),
					array(
						'title'       => 'Integrated Backyard Design',
						'description' => 'We do not just build pools - we design complete outdoor environments. Your pool is planned alongside the surrounding deck, landscaping, lighting, and features to create a cohesive, resort-quality space where every element enhances the next.',
					),
				),
				'process_steps' => array(
					'Free consultation and site evaluation to discuss your vision, assess your property, and review budget parameters.',
					'Custom pool design with 3D renderings, material selections, feature options, and a comprehensive proposal.',
					'Permitting, engineering, and soils testing completed before construction begins.',
					'Excavation, steel, plumbing, gunite application, tile, coping, decking, and equipment installation - managed by your dedicated project manager.',
					'Pool start-up, water chemistry balancing, equipment orientation, and walkthrough with warranty documentation.',
				),
				'faqs' => array(
					array(
						'question' => 'How much does a pool cost to build in Los Angeles?',
						'answer'   => 'Custom gunite pools in Los Angeles typically range from $80,000 for a standard-size pool to $250,000 or more for large pools with spas, water features, fire features, and premium finishes. The final cost depends on size, shape, depth, features, and site conditions. We provide a detailed proposal after your design consultation.',
					),
					array(
						'question' => 'How long does it take to build a pool?',
						'answer'   => 'The construction phase for a custom gunite pool typically takes eight to sixteen weeks. Including design, engineering, and permitting, the total timeline from initial consultation to swimming is usually four to six months.',
					),
					array(
						'question' => 'What is the difference between gunite and fiberglass pools?',
						'answer'   => 'Gunite pools are built on-site from reinforced concrete, allowing unlimited shapes, sizes, and custom features. Fiberglass pools are pre-manufactured shells with limited shape options. Gunite is more durable, fully customizable, and better suited to Los Angeles seismic conditions. It is the preferred choice for custom residential pools.',
					),
					array(
						'question' => 'Do I need a permit to build a pool in Los Angeles?',
						'answer'   => 'Yes. Swimming pool construction in Los Angeles requires building permits, and the project must pass multiple inspections throughout construction. Our team manages the entire permit and inspection process on your behalf.',
					),
					array(
						'question' => 'Can you add a spa to my pool?',
						'answer'   => 'Absolutely. Integrated spas are one of our most popular features. They can be designed as attached spillover spas that cascade into the pool, or as separate elevated spas with their own heating and jet systems. We also retrofit existing pools with new spa additions.',
					),
					array(
						'question' => 'What pool finishes do you offer?',
						'answer'   => 'We offer a full range of interior finishes including standard white plaster, colored plaster, pebble finishes (such as PebbleTec and PebbleSheen), glass bead finishes, and glass tile. Each option offers different aesthetics, textures, and durability characteristics. Our designers will help you select the right finish for your style and budget.',
					),
				),
				'related_services' => array( 'backyard-remodeling', 'outdoor-kitchens', 'patio-covers' ),
			),

			/* ============================================================
			 * SERVICE 12 - Outdoor Kitchens
			 * ============================================================ */
			array(
				'slug'             => 'outdoor-kitchens',
				'title'            => 'Outdoor Kitchens',
				'h1'               => 'Outdoor Kitchen Construction in Los Angeles',
				'hero_subheadline' => 'Cook, entertain, and live outdoors - in a kitchen built for the LA lifestyle.',
				'meta_title'       => 'Outdoor Kitchen Construction in Los Angeles | ACE Design & Build',
				'meta_description' => 'Custom outdoor kitchen design and construction in Los Angeles. Built-in grills, countertops, refrigeration, and more. Licensed and insured. Free consultation from ACE.',
				'introduction'     => "An outdoor kitchen transforms your backyard from a place you visit into a place you live. In Los Angeles, where the weather invites outdoor entertaining nearly every day of the year, a professionally designed and built outdoor kitchen becomes the social hub of your home - a fully functional cooking and gathering space where meals are prepared, drinks are poured, and memories are made under open skies.\n\nACE Design & Build creates outdoor kitchens that go far beyond a simple grill station. Our designs include built-in gas grills, side burners, pizza ovens, smokers, refrigerators, ice makers, sinks with hot and cold water, storage drawers, and premium countertop surfaces. Every component is specified for outdoor use, constructed with weatherproof materials, and connected to proper gas, electrical, and plumbing systems by our licensed crews.\n\nThe construction of an outdoor kitchen involves the same level of structural and utility work as an indoor kitchen. Concrete block or steel-framed islands must be properly built to support heavy countertops and appliances. Gas lines must be run safely and to code. Electrical circuits for lighting, outlets, and appliances must be properly sized and protected. Drainage for sinks and ice makers must be routed correctly. Our team handles every one of these elements with the precision and professionalism that defines all ACE projects.\n\nWhether you envision a compact grilling station with bar seating, a full outdoor kitchen with dining for twelve, or a complete entertainment zone with kitchen, bar, fire pit, and television, we design and build it as a cohesive space that reflects your lifestyle and elevates your home's outdoor living experience.",
				'cost_range'       => '$20,000 - $80,000+',
				'timeline'         => '3 - 6 weeks',
				'whats_included'   => array(
					'On-site consultation and design planning',
					'Custom outdoor kitchen layout with 3D renderings',
					'Concrete block or steel-framed island construction',
					'Countertop fabrication and installation (granite, tile, concrete)',
					'Built-in grill, burners, and appliance installation',
					'Gas line installation',
					'Electrical wiring, outlets, and lighting',
					'Plumbing for sink and drainage',
					'Pergola or shade structure integration (optional)',
					'Final finishes - stucco, stone veneer, or tile cladding',
				),
				'benefits' => array(
					array(
						'title'       => 'Fully Functional Cooking Space',
						'description' => 'Our outdoor kitchens are not just grills on a counter. They are complete cooking environments with gas burners, prep space, refrigeration, sinks, storage, and lighting - everything you need to prepare full meals without setting foot inside. Built-in appliances from top brands ensure performance and durability.',
					),
					array(
						'title'       => 'Weatherproof Construction',
						'description' => 'Every material we use is specified for outdoor exposure. Stainless steel appliances, granite or concrete countertops, marine-grade hardware, and waterproof cabinet systems ensure your outdoor kitchen stands up to sun, rain, and temperature changes year after year without deterioration.',
					),
					array(
						'title'       => 'The Ultimate Entertainment Hub',
						'description' => 'An outdoor kitchen naturally becomes the gathering point of your backyard. We design layouts with bar seating, dining space, conversation areas, and optional features like fire pits and televisions that keep your guests comfortable and entertained all evening long.',
					),
				),
				'process_steps' => array(
					'Free consultation to discuss your cooking habits, entertaining style, and backyard layout.',
					'Custom design with equipment selections, material finishes, utility requirements, and a detailed proposal.',
					'Utility rough-in - gas, electrical, plumbing, and drainage are installed and inspected.',
					'Island construction, countertop installation, appliance placement, and finish work.',
					'Final inspection, equipment testing, cleanup, and walkthrough with operational instructions.',
				),
				'faqs' => array(
					array(
						'question' => 'How much does an outdoor kitchen cost in Los Angeles?',
						'answer'   => 'Outdoor kitchens in Los Angeles typically range from $20,000 for a well-equipped grilling station to $80,000 or more for a full outdoor kitchen with premium appliances, countertops, lighting, and covered dining area. We provide a detailed proposal based on your specific design and equipment selections.',
					),
					array(
						'question' => 'Do I need a gas line for an outdoor kitchen?',
						'answer'   => 'We strongly recommend a natural gas connection for outdoor kitchens, as it eliminates the need to replace propane tanks and provides consistent fuel supply. Our licensed plumbers install dedicated gas lines from your home\'s main supply to your outdoor kitchen, permitted and inspected per local codes.',
					),
					array(
						'question' => 'What countertop materials work best outdoors?',
						'answer'   => 'Granite is the most popular choice for outdoor kitchens due to its durability, heat resistance, and natural beauty. Concrete countertops offer a modern aesthetic and can be custom colored. Tile countertops provide design flexibility. We help you select the right material based on your style and maintenance preferences.',
					),
					array(
						'question' => 'How long does it take to build an outdoor kitchen?',
						'answer'   => 'Most outdoor kitchens are completed in three to six weeks, depending on the complexity of the design and utility requirements. Simple grill stations may be completed in under two weeks, while large kitchens with extensive features take longer.',
					),
					array(
						'question' => 'Can you add an outdoor kitchen to an existing patio?',
						'answer'   => 'In many cases, yes. If your existing patio is structurally sound and properly sized, we can construct an outdoor kitchen on the existing surface. If the patio needs to be expanded or reinforced, we handle that as part of the project.',
					),
				),
				'related_services' => array( 'backyard-remodeling', 'patio-covers', 'swimming-pools' ),
			),

			/* ============================================================
			 * SERVICE 13 - Patio Covers
			 * ============================================================ */
			array(
				'slug'             => 'patio-covers',
				'title'            => 'Patio Covers',
				'h1'               => 'Patio Covers in Los Angeles',
				'hero_subheadline' => 'Shade, style, and year-round comfort for your outdoor living space.',
				'meta_title'       => 'Patio Covers in Los Angeles | ACE Design & Build',
				'meta_description' => 'Custom patio covers and shade structures in Los Angeles. Solid roofs, pergolas, lattice covers, and motorized louvered systems. Free consultation from ACE.',
				'introduction'     => "A patio cover transforms your outdoor space from a seasonal amenity into a year-round living area. In Los Angeles, where sunshine is abundant but afternoon heat can be intense, the right shade structure allows you to enjoy your patio, outdoor kitchen, or pool area in comfort at any time of day. ACE Design & Build designs and constructs custom patio covers that provide shade, protection from the elements, and architectural beauty that enhances your home's exterior.\n\nWe build a full range of patio cover styles to match your home's architecture and your functional needs. Solid roof patio covers provide complete shade and rain protection, making them ideal for outdoor kitchens and dining areas. Open-beam pergolas create filtered shade with a dramatic architectural presence. Lattice covers offer a lighter, more casual aesthetic. Motorized louvered systems give you full control - open the louvers for sunlight and airflow, or close them for complete shade and weather protection at the touch of a button.\n\nArchitectural integration is central to our design approach. A patio cover should look like a natural extension of your home, not an afterthought bolted onto the back of the house. Our designers match rooflines, materials, colors, and proportions to your existing structure, creating a seamless transition from indoors to outdoors. We use premium materials including dimensional lumber, engineered beams, aluminum, and composite systems that deliver both beauty and longevity.\n\nEvery ACE patio cover is engineered for structural integrity and built to meet local building codes. Proper footings, post sizing, beam calculations, and attachment methods ensure your cover is safe, stable, and built to withstand wind loads and the test of time. Our installations include integrated electrical for ceiling fans, lighting, and heaters - so your covered patio is comfortable and functional day and night.",
				'cost_range'       => '$8,000 - $40,000+',
				'timeline'         => '1 - 3 weeks',
				'whats_included'   => array(
					'On-site consultation and design planning',
					'Custom patio cover design matched to your home',
					'Engineering and permit processing',
					'Foundation and footing installation',
					'Structural post, beam, and rafter construction',
					'Roofing material installation (solid, lattice, or louvered)',
					'Electrical rough-in for fans, lighting, and heaters',
					'Painting or staining to match your home',
					'Gutter and downspout integration (solid covers)',
					'Final inspection and warranty documentation',
				),
				'benefits' => array(
					array(
						'title'       => 'Year-Round Comfort',
						'description' => 'A patio cover protects you from harsh afternoon sun, unexpected rain, and evening dew - extending the usability of your outdoor space to every hour of every day. Combined with ceiling fans for airflow and heaters for cool evenings, your covered patio becomes a true outdoor room.',
					),
					array(
						'title'       => 'Architectural Integration',
						'description' => 'Our patio covers are designed to complement your home\'s existing architecture. We match rooflines, materials, and paint colors to create a structure that looks like it was built with the house - not added as an afterthought. The result is a seamless, polished addition to your property.',
					),
					array(
						'title'       => 'Increased Home Value',
						'description' => 'Covered outdoor living spaces are highly desirable in the Los Angeles real estate market. A well-designed patio cover adds functional square footage to your home\'s outdoor living area and increases its appeal to potential buyers, delivering a strong return on your investment.',
					),
				),
				'process_steps' => array(
					'Free consultation to evaluate your patio area, discuss shade needs, and review style preferences.',
					'Custom design with structural specifications, material selections, and a detailed proposal.',
					'Permit acquisition and foundation or footing installation.',
					'Structural construction - posts, beams, rafters, and roofing material installation.',
					'Electrical, painting, final inspection, and walkthrough.',
				),
				'faqs' => array(
					array(
						'question' => 'How much does a patio cover cost in Los Angeles?',
						'answer'   => 'Patio covers in Los Angeles range from $8,000 for a basic lattice or pergola structure to $40,000 or more for large solid-roof covers or motorized louvered systems with integrated electrical. The final cost depends on the size, style, materials, and features you select.',
					),
					array(
						'question' => 'Do I need a permit for a patio cover?',
						'answer'   => 'Yes. Most patio covers in Los Angeles require a building permit, especially if they are attached to the house or exceed a certain size. Our team handles the entire permitting process, including engineering calculations and plan submissions.',
					),
					array(
						'question' => 'What is the difference between a pergola and a solid patio cover?',
						'answer'   => 'A pergola uses open beams or rafters to create filtered, partial shade. A solid patio cover has a fully enclosed roof that provides complete shade and rain protection. The best choice depends on your climate preferences, the function of the space, and your aesthetic taste.',
					),
					array(
						'question' => 'Can you add a patio cover to an existing patio?',
						'answer'   => 'Yes. We frequently install patio covers over existing concrete or paver patios. In most cases, we install new concrete footings for the support posts without disturbing the existing patio surface. If the patio needs to be expanded, we can handle that as well.',
					),
					array(
						'question' => 'What are motorized louvered patio covers?',
						'answer'   => 'Motorized louvered systems feature adjustable aluminum slats that can be opened or closed with a remote control. Open them for full sunlight and airflow, or close them for complete shade and rain protection. They offer the ultimate flexibility for outdoor living and are an increasingly popular choice among our clients.',
					),
				),
				'related_services' => array( 'backyard-remodeling', 'outdoor-kitchens', 'landscape-and-hardscaping' ),
			),

			/* ============================================================
			 * SERVICE 14 - Pavers
			 * ============================================================ */
			array(
				'slug'             => 'pavers',
				'title'            => 'Pavers',
				'h1'               => 'Paver Installation in Los Angeles',
				'hero_subheadline' => 'Durable, beautiful hardscaping that transforms any outdoor surface.',
				'meta_title'       => 'Paver Installation in Los Angeles | ACE Design & Build',
				'meta_description' => 'Professional paver installation in Los Angeles. Driveways, patios, walkways, and pool decks. Interlocking concrete, natural stone, and porcelain pavers. Free estimates.',
				'introduction'     => "Pavers offer unmatched versatility, durability, and aesthetic appeal for outdoor surfaces. Whether you are building a new patio, replacing a worn driveway, creating an elegant walkway, or surfacing a pool deck, interlocking pavers provide a design flexibility that poured concrete simply cannot match. ACE Design & Build installs premium paver systems throughout Los Angeles, delivering surfaces that are beautiful, functional, and built to last.\n\nOne of the greatest advantages of pavers is the extraordinary range of design options available. We work with interlocking concrete pavers in dozens of shapes, sizes, and colors; natural stone pavers including travertine, bluestone, flagstone, and slate; and porcelain pavers that combine the look of natural materials with exceptional durability. Patterns range from classic herringbone and running bond to contemporary linear layouts and custom mosaic designs - allowing you to create a surface that perfectly complements your home's architecture.\n\nPavers also offer significant practical advantages over poured concrete. Individual pavers can be easily removed and replaced if they become damaged, without disturbing the surrounding surface. Properly installed paver systems with polymeric sand joints create a flexible surface that resists cracking from ground movement - an important benefit in seismically active Los Angeles. Permeable paver options allow rainwater to filter through the joints into the ground below, reducing runoff and helping you meet local stormwater management requirements.\n\nEvery ACE paver installation begins with thorough base preparation - excavation, compaction, and a precisely graded aggregate base that provides a stable foundation. Edge restraints lock the perimeter in place, and joint sand fills the gaps to create a unified, interlocking surface. This meticulous process ensures your pavers remain level, stable, and free from shifting for decades.",
				'cost_range'       => '$15 - $35 per sq ft',
				'timeline'         => 'Varies by scope',
				'whats_included'   => array(
					'On-site consultation and surface assessment',
					'Custom paver layout and design',
					'Demolition and removal of existing surfaces',
					'Excavation, grading, and base compaction',
					'Aggregate base installation',
					'Paver installation with precision cutting and fitting',
					'Edge restraint installation',
					'Polymeric sand joint filling',
					'Sealing (optional, recommended)',
					'Final compaction and cleanup',
				),
				'benefits' => array(
					array(
						'title'       => 'Design Flexibility',
						'description' => 'With hundreds of paver styles, colors, sizes, and patterns available, the design possibilities are virtually unlimited. Our designers create custom layouts that complement your home\'s architecture - from classic, timeless patterns to bold, contemporary designs. Mix materials and colors to define borders, create focal points, and add visual interest.',
					),
					array(
						'title'       => 'Easy Repair and Maintenance',
						'description' => 'Unlike poured concrete, individual pavers can be removed and replaced without affecting the surrounding surface. This makes repairs simple and cost-effective. If you ever need to access underground utilities, pavers can be lifted and reinstalled - something that is impossible with a concrete slab.',
					),
					array(
						'title'       => 'Permeable Options for Stormwater Management',
						'description' => 'Permeable paver systems allow rainwater to filter through the joints and into the ground below, reducing surface runoff and helping recharge groundwater. In Los Angeles, where stormwater management is increasingly regulated, permeable pavers offer a functional and environmentally responsible solution.',
					),
				),
				'process_steps' => array(
					'Free on-site consultation to evaluate the area, discuss design preferences, and review material options.',
					'Custom paver layout design with material selections, patterns, and a detailed proposal.',
					'Excavation, grading, and compaction of the aggregate base to precise specifications.',
					'Paver installation with precision cutting, edge restraints, and polymeric sand jointing.',
					'Final compaction, optional sealing, cleanup, and walkthrough with care instructions.',
				),
				'faqs' => array(
					array(
						'question' => 'How much do pavers cost to install in Los Angeles?',
						'answer'   => 'Paver installation typically costs $15 to $35 per square foot, depending on the type of paver, complexity of the design, and preparation required. Concrete interlocking pavers are on the lower end, while natural stone and porcelain pavers are on the higher end. We provide detailed pricing in your proposal.',
					),
					array(
						'question' => 'Are pavers better than concrete?',
						'answer'   => 'Pavers and concrete each have their strengths. Pavers offer greater design flexibility, easier repairs, and better resistance to cracking. Concrete is more cost-effective for large, simple areas. Many homeowners choose pavers for patios, walkways, and driveways where aesthetics and longevity are priorities.',
					),
					array(
						'question' => 'How long do pavers last?',
						'answer'   => 'Quality interlocking pavers, properly installed, can last 30 to 50 years or more. Natural stone pavers like travertine and bluestone are virtually permanent when installed on a proper base. Regular maintenance - occasional cleaning and re-sanding of joints - keeps pavers looking like new.',
					),
					array(
						'question' => 'Do pavers require sealing?',
						'answer'   => 'Sealing is optional but recommended. A quality paver sealer enhances color, protects against stains, inhibits weed growth between joints, and stabilizes the polymeric sand. We recommend resealing every two to three years for best results.',
					),
					array(
						'question' => 'Can you install pavers over existing concrete?',
						'answer'   => 'In some cases, pavers can be installed as an overlay on existing concrete if the slab is in good condition and properly sloped for drainage. We evaluate the condition of your existing surface and recommend the best approach during your consultation.',
					),
					array(
						'question' => 'What are permeable pavers?',
						'answer'   => 'Permeable pavers are designed with wider joints or special shapes that allow rainwater to pass through the surface and into the ground below. They reduce stormwater runoff, help meet local drainage requirements, and are an environmentally responsible choice for driveways, patios, and walkways.',
					),
				),
				'related_services' => array( 'driveways', 'landscape-and-hardscaping', 'concrete' ),
			),

			/* ============================================================
			 * SERVICE 15 - Artificial Turf
			 * ============================================================ */
			array(
				'slug'             => 'artificial-turf',
				'title'            => 'Artificial Turf',
				'h1'               => 'Artificial Turf Installation in Los Angeles',
				'hero_subheadline' => 'A perfect lawn, 365 days a year - with zero water and zero maintenance.',
				'meta_title'       => 'Artificial Turf Installation in Los Angeles | ACE Design & Build',
				'meta_description' => 'Professional artificial turf installation in Los Angeles. Realistic, durable, pet-friendly synthetic grass. Save water and eliminate lawn maintenance. Free estimates.',
				'introduction'     => "A lush, green lawn is one of the most desirable features of any home - but in Los Angeles, maintaining a natural grass lawn is expensive, water-intensive, and demanding. The average Los Angeles lawn consumes approximately 56,000 gallons of water per year and requires weekly mowing, fertilizing, aerating, and pest control. Artificial turf eliminates all of that while delivering a perfect, year-round green lawn that looks and feels remarkably like the real thing.\n\nToday's premium artificial turf products are a far cry from the stiff, plastic-looking synthetic grass of decades past. Modern turf features multi-toned blade technology that replicates the varied colors and textures of natural grass. Soft, resilient fibers feel comfortable underfoot, and advanced backing systems provide excellent drainage - even in heavy rain. At ACE Design & Build, we install only top-tier turf products with realistic appearance, proven durability, and comprehensive manufacturer warranties.\n\nArtificial turf is an outstanding choice for families with children and pets. It stands up to heavy foot traffic, play, and pet use without developing bare spots, mud, or pest problems. Many of our turf products feature antimicrobial infill and efficient drainage systems that keep the surface clean and odor-free. For pet owners in particular, artificial turf eliminates the frustrating cycle of brown spots, digging damage, and muddy paws.\n\nBeyond lawns, we install artificial turf for putting greens, play areas, rooftop decks, commercial spaces, and side yards that are difficult to maintain with natural grass. Every installation follows a meticulous process of excavation, base preparation, precise seaming, and professional infill application that ensures your turf looks flawless and drains perfectly for years to come.",
				'cost_range'       => '$10 - $20 per sq ft',
				'timeline'         => '1 - 3 days',
				'whats_included'   => array(
					'On-site consultation and measurement',
					'Material selection from premium turf products',
					'Removal of existing grass and organic material',
					'Excavation and grading',
					'Compacted aggregate base installation',
					'Weed barrier fabric installation',
					'Turf layout, cutting, and precision seaming',
					'Infill application and brushing',
					'Edge trimming and border finishing',
					'Final grooming and cleanup',
				),
				'benefits' => array(
					array(
						'title'       => 'Massive Water Savings',
						'description' => 'The average Los Angeles lawn uses approximately 56,000 gallons of water per year. Artificial turf eliminates lawn irrigation entirely, saving you hundreds of dollars annually on water bills and helping conserve one of Southern California\'s most precious resources. Many local water agencies also offer rebates for grass-to-turf conversions.',
					),
					array(
						'title'       => 'Zero Maintenance, Year-Round Beauty',
						'description' => 'No mowing, no fertilizing, no aerating, no pest control, and no brown patches. Your artificial turf lawn looks perfectly green and manicured 365 days a year with zero ongoing maintenance. That means more weekends enjoying your yard instead of working on it.',
					),
					array(
						'title'       => 'Pet and Kid Friendly',
						'description' => 'Artificial turf stands up to heavy use from children and pets without developing bare spots, mud, or pest problems. Antimicrobial infill options and efficient drainage keep the surface clean and odor-free. No more muddy paws tracking through your house or chemical fertilizers where your kids play.',
					),
				),
				'process_steps' => array(
					'Free on-site consultation to measure the area, assess drainage, and help you select the right turf product.',
					'We provide a detailed proposal with product specifications, timeline, and pricing.',
					'Removal of existing grass, excavation, and installation of a compacted aggregate base with weed barrier.',
					'Turf is rolled out, precision-cut, seamed, and secured. Infill is applied and brushed into the fibers.',
					'Final grooming, edge finishing, cleanup, and a walkthrough with care tips.',
				),
				'faqs' => array(
					array(
						'question' => 'How much does artificial turf cost to install in Los Angeles?',
						'answer'   => 'Artificial turf installation typically costs $10 to $20 per square foot, including materials, base preparation, and labor. A typical 500-square-foot front yard conversion costs between $5,000 and $10,000. Rebates from local water agencies can offset a portion of the cost.',
					),
					array(
						'question' => 'How long does artificial turf last?',
						'answer'   => 'Premium artificial turf products typically last 15 to 25 years with normal use. The lifespan depends on the quality of the product, the amount of foot traffic, and sun exposure. All of our turf products come with manufacturer warranties of 8 to 15 years.',
					),
					array(
						'question' => 'Does artificial turf get hot in the sun?',
						'answer'   => 'Artificial turf can become warm on hot, sunny days - similar to a pool deck or patio surface. However, newer turf products with lighter-colored infill and advanced fiber technology stay significantly cooler than older products. We recommend these cooler options for high-sun areas and can discuss shading strategies during your consultation.',
					),
					array(
						'question' => 'Is artificial turf safe for pets?',
						'answer'   => 'Yes. Artificial turf is an excellent choice for pet owners. It resists digging, eliminates mud, and does not develop brown spots from pet waste. We offer antimicrobial infill options that inhibit bacteria and control odor. Solid waste is easily picked up, and liquid waste drains through the backing into the base below.',
					),
					array(
						'question' => 'Does artificial turf drain well?',
						'answer'   => 'Yes. Quality artificial turf products have perforated backing systems that allow water to drain through at rates exceeding 30 inches per hour. Combined with our compacted aggregate base, water drains quickly and efficiently - even during heavy Los Angeles rainstorms.',
					),
					array(
						'question' => 'Can I get a rebate for replacing my lawn with artificial turf?',
						'answer'   => 'Many Los Angeles-area water agencies offer rebates for removing natural grass and replacing it with drought-tolerant alternatives, including artificial turf. Rebate amounts vary by agency and are subject to change. We can help you identify available rebate programs during your consultation.',
					),
				),
				'related_services' => array( 'front-yard-renovation', 'landscape-and-hardscaping', 'backyard-remodeling' ),
			),

		), // End ace_services.

		/* ───────────────────────────────────────────────
		 * SEO Defaults
		 * ─────────────────────────────────────────────── */
		'ace_seo' => array(
			'home' => array(
				'meta_title'       => 'ACE Design & Build | Los Angeles Remodeling & Construction',
				'meta_description' => 'Los Angeles premier design-build firm. Full home remodeling, ADUs, kitchens, bathrooms, outdoor living, and more. 15 years of excellence. Free consultation.',
			),
			'about' => array(
				'meta_title'       => 'About ACE Design & Build | Los Angeles General Contractor',
				'meta_description' => 'Learn about ACE Design & Build - 15 years of trusted residential construction in Los Angeles. Licensed, bonded, insured. Over 2,000 projects completed.',
			),
			'services' => array(
				'meta_title'       => 'Our Services | ACE Design & Build Los Angeles',
				'meta_description' => 'Comprehensive residential construction services in Los Angeles. Remodeling, ADUs, additions, kitchens, bathrooms, outdoor living, and more. Free consultation.',
			),
			'portfolio' => array(
				'meta_title'       => 'Our Work | ACE Design & Build Portfolio',
				'meta_description' => 'Browse completed projects by ACE Design & Build. Kitchens, bathrooms, full home remodels, ADUs, outdoor living, and more in Los Angeles.',
			),
			'contact' => array(
				'meta_title'       => 'Contact ACE Design & Build | Free Consultation in Los Angeles',
				'meta_description' => 'Contact ACE Design & Build for a free remodeling consultation in Los Angeles. Call (310) 438-6866 or submit your request online. We respond within 2 hours.',
			),
			'blog' => array(
				'meta_title'       => 'Remodeling Tips & Insights | ACE Design & Build Blog',
				'meta_description' => 'Expert remodeling tips, design inspiration, and construction insights from ACE Design & Build in Los Angeles. Helpful guides for homeowners.',
			),
		),

		/* ───────────────────────────────────────────────
		 * Lead Form Settings
		 * ─────────────────────────────────────────────── */
		'ace_form_recipients'      => 'info@acedesignbuild.com',
		'ace_form_success_message' => "Thank you! Your request has been submitted. We'll be in touch within 2 hours during business hours.",
		'ace_form_thank_you_url'   => '/thank-you/',

		/* ───────────────────────────────────────────────
		 * Section Visibility
		 * ─────────────────────────────────────────────── */
		'ace_sections' => array(
			'hero'         => 1,
			'services'     => 1,
			'why_ace'      => 1,
			'stats'        => 1,
			'featured'     => 1,
			'process'      => 1,
			'testimonials' => 1,
			'cta'          => 1,
			'service_area' => 1,
			'blog'         => 1,
			'final_cta'    => 1,
			'about'        => 1,
			'portfolio'    => 1,
			'contact'      => 1,
		),

	);

	return $defaults;
}

/**
 * Install default options into the WordPress database.
 *
 * Loops through every default option and calls update_option() only
 * when the option does not already exist, preserving any values the
 * site owner has already customised.
 *
 * @return void
 */
function ace_install_default_options() {
	$defaults = ace_get_default_options();

	foreach ( $defaults as $key => $value ) {
		if ( false === get_option( $key ) ) {
			update_option( $key, $value );
		}
	}
}
