<?php
/**
 * Plugin Name: ACE WebP Optimizer
 * Description: Automatically converts images to WebP format for faster loading. Zero quality loss, major speed gains.
 * Version: 1.0.0
 * Author: ACE Design & Build
 * License: GPL v2 or later
 * Requires PHP: 7.4
 */

if (!defined('ABSPATH')) exit;

define('ACE_WEBP_VERSION', '1.0.0');
define('ACE_WEBP_PATH', plugin_dir_path(__FILE__));
define('ACE_WEBP_URL', plugin_dir_url(__FILE__));

require_once ACE_WEBP_PATH . 'includes/class-converter.php';
require_once ACE_WEBP_PATH . 'includes/class-admin.php';
require_once ACE_WEBP_PATH . 'includes/class-frontend.php';

/**
 * Activation check — verify WebP support
 */
register_activation_hook(__FILE__, function () {
    $supported = false;
    if (function_exists('imagewebp') && function_exists('imagecreatefromjpeg')) {
        $supported = true;
    } elseif (class_exists('Imagick')) {
        $formats = Imagick::queryFormats('WEBP');
        if (!empty($formats)) $supported = true;
    }
    update_option('ace_webp_supported', $supported ? 'yes' : 'no');
    if (!get_option('ace_webp_quality')) {
        update_option('ace_webp_quality', 82);
    }
    if (get_option('ace_webp_auto') === false) {
        update_option('ace_webp_auto', 'yes');
    }
});

/**
 * Admin notice if WebP not supported
 */
add_action('admin_notices', function () {
    if (get_option('ace_webp_supported') === 'no') {
        echo '<div class="notice notice-error"><p><strong>ACE WebP Optimizer:</strong> Your server does not support WebP conversion. Please enable GD with WebP support or install Imagick.</p></div>';
    }
});

// Initialize
add_action('init', function () {
    if (get_option('ace_webp_supported') !== 'yes') return;

    $converter = new ACE_WebP_Converter();

    // Auto-convert on upload
    if (get_option('ace_webp_auto', 'yes') === 'yes') {
        add_filter('wp_generate_attachment_metadata', [$converter, 'convert_on_upload'], 10, 2);
    }

    // Admin
    if (is_admin()) {
        new ACE_WebP_Admin($converter);
    }

    // Frontend rewriting
    if (!is_admin() && get_option('ace_webp_auto', 'yes') === 'yes') {
        new ACE_WebP_Frontend();
    }
});
