(function ($) {
    'use strict';

    let bulkRunning = false;
    let totalProcessed = 0;

    // Quality slider
    $('#aceQuality').on('input', function () {
        $('#qualityVal').text(this.value + '%');
    });

    // Save settings
    $('#aceSaveSettings').on('click', function () {
        const btn = $(this);
        btn.prop('disabled', true);

        $.post(aceWebP.ajax_url, {
            action: 'ace_webp_save',
            nonce: aceWebP.nonce,
            quality: $('#aceQuality').val(),
            auto: $('#aceAuto').is(':checked') ? 'yes' : 'no',
        }, function (res) {
            btn.prop('disabled', false);
            if (res.success) {
                $('#aceSaveMsg').text('Saved!').fadeIn().delay(2000).fadeOut();
            }
        });
    });

    // Bulk convert
    $('#aceBulkStart').on('click', function () {
        bulkRunning = true;
        totalProcessed = 0;
        $(this).hide();
        $('#aceBulkStop').show();
        $('#aceBulkProgress').show();
        runBatch();
    });

    $('#aceBulkStop').on('click', function () {
        bulkRunning = false;
        $(this).hide();
        $('#aceBulkStart').show().text('Resume');
        $('#aceBulkStatus').text('Stopped. ' + totalProcessed + ' images processed.');
    });

    function runBatch() {
        if (!bulkRunning) return;

        $.post(aceWebP.ajax_url, {
            action: 'ace_webp_bulk',
            nonce: aceWebP.nonce,
        }, function (res) {
            if (!res.success) {
                $('#aceBulkStatus').text('Error occurred.');
                bulkRunning = false;
                return;
            }

            totalProcessed += res.data.processed;
            $('#aceBulkStatus').text(totalProcessed + ' images processed (' + res.data.converted + ' converted this batch)');

            if (res.data.remaining && bulkRunning) {
                // Animate progress (approximate)
                let fill = Math.min(95, totalProcessed / (totalProcessed + 20) * 100);
                $('#aceProgressFill').css('width', fill + '%');
                setTimeout(runBatch, 300);
            } else {
                // Done
                $('#aceProgressFill').css('width', '100%');
                $('#aceBulkStatus').text('Done! ' + totalProcessed + ' images processed.');
                $('#aceBulkStop').hide();
                $('#aceBulkStart').show().text('Start Bulk Conversion');
                bulkRunning = false;
                refreshStats();
            }
        }).fail(function () {
            $('#aceBulkStatus').text('Server error. Try again.');
            bulkRunning = false;
        });
    }

    // Refresh stats
    $('#aceRefreshStats').on('click', refreshStats);

    function refreshStats() {
        $.post(aceWebP.ajax_url, {
            action: 'ace_webp_stats',
            nonce: aceWebP.nonce,
        }, function (res) {
            if (res.success) {
                $('#statTotal').text(res.data.total);
                $('#statConverted').text(res.data.converted);
                $('#statSaved').text(res.data.saved_mb + ' MB');
            }
        });
    }

})(jQuery);
