<?php
if (!defined('ABSPATH')) exit;

class ACE_WebP_Frontend {

    public function __construct() {
        add_action('template_redirect', [$this, 'start_buffer']);
    }

    public function start_buffer() {
        if (is_admin() || wp_doing_ajax() || wp_doing_cron()) return;
        if (defined('REST_REQUEST') && REST_REQUEST) return;

        $accept = isset($_SERVER['HTTP_ACCEPT']) ? $_SERVER['HTTP_ACCEPT'] : '';
        if (strpos($accept, 'image/webp') === false) return;

        ob_start([$this, 'rewrite_html']);
    }

    public function rewrite_html($html) {
        if (empty($html)) return $html;

        $upload_dir = wp_upload_dir();
        $upload_url = $upload_dir['baseurl'];
        $upload_path = $upload_dir['basedir'];

        $pattern = '#(' . preg_quote($upload_url, '#') . '/[^\s\'"\\)]+\.(jpe?g|png))#i';

        $html = preg_replace_callback($pattern, function ($matches) use ($upload_url, $upload_path) {
            $url = $matches[1];
            $relative = str_replace($upload_url, '', $url);
            $webp_file = $upload_path . $relative . '.webp';

            if (file_exists($webp_file)) {
                return $url . '.webp';
            }
            return $url;
        }, $html);

        return $html;
    }
}
