<?php
/**
 * Schema.org JSON-LD markup
 */

function ace_output_schema() {
    // LocalBusiness schema on every page
    ace_local_business_schema();

    // Breadcrumb schema on inner pages
    if ( ! is_front_page() ) {
        ace_breadcrumb_schema();
    }

    // FAQ schema on service pages
    if ( is_page_template( 'template-parts/service-page.php' ) || ( is_page() && get_query_var( 'ace_service' ) ) ) {
        ace_faq_schema();
    }
}
add_action( 'wp_head', 'ace_output_schema', 5 );

function ace_local_business_schema() {
    $schema = array(
        '@context'    => 'https://schema.org',
        '@type'       => 'HomeAndConstructionBusiness',
        'name'        => ace_get_company_name(),
        'description' => ace_get_option( 'tagline', 'Create with Confidence' ),
        'url'         => home_url( '/' ),
        'telephone'   => ace_get_phone(),
        'email'       => ace_get_email(),
        'address'     => array(
            '@type'           => 'PostalAddress',
            'streetAddress'   => '6100 Wilshire Blvd #1200',
            'addressLocality' => 'Los Angeles',
            'addressRegion'   => 'CA',
            'postalCode'      => '90048',
            'addressCountry'  => 'US',
        ),
        'geo' => array(
            '@type'     => 'GeoCoordinates',
            'latitude'  => '34.0633',
            'longitude' => '-118.3612',
        ),
        'openingHoursSpecification' => array(
            '@type'     => 'OpeningHoursSpecification',
            'dayOfWeek' => array( 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday' ),
            'opens'     => '10:00',
            'closes'    => '22:00',
        ),
        'areaServed' => array(
            '@type' => 'City',
            'name'  => 'Los Angeles',
        ),
        'priceRange'      => '$$$',
        'aggregateRating' => array(
            '@type'       => 'AggregateRating',
            'ratingValue' => '4.9',
            'reviewCount' => '200',
            'bestRating'  => '5',
        ),
    );

    $logo = ace_get_logo_url();
    if ( $logo ) {
        $schema['logo'] = $logo;
        $schema['image'] = $logo;
    }

    echo '<script type="application/ld+json">' . wp_json_encode( $schema, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT ) . '</script>' . "\n";
}

function ace_breadcrumb_schema() {
    $items = array();
    $position = 1;

    $items[] = array(
        '@type'    => 'ListItem',
        'position' => $position++,
        'name'     => 'Home',
        'item'     => home_url( '/' ),
    );

    if ( is_singular( 'post' ) ) {
        $items[] = array(
            '@type'    => 'ListItem',
            'position' => $position++,
            'name'     => 'Blog',
            'item'     => get_permalink( get_option( 'page_for_posts' ) ),
        );
        $items[] = array(
            '@type'    => 'ListItem',
            'position' => $position++,
            'name'     => get_the_title(),
        );
    } elseif ( is_page() ) {
        $items[] = array(
            '@type'    => 'ListItem',
            'position' => $position++,
            'name'     => get_the_title(),
        );
    }

    $schema = array(
        '@context'        => 'https://schema.org',
        '@type'           => 'BreadcrumbList',
        'itemListElement' => $items,
    );

    echo '<script type="application/ld+json">' . wp_json_encode( $schema, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT ) . '</script>' . "\n";
}

function ace_faq_schema() {
    // Get current service slug from query or page slug
    $slug = get_query_var( 'ace_service', '' );
    if ( ! $slug && is_page() ) {
        $slug = get_post_field( 'post_name', get_the_ID() );
    }

    $service = ace_get_service( $slug );
    if ( ! $service || empty( $service['faqs'] ) ) {
        return;
    }

    $faq_items = array();
    foreach ( $service['faqs'] as $faq ) {
        $faq_items[] = array(
            '@type'          => 'Question',
            'name'           => $faq['question'],
            'acceptedAnswer' => array(
                '@type' => 'Answer',
                'text'  => $faq['answer'],
            ),
        );
    }

    $schema = array(
        '@context'   => 'https://schema.org',
        '@type'      => 'FAQPage',
        'mainEntity' => $faq_items,
    );

    echo '<script type="application/ld+json">' . wp_json_encode( $schema, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT ) . '</script>' . "\n";
}
