<?php
/**
 * Template Name: About Page
 * @package ACE_Theme
 */
get_header();
?>

<!-- Hero -->
<section class="page-hero">
    <?php $bg = ace_get_option( 'about_hero_image', '' ); ?>
    <div class="page-hero-overlay"<?php echo $bg ? ' style="background-image: url(' . esc_url( $bg ) . ');"' : ''; ?>>
        <div class="container">
            <h1 class="page-hero-title"><?php echo esc_html( ace_get_option( 'about_headline', '15 Years of Building Los Angeles\' Finest Homes' ) ); ?></h1>
            <p class="page-hero-subtitle"><?php echo esc_html( ace_get_option( 'about_subheadline', 'We\'re not just contractors. We\'re designers, engineers, craftsmen, and partners in bringing your vision to life.' ) ); ?></p>
        </div>
    </div>
</section>

<!-- Our Story -->
<section class="section bg-white">
    <div class="container">
        <div class="about-story-grid">
            <div class="about-story-content">
                <h2><?php echo esc_html( ace_get_option( 'about_story_title', 'The ACE Story' ) ); ?></h2>
                <?php
                $story = ace_get_option( 'about_story', '' );
                if ( ! $story ) {
                    $story = "ACE Design & Build was founded with a simple belief: homeowners deserve a construction partner they can actually trust. For over 15 years, we've been that partner for thousands of families across Los Angeles.\n\nWe started as a small remodeling crew with big standards. Over the years, we've grown into a full-service design-build firm with in-house architects, designers, project managers, and skilled tradespeople - but our standards have never changed. Every project gets the same meticulous attention to detail, whether it's a bathroom refresh or a complete home transformation.\n\nWhat sets us apart isn't just what we build - it's how we build. We believe in radical transparency. That means honest timelines, upfront pricing, and zero surprises. It means a dedicated project manager who answers your calls. It means weekly progress updates with photos. And it means we don't consider a project complete until you're genuinely happy with the result.\n\nWe're proud to serve the communities of Los Angeles, from Beverly Hills to Pasadena, from the Westside to the Valley. This is our city, these are our neighbors, and every home we build reflects on who we are.";
                }
                echo wp_kses_post( wpautop( $story ) );
                ?>
            </div>
            <div class="about-story-image">
                <?php $story_img = ace_get_option( 'about_story_image', '' ); ?>
                <?php if ( $story_img ) : ?>
                    <img src="<?php echo esc_url( $story_img ); ?>" alt="<?php esc_attr_e( 'ACE Design & Build Team', 'ace-theme' ); ?>" loading="lazy">
                <?php else : ?>
                    <div class="image-placeholder large">
                        <?php echo ace_icon( 'users', 64 ); ?>
                        <span><?php esc_html_e( 'Our Team', 'ace-theme' ); ?></span>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</section>

<!-- Our Values -->
<section class="section bg-light">
    <div class="container">
        <div class="section-header text-center">
            <h2><?php echo esc_html( ace_get_option( 'about_values_title', 'What We Stand For' ) ); ?></h2>
        </div>
        <div class="values-grid">
            <?php
            $values = ace_get_about_values();
            $default_values = array(
                array( 'icon' => 'hammer', 'title' => 'Craftsmanship', 'description' => 'We don\'t do "good enough." Every cut, every joint, every finish is executed to the highest standard.' ),
                array( 'icon' => 'dollar-sign', 'title' => 'Transparency', 'description' => 'No hidden costs. No vague timelines. You\'ll always know exactly where your project stands.' ),
                array( 'icon' => 'users', 'title' => 'Respect', 'description' => 'Your home is your sanctuary. Our crews treat it - and you - with the utmost respect and professionalism.' ),
                array( 'icon' => 'shield', 'title' => 'Accountability', 'description' => 'We stand behind our work. Period. If something isn\'t right, we make it right.' ),
            );
            $values = ! empty( $values ) ? $values : $default_values;
            foreach ( $values as $value ) : ?>
                <div class="value-card">
                    <div class="value-icon">
                        <?php
                        $value_key_map = array(
                            'Craftsmanship'  => 'craftsmanship',
                            'Transparency'   => 'transparency',
                            'Respect'        => 'respect',
                            'Accountability' => 'accountability',
                        );
                        $vk = isset( $value_key_map[ $value['title'] ] ) ? $value_key_map[ $value['title'] ] : 'craftsmanship';
                        echo ace_get_icon( 'values', $vk, 'large' );
                        ?>
                    </div>
                    <h3><?php echo esc_html( $value['title'] ); ?></h3>
                    <p><?php echo esc_html( $value['description'] ); ?></p>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>

<!-- Stats -->
<?php get_template_part( 'template-parts/stats-counter' ); ?>

<!-- Certifications -->
<section class="section bg-white">
    <div class="container">
        <div class="section-header text-center">
            <h2><?php esc_html_e( 'Certifications & Affiliations', 'ace-theme' ); ?></h2>
        </div>
        <div class="certifications-grid">
            <?php
            $certs = get_option( 'ace_about_certifications', array() );
            if ( empty( $certs ) ) {
                $certs = array(
                    'Licensed by the California Contractors State License Board (CSLB)',
                    'Bonded & Fully Insured',
                    'Member of the National Association of Home Builders (NAHB)',
                    'Member of the National Kitchen & Bath Association (NKBA)',
                    'A+ BBB Rating',
                );
            }
            foreach ( $certs as $cert ) : ?>
                <div class="cert-item">
                    <span class="ace-icon-inline"><i class="fas fa-certificate"></i></span>
                    <span><?php echo esc_html( $cert ); ?></span>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>

<!-- CTA -->
<?php get_template_part( 'template-parts/cta-banner' ); ?>

<?php get_footer(); ?>
