<?php
/**
 * Template Name: FAQ Page
 *
 * Frequently Asked Questions page for ACE Design & Build.
 * Organized by category with accessible accordion components.
 *
 * @package ACE_Theme
 */

get_header();

// FAQ data organized by category.
$faq_categories = array(
	array(
		'id'    => 'general',
		'title' => __( 'General Questions', 'ace-theme' ),
		'icon'  => 'home',
		'faqs'  => array(
			array(
				'question' => __( 'What areas does ACE Design & Build serve?', 'ace-theme' ),
				'answer'   => __( 'We proudly serve all of Greater Los Angeles, including Beverly Hills, Santa Monica, Pasadena, Burbank, Glendale, the San Fernando Valley, and surrounding communities. Our crews are based locally, so we know the building codes and permit requirements for every jurisdiction in the LA area. If you are unsure whether your neighborhood falls within our service area, give us a call and we will be happy to confirm.', 'ace-theme' ),
			),
			array(
				'question' => __( 'How do I get started with my project?', 'ace-theme' ),
				'answer'   => __( 'Getting started is simple. You can fill out our online contact form, call us directly, or request a free in-home consultation through our website. One of our project consultants will schedule a visit to your home, discuss your goals, assess the space, and walk you through next steps with zero pressure or obligation.', 'ace-theme' ),
			),
			array(
				'question' => __( 'Are you licensed, bonded, and insured?', 'ace-theme' ),
				'answer'   => __( 'Yes. ACE Design & Build is fully licensed by the California Contractors State License Board (CSLB), bonded, and carries comprehensive general liability insurance as well as workers\' compensation coverage. We are happy to provide proof of insurance and our license number upon request. Your investment is protected at every stage of the project.', 'ace-theme' ),
			),
			array(
				'question' => __( 'How long has ACE been in business?', 'ace-theme' ),
				'answer'   => __( 'ACE Design & Build has been serving Los Angeles homeowners for over 15 years. In that time we have completed more than 2,000 projects ranging from bathroom refreshes to full-scale home renovations. Our experience means fewer surprises, better planning, and a smoother build process for you.', 'ace-theme' ),
			),
			array(
				'question' => __( 'Do you offer free consultations?', 'ace-theme' ),
				'answer'   => __( 'Absolutely. We offer a complimentary in-home consultation where we visit your property, listen to your ideas, evaluate the existing conditions, and provide an initial scope of work. There is no cost and no obligation. We believe you should feel confident about your contractor before committing a single dollar.', 'ace-theme' ),
			),
		),
	),
	array(
		'id'    => 'services',
		'title' => __( 'Services', 'ace-theme' ),
		'icon'  => 'hammer',
		'faqs'  => array(
			array(
				'question' => __( 'What types of remodeling services do you offer?', 'ace-theme' ),
				'answer'   => __( 'We offer a full range of residential remodeling services including kitchen remodels, bathroom renovations, room additions, whole-home renovations, ADU construction, outdoor living spaces, and pool installation. Whether you need a single room updated or an entire property transformed, our team handles every trade in-house for a seamless experience.', 'ace-theme' ),
			),
			array(
				'question' => __( 'Can you handle both interior and exterior projects?', 'ace-theme' ),
				'answer'   => __( 'Yes, we handle both interior and exterior work. On the interior side we do kitchens, bathrooms, living spaces, flooring, and structural modifications. Exterior projects include facades, landscaping, hardscaping, decks, patios, outdoor kitchens, pools, and ADU construction. Many of our clients combine interior and exterior scopes into a single project for better efficiency and cost savings.', 'ace-theme' ),
			),
			array(
				'question' => __( 'Do you build ADUs (Accessory Dwelling Units)?', 'ace-theme' ),
				'answer'   => __( 'Yes, ADU construction is one of our core specialties. We handle the entire process from feasibility assessment and architectural design through permitting and final construction. California and Los Angeles have specific ADU regulations, and our team stays current on all local ordinances to ensure your project is approved and built to code.', 'ace-theme' ),
			),
			array(
				'question' => __( 'Do you provide design services or just construction?', 'ace-theme' ),
				'answer'   => __( 'We are a full-service design-build firm, which means we provide both architectural design and construction under one roof. Our in-house design team creates detailed plans, material selections, and 3D renderings before construction begins. This integrated approach saves time, reduces miscommunication, and gives you a single point of accountability from concept to completion.', 'ace-theme' ),
			),
			array(
				'question' => __( 'Can you work with my existing architect or designer?', 'ace-theme' ),
				'answer'   => __( 'Of course. While we offer in-house design, we are equally comfortable building from plans provided by your architect or designer. We regularly collaborate with outside design professionals and can provide value engineering feedback to help ensure the design is buildable, on budget, and meets all local code requirements.', 'ace-theme' ),
			),
		),
	),
	array(
		'id'    => 'pricing',
		'title' => __( 'Pricing & Budget', 'ace-theme' ),
		'icon'  => 'dollar-sign',
		'faqs'  => array(
			array(
				'question' => __( 'How much does a typical remodeling project cost?', 'ace-theme' ),
				'answer'   => __( 'Project costs vary widely based on scope, materials, and complexity. A bathroom remodel in Los Angeles might range from $25,000 to $75,000, while a full kitchen renovation can range from $50,000 to $150,000 or more. We provide a detailed, line-item estimate after your free consultation so you know exactly what to expect before any work begins.', 'ace-theme' ),
			),
			array(
				'question' => __( 'Do you offer financing options?', 'ace-theme' ),
				'answer'   => __( 'Yes, we work with several trusted lending partners to offer flexible financing options for qualified homeowners. Whether you prefer a home equity line of credit, a personal loan, or a specialized home improvement loan, we can connect you with the right solution. Ask your project consultant for details during your consultation.', 'ace-theme' ),
			),
			array(
				'question' => __( 'What is included in your project estimates?', 'ace-theme' ),
				'answer'   => __( 'Our estimates are fully transparent and itemized. They include all labor, materials, permits, design fees, project management, debris removal, and a detailed scope of work. We do not bury costs in vague line items. You will see exactly where every dollar goes so there are no surprises once construction begins.', 'ace-theme' ),
			),
			array(
				'question' => __( 'How do you handle change orders?', 'ace-theme' ),
				'answer'   => __( 'We understand that changes sometimes come up during a project. Any modification to the original scope is documented with a written change order that clearly states the additional cost and any timeline impact. We review it with you and get your written approval before proceeding, so you always stay in control of your budget.', 'ace-theme' ),
			),
		),
	),
	array(
		'id'    => 'process',
		'title' => __( 'Process & Timeline', 'ace-theme' ),
		'icon'  => 'calendar',
		'faqs'  => array(
			array(
				'question' => __( 'How long does a typical remodeling project take?', 'ace-theme' ),
				'answer'   => __( 'Timelines depend on the scope of work. A standard bathroom remodel typically takes 3 to 6 weeks, a kitchen renovation 6 to 12 weeks, and a whole-home remodel or addition can take 3 to 6 months. During your consultation we provide a realistic project schedule with clearly defined milestones so you can plan accordingly.', 'ace-theme' ),
			),
			array(
				'question' => __( 'What is your design-build process?', 'ace-theme' ),
				'answer'   => __( 'Our process has four main phases: consultation, design, construction, and final walkthrough. It starts with a free in-home visit, moves into detailed design and planning with your input, transitions into expert construction managed by a dedicated project manager, and ends with a thorough walkthrough to ensure everything meets your expectations. This streamlined approach keeps your project on time and on budget.', 'ace-theme' ),
			),
			array(
				'question' => __( 'Will I have a dedicated project manager?', 'ace-theme' ),
				'answer'   => __( 'Yes. Every ACE project is assigned a dedicated project manager who serves as your single point of contact from start to finish. They coordinate all trades, manage the schedule, handle inspections, and provide you with regular progress updates including photos. You will never have to wonder what is happening on your job site.', 'ace-theme' ),
			),
			array(
				'question' => __( 'How do you handle permits and inspections?', 'ace-theme' ),
				'answer'   => __( 'We manage the entire permitting and inspection process on your behalf. Our team prepares all required drawings and applications, submits them to the appropriate city or county department, and schedules every inspection throughout the build. With over 15 years of experience in Los Angeles, we know the local requirements inside and out, which helps avoid delays.', 'ace-theme' ),
			),
		),
	),
	array(
		'id'    => 'warranty',
		'title' => __( 'Technical & Warranty', 'ace-theme' ),
		'icon'  => 'shield',
		'faqs'  => array(
			array(
				'question' => __( 'What warranty do you offer on your work?', 'ace-theme' ),
				'answer'   => __( 'We stand behind every project with a comprehensive workmanship warranty. Our standard warranty covers labor and craftsmanship, and many of the materials and products we install carry their own manufacturer warranties that can extend coverage even further. Full warranty details are outlined in your project contract before work begins.', 'ace-theme' ),
			),
			array(
				'question' => __( 'Do you use licensed subcontractors?', 'ace-theme' ),
				'answer'   => __( 'Yes. Every subcontractor on an ACE job site is licensed, insured, and vetted to meet our quality standards. We have long-standing relationships with our trade partners, many of whom have worked with us for over a decade. This consistency ensures reliable craftsmanship and a crew that knows how we operate.', 'ace-theme' ),
			),
			array(
				'question' => __( 'How do you ensure quality control during construction?', 'ace-theme' ),
				'answer'   => __( 'Quality control is built into every phase of our process. Your dedicated project manager conducts daily site inspections, and our operations team performs milestone checkpoints at key stages of construction. We also schedule all required city inspections promptly. Nothing moves to the next phase until the current work meets our standards and yours.', 'ace-theme' ),
			),
			array(
				'question' => __( 'What happens if there are issues after the project is complete?', 'ace-theme' ),
				'answer'   => __( 'We are just a phone call away. If you notice anything that needs attention after your final walkthrough, contact us and we will send a crew to address it promptly under our warranty. We also perform a complimentary follow-up check after project completion to make sure everything is holding up perfectly. Your satisfaction does not end on move-in day.', 'ace-theme' ),
			),
		),
	),
);

// Global FAQ index counter for unique IDs across all categories.
$faq_global_index = 0;
?>

<!-- Page Hero -->
<section class="page-hero">
	<div class="page-hero-overlay">
		<div class="container">
			<h1 class="page-hero-title fade-in-up"><?php esc_html_e( 'Frequently Asked Questions', 'ace-theme' ); ?></h1>
			<p class="page-hero-subtitle fade-in-up" style="animation-delay: 0.2s"><?php esc_html_e( 'Everything you need to know about working with ACE Design & Build. Can\'t find your answer? We\'re always happy to help.', 'ace-theme' ); ?></p>
		</div>
	</div>
</section>

<!-- Breadcrumbs -->
<?php ace_breadcrumbs(); ?>

<!-- FAQ Category Navigation -->
<section class="section bg-white faq-nav-section">
	<div class="container">
		<nav class="faq-category-nav fade-in-up" aria-label="<?php esc_attr_e( 'FAQ Categories', 'ace-theme' ); ?>">
			<?php foreach ( $faq_categories as $category ) : ?>
				<a href="#faq-<?php echo esc_attr( $category['id'] ); ?>" class="faq-nav-link">
					<?php echo ace_icon( $category['icon'], 18 ); ?>
					<span><?php echo esc_html( $category['title'] ); ?></span>
				</a>
			<?php endforeach; ?>
		</nav>
	</div>
</section>

<!-- FAQ Sections -->
<?php foreach ( $faq_categories as $cat_index => $category ) : ?>
	<section id="faq-<?php echo esc_attr( $category['id'] ); ?>" class="section <?php echo 0 === $cat_index % 2 ? 'bg-light' : 'bg-white'; ?> faq-section">
		<div class="container">
			<div class="section-header fade-in-up">
				<div class="faq-category-header">
					<div class="faq-category-icon">
						<?php echo ace_icon( $category['icon'], 28 ); ?>
					</div>
					<h2><?php echo esc_html( $category['title'] ); ?></h2>
				</div>
			</div>

			<div class="faq-accordion fade-in-up" style="animation-delay: 0.2s">
				<?php foreach ( $category['faqs'] as $faq ) :
					$faq_id = 'faq-answer-' . $faq_global_index;
				?>
					<div class="faq-item">
						<button
							class="faq-question"
							type="button"
							aria-expanded="false"
							aria-controls="<?php echo esc_attr( $faq_id ); ?>"
						>
							<span><?php echo esc_html( $faq['question'] ); ?></span>
							<?php echo ace_icon( 'chevron-down', 20 ); ?>
						</button>
						<div
							class="faq-answer"
							id="<?php echo esc_attr( $faq_id ); ?>"
							role="region"
							aria-labelledby="<?php echo esc_attr( $faq_id . '-btn' ); ?>"
						>
							<p><?php echo wp_kses_post( $faq['answer'] ); ?></p>
						</div>
					</div>
				<?php
					$faq_global_index++;
				endforeach; ?>
			</div>
		</div>
	</section>
<?php endforeach; ?>

<!-- Still Have Questions CTA -->
<section class="section bg-navy faq-cta-section">
	<div class="container">
		<div class="faq-cta-inner fade-in-up">
			<div class="faq-cta-content">
				<h2><?php esc_html_e( 'Still Have Questions?', 'ace-theme' ); ?></h2>
				<p><?php esc_html_e( 'Our team is ready to help. Reach out for a free, no-obligation consultation and get personalized answers about your specific project.', 'ace-theme' ); ?></p>
			</div>
			<div class="faq-cta-actions">
				<a href="<?php echo esc_url( home_url( '/contact/' ) ); ?>" class="btn btn-primary btn-lg" data-popup="consultation">
					<?php echo ace_icon( 'arrow-right', 18 ); ?>
					<?php esc_html_e( 'Contact Us Today', 'ace-theme' ); ?>
				</a>
				<a href="<?php echo esc_url( ace_get_phone_link() ); ?>" class="btn btn-ghost btn-lg">
					<?php echo ace_icon( 'phone', 18 ); ?>
					<?php esc_html_e( 'Call ', 'ace-theme' ); ?><?php echo esc_html( ace_get_phone() ); ?>
				</a>
			</div>
		</div>
	</div>
</section>

<?php get_footer(); ?>
