<?php
/**
 * Template Name: Services Page
 * @package ACE_Theme
 */
get_header();
?>

<!-- Hero -->
<section class="page-hero">
    <div class="page-hero-overlay">
        <div class="container">
            <h1 class="page-hero-title"><?php esc_html_e( 'Our Services', 'ace-theme' ); ?></h1>
            <p class="page-hero-subtitle"><?php esc_html_e( 'Comprehensive residential construction and remodeling services, from concept to completion.', 'ace-theme' ); ?></p>
        </div>
    </div>
</section>

<!-- Services Grid -->
<section class="section bg-white">
    <div class="container">
        <div class="services-page-grid">
            <?php
            $services = ace_get_services();
            if ( ! empty( $services ) ) :
                foreach ( $services as $service ) :
                    $image = isset( $service['hero_image'] ) ? $service['hero_image'] : '';
                    $intro = isset( $service['introduction'] ) ? $service['introduction'] : '';
                    $excerpt = wp_trim_words( wp_strip_all_tags( $intro ), 25, '...' );
                    ?>
                    <div class="service-page-card">
                        <div class="service-page-card-image">
                            <?php if ( $image ) : ?>
                                <img src="<?php echo esc_url( $image ); ?>" alt="<?php echo esc_attr( $service['title'] ); ?>" loading="lazy">
                            <?php else : ?>
                                <div class="service-card-placeholder">
                                    <i class="fas <?php echo esc_attr( ace_get_service_icon_class( $service['slug'] ) ); ?>" style="font-size: 2.5rem; color: #C6A355;"></i>
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="service-page-card-content">
                            <h2><a href="<?php echo esc_url( home_url( '/services/' . $service['slug'] . '/' ) ); ?>"><?php echo esc_html( $service['title'] ); ?></a></h2>
                            <?php if ( $excerpt ) : ?>
                                <p><?php echo esc_html( $excerpt ); ?></p>
                            <?php endif; ?>
                            <a href="<?php echo esc_url( home_url( '/services/' . $service['slug'] . '/' ) ); ?>" class="link-arrow">
                                <?php esc_html_e( 'Learn More', 'ace-theme' ); ?> <?php echo ace_icon( 'arrow-right', 14 ); ?>
                            </a>
                        </div>
                    </div>
                <?php endforeach;
            endif; ?>
        </div>
    </div>
</section>

<!-- CTA -->
<?php get_template_part( 'template-parts/cta-banner' ); ?>

<?php get_footer(); ?>
