<?php
/**
 * Search Results Template
 * @package ACE_Theme
 */
get_header();
?>

<section class="page-hero page-hero-sm">
    <div class="page-hero-overlay">
        <div class="container">
            <h1 class="page-hero-title"><?php printf( esc_html__( 'Search Results for: "%s"', 'ace-theme' ), get_search_query() ); ?></h1>
        </div>
    </div>
</section>

<section class="section bg-white">
    <div class="container">
        <div class="blog-layout">
            <div class="blog-main">
                <?php if ( have_posts() ) : ?>
                    <p class="search-count"><?php printf( esc_html__( '%d results found', 'ace-theme' ), $wp_query->found_posts ); ?></p>
                    <div class="blog-grid-2col">
                        <?php while ( have_posts() ) : the_post(); ?>
                            <?php get_template_part( 'template-parts/blog-card' ); ?>
                        <?php endwhile; ?>
                    </div>
                    <div class="pagination">
                        <?php the_posts_pagination( array(
                            'mid_size'  => 2,
                            'prev_text' => '&laquo; ' . esc_html__( 'Previous', 'ace-theme' ),
                            'next_text' => esc_html__( 'Next', 'ace-theme' ) . ' &raquo;',
                        ) ); ?>
                    </div>
                <?php else : ?>
                    <div class="no-results text-center">
                        <h2><?php esc_html_e( 'No Results Found', 'ace-theme' ); ?></h2>
                        <p><?php esc_html_e( 'Sorry, no results matched your search. Try different keywords or browse our services.', 'ace-theme' ); ?></p>
                        <?php get_search_form(); ?>
                    </div>
                <?php endif; ?>
            </div>
            <?php get_sidebar(); ?>
        </div>
    </div>
</section>

<?php get_footer(); ?>
