<?php
/**
 * Process Steps Template Part
 *
 * Expects $args['steps'] array and optional $args['title'], $args['subtitle']
 *
 * @package ACE_Theme
 */

$steps = isset( $args['steps'] ) ? $args['steps'] : array();
$title = isset( $args['title'] ) ? $args['title'] : '';
$subtitle = isset( $args['subtitle'] ) ? $args['subtitle'] : '';
if ( empty( $steps ) ) return;
?>
<div class="process-section">
    <?php if ( $title ) : ?>
        <div class="section-header text-center">
            <h2><?php echo esc_html( $title ); ?></h2>
            <?php if ( $subtitle ) : ?>
                <p class="section-subtitle"><?php echo esc_html( $subtitle ); ?></p>
            <?php endif; ?>
        </div>
    <?php endif; ?>
    <div class="process-timeline">
        <?php foreach ( $steps as $index => $step ) : ?>
            <div class="process-step">
                <div class="step-number"><?php echo intval( $index + 1 ); ?></div>
                <div class="step-content">
                    <h3><?php echo esc_html( $step['title'] ); ?></h3>
                    <p><?php echo esc_html( $step['description'] ); ?></p>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
</div>
