<?php
/**
 * Project Card Template Part
 *
 * @package ACE_Theme
 */

$categories = get_the_terms( get_the_ID(), 'project_category' );
$category_name = $categories && ! is_wp_error( $categories ) ? $categories[0]->name : '';
?>
<div class="project-card">
    <a href="<?php the_permalink(); ?>" class="project-card-link">
        <div class="project-card-image">
            <?php if ( has_post_thumbnail() ) : ?>
                <?php the_post_thumbnail( 'ace-portfolio', array( 'loading' => 'lazy' ) ); ?>
            <?php else : ?>
                <div class="image-placeholder">
                    <?php echo ace_icon( 'home', 48 ); ?>
                </div>
            <?php endif; ?>
            <div class="project-card-overlay">
                <?php if ( $category_name ) : ?>
                    <span class="project-category"><?php echo esc_html( $category_name ); ?></span>
                <?php endif; ?>
                <h3><?php the_title(); ?></h3>
            </div>
        </div>
    </a>
</div>
