<?php get_header(); ?>

<section class="fresh-section" style="padding-top: calc(var(--space-3xl) + 80px);">
    <div class="fresh-container">
        <div class="fade-up" style="margin-bottom: var(--space-2xl);">
            <span class="fresh-overline">קייס סטאדי</span>
            <h1>התוצאות מדברות</h1>
            <p style="margin-top: var(--space-md); max-width: 500px;">כל פרויקט, כל מספר — אמיתי. ככה נראית עבודה שעובדת.</p>
        </div>

        <?php if ( have_posts() ) : ?>
            <div class="fresh-grid fresh-grid--3 stagger-children">
                <?php while ( have_posts() ) : the_post();
                    $metric_num   = get_post_meta( get_the_ID(), '_fresh_metric_number', true );
                    $metric_label = get_post_meta( get_the_ID(), '_fresh_metric_label', true );
                    $terms        = get_the_terms( get_the_ID(), 'case_category' );
                    $cat_name     = $terms ? $terms[0]->name : '';
                ?>
                    <article class="case-card">
                        <?php if ( has_post_thumbnail() ) : ?>
                            <div class="case-card__image">
                                <img src="<?php echo esc_url( get_the_post_thumbnail_url( get_the_ID(), 'fresh-case' ) ); ?>"
                                     alt="<?php the_title_attribute(); ?>" loading="lazy">
                            </div>
                        <?php endif; ?>
                        <div class="case-card__body">
                            <?php if ( $cat_name ) : ?>
                                <span class="case-card__category"><?php echo esc_html( $cat_name ); ?></span>
                            <?php endif; ?>
                            <h3 class="case-card__title">
                                <a href="<?php the_permalink(); ?>" style="color: inherit;"><?php the_title(); ?></a>
                            </h3>
                            <p class="case-card__excerpt"><?php the_excerpt(); ?></p>
                            <?php if ( $metric_num ) : ?>
                                <div class="case-card__stat">
                                    <span class="case-card__stat-number"><?php echo esc_html( $metric_num ); ?></span>
                                    <span class="case-card__stat-label"><?php echo esc_html( $metric_label ); ?></span>
                                </div>
                            <?php endif; ?>
                        </div>
                    </article>
                <?php endwhile; ?>
            </div>
        <?php endif; ?>
    </div>
</section>

<?php get_footer(); ?>
