<!DOCTYPE html>
<html <?php language_attributes(); ?> dir="rtl">
<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="<?php bloginfo( 'description' ); ?>">
    <?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<?php wp_body_open(); ?>

<header class="site-header" id="site-header">
    <div class="fresh-container fresh-container--wide">

        <!-- Logo -->
        <a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="site-logo" aria-label="<?php bloginfo( 'name' ); ?>">
            <?php if ( has_custom_logo() ) : ?>
                <?php
                $logo_id  = get_theme_mod( 'custom_logo' );
                $logo_url = wp_get_attachment_image_url( $logo_id, 'full' );
                ?>
                <img src="<?php echo esc_url( $logo_url ); ?>" alt="<?php bloginfo( 'name' ); ?>" width="120" height="36">
            <?php else : ?>
                <img src="<?php echo esc_url( FRESH_URI . '/assets/images/fresh-logo.png' ); ?>"
                     alt="FRESH" width="120" height="36">
            <?php endif; ?>
        </a>

        <!-- Navigation -->
        <nav class="main-nav" id="main-nav" aria-label="<?php esc_attr_e( 'ניווט ראשי', 'fresh-theme' ); ?>">
            <?php
            if ( has_nav_menu( 'primary' ) ) {
                wp_nav_menu( [
                    'theme_location' => 'primary',
                    'container'      => false,
                    'menu_class'     => 'main-nav__list',
                    'walker'         => new Fresh_Nav_Walker(),
                    'depth'          => 1,
                ]);
            } else {
                ?>
                <ul class="main-nav__list">
                    <li><a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="main-nav__link is-active">דף הבית</a></li>
                    <li><a href="#services" class="main-nav__link">שירותים</a></li>
                    <li><a href="#cases" class="main-nav__link">קייס סטאדי</a></li>
                    <li><a href="#about" class="main-nav__link">אודות</a></li>
                    <li><a href="#contact" class="main-nav__link">צור קשר</a></li>
                </ul>
                <?php
            }
            ?>
            <a href="#contact" class="fresh-btn fresh-btn--primary">בואו נדבר</a>
        </nav>

        <!-- Mobile Toggle -->
        <button class="mobile-toggle" id="mobile-toggle" aria-label="<?php esc_attr_e( 'תפריט', 'fresh-theme' ); ?>" aria-expanded="false">
            <span></span>
            <span></span>
            <span></span>
        </button>

    </div>
</header>

<main id="main-content" class="site-main">
