<?php get_header(); ?>

<article class="fresh-section" style="padding-top: calc(var(--space-3xl) + 80px);">
    <?php while ( have_posts() ) : the_post();
        $metric_num   = get_post_meta( get_the_ID(), '_fresh_metric_number', true );
        $metric_label = get_post_meta( get_the_ID(), '_fresh_metric_label', true );
        $terms        = get_the_terms( get_the_ID(), 'case_category' );
    ?>
        <div class="fresh-container fresh-container--narrow">
            <?php if ( $terms ) : ?>
                <span class="fresh-overline"><?php echo esc_html( $terms[0]->name ); ?></span>
            <?php endif; ?>

            <h1 style="margin-bottom: var(--space-lg);"><?php the_title(); ?></h1>

            <?php if ( $metric_num ) : ?>
                <div style="display: flex; align-items: baseline; gap: var(--space-md); margin-bottom: var(--space-xl); padding: var(--space-lg); background: var(--fresh-charcoal); clip-path: polygon(0 0, calc(100% - 16px) 0, 100% 16px, 100% 100%, 16px 100%, 0 calc(100% - 16px));">
                    <span style="font-family: var(--font-display); font-size: var(--text-3xl); color: var(--fresh-accent);"><?php echo esc_html( $metric_num ); ?></span>
                    <span style="color: var(--fresh-slate);"><?php echo esc_html( $metric_label ); ?></span>
                </div>
            <?php endif; ?>
        </div>

        <?php if ( has_post_thumbnail() ) : ?>
            <div class="fresh-container fresh-container--wide" style="margin-bottom: var(--space-xl);">
                <div class="knife-mask">
                    <img src="<?php echo esc_url( get_the_post_thumbnail_url( get_the_ID(), 'fresh-hero' ) ); ?>"
                         alt="<?php the_title_attribute(); ?>" style="max-height: 500px; width: 100%; object-fit: cover;">
                </div>
            </div>
        <?php endif; ?>

        <div class="fresh-container fresh-container--narrow">
            <div class="entry-content">
                <?php the_content(); ?>
            </div>

            <div style="margin-top: var(--space-2xl); text-align: center; padding-top: var(--space-xl); border-top: 1px solid rgba(255,255,255,0.06);">
                <p style="margin-bottom: var(--space-md);">רוצים תוצאות דומות?</p>
                <a href="<?php echo esc_url( home_url( '/#contact' ) ); ?>" class="fresh-btn fresh-btn--primary fresh-btn--large">
                    דברו איתנו →
                </a>
            </div>
        </div>

    <?php endwhile; ?>
</article>

<?php get_footer(); ?>
