<?php get_header(); ?>

<article class="fresh-section" style="padding-top: calc(var(--space-3xl) + 80px);">
    <div class="fresh-container fresh-container--narrow">
        <?php while ( have_posts() ) : the_post(); ?>

            <span class="fresh-overline"><?php echo get_the_date(); ?> · <?php the_category( ', ' ); ?></span>
            <h1 style="margin-bottom: var(--space-lg);"><?php the_title(); ?></h1>

            <?php if ( has_post_thumbnail() ) : ?>
                <div class="knife-mask" style="margin-bottom: var(--space-xl);">
                    <img src="<?php echo esc_url( get_the_post_thumbnail_url( get_the_ID(), 'large' ) ); ?>"
                         alt="<?php the_title_attribute(); ?>">
                </div>
            <?php endif; ?>

            <div class="entry-content">
                <?php the_content(); ?>
            </div>

            <?php the_tags( '<p style="color: var(--fresh-slate); margin-top: var(--space-xl); font-size: var(--text-sm);">תגיות: ', ', ', '</p>' ); ?>

            <nav style="display: flex; justify-content: space-between; margin-top: var(--space-xl); padding-top: var(--space-lg); border-top: 1px solid rgba(255,255,255,0.06);">
                <div><?php previous_post_link( '%link', '← %title' ); ?></div>
                <div><?php next_post_link( '%link', '%title →' ); ?></div>
            </nav>

        <?php endwhile; ?>
    </div>
</article>

<?php get_footer(); ?>
