<?php
require __DIR__ . '/wp-load.php';

$h = get_option('freshm_homepage', []);

echo "Hero subtitle:\n" . $h['freshm_hero_subtitle'] . "\n\n";
echo "Services subtitle:\n" . $h['freshm_services_subtitle'] . "\n\n";

echo "Why FRESH values:\n";
foreach ($h['freshm_why_values'] as $i => $v) {
    echo ($i+1) . ". {$v['icon']} {$v['title']} - " . mb_substr($v['desc'], 0, 40) . "...\n";
}

echo "\nServices backslash check:\n";
$s = get_option('freshm_services_data', []);
foreach ($s as $svc) {
    $slug = $svc['slug'] ?? 'unknown';
    $json = json_encode($svc, JSON_UNESCAPED_UNICODE);
    if (strpos($json, '\\\\') !== false) {
        echo "BACKSLASH: $slug\n";
    } else {
        echo "CLEAN: $slug\n";
    }
}

echo "\npaid-campaigns benefits:\n";
foreach ($s as $svc) {
    if (($svc['slug'] ?? '') === 'paid-campaigns') {
        foreach ($svc['benefits'] as $i => $b) {
            echo "  $i. {$b['title']}: {$b['desc']}\n";
        }
    }
}

echo "\nmenu-design check tick:\n";
foreach ($s as $svc) {
    if (($svc['slug'] ?? '') === 'menu-design') {
        echo "  metrics[0]: " . ($svc['metrics'][0]['desc'] ?? 'N/A') . "\n";
        echo "  content contains צ'ק: " . (strpos($svc['content'], "צ'ק") !== false ? 'YES' : 'NO') . "\n";
    }
}

echo "\nseo content snippet:\n";
foreach ($s as $svc) {
    if (($svc['slug'] ?? '') === 'seo') {
        echo mb_substr($svc['content'], 0, 200) . "\n";
    }
}

echo "\ninfluencer excerpt:\n";
foreach ($s as $svc) {
    if (($svc['slug'] ?? '') === 'influencer-marketing') {
        echo $svc['excerpt'] . "\n";
    }
}
