<?php
defined( 'ABSPATH' ) || exit;

/**
 * Return all 14 category slugs.
 *
 * @return array
 */
function freshm_get_category_slugs() {
    return array(
        'strategy', 'paid-ads', 'social-media', 'google-business',
        'content-creation', 'delivery-platforms', 'reservation-platforms',
        'loyalty-club', 'influencer-collabs', 'reviews', 'branding',
        'websites', 'analytics', 'digital-menus',
    );
}

/**
 * Get saved category-page data for a single slug.
 * Falls back to built-in defaults when the option is empty.
 *
 * @param  string $slug
 * @return array
 */
function freshm_get_category_page_data( $slug ) {
    $data = get_option( 'freshm_category_page_' . $slug, array() );
    if ( empty( $data ) ) {
        $defaults = freshm_get_default_category_data();
        $data = $defaults[ $slug ] ?? array();
    }
    return wp_unslash( $data );
}

/**
 * Default content for all 14 category pages.
 *
 * @return array  slug => data
 */
function freshm_get_default_category_data() {
    return array(

        /* ───────────────────────────────────────────────
         * 1. strategy
         * ─────────────────────────────────────────────── */
        'strategy' => array(
            'name'           => 'אסטרטגיה',
            'hero_icon'      => '🧭',
            'hero_title'     => 'אסטרטגיה שיווקית למסעדות',
            'hero_subtitle'  => 'התוכנית ההוליסטית שמחברת את כל הנקודות — ומביאה תוצאות',
            'hero_bg_image'  => '',
            'problem_title'  => 'הבעיה שאנחנו פותרים',
            'problem_content'=> 'הרבה מסעדות מנהלות שיווק בגישה של "קצת מהכל" — פוסט פה, קמפיין שם, צילום פעם ברבעון. בלי תוכנית אחודה, כל פעולה עובדת לבד ומאבדת את האפקט. התוצאה: תקציבים שמתפזרים, מסרים לא אחידים, ותחושה שהשיווק לא באמת מזיז את המחט. מסעדה שרוצה לצמוח צריכה קודם כל תוכנית ברורה — ורק אחר כך לרוץ.',
            'process'        => array(
                array(
                    'title'       => 'אפיון מעמיק',
                    'description' => 'הבנת המודל העסקי, קהלי היעד, המתחרים, והיתרונות הייחודיים של המסעדה',
                ),
                array(
                    'title'       => 'ניתוח מצב קיים',
                    'description' => 'אודיט מלא של כל ערוצי השיווק, הנתונים, ונקודות המגע עם הלקוח',
                ),
                array(
                    'title'       => 'בניית אסטרטגיה',
                    'description' => 'תוכנית שנתית/רבעונית שמחברת קמפיינים, תוכן, פלטפורמות ו-CRM לתוכנית אחת',
                ),
                array(
                    'title'       => 'תוכנית פעולה',
                    'description' => 'לוח זמנים מפורט עם אבני דרך, תקציבים, ויעדים מדידים לכל ערוץ',
                ),
                array(
                    'title'       => 'ליווי ואופטימיזציה',
                    'description' => 'מעקב חודשי, דוחות ביצועים, והתאמת האסטרטגיה בהתאם לנתונים',
                ),
            ),
            'stats'          => array(
                array(
                    'number' => '64%',
                    'label'  => 'מההזמנות למסעדות בישראל מבוצעות באופן מקוון',
                    'source' => 'Ontopo, 2025',
                ),
                array(
                    'number' => '31%',
                    'label'  => 'בלבד מהמסעדנים בישראל מגדירים את העסק שלהם כיציב',
                    'source' => 'סקר Ontopo, 2025',
                ),
                array(
                    'number' => '5-10%',
                    'label'  => 'שולי הרווח הממוצעים של מסעדה — כל שקל שיווק חייב לעבוד חכם',
                    'source' => 'Israel Restaurant Association / Haaretz',
                ),
                array(
                    'number' => '57',
                    'label'  => 'מסעדות שנסגרו בישראל בין אוקטובר 2024 למאי 2025',
                    'source' => 'Ontopo / Calcalist',
                ),
            ),
            'faq'            => array(
                array(
                    'question' => 'מה ההבדל בין אסטרטגיה לניהול שיווק שוטף?',
                    'answer'   => 'אסטרטגיה היא התוכנית — היא מגדירה את המטרות, קהלי היעד, ערוצי השיווק, ואיך הכל מתחבר. ניהול שוטף הוא הביצוע היום-יומי. בלי אסטרטגיה, הניהול השוטף הוא ניחושים. אנחנו מציעים את שניהם.',
                ),
                array(
                    'question' => 'כמה זמן לוקח לבנות אסטרטגיה?',
                    'answer'   => 'בדרך כלל 2-4 שבועות, תלוי במורכבות העסק. זה כולל פגישות אפיון, מחקר שוק, וניתוח מתחרים. בסוף התהליך מתקבל מסמך אסטרטגי מפורט עם תוכנית פעולה.',
                ),
                array(
                    'question' => 'האם האסטרטגיה כוללת גם תקציב?',
                    'answer'   => 'כן. אנחנו מגדירים מסגרת תקציב מומלצת לכל ערוץ, עם תחזית ROI צפוי. אבל האסטרטגיה מותאמת לתקציב הקיים — לא להפך.',
                ),
                array(
                    'question' => 'מה קורה אחרי שהאסטרטגיה מוכנה?',
                    'answer'   => 'אנחנו יכולים לבצע את התוכנית בעצמנו, או ללוות צוות פנימי שמבצע. רוב הלקוחות בוחרים שאנחנו ננהל את הביצוע כי ככה האסטרטגיה מיושמת כמו שצריך.',
                ),
                array(
                    'question' => 'האם אסטרטגיה רלוונטית גם למסעדה קטנה?',
                    'answer'   => 'דווקא. מסעדה קטנה לא יכולה להרשות לעצמה לבזבז תקציב. אסטרטגיה ממוקדת מאפשרת להשקיע בדיוק במה שעובד ולוותר על מה שלא.',
                ),
            ),
            'cta_title'       => 'מוכנים לתוכנית שמחברת הכל?',
            'cta_subtitle'    => 'שיחת אפיון ראשונה ללא עלות — נבין את העסק ונבנה תוכנית מותאמת.',
            'cta_btn_text'    => 'קבעו שיחה ←',
            'cta_btn_url'     => '#',
            'cta_show_whatsapp' => '1',
        ),

        /* ───────────────────────────────────────────────
         * 2. paid-ads
         * ─────────────────────────────────────────────── */
        'paid-ads' => array(
            'name'           => 'קידום ממומן',
            'hero_icon'      => '🎯',
            'hero_title'     => 'קידום ממומן למסעדות',
            'hero_subtitle'  => 'להביא את הלקוחות הנכונים, בזמן הנכון, בתקציב שעובד',
            'hero_bg_image'  => '',
            'problem_title'  => 'הבעיה שאנחנו פותרים',
            'problem_content'=> 'בעלי מסעדות משקיעים אלפי שקלים בפרסום — וברוב המקרים לא יודעים מה עובד ומה לא. קמפיינים רצים בלי אופטימיזציה, תקציבים נשרפים על קהלים לא רלוונטיים, ובסוף החודש קשה להצביע על כמה לקוחות חדשים באמת הגיעו. בלי מיקוד גיאוגרפי מדויק, בלי מעקב המרות, ובלי מי שמבין מסעדנות — התקציב מתפזר.',
            'process'        => array(
                array(
                    'title'       => 'מחקר ואפיון',
                    'description' => 'מיפוי קהלי יעד, ניתוח מתחרים באזור, והגדרת יעדים מדידים',
                ),
                array(
                    'title'       => 'בניית קמפיינים',
                    'description' => 'הקמה ב-Meta, Google ו/או TikTok עם קריאייטיב מקצועי ומיקוד גיאוגרפי',
                ),
                array(
                    'title'       => 'אופטימיזציה שוטפת',
                    'description' => 'מעקב יומי, בדיקות A/B, והתאמות בזמן אמת',
                ),
                array(
                    'title'       => 'דיווח ותובנות',
                    'description' => 'דוח חודשי מפורט עם המלצות לשיפור',
                ),
            ),
            'stats'          => array(
                array(
                    'number' => '72%',
                    'label'  => 'מהצרכנים משתמשים ברשתות חברתיות כדי לחקור מסעדות לפני ביקור',
                    'source' => 'Restaurant Social Media Statistics, 2025',
                ),
                array(
                    'number' => '8.6 מיליון',
                    'label'  => 'ישראלים הזמינו מקום במסעדה ב-2025 דרך פלטפורמות דיגיטליות',
                    'source' => 'Ontopo, 2025',
                ),
                array(
                    'number' => '40%',
                    'label'  => 'מהצרכנים מגלים מסעדות חדשות דרך חיפוש בגוגל',
                    'source' => 'Toast Restaurant Survey, 2024',
                ),
                array(
                    'number' => '75%',
                    'label'  => 'מהחיפושים המקומיים בגוגל מובילים לפעולה (שיחה, ביקור, הזמנה)',
                    'source' => 'Google Restaurant Search Statistics, 2025',
                ),
            ),
            'faq'            => array(
                array(
                    'question' => 'כמה עולה קמפיין ממומן למסעדה?',
                    'answer'   => 'תקציב פרסום של 2,000-5,000 ₪ לחודש הוא נקודת התחלה טובה למסעדה מקומית. לתקציב הזה מתווספת עלות ניהול. הסכום המדויק תלוי באזור, בתחרות ובמטרות.',
                ),
                array(
                    'question' => 'כמה זמן לוקח לראות תוצאות?',
                    'answer'   => 'בקמפיינים ממומנים התוצאות מגיעות תוך ימים. אופטימיזציה משמעותית קורית אחרי 2-4 שבועות של נתונים.',
                ),
                array(
                    'question' => 'מה ההבדל בין גוגל לפייסבוק?',
                    'answer'   => 'גוגל תופס אנשים שכבר מחפשים מסעדה — כוונה גבוהה. Meta (פייסבוק/אינסטגרם) מצוין ליצירת ביקוש — להראות את המנות לאנשים שעוד לא חיפשו. אסטרטגיה מנצחת משלבת את שניהם.',
                ),
                array(
                    'question' => 'איך מודדים הצלחה?',
                    'answer'   => 'לפי מדדים עסקיים: הזמנות, שיחות, הגעות, עלות לליד, ו-ROAS. לא רק לייקים וחשיפות.',
                ),
                array(
                    'question' => 'האם אתם עובדים גם עם TikTok?',
                    'answer'   => 'כן. TikTok הפכה לפלטפורמה מרכזית בקטגוריית האוכל עם חשיפה אורגנית גבוהה, במיוחד בקרב קהל צעיר.',
                ),
            ),
            'cta_title'       => 'מוכנים להביא יותר לקוחות?',
            'cta_subtitle'    => 'שיחת אפיון ראשונה ללא עלות.',
            'cta_btn_text'    => 'קבעו שיחה ←',
            'cta_btn_url'     => '#',
            'cta_show_whatsapp' => '1',
        ),

        /* ───────────────────────────────────────────────
         * 3. social-media
         * ─────────────────────────────────────────────── */
        'social-media' => array(
            'name'           => 'ניהול רשתות חברתיות',
            'hero_icon'      => '📱',
            'hero_title'     => 'ניהול רשתות חברתיות למסעדות',
            'hero_subtitle'  => 'נוכחות שגורמת לאנשים לרעוב — ולהגיע',
            'hero_bg_image'  => '',
            'problem_title'  => 'הבעיה שאנחנו פותרים',
            'problem_content'=> 'מסעדה יכולה להגיש את האוכל הכי טוב בעיר, אבל אם הנוכחות שלה ברשתות חלשה — אנשים לא יודעים שהיא קיימת. ניהול "בין לבין", תמונות בתאורה גרועה, ופוסטים פעם בשבועיים לא מזיזים את המחט. ניהול מקצועי דורש זמן, ידע ועקביות — בדיוק מה שלבעל מסעדה עמוס אין.',
            'process'        => array(
                array(
                    'title'       => 'אפיון זהות דיגיטלית',
                    'description' => 'טון, שפה ויזואלית, ופרסונה שמתאימה למסעדה',
                ),
                array(
                    'title'       => 'לוח תוכן חודשי',
                    'description' => 'תכנון 12-20 פוסטים כולל סטוריז וריילס',
                ),
                array(
                    'title'       => 'פרסום וניהול',
                    'description' => 'העלאה, תזמון, ומעקב אחר ביצועים',
                ),
                array(
                    'title'       => 'ניהול קהילה',
                    'description' => 'מענה לתגובות, הודעות, וביקורות',
                ),
            ),
            'stats'          => array(
                array(
                    'number' => '90%',
                    'label'  => 'מהצרכנים בודקים רשתות חברתיות של מסעדה לפני ביקור',
                    'source' => 'Restaurant Social Media Statistics, 2025',
                ),
                array(
                    'number' => '73%',
                    'label'  => 'מהצרכנים יבחרו מתחרה אם מסעדה לא מגיבה להודעות',
                    'source' => 'Cropink Restaurant Statistics, 2025',
                ),
                array(
                    'number' => '57%',
                    'label'  => 'מהאנשים מושפעים מתמונות אוכל ברשתות',
                    'source' => 'Restaurant Social Media Statistics, 2025',
                ),
                array(
                    'number' => '30%',
                    'label'  => 'מהאנשים נמנעים ממסעדה שהפרופיל החברתי שלה נראה מוזנח',
                    'source' => 'Cropink, 2025',
                ),
            ),
            'faq'            => array(
                array(
                    'question' => 'כמה פוסטים בחודש זה מספיק?',
                    'answer'   => '12-20 פוסטים בחודש (3-5 בשבוע) עם סטוריז יומיים. עקביות חשובה יותר מכמות.',
                ),
                array(
                    'question' => 'מי כותב את הטקסטים?',
                    'answer'   => 'קופירייטרים שמתמחים בתחום המזון ומכירים קהל ישראלי. הטקסטים מותאמים לכל פלטפורמה.',
                ),
                array(
                    'question' => 'האם אתם מנהלים גם תגובות?',
                    'answer'   => 'כן. ניהול קהילה הוא חלק מרכזי — תגובות, הודעות פרטיות, וביקורות.',
                ),
                array(
                    'question' => 'מה ההבדל בין ניהול סושיאל לקמפיינים?',
                    'answer'   => 'סושיאל = תוכן אורגני. קמפיינים = פרסום בתשלום שמקדם תוכן לקהלים חדשים. הם משלימים.',
                ),
                array(
                    'question' => 'באילו פלטפורמות אתם עובדים?',
                    'answer'   => 'Instagram, Facebook, TikTok — וכל פלטפורמה רלוונטית. הבחירה נגזרת מקהל היעד של המסעדה.',
                ),
            ),
            'cta_title'       => 'רוצים נוכחות שמדברת בשבילכם?',
            'cta_subtitle'    => 'נבנה נוכחות שמביאה לקוחות — לא רק לייקים.',
            'cta_btn_text'    => 'דברו איתנו ←',
            'cta_btn_url'     => '#',
            'cta_show_whatsapp' => '1',
        ),

        /* ───────────────────────────────────────────────
         * 4. google-business
         * ─────────────────────────────────────────────── */
        'google-business' => array(
            'name'           => 'ניהול פרופיל עסקי בגוגל',
            'hero_icon'      => '📍',
            'hero_title'     => 'ניהול פרופיל עסקי בגוגל למסעדות',
            'hero_subtitle'  => 'כשמחפשים מסעדה באזור — אתם מופיעים ראשונים',
            'hero_bg_image'  => '',
            'problem_title'  => 'הבעיה שאנחנו פותרים',
            'problem_content'=> 'כשלקוח פוטנציאלי מחפש "מסעדה + [אזור]" בגוגל, הפרופיל העסקי הוא הדבר הראשון שהוא רואה — לפני האתר, לפני הרשתות, לפני הכל. פרופיל לא מעודכן עם תמונות ישנות, שעות לא נכונות, וביקורות ללא מענה — מרחיק לקוחות עוד לפני שהם הספיקו לטעום. רוב המסעדות לא יודעות כמה תנועה (ופוטנציאל) הן מאבדות פשוט כי הפרופיל לא מטופל.',
            'process'        => array(
                array(
                    'title'       => 'אודיט פרופיל',
                    'description' => 'בדיקת מצב קיים: שלמות הפרופיל, תמונות, קטגוריות, ביקורות, ודירוג',
                ),
                array(
                    'title'       => 'אופטימיזציה מלאה',
                    'description' => 'עדכון כל השדות, העלאת תמונות מקצועיות, הגדרת שעות, תפריט ומאפיינים',
                ),
                array(
                    'title'       => 'ניהול ביקורות',
                    'description' => 'מענה מקצועי לכל ביקורת (חיובית ושלילית), אסטרטגיית עידוד ביקורות',
                ),
                array(
                    'title'       => 'תוכן שוטף',
                    'description' => 'פרסום פוסטים שבועיים, עדכון מבצעים, ותמונות חדשות',
                ),
            ),
            'stats'          => array(
                array(
                    'number' => '46%',
                    'label'  => 'מהצרכנים בודקים ביקורות גוגל קודם כל כשהם מחפשים מסעדה',
                    'source' => 'Toast Restaurant Survey, 2024',
                ),
                array(
                    'number' => '88%',
                    'label'  => 'מהסועדים מתייחסים לביקורות גוגל כגורם מרכזי בבחירת מסעדה',
                    'source' => 'Google Review Statistics for Hospitality, 2025',
                ),
                array(
                    'number' => '91%',
                    'label'  => 'מהצרכנים יימנעו ממסעדה עם דירוג מתחת ל-4 כוכבים',
                    'source' => 'Google Review Statistics for Hospitality, 2025',
                ),
                array(
                    'number' => '75%',
                    'label'  => 'מהחיפושים המקומיים בגוגל מובילים לפעולה תוך 24 שעות',
                    'source' => 'Google Restaurant Search Statistics, 2025',
                ),
            ),
            'faq'            => array(
                array(
                    'question' => 'מה זה בדיוק "פרופיל עסקי בגוגל"?',
                    'answer'   => 'זה הכרטיס שמופיע כשמחפשים את המסעדה בגוגל או בגוגל מפות. הוא כולל שם, כתובת, שעות, טלפון, תמונות, ביקורות ותפריט. זה בעצם "הדף הראשי" שלכם עבור רוב הלקוחות.',
                ),
                array(
                    'question' => 'כמה זמן לוקח לראות שיפור?',
                    'answer'   => 'שיפורים בדירוג ובנראות בגוגל מפות מתחילים להיראות תוך 2-4 שבועות מאופטימיזציה מלאה. תוצאות משמעותיות — 2-3 חודשים.',
                ),
                array(
                    'question' => 'האם זה רלוונטי גם אם יש לנו אתר?',
                    'answer'   => 'בהחלט. רוב האנשים לא מגיעים לאתר — הם רואים את הפרופיל בגוגל ומחליטים שם. הפרופיל העסקי חשוב לפחות כמו האתר, ובמקרים רבים יותר.',
                ),
                array(
                    'question' => 'איך מגדילים כמות ביקורות?',
                    'answer'   => 'בעיקר דרך עידוד אקטיבי — QR קודים על השולחנות, בקשה מנומסת בסוף הארוחה, ותהליך שמקל על הלקוח לכתוב ביקורת. אנחנו בונים את התהליך הזה.',
                ),
                array(
                    'question' => 'האם אתם עונים לביקורות שליליות?',
                    'answer'   => 'כן — וזה קריטי. 97% מהקוראים קוראים גם את התגובות של העסק. תגובה מקצועית לביקורת שלילית יכולה להפוך את המצב. אנחנו מנסחים תגובות שמשדרות מקצועיות ואכפתיות.',
                ),
            ),
            'cta_title'       => 'מוכנים להופיע ראשונים?',
            'cta_subtitle'    => 'אופטימיזציה מלאה לפרופיל העסקי שלכם — מחר כבר נראה שינוי.',
            'cta_btn_text'    => 'בואו נתחיל ←',
            'cta_btn_url'     => '#',
            'cta_show_whatsapp' => '1',
        ),

        /* ───────────────────────────────────────────────
         * 5. content-creation
         * ─────────────────────────────────────────────── */
        'content-creation' => array(
            'name'           => 'יצירת תוכן',
            'hero_icon'      => '🎬',
            'hero_title'     => 'יצירת תוכן למסעדות',
            'hero_subtitle'  => 'צילום, וידאו ועיצוב שגורמים לאנשים לרעוב',
            'hero_bg_image'  => '',
            'problem_title'  => 'הבעיה שאנחנו פותרים',
            'problem_content'=> 'תוכן הוא הדלק של כל השיווק — בלי תמונות מנות מקצועיות, בלי וידאו שתופס עין, ובלי עיצוב מותאם — כל הקמפיינים וכל הרשתות החברתיות לא באמת עובדים. הרבה מסעדות מסתפקות בתמונות טלפון ועיצוב ב-Canva, ואז תמהות למה התוכן לא מביא תוצאות. תוכן מקצועי לא עולה הרבה יותר, אבל התוצאות שונות לחלוטין.',
            'process'        => array(
                array(
                    'title'       => 'תכנון הפקה',
                    'description' => 'הגדרת סגנון, בחירת מנות לצילום, תיאום לוח זמנים עם המסעדה',
                ),
                array(
                    'title'       => 'צילום סטילס',
                    'description' => 'צילום מנות מקצועי עם סטיילינג מזון ותאורה מבוקרת',
                ),
                array(
                    'title'       => 'צילום וידאו',
                    'description' => 'סרטונים קצרים לריילס/טיקטוק, סרטוני תדמית, ותוכן "מאחורי הקלעים"',
                ),
                array(
                    'title'       => 'עריכה ועיצוב',
                    'description' => 'עריכת תמונות, מונטאז\' וידאו, ועיצוב גרפי מותאם לכל פלטפורמה',
                ),
                array(
                    'title'       => 'ספריית תוכן',
                    'description' => 'ארגון כל התוכן בספרייה מסודרת שהמסעדה והצוות יכולים להשתמש בה',
                ),
            ),
            'stats'          => array(
                array(
                    'number' => '57%',
                    'label'  => 'מהאנשים מושפעים מתמונות אוכל ברשתות — תמונה טובה שווה אלף הזמנות',
                    'source' => 'Restaurant Social Media Statistics, 2025',
                ),
                array(
                    'number' => '65%',
                    'label'  => 'מהלקוחות אומרים שתמונות מנות משפיעות מאוד על ההחלטה היכן לאכול',
                    'source' => 'Restroworks, 2025',
                ),
                array(
                    'number' => '86%',
                    'label'  => 'מהסועדים מפרסמים על הארוחה שלהם אם המנה נראית טוב',
                    'source' => 'Cropink Restaurant Social Media, 2025',
                ),
                array(
                    'number' => '48%',
                    'label'  => 'מהמסעדות אימצו שיווק וידאו קצר (TikTok/Reels) ב-2024',
                    'source' => 'Restroworks, 2025',
                ),
            ),
            'faq'            => array(
                array(
                    'question' => 'כמה עולה יום צילום?',
                    'answer'   => 'יום צילום מנות מלא (15-25 מנות) נע בין 3,000-8,000 ₪ תלוי בהיקף. זה כולל צלם, סטייליסט, תאורה, עריכה ורטוש. התמונות משמשות לחודשים.',
                ),
                array(
                    'question' => 'האם אתם מצלמים גם וידאו?',
                    'answer'   => 'כן — סרטוני TikTok/Reels קצרים, סרטוני תדמית, וצילום "מאחורי הקלעים" במטבח. הפקה מלאה.',
                ),
                array(
                    'question' => 'כמה פעמים צריך לצלם?',
                    'answer'   => 'תלוי בכמות התוכן הנדרשת. ברוב המקרים, צילום אחד ל-2-3 חודשים מספיק. מסעדות שמעדכנות תפריט לעתים קרובות — צילום חודשי.',
                ),
                array(
                    'question' => 'האם אפשר לקבל גם תמונות וגם וידאו באותו יום?',
                    'answer'   => 'כן, וזה אפילו מומלץ. אנחנו מתכננים ימי הפקה שמייצרים גם סטילס וגם וידאו, מה שחוסך זמן ועלויות.',
                ),
                array(
                    'question' => 'מה ההבדל בין תוכן שלכם לתמונת טלפון?',
                    'answer'   => 'תאורה מקצועית, סטיילינג מזון, זוויות מחושבות, ועריכה שמותאמת לפלטפורמה. תמונה מקצועית מגדילה engagement ב-2-3x בהשוואה לתמונת טלפון.',
                ),
            ),
            'cta_title'       => 'מוכנים לתוכן שמוכר?',
            'cta_subtitle'    => 'צילום מקצועי שהופך עוקבים ללקוחות.',
            'cta_btn_text'    => 'תאמו צילום ←',
            'cta_btn_url'     => '#',
            'cta_show_whatsapp' => '1',
        ),

        /* ───────────────────────────────────────────────
         * 6. delivery-platforms
         * ─────────────────────────────────────────────── */
        'delivery-platforms' => array(
            'name'           => 'ניהול פלטפורמות משלוחים',
            'hero_icon'      => '🛵',
            'hero_title'     => 'ניהול פלטפורמות משלוחים למסעדות',
            'hero_subtitle'  => 'למקסם הכנסות ולהקטין עמלות — בכל הזמנה',
            'hero_bg_image'  => '',
            'problem_title'  => 'הבעיה שאנחנו פותרים',
            'problem_content'=> 'פלטפורמות המשלוחים הפכו להכרחיות, אבל העמלות של 20-30% על כל הזמנה אוכלות את הרווח. מסעדות רבות נמצאות ב-Wolt וב-10bis אבל לא ממקסמות: תמונות ישנות, תפריט לא מותאם, דירוג נמוך. בלי אופטימיזציה — משלמים עמלות גבוהות ומקבלים פחות הזמנות ממה שאפשר.',
            'process'        => array(
                array(
                    'title'       => 'אודיט פלטפורמות',
                    'description' => 'ניתוח מצב ב-Wolt, 10bis, ופלטפורמות נוספות',
                ),
                array(
                    'title'       => 'אופטימיזציה מלאה',
                    'description' => 'תמונות מקצועיות, תיאורים שמוכרים, מבנה תפריט אופטימלי',
                ),
                array(
                    'title'       => 'אסטרטגיית תמחור',
                    'description' => 'מודל תמחור שונה לכל פלטפורמה שמפצה על עמלות',
                ),
                array(
                    'title'       => 'ניטור שוטף',
                    'description' => 'מעקב דירוגים, ביקורות, ונתוני ביצועים חודשיים',
                ),
            ),
            'stats'          => array(
                array(
                    'number' => '20-30%',
                    'label'  => 'העמלה שפלטפורמות המשלוחים גובות — עם שולי רווח של 5-10%, מחצית הרווח הולך לפלטפורמה',
                    'source' => 'Israel Restaurant Association / Haaretz',
                ),
                array(
                    'number' => '35%',
                    'label'  => 'מההזמנות ב-Wolt ישראל כבר לא קשורות למסעדות — הפלטפורמה הופכת ל"אפליקציית הכל"',
                    'source' => 'Wolt Israel VP, 2025',
                ),
                array(
                    'number' => '~2,000',
                    'label'  => 'מסעדות Full Service פעילות בישראל — התחרות בפלטפורמות אינטנסיבית',
                    'source' => 'Ontopo',
                ),
                array(
                    'number' => '12%',
                    'label'  => 'שיעור ביטולי ההזמנות שלא הודיעו מראש בישראל',
                    'source' => 'Ontopo',
                ),
            ),
            'faq'            => array(
                array(
                    'question' => 'כמה עמלה Wolt באמת לוקחת?',
                    'answer'   => 'העמלה הבסיסית נעה בין 20-30% מערך ההזמנה, בתוספת עמלת תפעול של כ-5%. המספר תלוי בהסכם, בנפח, ובבלעדיות. אנחנו עוזרים לנהל משא ומתן.',
                ),
                array(
                    'question' => 'איך משפרים דירוג?',
                    'answer'   => 'שילוב של תמונות מקצועיות, פרופיל מלא, מהירות הכנה, ודירוג לקוחות. שיפור מורגש לוקח 4-8 שבועות.',
                ),
                array(
                    'question' => 'האם כדאי להיות בכל הפלטפורמות?',
                    'answer'   => 'לא בהכרח. זה תלוי באזור ובקהל. אנחנו ממליצים על בסיס נתונים.',
                ),
                array(
                    'question' => 'האם אפשר להקטין תלות בפלטפורמות?',
                    'answer'   => 'כן, וזו בדיוק המטרה. אנחנו בונים במקביל ערוצי הזמנה ישירים (אתר, WhatsApp) כדי שחלק גדל יגיע בלי עמלות.',
                ),
            ),
            'cta_title'       => 'רוצים להרוויח יותר מכל הזמנה?',
            'cta_subtitle'    => 'אסטרטגיית משלוחים שמגדילה רווח ומקטינה תלות.',
            'cta_btn_text'    => 'בואו נדבר ←',
            'cta_btn_url'     => '#',
            'cta_show_whatsapp' => '1',
        ),

        /* ───────────────────────────────────────────────
         * 7. reservation-platforms
         * ─────────────────────────────────────────────── */
        'reservation-platforms' => array(
            'name'           => 'ניהול פלטפורמות להזמנת שולחן',
            'hero_icon'      => '🪑',
            'hero_title'     => 'ניהול פלטפורמות להזמנת שולחן',
            'hero_subtitle'  => 'שהשולחנות יהיו מלאים — כל ערב, כל סוף שבוע',
            'hero_bg_image'  => '',
            'problem_title'  => 'הבעיה שאנחנו פותרים',
            'problem_content'=> 'מסעדות שלא מנהלות נכון את מערכת ההזמנות מפסידות לקוחות כל יום. שולחנות ריקים בימים חלשים, No-shows שעולים כסף, ופרופיל ב-Ontopo או Google שלא ממקסם את הפוטנציאל. ניהול חכם של הזמנות — כולל Yield Management, ניהול רשימות המתנה, ואופטימיזציה של הפרופיל בפלטפורמות — יכול להגדיל תפוסה משמעותית.',
            'process'        => array(
                array(
                    'title'       => 'ניתוח תפוסות',
                    'description' => 'מיפוי ימים/שעות חזקים וחלשים, ניתוח דפוסי הזמנות',
                ),
                array(
                    'title'       => 'אופטימיזציה של פרופילים',
                    'description' => 'שיפור הנוכחות ב-Ontopo, Google, ופלטפורמות נוספות',
                ),
                array(
                    'title'       => 'אסטרטגיית תפוסה',
                    'description' => 'מבצעים ממוקדים לימים חלשים, ניהול No-shows, ו-Yield Management',
                ),
                array(
                    'title'       => 'ניטור וניתוח',
                    'description' => 'מעקב שוטף אחר שיעורי תפוסה, ביטולים, ודפוסי הזמנות',
                ),
            ),
            'stats'          => array(
                array(
                    'number' => '8.6 מיליון',
                    'label'  => 'ישראלים הזמינו מקום במסעדה ב-2025',
                    'source' => 'Ontopo, 2025',
                ),
                array(
                    'number' => '64%',
                    'label'  => 'מההזמנות למסעדות בישראל מבוצעות אונליין',
                    'source' => 'Ontopo, 2025',
                ),
                array(
                    'number' => '12%',
                    'label'  => 'שיעור ביטולים ללא הודעה מראש — כל No-show הוא שולחן ריק והפסד ישיר',
                    'source' => 'Ontopo',
                ),
                array(
                    'number' => '30%',
                    'label'  => 'הירידה הממוצעת בתפוסת מסעדות בישראל בתחילת 2025',
                    'source' => 'Ontopo / Calcalist, מאי 2025',
                ),
            ),
            'faq'            => array(
                array(
                    'question' => 'באיזו פלטפורמת הזמנות כדאי להשתמש?',
                    'answer'   => 'Ontopo היא המובילה בישראל עם מעל 8.6 מיליון הזמנות בשנה. בהתאם לסוג המסעדה, ייתכן שמתאימות גם פלטפורמות נוספות או פתרון הזמנות באתר עצמי.',
                ),
                array(
                    'question' => 'איך מתמודדים עם No-shows?',
                    'answer'   => 'שילוב של אישורי הזמנה אוטומטיים (SMS/WhatsApp), מדיניות ביטולים ברורה, ובמקרים מסוימים — ביטחון כרטיס אשראי. אנחנו בונים את המערכת.',
                ),
                array(
                    'question' => 'איך ממלאים ימים חלשים?',
                    'answer'   => 'מבצעים ממוקדים (Happy Hour, תפריט עסקי), קמפיינים דיגיטליים שמטרגטים ימים ספציפיים, ושיתופי פעולה. נתוני התפוסה מכוונים את האסטרטגיה.',
                ),
                array(
                    'question' => 'מה זה Yield Management למסעדות?',
                    'answer'   => 'זה ניהול דינמי של תפוסה — בדומה למלונות וטיסות. לדוגמה: הגבלת גודל שולחנות בשעות שיא, הצעות מיוחדות בשעות נמוכות, וניהול אורך ישיבה.',
                ),
            ),
            'cta_title'       => 'רוצים שולחנות מלאים כל ערב?',
            'cta_subtitle'    => 'ניהול חכם של הזמנות ותפוסה.',
            'cta_btn_text'    => 'דברו איתנו ←',
            'cta_btn_url'     => '#',
            'cta_show_whatsapp' => '1',
        ),

        /* ───────────────────────────────────────────────
         * 8. loyalty-club
         * ─────────────────────────────────────────────── */
        'loyalty-club' => array(
            'name'           => 'ניהול מערכות מועדון לקוחות',
            'hero_icon'      => '💳',
            'hero_title'     => 'מועדון לקוחות למסעדות',
            'hero_subtitle'  => 'להכיר את הלקוחות — ולגרום להם לחזור שוב ושוב',
            'hero_bg_image'  => '',
            'problem_title'  => 'הבעיה שאנחנו פותרים',
            'problem_content'=> 'רוב המסעדות לא יודעות מי הלקוחות שלהן. אין מאגר מידע, אין מעקב אחרי ביקורים חוזרים, ואין דרך לתקשר ישירות. לקוח שהגיע ונהנה — לא חוזר כי אין מי שיזכיר לו. בינתיים כל הנתונים יושבים אצל Wolt ולא אצל המסעדה.',
            'process'        => array(
                array(
                    'title'       => 'אפיון צרכים',
                    'description' => 'הבנת המודל, ערוצי התקשורת, ונפח הלקוחות',
                ),
                array(
                    'title'       => 'הקמת מועדון',
                    'description' => 'בחירת פלטפורמה, הגדרת מבנה ההטבות, ועיצוב חוויית ההצטרפות',
                ),
                array(
                    'title'       => 'בניית אוטומציות',
                    'description' => 'הודעת ברוכים הבאים, תזכורות, הצעות ליום הולדת, ומסעות לקוח',
                ),
                array(
                    'title'       => 'ניהול שוטף',
                    'description' => 'שליחת הודעות, ניתוח נתונים, והתאמת ההטבות לפי התנהגות',
                ),
            ),
            'stats'          => array(
                array(
                    'number' => '5x',
                    'label'  => 'עלות רכישת לקוח חדש גבוהה פי 5 משימור לקוח קיים',
                    'source' => 'Harvard Business Review',
                ),
                array(
                    'number' => '4,400%',
                    'label'  => 'ה-ROI הממוצע של אימייל מרקטינג — כל שקל שמושקע מחזיר 44 ₪',
                    'source' => '99Firms Email Marketing Report',
                ),
                array(
                    'number' => '49%',
                    'label'  => 'מהצרכנים מעדיפים לקבל מבצעים שבועיים במייל מעסקים שהם אוהבים',
                    'source' => 'Restaurant Marketing Statistics, 2025',
                ),
                array(
                    'number' => '74%',
                    'label'  => 'מהלקוחות שעוקבים ומגיבים למסעדה ברשתות נוטים יותר לבקר ולהזמין',
                    'source' => 'Restaurant Customer Statistics, 2025',
                ),
            ),
            'faq'            => array(
                array(
                    'question' => 'האם מסעדה קטנה באמת צריכה מועדון לקוחות?',
                    'answer'   => 'דווקא. כשבסיס הלקוחות קטן, כל לקוח חוזר שווה הרבה. מועדון פשוט יכול להגדיל תדירות ביקורים ב-20-30%.',
                ),
                array(
                    'question' => 'איזו מערכת אתם ממליצים?',
                    'answer'   => 'תלוי בגודל ובתקציב. יש פתרונות שמתחילים בחינם ועד מערכות מתקדמות. אנחנו מתאימים את הכלי למסעדה.',
                ),
                array(
                    'question' => 'SMS או WhatsApp?',
                    'answer'   => 'SMS — שיעורי פתיחה של 90%+, קצר ויקר יותר. WhatsApp — הודעות עשירות יותר בעלות נמוכה, אבל דורש הסכמה. אנחנו ממליצים שילוב.',
                ),
                array(
                    'question' => 'איך גורמים ללקוחות להצטרף?',
                    'answer'   => 'QR קוד על השולחן, הצעה אטרקטיבית להצטרפות (מנה/קינוח/הנחה), והכנת הצוות לתהליך. כשזה פשוט — אנשים מצטרפים.',
                ),
            ),
            'cta_title'       => 'מוכנים להכיר את הלקוחות שלכם?',
            'cta_subtitle'    => 'מועדון לקוחות שהופך ביקור חד-פעמי למערכת יחסים.',
            'cta_btn_text'    => 'בואו נתחיל ←',
            'cta_btn_url'     => '#',
            'cta_show_whatsapp' => '1',
        ),

        /* ───────────────────────────────────────────────
         * 9. influencer-collabs
         * ─────────────────────────────────────────────── */
        'influencer-collabs' => array(
            'name'           => 'שיתופי פעולה עם משפיענים',
            'hero_icon'      => '⭐',
            'hero_title'     => 'שיתופי פעולה עם משפיענים',
            'hero_subtitle'  => 'הפה-לאוזן של הדור הזה — עובד, כשעושים את זה נכון',
            'hero_bg_image'  => '',
            'problem_title'  => 'הבעיה שאנחנו פותרים',
            'problem_content'=> 'שיתופי פעולה עם בלוגרי אוכל ומשפיענים יכולים להביא מאות לקוחות חדשים — או להיות בזבוז כסף מוחלט. ההבדל הוא בבחירת המשפיען הנכון, בתיאום הנכון, ובמדידת תוצאות. מסעדות רבות מזמינות משפיענים על בסיס כמות עוקבים בלבד, בלי לבדוק אם הקהל רלוונטי ובלי למדוד אם זה הביא לקוחות אמיתיים.',
            'process'        => array(
                array(
                    'title'       => 'זיהוי ומיפוי',
                    'description' => 'איתור משפיעני אוכל רלוונטיים לפי אזור, קהל, ואנגייג\'מנט (לא רק עוקבים)',
                ),
                array(
                    'title'       => 'תיאום ומשא ומתן',
                    'description' => 'יצירת קשר, הגדרת תנאים, ובניית בריף ברור',
                ),
                array(
                    'title'       => 'ליווי ההפקה',
                    'description' => 'תיאום ביקור, הכנת המסעדה, וידוא שהתוכן עומד בציפיות',
                ),
                array(
                    'title'       => 'מדידת תוצאות',
                    'description' => 'מעקב אחר חשיפה, engagement, וביקורים בפועל',
                ),
            ),
            'stats'          => array(
                array(
                    'number' => '40%',
                    'label'  => 'מהסועדים מושפעים מביקורות משפיענים בהחלטה היכן לאכול',
                    'source' => 'Cropink Restaurant Social Media, 2025',
                ),
                array(
                    'number' => '$6.50',
                    'label'  => 'ההחזר הממוצע על כל דולר שמושקע בשיתוף פעולה עם משפיען מזון',
                    'source' => 'QSR Magazine, 2024',
                ),
                array(
                    'number' => '30%',
                    'label'  => 'עלייה בהזמנות בשבוע שאחרי פוסט של משפיען מזון מקומי',
                    'source' => 'Restaurant Trend Report, 2024-2025',
                ),
                array(
                    'number' => '49%',
                    'label'  => 'מקרב גילאי 25-34 מושפעים מיוצרי תוכן בתחום האוכל',
                    'source' => 'Cropink, 2025',
                ),
            ),
            'faq'            => array(
                array(
                    'question' => 'כמה עולה שיתוף פעולה עם משפיען?',
                    'answer'   => 'הטווח רחב: מיקרו-משפיענים (5K-50K עוקבים) — ארוחה בחינם עד 2,000 ₪. משפיענים בינוניים — 2,000-8,000 ₪. משפיענים גדולים — 8,000 ₪ ומעלה. לא תמיד הגדולים הם הטובים.',
                ),
                array(
                    'question' => 'איך בוחרים את המשפיען הנכון?',
                    'answer'   => 'שלושה דברים: קהל מקומי רלוונטי (לא עוקבים מחו"ל), אנגייג\'מנט אמיתי (לא בוטים), וסגנון שמתאים למסעדה. אנחנו מנתחים נתונים לפני כל שיתוף.',
                ),
                array(
                    'question' => 'מה אנחנו מקבלים בתמורה?',
                    'answer'   => 'בדרך כלל: פוסט ו/או ריל באינסטגרם/טיקטוק, סטוריז, ותוכן שאפשר לעשות בו שימוש חוזר בערוצים שלכם. הכל מוגדר מראש בבריף.',
                ),
                array(
                    'question' => 'איך מודדים אם זה עבד?',
                    'answer'   => 'חשיפות ואנגייג\'מנט על התוכן, עלייה בעוקבים, עלייה בהזמנות באותו שבוע, וקוד הנחה ייעודי (אם רלוונטי).',
                ),
            ),
            'cta_title'       => 'רוצים שידברו עליכם?',
            'cta_subtitle'    => 'נחבר אתכם עם המשפיענים הנכונים שמביאים לקוחות אמיתיים.',
            'cta_btn_text'    => 'דברו איתנו ←',
            'cta_btn_url'     => '#',
            'cta_show_whatsapp' => '1',
        ),

        /* ───────────────────────────────────────────────
         * 10. reviews
         * ─────────────────────────────────────────────── */
        'reviews' => array(
            'name'           => 'שיפור ביקורות',
            'hero_icon'      => '⭐',
            'hero_title'     => 'שיפור ביקורות למסעדות',
            'hero_subtitle'  => 'ביקורת טובה שווה יותר מכל פרסומת',
            'hero_bg_image'  => '',
            'problem_title'  => 'הבעיה שאנחנו פותרים',
            'problem_content'=> '94% מהצרכנים קוראים ביקורות לפני שבוחרים מסעדה — ומסעדה עם דירוג מתחת ל-4 כוכבים כמעט בלתי נראית. הבעיה: לקוחות מרוצים לא כותבים ביקורות מעצמם, ולקוחות מאוכזבים דווקא כן. התוצאה — דירוג שלא משקף את האיכות האמיתית, וביקורות שליליות שמרחיקות לקוחות חדשים.',
            'process'        => array(
                array(
                    'title'       => 'אודיט ביקורות',
                    'description' => 'ניתוח כל הביקורות בכל הפלטפורמות: גוגל, טריפאדוויזור, פייסבוק, Wolt',
                ),
                array(
                    'title'       => 'מענה מקצועי',
                    'description' => 'ניסוח תגובות לכל ביקורת — חיובית ושלילית — בטון שמשדר מקצועיות',
                ),
                array(
                    'title'       => 'אסטרטגיית עידוד',
                    'description' => 'בניית תהליך שמעודד לקוחות מרוצים להשאיר ביקורת',
                ),
                array(
                    'title'       => 'ניטור מתמשך',
                    'description' => 'מעקב יומי אחר ביקורות חדשות והתראות בזמן אמת',
                ),
            ),
            'stats'          => array(
                array(
                    'number' => '94%',
                    'label'  => 'מהצרכנים קוראים ביקורות אונליין לפני שמחליטים היכן לאכול',
                    'source' => 'Google Restaurant Search Statistics, 2025',
                ),
                array(
                    'number' => '91%',
                    'label'  => 'מהצרכנים יימנעו ממסעדה עם דירוג מתחת ל-4 כוכבים בגוגל',
                    'source' => 'Google Review Statistics for Hospitality, 2025',
                ),
                array(
                    'number' => '97%',
                    'label'  => 'מקוראי הביקורות קוראים גם את תגובות העסק',
                    'source' => 'LocaliQ / ReviewTrackers',
                ),
                array(
                    'number' => '10%',
                    'label'  => 'עלייה בהכנסות על כל כוכב שנוסף לדירוג הממוצע בגוגל',
                    'source' => 'Google Review Statistics for Hospitality, 2025',
                ),
            ),
            'faq'            => array(
                array(
                    'question' => 'איך גורמים ללקוחות לכתוב ביקורות?',
                    'answer'   => 'QR קודים על השולחנות, בקשה מנומסת מהמלצר בסוף ארוחה מוצלחת, ומערכת תזכורות אוטומטית. הכל חוקי ולפי מדיניות גוגל.',
                ),
                array(
                    'question' => 'מה עושים עם ביקורת שלילית?',
                    'answer'   => 'עונים מהר, בטון מקצועי ואכפתי. מזמינים את הלקוח לחזור. ביקורת שלילית עם תגובה טובה יכולה דווקא לחזק אמון.',
                ),
                array(
                    'question' => 'האם אפשר למחוק ביקורות שליליות?',
                    'answer'   => 'רק אם הן מפרות את המדיניות של גוגל (ספאם, תוכן פוגעני, ביקורת מזויפת). אנחנו יודעים לזהות ולדווח. ביקורת לגיטימית — לא ניתן למחוק, אבל ניתן להגיב עליה.',
                ),
                array(
                    'question' => 'כמה ביקורות צריך?',
                    'answer'   => 'מסעדות מובילות מחזיקות בדרך כלל 1,000+ ביקורות. היעד הוא לא רק כמות, אלא גם רעננות — 73% מהצרכנים קוראים רק ביקורות מהחודש האחרון.',
                ),
            ),
            'cta_title'       => 'מוכנים לדירוג שמשקף את האיכות?',
            'cta_subtitle'    => 'נבנה אסטרטגיית ביקורות שמגדילה דירוג ותנועה.',
            'cta_btn_text'    => 'בואו נתחיל ←',
            'cta_btn_url'     => '#',
            'cta_show_whatsapp' => '1',
        ),

        /* ───────────────────────────────────────────────
         * 11. branding
         * ─────────────────────────────────────────────── */
        'branding' => array(
            'name'           => 'מיתוג',
            'hero_icon'      => '💎',
            'hero_title'     => 'מיתוג למסעדות',
            'hero_subtitle'  => 'הזהות שגורמת לאנשים לזכור — ולחזור',
            'hero_bg_image'  => '',
            'problem_title'  => 'הבעיה שאנחנו פותרים',
            'problem_content'=> 'לוגו שנעשה בזול, תפריט גנרי, אריזות משלוחים לבנות. בשוק רווי של אלפי מסעדות, מה שמבדיל עסק מצליח הוא סיפור מותג חזק וחוויה ויזואלית עקבית. לקוחות מקבלים החלטות בשניות — ואם המסעדה לא נראית מקצועית ושונה, הם ימשיכו הלאה.',
            'process'        => array(
                array(
                    'title'       => 'מחקר ואפיון',
                    'description' => 'הבנת הקונספט, קהל היעד, והערכים. ניתוח מתחרים ופערים',
                ),
                array(
                    'title'       => 'פיתוח זהות',
                    'description' => 'לוגו, פלטת צבעים, טיפוגרפיה, ושפה עיצובית מלאה',
                ),
                array(
                    'title'       => 'יישום',
                    'description' => 'תפריטים, אריזות, כרטיסי ביקור, שילוט, וחומרי דפוס',
                ),
                array(
                    'title'       => 'הנחיות מותג',
                    'description' => 'מסמך שמבטיח עקביות ויזואלית בכל נקודת מגע',
                ),
            ),
            'stats'          => array(
                array(
                    'number' => '~2,000',
                    'label'  => 'מסעדות Full Service פעילות בישראל — התחרות על תשומת הלב אינטנסיבית',
                    'source' => 'Ontopo',
                ),
                array(
                    'number' => '15%',
                    'label'  => 'הגידול הממוצע בצ\'ק כשהתפריט מעוצב מקצועית עם אלמנטים שמכוונים בחירה',
                    'source' => 'Restaurant menu engineering benchmarks',
                ),
                array(
                    'number' => '62%',
                    'label'  => 'מהצרכנים בודקים רשתות חברתיות לפני שמחליטים — והעיצוב הוא הדבר הראשון שהם רואים',
                    'source' => 'Restaurant Social Media, 2025',
                ),
                array(
                    'number' => '3 שניות',
                    'label'  => 'הזמן הממוצע שלוקח לצרכן להחליט אם להמשיך לגלול או לעצור',
                    'source' => 'ממוצע תעשייתי, UX Research',
                ),
            ),
            'faq'            => array(
                array(
                    'question' => 'כמה עולה מיתוג למסעדה?',
                    'answer'   => 'מיתוג מלא: 8,000-15,000 ₪ למסעדה חדשה. ריפרש של מותג קיים — פחות. מותאם להיקף.',
                ),
                array(
                    'question' => 'כמה זמן לוקח?',
                    'answer'   => 'מיתוג מלא: 4-8 שבועות. לוגו בלבד: 2-3 שבועות. תפריט: 1-2 שבועות.',
                ),
                array(
                    'question' => 'יש לנו לוגו — אפשר רק שפה עיצובית?',
                    'answer'   => 'בהחלט. אנחנו לוקחים את הקיים ומרחיבים למערכת עיצובית מקצועית ועקבית.',
                ),
                array(
                    'question' => 'מה כולל "זהות מותגית מלאה"?',
                    'answer'   => 'לוגו ווריאציות, פלטת צבעים, טיפוגרפיה, סגנון צילום, טון דיבור, ויישום על כל נקודות המגע.',
                ),
            ),
            'cta_title'       => 'מוכנים לבנות מותג שנזכר?',
            'cta_subtitle'    => 'תנו לנו לספר את הסיפור הוויזואלי של המסעדה שלכם.',
            'cta_btn_text'    => 'קבעו פגישת אפיון ←',
            'cta_btn_url'     => '#',
            'cta_show_whatsapp' => '1',
        ),

        /* ───────────────────────────────────────────────
         * 12. websites
         * ─────────────────────────────────────────────── */
        'websites' => array(
            'name'           => 'בניית אתרים',
            'hero_icon'      => '🌐',
            'hero_title'     => 'בניית אתרים למסעדות',
            'hero_subtitle'  => 'האתר שעובד בשבילכם — 24/7',
            'hero_bg_image'  => '',
            'problem_title'  => 'הבעיה שאנחנו פותרים',
            'problem_content'=> '51% מהצרכנים בודקים את האתר של מסעדה לפני ביקור — ו-45% מחפשים תמונות מנות באתר. אבל מסעדות רבות מסתדרות עם אתר ישן, לא מותאם למובייל, עם תפריט PDF שלא נפתח בטלפון. אתר שלא מותאם = לקוחות שמתייאשים ועוברים למתחרה.',
            'process'        => array(
                array(
                    'title'       => 'אפיון ו-UX',
                    'description' => 'הגדרת מטרות האתר, מבנה עמודים, וחוויית משתמש',
                ),
                array(
                    'title'       => 'עיצוב',
                    'description' => 'עיצוב מותאם לזהות המותגית, מובייל-פירסט',
                ),
                array(
                    'title'       => 'פיתוח',
                    'description' => 'בנייה על וורדפרס או פלטפורמה מותאמת, מהירה ומאובטחת',
                ),
                array(
                    'title'       => 'תוכן ו-SEO',
                    'description' => 'כתיבת תוכן, אופטימיזציה למנועי חיפוש, ואינטגרציה עם הזמנות ומשלוחים',
                ),
                array(
                    'title'       => 'תחזוקה',
                    'description' => 'עדכונים שוטפים, גיבויים, ותמיכה טכנית',
                ),
            ),
            'stats'          => array(
                array(
                    'number' => '83%',
                    'label'  => 'מהצרכנים מחפשים מסעדה באינטרנט לפני ביקור',
                    'source' => 'Toast Restaurant Survey, 2024',
                ),
                array(
                    'number' => '60%+',
                    'label'  => 'מחיפושי המסעדות מגיעים ממובייל — אתר שלא מותאם לטלפון מפסיד את הרוב',
                    'source' => 'Google Restaurant Search Statistics, 2025',
                ),
                array(
                    'number' => '45%',
                    'label'  => 'מהסועדים מחפשים תמונות מנות באתר',
                    'source' => 'Restaurant Customer Statistics, 2025',
                ),
                array(
                    'number' => '36%',
                    'label'  => 'מהצרכנים אומרים שתמונות גרועות באתר מרתיעות אותם מלבקר',
                    'source' => 'Restaurant Customer Statistics, 2025',
                ),
            ),
            'faq'            => array(
                array(
                    'question' => 'כמה עולה אתר למסעדה?',
                    'answer'   => 'אתר תדמית בסיסי: 5,000-10,000 ₪. אתר מלא עם הזמנות, תפריט דינמי, ו-SEO: 10,000-25,000 ₪. תחזוקה חודשית: 300-800 ₪.',
                ),
                array(
                    'question' => 'כמה זמן לוקח?',
                    'answer'   => 'אתר בסיסי: 2-3 שבועות. אתר מלא: 4-8 שבועות. תלוי בהיקף ובתוכן.',
                ),
                array(
                    'question' => 'האם אפשר לערוך תוכן בעצמנו?',
                    'answer'   => 'כן. אנחנו בונים על וורדפרס עם פאנל ניהול פשוט. המסעדה יכולה לעדכן תפריטים, תמונות ושעות בלי קוד.',
                ),
                array(
                    'question' => 'האם האתר יכלול הזמנת שולחן?',
                    'answer'   => 'כן — אינטגרציה עם Ontopo, או מערכת הזמנות מובנית. גם הזמנות משלוחים ישירות.',
                ),
                array(
                    'question' => 'מה עם SEO?',
                    'answer'   => 'כל אתר שאנחנו בונים כולל אופטימיזציה בסיסית: מבנה נכון, מהירות טעינה, meta tags, ו-Schema markup. SEO מתקדם — בנפרד.',
                ),
            ),
            'cta_title'       => 'מוכנים לאתר שעובד?',
            'cta_subtitle'    => 'אתר שנראה מעולה, טוען מהר, וממיר מבקרים ללקוחות.',
            'cta_btn_text'    => 'בואו נתכנן ←',
            'cta_btn_url'     => '#',
            'cta_show_whatsapp' => '1',
        ),

        /* ───────────────────────────────────────────────
         * 13. analytics
         * ─────────────────────────────────────────────── */
        'analytics' => array(
            'name'           => 'אנליטיקס ודוחות',
            'hero_icon'      => '📊',
            'hero_title'     => 'אנליטיקס ודוחות למסעדות',
            'hero_subtitle'  => 'מספרים שמספרים סיפור — ומובילים להחלטות',
            'hero_bg_image'  => '',
            'problem_title'  => 'הבעיה שאנחנו פותרים',
            'problem_content'=> 'מסעדות רבות מקבלות החלטות שיווקיות על בסיס תחושת בטן. כמה לקוחות הגיעו מהקמפיין? מה ה-ROI של הפרסום? איזה יום הכי רווחי? בלי נתונים ברורים — אי אפשר לדעת מה עובד, מה לשפר, ולאן להפנות תקציב.',
            'process'        => array(
                array(
                    'title'       => 'הגדרת KPIs',
                    'description' => 'מה חשוב למדוד: הזמנות, שיחות, ביקורים, עלות לליד, ROI',
                ),
                array(
                    'title'       => 'הקמת תשתית',
                    'description' => 'Google Analytics, Meta Pixel, מעקב המרות, ודשבורד מותאם',
                ),
                array(
                    'title'       => 'דוחות חודשיים',
                    'description' => 'ניתוח ביצועים, מגמות, והמלצות מבוססות נתונים',
                ),
                array(
                    'title'       => 'תובנות אסטרטגיות',
                    'description' => 'זיהוי הזדמנויות, אזהרות מוקדמות, ותוכנית פעולה',
                ),
            ),
            'stats'          => array(
                array(
                    'number' => '64%',
                    'label'  => 'מההזמנות דיגיטליות — נתונים שאפשר למדוד, לנתח ולשפר',
                    'source' => 'Ontopo, 2025',
                ),
                array(
                    'number' => '15-20%',
                    'label'  => 'השיפור הממוצע בהמרות כשמסתמכים על נתונים ולא על תחושה',
                    'source' => 'Google Review Statistics / LocaliQ',
                ),
                array(
                    'number' => '31%',
                    'label'  => 'מהמסעדנים מרגישים יציבים — האחרים חסרים נתונים שמאפשרים קבלת החלטות',
                    'source' => 'Ontopo, 2025',
                ),
                array(
                    'number' => '5-10%',
                    'label'  => 'שולי רווח — בשוליים כאלה, כל אחוז שיפור בהמרות הוא כסף אמיתי',
                    'source' => 'Israel Restaurant Association',
                ),
            ),
            'faq'            => array(
                array(
                    'question' => 'אנחנו מסעדה קטנה — באמת צריכים אנליטיקס?',
                    'answer'   => 'דווקא. מסעדה קטנה לא יכולה להרשות לעצמה ניחושים. נתונים בסיסיים על מה עובד ומה לא יכולים לחסוך אלפי שקלים בחודש.',
                ),
                array(
                    'question' => 'מה כולל הדוח החודשי?',
                    'answer'   => 'סיכום ביצועי קמפיינים, נתוני אתר ורשתות, עלות לליד, ROI, מגמות, והמלצות לחודש הבא. הכל ויזואלי וברור.',
                ),
                array(
                    'question' => 'באילו כלים אתם משתמשים?',
                    'answer'   => 'Google Analytics, Meta Business Suite, Google Ads, ודשבורד מותאם שמאחד הכל. הגישה פתוחה גם ללקוח.',
                ),
                array(
                    'question' => 'כמה זה עולה?',
                    'answer'   => 'ניתוח ודוחות נכללים בכל חבילת ניהול שיווק שלנו. ניתן לרכוש גם כשירות עצמאי למסעדות שמנהלות שיווק בעצמן.',
                ),
            ),
            'cta_title'       => 'מוכנים לקבל החלטות על בסיס נתונים?',
            'cta_subtitle'    => 'דוחות ברורים שמובילים לתוצאות.',
            'cta_btn_text'    => 'קבעו שיחה ←',
            'cta_btn_url'     => '#',
            'cta_show_whatsapp' => '1',
        ),

        /* ───────────────────────────────────────────────
         * 14. digital-menus
         * ─────────────────────────────────────────────── */
        'digital-menus' => array(
            'name'           => 'תפריטים דיגיטליים',
            'hero_icon'      => '📋',
            'hero_title'     => 'תפריטים דיגיטליים למסעדות',
            'hero_subtitle'  => 'תפריט שמוכר — לא רק מציג',
            'hero_bg_image'  => '',
            'problem_title'  => 'הבעיה שאנחנו פותרים',
            'problem_content'=> 'תפריט הוא כלי המכירות מספר 1 של מסעדה — ורוב המסעדות לא מנצלות את הפוטנציאל שלו. תפריט PDF שלא נפתח בטלפון, תמונות באיכות נמוכה, ותיאורים גנריים — כל אלה מפספסים את ההזדמנות לגרום ללקוח להזמין יותר. תפריט דיגיטלי מעוצב נכון מגדיל צ\'ק ומשפר חוויה.',
            'process'        => array(
                array(
                    'title'       => 'ניתוח תפריט קיים',
                    'description' => 'מה עובד, מה לא, ואיפה יש הזדמנויות לשיפור',
                ),
                array(
                    'title'       => 'עיצוב ומיתוג',
                    'description' => 'עיצוב תפריט דיגיטלי שמתאים לזהות המותגית ומותאם למובייל',
                ),
                array(
                    'title'       => 'Menu Engineering',
                    'description' => 'סידור אסטרטגי של מנות, תמחור פסיכולוגי, והדגשת מנות רווחיות',
                ),
                array(
                    'title'       => 'הטמעה',
                    'description' => 'QR קודים, אינטגרציה עם פלטפורמות משלוחים, ואתר',
                ),
            ),
            'stats'          => array(
                array(
                    'number' => '88%',
                    'label'  => 'מהמסעדנים אומרים שתפריט QR עוזר לייעל את העסק',
                    'source' => 'Restaurant QR Menu Statistics',
                ),
                array(
                    'number' => '15%',
                    'label'  => 'הגידול הממוצע בצ\'ק כשהתפריט מעוצב עם Menu Engineering מקצועי',
                    'source' => 'Restaurant menu engineering benchmarks',
                ),
                array(
                    'number' => '45%',
                    'label'  => 'מהסועדים מחפשים תמונות מנות — תפריט ויזואלי מגדיל המרות',
                    'source' => 'Restaurant Customer Statistics, 2025',
                ),
                array(
                    'number' => '60%+',
                    'label'  => 'מהגלישה למסעדות מגיעה ממובייל — תפריט שלא מותאם לטלפון מפסיד את הרוב',
                    'source' => 'Google, 2025',
                ),
            ),
            'faq'            => array(
                array(
                    'question' => 'מה ההבדל בין תפריט PDF לתפריט דיגיטלי?',
                    'answer'   => 'תפריט דיגיטלי מותאם למובייל, ניתן לעדכון בזמן אמת, כולל תמונות ברזולוציה גבוהה, ומתואם עם מערכות הזמנות. PDF — לא.',
                ),
                array(
                    'question' => 'כמה עולה עיצוב תפריט דיגיטלי?',
                    'answer'   => 'תלוי בהיקף: תפריט QR בסיסי — 1,500-3,000 ₪. תפריט מעוצב עם צילומים ו-Menu Engineering — 5,000-12,000 ₪.',
                ),
                array(
                    'question' => 'מה זה Menu Engineering?',
                    'answer'   => 'סידור אסטרטגי של מנות בתפריט שמגדיל את הסיכוי שלקוחות יזמינו מנות רווחיות. זה כולל מיקום, תיאורים, תמחור פסיכולוגי, ועיצוב שמכוון את העין.',
                ),
                array(
                    'question' => 'האם אפשר לעדכן את התפריט בעצמנו?',
                    'answer'   => 'כן. אנחנו בונים תפריטים עם פאנל ניהול פשוט שמאפשר לעדכן מנות, מחירים ותמונות בלי עזרה טכנית.',
                ),
                array(
                    'question' => 'האם זה עובד גם עם Wolt ו-10bis?',
                    'answer'   => 'אנחנו מתאימים את התפריט לכל פלטפורמה — כל אחת עם התמונות, התיאורים והמחירים שמתאימים לה.',
                ),
            ),
            'cta_title'       => 'מוכנים לתפריט שמוכר?',
            'cta_subtitle'    => 'תפריט דיגיטלי מעוצב שמגדיל צ\'ק ומשפר חוויה.',
            'cta_btn_text'    => 'בואו נעצב ←',
            'cta_btn_url'     => '#',
            'cta_show_whatsapp' => '1',
        ),

    );
}

/**
 * Seed default category page data into wp_options.
 *
 * @param bool $force  When true, overwrite existing options.
 */
function freshm_seed_category_pages( $force = false ) {
    $defaults = freshm_get_default_category_data();
    foreach ( $defaults as $slug => $data ) {
        $option_key = 'freshm_category_page_' . $slug;
        if ( $force || ! get_option( $option_key ) ) {
            update_option( $option_key, $data );
        }
    }
}

/**
 * Ensure all 14 service-category taxonomy terms exist.
 * Runs on init (after taxonomy registration) with a one-time transient check.
 */
function freshm_ensure_category_terms() {
    if ( ! taxonomy_exists( 'service_category' ) ) return;
    // Only check once per day to avoid repeated DB queries
    if ( get_transient( 'freshm_cats_terms_checked' ) ) return;

    $defaults = freshm_get_default_category_data();
    foreach ( $defaults as $slug => $data ) {
        if ( ! term_exists( $slug, 'service_category' ) ) {
            wp_insert_term( $data['name'], 'service_category', array( 'slug' => $slug ) );
        }
    }
    set_transient( 'freshm_cats_terms_checked', 1, DAY_IN_SECONDS );
}
add_action( 'init', 'freshm_ensure_category_terms', 20 );
