<?php
/**
 * FRESH Manager - Default Service Data (15 Services + 5 Categories)
 * Single source of truth for activation hooks, fallbacks, and reset.
 */
defined( 'ABSPATH' ) || exit;

/**
 * Get default 5 service categories.
 */
function freshm_get_default_service_cats() {
    return array(
        array( 'name' => 'פרסום ממומן',      'slug' => 'paid-advertising',      'order' => 0 ),
        array( 'name' => 'סושיאל ותוכן',     'slug' => 'social-content',        'order' => 1 ),
        array( 'name' => 'מיתוג ונוכחות',    'slug' => 'branding-presence',     'order' => 2 ),
        array( 'name' => 'ניהול פלטפורמות',  'slug' => 'platform-management',   'order' => 3 ),
        array( 'name' => 'צמיחה ומדידה',     'slug' => 'growth-measurement',    'order' => 4 ),
    );
}

/**
 * Get default 15 services with full Hebrew content.
 */
function freshm_get_default_services() {
    return array(

        /* -- 1. קמפיינים ממומנים -- */
        array(
            'name'      => 'קמפיינים ממומנים',
            'slug'      => 'paid-campaigns',
            'category'  => 'paid-advertising',
            'icon'      => 'paid-campaigns',
            'custom_icon' => '',
            'excerpt'   => 'Facebook, Instagram, Google, TikTok - מיקוד גיאוגרפי ואופטימיזציה',
            'color'     => '#c9a84c',
            'order'     => 1,
            'status'    => 'publish',
            'hero_image' => '',
            'content'   => 'ניהול קמפיינים למסעדות זה לא אותו דבר כמו פרסום חנות בגדים או קליניקה. הקהל שונה, השעות קריטיות, והתוכן חייב לגרום לרעב - לא סתם לעניין. אנחנו מנהלים קמפיינים ממומנים ב-Facebook, Instagram, Google Ads ו-TikTok Ads, עם התמחות ספציפית במסעדות. כל קמפיין נבנה עם מיקוד גיאוגרפי חכם סביב אזור המסעדה, תזמון לפי שעות הפעילות, ומסרים שמותאמים לשלב שבו הלקוח נמצא - בין אם הוא מחפש מקום לערב הזה, או שאנחנו רוצים לזרוע אצלו את הרצון לבקר בשבוע הבא. אנחנו לא סתם מפעילים קמפיינים - אנחנו ממלאים מסעדות.',
            'video_url' => '',
            'cta_title' => 'רוצים יותר לקוחות מחר?',
            'cta_text'  => 'בואו נבנה קמפיין ממוקד שמביא תוצאות.',
            'cta_btn'   => 'דברו איתנו',
            'benefits'  => array(
                array( 'icon' => '🎯', 'title' => 'מיקוד גיאוגרפי',           'desc' => 'טירגוט מדויק לפי רדיוס סביב המסעדה, שכונות ואזורי ביקוש' ),
                array( 'icon' => '📊', 'title' => 'אופטימיזציה יומית',         'desc' => 'מעקב שוטף אחרי ביצועים, התאמת תקציבים וקהלים בזמן אמת' ),
                array( 'icon' => '🎨', 'title' => 'קריאייטיב שמביא תוצאות',   'desc' => 'תמונות, סרטונים ומסרים שנבנו ספציפית למסעדות' ),
                array( 'icon' => '📋', 'title' => 'דוחות חודשיים',             'desc' => 'דוח ביצועים מפורט עם המלצות לחודש הבא' ),
                array( 'icon' => '🧪', 'title' => 'A/B Testing',               'desc' => 'בדיקת גרסאות שונות של מודעות למציאת השילוב המנצח' ),
                array( 'icon' => '💰', 'title' => 'ניהול תקציב',               'desc' => 'חלוקה אופטימלית של התקציב בין פלטפורמות, ימים ושעות' ),
                array( 'icon' => '🔄', 'title' => 'Retargeting',               'desc' => 'טירגוט מחדש של גולשים שכבר ביקרו באתר או בעמוד שלכם' ),
                array( 'icon' => '📅', 'title' => 'אסטרטגיית הגשה',            'desc' => 'תכנון מסרים שונים לשעות שיא, ימים חלשים ואירועים מיוחדים' ),
            ),
            'process'   => array(
                array( 'number' => '01', 'title' => 'אפיון והגדרת יעדים', 'desc' => 'מבינים את המסעדה, הקהל, והמטרות העסקיות' ),
                array( 'number' => '02', 'title' => 'בניית אסטרטגיה',     'desc' => 'בוחרים פלטפורמות, קהלים, תקציב ולוח זמנים' ),
                array( 'number' => '03', 'title' => 'הקמה והשקה',         'desc' => 'עיצוב מודעות, כתיבת קופי, והשקת הקמפיינים' ),
                array( 'number' => '04', 'title' => 'אופטימיזציה ודיווח', 'desc' => 'מעקב יומי, שיפור מתמשך, ודוחות ביצועים שקופים' ),
            ),
            'metrics'   => array(
                array( 'number' => '+340%', 'desc' => 'גידול בהזמנות אונליין' ),
                array( 'number' => '4-8x',  'desc' => 'ROI ממוצע על הוצאות פרסום' ),
                array( 'number' => '90 יום', 'desc' => 'לתוצאות ראשונות משמעותיות' ),
            ),
            'gallery'   => array(),
            'closing_text' => 'בזמן שאתם קוראים את זה, הלקוחות שלכם גוללים בפיד ורואים את המתחרים. כל יום בלי קמפיין ממוקד הוא יום של שולחנות ריקים שלא היו צריכים להיות ריקים. בואו נשנה את זה - כבר מהשבוע הבא.',
            'faqs' => array(
                array( 'q' => 'כמה תקציב פרסום צריך כדי להתחיל?', 'a' => 'אין תקציב מינימלי קבוע - זה תלוי במיקום, בגודל המסעדה ובמטרות. יש מסעדות שמתחילות עם 3,000 שקל בחודש ויש כאלה שמשקיעות 30,000. אנחנו מתאימים את התקציב לגודל ולשלב של העסק, ומוודאים שכל שקל עובד.' ),
                array( 'q' => 'באיזה פלטפורמות אתם מפרסמים?', 'a' => 'אנחנו מנהלים קמפיינים ב-Facebook, Instagram, Google Ads ו-TikTok Ads. הבחירה תלויה בקהל היעד שלכם ובסוג המסעדה. לרוב אנחנו מתחילים עם Facebook ו-Instagram, ומרחיבים לפלטפורמות נוספות בהמשך.' ),
                array( 'q' => 'תוך כמה זמן רואים תוצאות מקמפיינים?', 'a' => 'בקמפיינים ממומנים התוצאות מגיעות מהר. בדרך כלל תוך 48-72 שעות מהשקת הקמפיין כבר רואים לידים ותנועה. השיפור האמיתי מגיע אחרי 2-3 שבועות של אופטימיזציה, כשהמערכת לומדת מה עובד הכי טוב.' ),
                array( 'q' => 'מה ההבדל בינכם לבין לנהל קמפיינים לבד?', 'a' => 'אנחנו מכירים את תעשיית המסעדות לעומק - יודעים באיזה שעות לפרסם, איזה תוכן עובד, ואיך לתזמן קמפיינים סביב חגים, מזג אוויר ואירועים. בנוסף, אנחנו מנהלים עשרות קמפיינים במקביל ויש לנו דאטה שחוסכת לכם חודשים של ניסוי וטעייה.' ),
            ),
        ),

        /* -- 2. שיווק משפיענים ויוצרי תוכן -- */
        array(
            'name'      => 'שיווק משפיענים ויוצרי תוכן',
            'slug'      => 'influencer-marketing',
            'category'  => 'paid-advertising',
            'icon'      => 'influencer-marketing',
            'custom_icon' => '',
            'excerpt'   => 'בלוגרים, טיקטוקיסטים, יוצרי תוכן - תוצאות מדידות',
            'color'     => '#c9a84c',
            'order'     => 2,
            'status'    => 'publish',
            'hero_image' => '',
            'content'   => 'שיווק משפיענים למסעדות עובד אחרת מכל תחום אחר. הגולשים לא רוצים לראות פוזה ליד צלחת - הם רוצים לראות מישהו שהם סומכים עליו נהנה באמת מהאוכל. אנחנו מנהלים את כל התהליך מקצה לקצה - מאיתור יוצר התוכן שהקהל שלו הוא בדיוק הקהל שלכם, דרך בניית בריף מדויק שמייצר תוכן אותנטי ולא מאולץ, ועד תיאום ההגעה, אישור כל פריט תוכן ומדידת התוצאות בפועל. לא מחפשים את המשפיען עם הכי הרבה עוקבים - מחפשים את זה שיביא לכם הזמנות.',
            'video_url' => '',
            'cta_title' => 'רוצים שיחברו אתכם עם המשפיענים הנכונים?',
            'cta_text'  => 'ניהול מלא של שיתופי פעולה - מבחירה ועד מדידת תוצאות.',
            'cta_btn'   => 'דברו איתנו',
            'benefits'  => array(
                array( 'icon' => '🔍', 'title' => 'איתור ובחירת יוצרי תוכן', 'desc' => 'מיפוי משפיענים לפי קהל יעד, אזור גיאוגרפי וסגנון' ),
                array( 'icon' => '📋', 'title' => 'בריף ותיאום',              'desc' => 'הכנת בריף מותאם, תיאום הגעה ומעקב אחרי ביצוע' ),
                array( 'icon' => '✅', 'title' => 'אישור תוכן',              'desc' => 'בקרת איכות על כל תוכן לפני עלייה - מסרים, איכות ומיתוג' ),
                array( 'icon' => '📊', 'title' => 'מדידת ROI',               'desc' => 'מעקב מדויק אחרי תוצאות כל שיתוף פעולה' ),
                array( 'icon' => '🤝', 'title' => 'ניהול קשרים שוטף',        'desc' => 'בניית מאגר יוצרים ותחזוקת קשרים ארוכי טווח' ),
                array( 'icon' => '💰', 'title' => 'ניהול תקציב משפיענים',     'desc' => 'הקצאת תקציב חכמה בין יוצרים בהתאם לביצועים' ),
                array( 'icon' => '🔄', 'title' => 'תוכן למיחזור',            'desc' => 'ניצול התוכן שנוצר לשימוש חוזר בפרסום ממומן וברשתות' ),
                array( 'icon' => '📈', 'title' => 'דוח ביצועי משפיענים',      'desc' => 'סיכום חודשי של כל שיתוף - חשיפה, הגעות, המרות' ),
            ),
            'process'   => array(
                array( 'number' => '01', 'title' => 'זיהוי משפיענים רלוונטיים', 'desc' => 'מחקר ובחירת יוצרי התוכן המתאימים ביותר לקהל היעד' ),
                array( 'number' => '02', 'title' => 'ניהול משא ומתן',           'desc' => 'סגירת תנאים, תקציב, ותיאום ציפיות' ),
                array( 'number' => '03', 'title' => 'תיאום ביקורים ותוכן',      'desc' => 'ארגון הביקור, הכוונת התוכן, ובקרת איכות' ),
                array( 'number' => '04', 'title' => 'מעקב תוצאות',             'desc' => 'מדידת ביצועים, ניתוח ROI, והמלצות להמשך' ),
            ),
            'metrics'   => array(
                array( 'number' => '+200%', 'desc' => 'עלייה ממוצעת בביקורים אחרי קמפיין' ),
                array( 'number' => '50+',   'desc' => 'משפיענים ברשת השותפים שלנו' ),
            ),
            'gallery'   => array(),
            'closing_text' => 'הפוסט הנכון, מהאדם הנכון, יכול למלא לכם את המסעדה לשבועיים. אנחנו יודעים בדיוק מי האדם הזה עבורכם. השאירו פרטים ונתחיל לחבר.',
            'faqs' => array(
                array( 'q' => 'איך אתם בוחרים את המשפיענים?', 'a' => 'אנחנו לא מסתכלים רק על מספר העוקבים. בודקים אנגייג\'מנט אמיתי, התאמה לסגנון המסעדה, איכות תוכן, ומיקום גיאוגרפי של הקהל. משפיען עם 5,000 עוקבים מהאזור שלכם יכול להביא יותר תוצאות ממשפיען עם 500,000 מפוזרים.' ),
                array( 'q' => 'כמה עולה שיתוף פעולה עם משפיען?', 'a' => 'זה משתנה מאוד - מארוחה בתמורה לתוכן ועד עסקאות של אלפי שקלים. אנחנו מנהלים את המשא ומתן ומוודאים שהמחיר הוגן ביחס לתוצאה הצפויה. תמיד נציג לכם אופציות בטווחי תקציב שונים.' ),
                array( 'q' => 'מה קורה אם התוכן לא טוב?', 'a' => 'כל תוכן עובר אישור שלנו ושלכם לפני פרסום. אנחנו מכינים בריף מפורט ליוצר התוכן עם הנחיות ברורות. אם התוכן לא עומד בסטנדרט - מבקשים תיקונים או צילום מחדש.' ),
                array( 'q' => 'איך מודדים אם שיתוף הפעולה הצליח?', 'a' => 'אנחנו עוקבים אחרי מספרים אמיתיים - לא רק לייקים. מודדים כמה אנשים הגיעו למסעדה דרך המשפיען, כמה הזמנות נכנסו, ומה ה-ROI של ההשקעה. כל שיתוף פעולה מקבל דוח ביצועים.' ),
            ),
        ),

        /* -- 3. ניהול רשתות חברתיות -- */
        array(
            'name'      => 'ניהול רשתות חברתיות',
            'slug'      => 'social-management',
            'category'  => 'social-content',
            'icon'      => 'social-management',
            'custom_icon' => '',
            'excerpt'   => 'תוכן, קהילה, אנגייג\'מנט - נוכחות שמביאה סועדים',
            'color'     => '#c9a84c',
            'order'     => 3,
            'status'    => 'publish',
            'hero_image' => '',
            'content'   => 'מסעדה שלא פעילה ברשתות החברתיות - כמעט לא קיימת. אבל פעילות בשביל לסמן וי זה לא מספיק. צריך תוכן שמספר סיפור, שבונה קהילה, שגורם לאנשים לעקוב, לשתף ובסוף - להגיע ולשבת. אנחנו מנהלים את הנוכחות הדיגיטלית המלאה של המסעדה - מתכנון לוח תוכן חודשי שמשלב עונתיות, חגים ואירועים, דרך כתיבת פוסטים שמדברים בשפה של הקהל שלכם, ועד ניהול קהילה יומיומי שהופך עוקבים ללקוחות קבועים. כל פוסט, סטורי ורילס שיוצא מאיתנו נבנה עם מטרה אחת ברורה - להביא אנשים לשבת אצלכם.',
            'video_url' => '',
            'cta_title' => 'רוצים סושיאל שמביא לקוחות?',
            'cta_text'  => 'ניהול מקצועי, תוכן שמוכר, ותוצאות שרואים.',
            'cta_btn'   => 'דברו איתנו',
            'benefits'  => array(
                array( 'icon' => '📅', 'title' => 'תוכנית תוכן חודשית',       'desc' => 'לוח שנה שיווקי עם 12-20 פוסטים, סטוריז ורילסים בחודש' ),
                array( 'icon' => '✍️', 'title' => 'יצירת תוכן',               'desc' => 'כתיבת פוסטים, עיצוב ועריכה - הכל מותאם למותג המסעדה' ),
                array( 'icon' => '💬', 'title' => 'ניהול קהילה',               'desc' => 'מענה לתגובות, הודעות, שיתופים ותיוגים בזמן אמת' ),
                array( 'icon' => '📊', 'title' => 'דוחות ביצועים',             'desc' => 'ניתוח חודשי של צמיחה, אנגייג\'מנט וביצועי תוכן' ),
                array( 'icon' => '🔍', 'title' => 'אסטרטגיית Hashtags',       'desc' => 'מחקר ובחירת האשטאגים האפקטיביים לנישת המסעדה' ),
                array( 'icon' => '🎉', 'title' => 'ניהול אירועים ומבצעים',    'desc' => 'קידום אירועים מיוחדים, חגים ומבצעים עונתיים' ),
                array( 'icon' => '📋', 'title' => 'לוח שנה עונתי',            'desc' => 'תכנון מראש לחגים, עונות, אירועים ותאריכים מיוחדים' ),
                array( 'icon' => '📈', 'title' => 'ניתוח מתחרים',             'desc' => 'מעקב אחרי פעילות מתחרים והתאמת אסטרטגיה' ),
            ),
            'process'   => array(
                array( 'number' => '01', 'title' => 'בניית אסטרטגיה',   'desc' => 'הגדרת טון, שפה ויזואלית, ומטרות תוכן' ),
                array( 'number' => '02', 'title' => 'לוח תוכן חודשי',   'desc' => 'תכנון, עיצוב וכתיבה של כל התכנים מראש' ),
                array( 'number' => '03', 'title' => 'פרסום וניהול',      'desc' => 'פרסום בזמנים אופטימליים וניהול קהילה יומי' ),
                array( 'number' => '04', 'title' => 'ניתוח ושיפור',      'desc' => 'דוח חודשי, ניתוח ביצועים, ואופטימיזציה' ),
            ),
            'metrics'   => array(
                array( 'number' => '+180%', 'desc' => 'גידול ממוצע במעורבות' ),
                array( 'number' => '70%',   'desc' => 'מהלקוחות בודקים אינסטגרם לפני ביקור' ),
            ),
            'gallery'   => array(),
            'closing_text' => 'הפיד של המסעדה שלכם הוא חלון הראווה שלכם ב-2025. אם הוא לא עובד בשבילכם - הוא עובד נגדכם. תנו לנו חודש אחד ותראו את ההבדל.',
            'faqs' => array(
                array( 'q' => 'כמה פוסטים אתם מעלים בחודש?', 'a' => 'בדרך כלל בין 12 ל-20 פוסטים בחודש, פלוס סטוריז יומיים. אבל הכמות מותאמת לכל מסעדה - יש כאלה שצריכות נוכחות יומית אינטנסיבית ויש כאלה שמספיק להן 3 פוסטים בשבוע. איכות תמיד לפני כמות.' ),
                array( 'q' => 'אתם גם כותבים את הטקסטים?', 'a' => 'כן, הכל כלול - קופי, עיצוב, תזמון ופרסום. אנחנו לומדים את הטון והשפה של המסעדה ויוצרים תוכן שמרגיש אותנטי. כל פוסט עובר אישור שלכם לפני שעולה.' ),
                array( 'q' => 'מה עם תגובות ומסרים?', 'a' => 'אנחנו מנהלים את הקהילה שלכם - עונים לתגובות, מגיבים למסרים, ומנהלים שיח. זמן תגובה ממוצע: עד 3 שעות בשעות פעילות. תגובות שדורשות ידע ספציפי על המסעדה מועברות אליכם.' ),
                array( 'q' => 'אני יכול לבקש שינויים בתוכן?', 'a' => 'כמובן. בתחילת כל חודש אנחנו שולחים לוח תוכן לאישור. אתם יכולים לבקש שינויים, להוסיף רעיונות, או לבטל פוסטים. זו שותפות - לא תכתיב.' ),
            ),
        ),

        /* -- 4. צילום מנות -- */
        array(
            'name'      => 'צילום מנות',
            'slug'      => 'food-photography',
            'category'  => 'social-content',
            'icon'      => 'food-photography',
            'custom_icon' => '',
            'excerpt'   => 'צילום אוכל מקצועי שהופך כל מנה לתמונה שמוכרת',
            'color'     => '#c9a84c',
            'order'     => 4,
            'status'    => 'publish',
            'hero_image' => '',
            'content'   => 'צילום אוכל הוא אומנות בפני עצמה. לא מספיק מצלמה טובה - צריך הבנה עמוקה של פוד סטיילינג, תאורה שמחמיאה לצבעי המנה, וידע איך להעביר טעם, ריח וטקסטורה דרך תמונה אחת בלבד. הצלמים שלנו מתמחים בצילומי F&B ומכירים את הזוויות, הרגעים והפרטים הקטנים שהופכים צלחת רגילה לתמונה שגורמת לאנשים לעצור לגלול, לבלוע רוק ולהזמין. כל צילום מותאם לשימוש הספציפי - בין אם זה לפיד Instagram, לתפריט דיגיטלי, לפלטפורמות משלוחים או לאתר. התמונות שלנו לא סתם יפות - הן מוכרות.',
            'video_url' => '',
            'cta_title' => 'רוצים תמונות שמוכרות?',
            'cta_text'  => 'צילום מקצועי שמביא תוצאות.',
            'cta_btn'   => 'דברו איתנו',
            'benefits'  => array(
                array( 'icon' => '📸', 'title' => 'צילום במסעדה',             'desc' => 'הגעה למסעדה עם ציוד מקצועי - תאורה, רקעים ופוד סטיילינג' ),
                array( 'icon' => '✨', 'title' => 'עריכת תמונות',             'desc' => 'ריטוש מקצועי, התאמת צבעים ועריכה שמתאימה לשפת המותג' ),
                array( 'icon' => '📱', 'title' => 'התאמה לפלטפורמות',         'desc' => 'חיתוך וגודל מותאם ל-Instagram, Facebook, Wolt, 10bis ואתר' ),
                array( 'icon' => '📦', 'title' => 'מאגר תמונות',              'desc' => 'העברת כל התמונות בגודל מלא ובאיכות גבוהה - שלכם לנצח' ),
                array( 'icon' => '🍳', 'title' => 'פוד סטיילינג',             'desc' => 'עיצוב והכנת המנות לפני הצילום לתוצאה מושלמת' ),
                array( 'icon' => '📋', 'title' => 'צילומי תפריט',             'desc' => 'צילום מותאם לתפריט דיגיטלי ומודפס' ),
                array( 'icon' => '🛵', 'title' => 'צילום לפלטפורמות משלוח',   'desc' => 'תמונות בפורמט ובגודל שנדרש ב-Wolt, 10bis ו-Cibus' ),
                array( 'icon' => '📅', 'title' => 'צילומי עונה',              'desc' => 'עדכון תמונות למנות חדשות, תפריטים עונתיים ומבצעים' ),
            ),
            'process'   => array(
                array( 'number' => '01', 'title' => 'תכנון הצילום',     'desc' => 'בחירת מנות, מודבורד, וסגנון ויזואלי' ),
                array( 'number' => '02', 'title' => 'יום צילום',         'desc' => 'הגעה למסעדה עם ציוד מקצועי וצילום מלא' ),
                array( 'number' => '03', 'title' => 'עריכה ורטוש',      'desc' => 'עיבוד מקצועי, התאמת צבעים, וחיתוך' ),
                array( 'number' => '04', 'title' => 'מסירה',             'desc' => 'קבצים באיכות גבוהה מותאמים לכל שימוש' ),
            ),
            'metrics'   => array(
                array( 'number' => '+250%', 'desc' => 'עלייה במעורבות עם תוכן מצולם מקצועית' ),
                array( 'number' => '+120%', 'desc' => 'גידול בהזמנות אחרי עדכון תמונות בפלטפורמות' ),
            ),
            'gallery'   => array(),
            'closing_text' => 'המנות שלכם מעולות. אבל אם התמונות לא עושות צדק - אף אחד לא ידע את זה. צילום אחד טוב שווה אלף מילים ומאה הזמנות. בואו נצלם.',
            'faqs' => array(
                array( 'q' => 'כמה מנות אפשר לצלם ביום צילומים?', 'a' => 'ביום צילומים ממוצע אנחנו מצלמים 15-25 מנות, תלוי במורכבות ובסטיילינג. מנות פשוטות לוקחות פחות זמן, מנות עם מרכיבים רבים או סטיילינג מורכב לוקחות יותר.' ),
                array( 'q' => 'אתם מביאים ציוד או מצלמים בטלפון?', 'a' => 'אנחנו מגיעים עם ציוד מקצועי מלא - מצלמה, עדשות, תאורה, רפלקטורים ואביזרי סטיילינג. התוצאה היא ברמה שונה לחלוטין מצילום בטלפון.' ),
                array( 'q' => 'מה קורה עם העריכה?', 'a' => 'כל התמונות עוברות עריכה מקצועית - תיקוני צבע, בהירות, חדות ורטאץ\' בסיסי. אתם מקבלים קבצים בגודל מלא ובגרסה מותאמת לרשתות חברתיות ולפלטפורמות משלוחים.' ),
                array( 'q' => 'אפשר גם לעדכן תמונות בפלטפורמות המשלוחים?', 'a' => 'כן, אנחנו מצלמים בפורמטים שמתאימים לכל פלטפורמה - Wolt, 10bis, Cibus. אם אתם לקוחות שלנו גם באופטימיזציית משלוחים, אנחנו מעלים את התמונות ישירות.' ),
            ),
        ),

        /* -- 5. צילומי סטילס -- */
        array(
            'name'      => 'צילומי סטילס',
            'slug'      => 'stills-photography',
            'category'  => 'social-content',
            'icon'      => 'stills-photography',
            'custom_icon' => '',
            'excerpt'   => 'צילומי אווירה, מרחב וזהות שמספרים את הסיפור של המקום',
            'color'     => '#c9a84c',
            'order'     => 5,
            'status'    => 'publish',
            'hero_image' => '',
            'content'   => 'צילומי סטילס למסעדה הם הבסיס של כל נכס דיגיטלי שיש לכם - האתר, פרופיל Google, עמודי הנחיתה, הבאנרים ופרסומות. הם אלה שנותנים ללקוח הפוטנציאלי את ההרגשה של המקום עוד הרבה לפני שהוא נכנס בדלת. אנחנו מצלמים את החלל, הבר, הפרטים הקטנים שהופכים את המסעדה למיוחדת, הצוות בפעולה, ואת האווירה שגורמת לאנשים לרצות להיות שם. כל תמונה נבנית כך שתשרת את המיתוג הכללי של המסעדה, תעבוד לאורך זמן, ותגרום לכל מי שרואה אותה להרגיש שהוא חייב לבקר.',
            'video_url' => '',
            'cta_title' => 'רוצים תמונות שמספרות סיפור?',
            'cta_text'  => 'צילומי סטילס שמעבירים את האווירה של המקום.',
            'cta_btn'   => 'דברו איתנו',
            'benefits'  => array(
                array( 'icon' => '🏠', 'title' => 'צילומי חלל ואווירה',       'desc' => 'תמונות של המסעדה, הבר, האזורים השונים - אור טבעי ומלאכותי' ),
                array( 'icon' => '👥', 'title' => 'צילומי צוות',               'desc' => 'תמונות מקצועיות של השפים, הצוות והבעלים בפעולה' ),
                array( 'icon' => '✨', 'title' => 'צילומי פרטים',              'desc' => 'הטקסטורות, הכלים, הנרות, הפרחים - כל מה שיוצר אווירה' ),
                array( 'icon' => '📦', 'title' => 'עריכה ואספקה',             'desc' => 'תמונות ערוכות ומוכנות לשימוש בכל הפלטפורמות' ),
                array( 'icon' => '🌳', 'title' => 'צילומי חוץ',               'desc' => 'חזית המסעדה, ישיבה חיצונית, סביבה ונוף' ),
                array( 'icon' => '📍', 'title' => 'צילום לפרופיל Google',      'desc' => 'תמונות מותאמות ל-Google Business Profile' ),
                array( 'icon' => '🌐', 'title' => 'צילום לאתר',               'desc' => 'תמונות ברזולוציה גבוהה מותאמות לבאנרים ולעמודים' ),
                array( 'icon' => '📁', 'title' => 'מאגר תמונות ממותג',        'desc' => 'ספריית תמונות מאורגנת לפי קטגוריות לשימוש שוטף' ),
            ),
            'process'   => array(
                array( 'number' => '01', 'title' => 'תכנון',    'desc' => 'הגדרת סגנון, רשימת שוטים, ולוח זמנים' ),
                array( 'number' => '02', 'title' => 'צילום',    'desc' => 'הגעה עם ציוד מקצועי וצילום במסעדה' ),
                array( 'number' => '03', 'title' => 'עריכה',    'desc' => 'ריטוש, התאמת צבעים, וחיתוך לפלטפורמות' ),
                array( 'number' => '04', 'title' => 'מסירה',    'desc' => 'ספריית תמונות מאורגנת באיכות גבוהה' ),
            ),
            'metrics'   => array(
                array( 'number' => '+180%', 'desc' => 'שיפור בחוויית המותג הדיגיטלית' ),
                array( 'number' => '+90%',  'desc' => 'עלייה באינטראקציה עם תמונות מקצועיות' ),
            ),
            'gallery'   => array(),
            'closing_text' => 'אנשים מחליטים תוך 3 שניות אם המסעדה שלכם שווה ביקור. הסטילס שלכם הם 3 השניות האלה. הגיע הזמן שהם יעבדו בשבילכם.',
            'faqs' => array(
                array( 'q' => 'מה ההבדל בין צילום מנות לצילומי סטילס?', 'a' => 'צילום מנות מתמקד באוכל עצמו - הצלחת, המרכיבים, הטקסטורות. צילומי סטילס מספרים את הסיפור של המסעדה כולה - החלל, האווירה, הבר, הפרטים הקטנים, הצוות בפעולה. שניהם חשובים, כל אחד לשימוש אחר.' ),
                array( 'q' => 'כמה זמן לוקח יום צילומי סטילס?', 'a' => 'בין 3 ל-6 שעות, תלוי בגודל המסעדה ובכמות הזוויות. אנחנו מצלמים בשעות שמתאימות לתאורה הטבעית ולאווירה של המקום - לפעמים בבוקר לאור טבעי, לפעמים בערב לאווירה.' ),
                array( 'q' => 'התמונות שלכם מתאימות לאתר?', 'a' => 'בהחלט. אנחנו מצלמים ברזולוציה גבוהה ומספקים גרסאות מותאמות לכל שימוש - אתר, Google Business Profile, רשתות חברתיות, באנרים ודפוס.' ),
                array( 'q' => 'צריך להכין את המסעדה לפני הצילום?', 'a' => 'אנחנו שולחים רשימת הכנה מסודרת לפני יום הצילום. בדרך כלל צריך שהמקום יהיה נקי ומסודר, תאורה עובדת, ואם רוצים צילומי צוות - שהאנשים הרלוונטיים יהיו זמינים.' ),
            ),
        ),

        /* -- 6. צילומי וידאו -- */
        array(
            'name'      => 'צילומי וידאו',
            'slug'      => 'video-production',
            'category'  => 'social-content',
            'icon'      => 'video-production',
            'custom_icon' => '',
            'excerpt'   => 'רילסים, סרטונים ותוכן שגורם לאנשים לעצור לגלול',
            'color'     => '#c9a84c',
            'order'     => 6,
            'status'    => 'publish',
            'hero_image' => '',
            'content'   => 'בעולם שבו אנשים גוללים מהר, וידאו הוא מה שמשאיר אותם. רילס של 15 שניות עם גבינה שנמתחת, סטייק שנחתך בסכין חדה, או קוקטייל שנמזג לכוס קרח - זה מה שגורם לאנשים לעצור, לשמור, לשתף ולהזמין שולחן. אנחנו מפיקים תוכן וידאו שמותאם ספציפית לתעשיית המסעדות - מרילסים קצרים ומהירים ל-Instagram ו-TikTok ועד סרטוני מותג ארוכים יותר לאתר ול-YouTube. כל וידאו עובר צילום מקצועי עם ציוד קולנועי, עריכה קצבית שתפסת עין, ואפקטים שמותאמים לפלטפורמה. אנחנו לא עושים סרטונים - אנחנו יוצרים חוויות שמעבירים אנשים מהמסך ישר לשולחן.',
            'video_url' => '',
            'cta_title' => 'רוצים וידאו שמוכר?',
            'cta_text'  => 'הפקת וידאו מקצועית שמביאה תוצאות.',
            'cta_btn'   => 'דברו איתנו',
            'benefits'  => array(
                array( 'icon' => '🎬', 'title' => 'צילום וידאו במסעדה',           'desc' => 'צילום מקצועי עם ציוד קולנועי - תנועה, תאורה, סאונד' ),
                array( 'icon' => '📱', 'title' => 'רילסים וסרטונים קצרים',        'desc' => 'תוכן מותאם ל-Instagram Reels, TikTok ו-Facebook Stories' ),
                array( 'icon' => '✂️', 'title' => 'עריכת וידאו',                  'desc' => 'חיתוך קצבי, מוזיקה, כתוביות ואפקטים מותאמים' ),
                array( 'icon' => '🎞️', 'title' => 'סרטוני מותג',                  'desc' => 'סרטונים ארוכים יותר לאתר, ל-YouTube או לאירועים' ),
                array( 'icon' => '📝', 'title' => 'כתוביות ותרגום',               'desc' => 'הוספת כתוביות בעברית ובאנגלית לנגישות מקסימלית' ),
                array( 'icon' => '📲', 'title' => 'תוכן לסטוריז',                'desc' => 'סרטונים קצרים ואנכיים מותאמים לפורמט סטוריז' ),
                array( 'icon' => '🎥', 'title' => 'צילום Behind The Scenes',      'desc' => 'תוכן מאחורי הקלעים של המטבח, ההכנות והצוות' ),
                array( 'icon' => '📁', 'title' => 'ספריית וידאו',                 'desc' => 'ארגון ואספקת כל הקבצים בפורמטים שונים לשימוש חוזר' ),
            ),
            'process'   => array(
                array( 'number' => '01', 'title' => 'תכנון',    'desc' => 'מודבורד, רשימת שוטים, וסגנון עריכה' ),
                array( 'number' => '02', 'title' => 'צילום',    'desc' => 'יום צילום במסעדה עם ציוד מקצועי' ),
                array( 'number' => '03', 'title' => 'עריכה',    'desc' => 'חיתוך, מוזיקה, כתוביות, ואפקטים' ),
                array( 'number' => '04', 'title' => 'מסירה',    'desc' => 'קבצים מוכנים לכל פלטפורמה ושימוש' ),
            ),
            'metrics'   => array(
                array( 'number' => '+300%', 'desc' => 'עלייה במעורבות עם תוכן וידאו' ),
                array( 'number' => '+200%', 'desc' => 'גידול בשמירות ושיתופים' ),
            ),
            'gallery'   => array(),
            'closing_text' => 'רילס אחד טוב יכול להגיע לעשרות אלפי אנשים - אורגנית, בלי שקל על פרסום. אנחנו יודעים לייצר את הרילס הזה. השאלה היא רק מתי מתחילים.',
            'faqs' => array(
                array( 'q' => 'כמה רילסים אתם מפיקים ביום צילומים?', 'a' => 'ביום צילום ממוצע אנחנו מפיקים חומר גלם ל-8-15 רילסים. העריכה לוקחת עוד כמה ימים, ואתם מקבלים את הסרטונים הסופיים מוכנים לפרסום.' ),
                array( 'q' => 'מה הפורמט? רק רילסים?', 'a' => 'בעיקר רילסים ו-Shorts - כי שם הקהל. אבל אנחנו מפיקים גם סרטוני מותג ארוכים יותר לאתר, סטוריז, ותוכן ל-TikTok. הפורמט מותאם למטרה.' ),
                array( 'q' => 'צריך שחקנים או סטטיסטים?', 'a' => 'בדרך כלל לא. אנחנו מצלמים את האוכל, את הצוות ואת האווירה. הסרטונים הכי אותנטיים הם אלה שמציגים את המסעדה כמו שהיא - בלי העמדה מוגזמת.' ),
                array( 'q' => 'אפשר להשתמש ברילסים גם לפרסום ממומן?', 'a' => 'בהחלט, ואנחנו ממליצים על זה. רילסים מצולמים מקצועית עובדים מצוין כקריאייטיב לקמפיינים. אם אתם לקוחות שלנו גם בקמפיינים, אנחנו מתאמים את התוכן מראש.' ),
            ),
        ),

        /* -- 7. ניהול מוניטין וביקורות -- */
        array(
            'name'      => 'ניהול מוניטין וביקורות',
            'slug'      => 'reputation',
            'category'  => 'social-content',
            'icon'      => 'reputation',
            'custom_icon' => '',
            'excerpt'   => 'Google, TripAdvisor - מענה מקצועי ואסטרטגיית ביקורות',
            'color'     => '#c9a84c',
            'order'     => 7,
            'status'    => 'publish',
            'hero_image' => '',
            'content'   => 'רוב הסועדים בודקים ביקורות לפני שהם מזמינים שולחן. ביקורת שלילית אחת בלי מענה מקצועי יכולה לעלות לכם עשרות לקוחות - ומסעדה עם ביקורות מעטות, גם אם הן מעולות, פשוט לא מצליחה להתחרות על תשומת הלב. אנחנו בונים אסטרטגיה שלמה סביב המוניטין האונליין של המסעדה - מעידוד לקוחות מרוצים להשאיר ביקורת בצורה טבעית, דרך מענה מקצועי ואדיב לכל ביקורת - חיובית ושלילית - ועד ניטור שוטף של כל מה שנאמר עליכם ב-Google, ב-TripAdvisor וברשתות. אנחנו הופכים את המוניטין שלכם מנקודת תורפה לנשק שיווקי.',
            'video_url' => '',
            'cta_title' => 'רוצים מוניטין 5 כוכבים?',
            'cta_text'  => 'ניהול מוניטין שמביא אמינות ולקוחות חדשים.',
            'cta_btn'   => 'דברו איתנו',
            'benefits'  => array(
                array( 'icon' => '📋', 'title' => 'אסטרטגיית איסוף ביקורות',  'desc' => 'מנגנונים חכמים לעידוד ביקורות חיוביות - QR, SMS, WhatsApp' ),
                array( 'icon' => '💬', 'title' => 'מענה מקצועי',               'desc' => 'תגובות מותאמות לכל ביקורת - חיובית ושלילית' ),
                array( 'icon' => '🔍', 'title' => 'ניטור שוטף',                'desc' => 'מעקב יומי אחרי ביקורות חדשות ב-Google, TripAdvisor וברשתות' ),
                array( 'icon' => '📊', 'title' => 'דוח מוניטין חודשי',         'desc' => 'סיכום ציון, מגמות, נושאים חוזרים והמלצות לשיפור' ),
                array( 'icon' => '📈', 'title' => 'בניית אמינות',              'desc' => 'שיפור מתמיד של הציון הממוצע וכמות הביקורות' ),
                array( 'icon' => '🛡️', 'title' => 'ניהול משברים',              'desc' => 'טיפול מקצועי בביקורות שליליות חריגות או משברי מוניטין' ),
                array( 'icon' => '👥', 'title' => 'הדרכת צוות',                'desc' => 'הנחיות לצוות המסעדה לעידוד ביקורות באופן טבעי' ),
                array( 'icon' => '🧠', 'title' => 'ניתוח סנטימנט',            'desc' => 'ניתוח נושאים חוזרים בביקורות לשיפור חוויית הלקוח' ),
            ),
            'process'   => array(
                array( 'number' => '01', 'title' => 'מיפוי מוניטין',     'desc' => 'סקירה מלאה של הנוכחות בכל הפלטפורמות' ),
                array( 'number' => '02', 'title' => 'הגדרת מדיניות',     'desc' => 'בניית מדיניות תגובה ואיסוף ביקורות' ),
                array( 'number' => '03', 'title' => 'ניהול שוטף',        'desc' => 'מענה יומי, ניטור, ואיסוף ביקורות פעיל' ),
                array( 'number' => '04', 'title' => 'דיווח',             'desc' => 'דוח מוניטין חודשי עם מגמות וציונים' ),
            ),
            'metrics'   => array(
                array( 'number' => '4.7+', 'desc' => 'ציון ממוצע בגוגל אצל הלקוחות שלנו' ),
                array( 'number' => '+200%', 'desc' => 'גידול בכמות הביקורות החיוביות' ),
            ),
            'gallery'   => array(),
            'closing_text' => 'כל יום שעובר עם ביקורת שלילית בלי מענה - עולה לכם לקוחות. כל שבוע בלי אסטרטגיית ביקורות - עולה לכם דירוג. בואו נהפוך את המוניטין שלכם ליתרון תחרותי.',
            'faqs' => array(
                array( 'q' => 'איך אתם גורמים ללקוחות להשאיר ביקורות?', 'a' => 'אנחנו בונים מערכת אוטומטית שמזהה לקוחות מרוצים ושולחת להם הזמנה להשאיר ביקורת - ברגע הנכון, בצורה טבעית ולא מאולצת. שום דבר מזויף.' ),
                array( 'q' => 'מה עושים עם ביקורות שליליות?', 'a' => 'מגיבים מהר, בצורה מקצועית ואמפתית. לא מתנצחים, לא מתגוננים. ביקורת שלילית עם תגובה טובה יכולה דווקא לחזק את האמון. אנחנו מתאמים את התגובה אתכם לפני פרסום.' ),
                array( 'q' => 'כמה זמן לוקח לשפר דירוג ב-Google?', 'a' => 'עם אסטרטגיה עקבית, רוב המסעדות רואות שיפור של 0.3-0.5 כוכבים תוך 2-3 חודשים. זה תהליך מתמשך - לא קסם של לילה אחד, אבל התוצאות מגיעות ומחזיקות.' ),
                array( 'q' => 'אתם גם מטפלים בביקורות ב-TripAdvisor?', 'a' => 'כן, אנחנו מנהלים את המוניטין שלכם בכל הפלטפורמות - Google, TripAdvisor, Facebook, ואפילו ביקורות בפלטפורמות המשלוחים. הכל ממקום אחד.' ),
            ),
        ),

        /* -- 8. מיתוג מסעדות -- */
        array(
            'name'      => 'מיתוג מסעדות',
            'slug'      => 'branding',
            'category'  => 'branding-presence',
            'icon'      => 'branding',
            'custom_icon' => '',
            'excerpt'   => 'לוגו, זהות חזותית, שפה עיצובית וקונספט',
            'color'     => '#c9a84c',
            'order'     => 8,
            'status'    => 'publish',
            'hero_image' => '',
            'content'   => 'מיתוג מסעדה הוא הרבה יותר מלוגו יפה. זו ההחלטה איך המסעדה מרגישה, איך היא מדברת, ומה אנשים אומרים עליה כשהם ממליצים לחברים. אנחנו בונים זהות מותגית שלמה - מהלוגו ופלטת הצבעים, דרך הטיפוגרפיה, הצורות והאווירה, ועד לכל נקודת מגע: התפריט, האתר, הרשתות החברתיות, האריזות ועיצוב הפנים. הכל מתחבר לסיפור אחד קוהרנטי שעובד - כזה שגורם לסועד להרגיש שהוא לא סתם אוכל ארוחה, אלא נכנס לעולם שלם.',
            'video_url' => '',
            'cta_title' => 'מוכנים למותג שמחבר?',
            'cta_text'  => 'בואו נבנה זהות מותגית שהלקוחות לא ישכחו.',
            'cta_btn'   => 'דברו איתנו',
            'benefits'  => array(
                array( 'icon' => '💎', 'title' => 'לוגו ולוגוטייפ',            'desc' => 'עיצוב לוגו ייחודי שמבטא את הרוח והקונספט של המסעדה' ),
                array( 'icon' => '🎨', 'title' => 'שפה עיצובית',               'desc' => 'פלטת צבעים, טיפוגרפיה, אלמנטים גרפיים וקו מנחה' ),
                array( 'icon' => '📘', 'title' => 'מדריך מותג',                'desc' => 'מסמך Brand Guidelines שמנחה כל עיצוב עתידי' ),
                array( 'icon' => '📦', 'title' => 'עיצוב אריזות',              'desc' => 'שקיות, קופסאות משלוח, מפיות ופריטים ממותגים' ),
                array( 'icon' => '📱', 'title' => 'אדפטציה דיגיטלית',          'desc' => 'התאמת המיתוג לרשתות חברתיות, אתר ופלטפורמות' ),
                array( 'icon' => '📋', 'title' => 'עיצוב כרטיס ביקור',         'desc' => 'כרטיס ביקור ממותג לבעלים ולצוות ניהול' ),
                array( 'icon' => '🪧', 'title' => 'עיצוב שילוט',               'desc' => 'שילוט חוץ, שילוט פנים, סטנדים ובאנרים' ),
                array( 'icon' => '🖨️', 'title' => 'עיצוב פריטי דפוס',          'desc' => 'תחתיות, מפות שולחן, פלייסמטים ופריטי מותג' ),
            ),
            'process'   => array(
                array( 'number' => '01', 'title' => 'מחקר ואפיון',     'desc' => 'ניתוח קהל, מתחרים, ומגמות בשוק' ),
                array( 'number' => '02', 'title' => 'פיתוח קונספט',    'desc' => 'בניית סיפור מותג וכיוון עיצובי' ),
                array( 'number' => '03', 'title' => 'עיצוב',           'desc' => 'לוגו, צבעים, טיפוגרפיה, ושפה ויזואלית' ),
                array( 'number' => '04', 'title' => 'יישום',           'desc' => 'יישום על כל נקודות המגע - דיגיטל ודפוס' ),
            ),
            'metrics'   => array(
                array( 'number' => '+85%', 'desc' => 'זיהוי מותג מוגבר אצל הלקוחות' ),
                array( 'number' => '+40%', 'desc' => 'עלייה בנאמנות לקוחות' ),
            ),
            'gallery'   => array(),
            'closing_text' => 'מסעדה בלי מותג ברור היא עוד מקום לאכול. מסעדה עם מותג חזק היא חוויה שאנשים מחפשים. מוכנים להפוך מאפשרות לבחירה ראשונה?',
            'faqs' => array(
                array( 'q' => 'כמה זמן לוקח תהליך מיתוג?', 'a' => 'תהליך מיתוג מלא לוקח בין 4 ל-8 שבועות - מהבריף הראשוני ועד לאספקת כל החומרים. לוגו בלבד לוקח 2-3 שבועות. אנחנו לא ממהרים - כי מיתוג שנעשה נכון מלווה אתכם שנים.' ),
                array( 'q' => 'מה כולל חבילת מיתוג מלאה?', 'a' => 'לוגו, פלטת צבעים, טיפוגרפיה, שפה עיצובית, מדריך מותג, עיצוב תפריט, כרטיס ביקור, ואדפטציה דיגיטלית לכל הפלטפורמות. הכל בקובץ מסודר שאפשר להעביר לכל ספק.' ),
                array( 'q' => 'אם כבר יש לי לוגו, אפשר רק לרענן?', 'a' => 'כמובן. לא תמיד צריך להתחיל מאפס. לפעמים רענון של הלוגו הקיים, עדכון פלטת הצבעים, ויצירת שפה עיצובית סביבו זה בדיוק מה שצריך.' ),
                array( 'q' => 'אתם גם מעצבים אריזות למשלוחים?', 'a' => 'כן. אריזות משלוחים הן נקודת מגע קריטית עם הלקוח - ועיצוב טוב הופך משלוח רגיל לחוויה. אנחנו מעצבים שקיות, קופסאות, מדבקות, ומוסיפים נגיעות שגורמות ללקוח לצלם ולשתף.' ),
            ),
        ),

        /* -- 9. עיצוב תפריט דיגיטלי -- */
        array(
            'name'      => 'עיצוב תפריט דיגיטלי',
            'slug'      => 'menu-design',
            'category'  => 'branding-presence',
            'icon'      => 'menu-design',
            'custom_icon' => '',
            'excerpt'   => 'QR, דפוס, פלטפורמות - Menu Engineering',
            'color'     => '#c9a84c',
            'order'     => 9,
            'status'    => 'publish',
            'hero_image' => '',
            'content'   => 'התפריט הוא כלי המכירה החזק ביותר שיש למסעדה - וגם הכי מזולזל. עיצוב תפריט חכם עם היררכיה ברורה, מיקום אסטרטגי של מנות רווחיות, תמחור נכון שלא מבהיל ותמונות שעושות חשק - יכול להגדיל את הצ\'ק הממוצע ב-15-25%. אנחנו מעצבים תפריטים דיגיטליים ומודפסים עם עקרונות של Menu Engineering - שיטה שמבוססת על פסיכולוגיה צרכנית שמכוונת את העין של הסועד בדיוק לאן שאתם רוצים. לא סתם תפריט יפה - תפריט שמוכר.',
            'video_url' => '',
            'cta_title' => 'רוצים תפריט שמגדיל מכירות?',
            'cta_text'  => 'עיצוב תפריט מקצועי שגורם ללקוחות להזמין יותר.',
            'cta_btn'   => 'דברו איתנו',
            'benefits'  => array(
                array( 'icon' => '📱', 'title' => 'עיצוב תפריט דיגיטלי',       'desc' => 'תפריט QR Code מותאם למובייל עם עיצוב ממותג' ),
                array( 'icon' => '🖨️', 'title' => 'עיצוב תפריט לדפוס',         'desc' => 'עיצוב מוכן להדפסה - A3, A4 או פורמט ייחודי' ),
                array( 'icon' => '📊', 'title' => 'Menu Engineering',           'desc' => 'ניתוח רווחיות ופופולריות מנות, מיקום אסטרטגי בתפריט' ),
                array( 'icon' => '🛵', 'title' => 'התאמה לפלטפורמות',           'desc' => 'עדכון תפריט ב-Wolt, 10bis, Cibus, Tabit ואתר' ),
                array( 'icon' => '📅', 'title' => 'עדכונים עונתיים',            'desc' => 'עיצוב תפריטים עונתיים, חגים ומבצעים מיוחדים' ),
                array( 'icon' => '🌐', 'title' => 'תפריט רב-שפתי',             'desc' => 'עיצוב תפריט בעברית ובאנגלית לקהל תיירים' ),
                array( 'icon' => '🍷', 'title' => 'עיצוב תפריט משקאות',        'desc' => 'תפריט בר, קוקטיילים, יינות - עיצוב ייעודי' ),
                array( 'icon' => '💰', 'title' => 'ייעוץ תמחור',               'desc' => 'המלצות לתמחור חכם שמגדיל את הצ\'ק הממוצע' ),
            ),
            'process'   => array(
                array( 'number' => '01', 'title' => 'אפיון ותכנון',    'desc' => 'סקירת התפריט הקיים ותכנון המבנה החדש' ),
                array( 'number' => '02', 'title' => 'צילום מנות',       'desc' => 'צילום מקצועי של כל המנות' ),
                array( 'number' => '03', 'title' => 'עיצוב',            'desc' => 'עיצוב התפריט בהתאם לזהות המותגית' ),
                array( 'number' => '04', 'title' => 'הפצה',             'desc' => 'העלאה לכל הפלטפורמות + הדפסה' ),
            ),
            'metrics'   => array(
                array( 'number' => '+20%',  'desc' => 'גידול בצ\'ק הממוצע' ),
                array( 'number' => '+35%',  'desc' => 'עלייה בהזמנות מקוונות' ),
            ),
            'gallery'   => array(),
            'closing_text' => 'התפריט הנוכחי שלכם כנראה עולה לכם כסף בלי שאתם יודעים. תפריט מעוצב נכון יכול להגדיל את הצ\'ק הממוצע ב-15-25%. זה לא קסם - זה Menu Engineering.',
            'faqs' => array(
                array( 'q' => 'מה זה Menu Engineering?', 'a' => 'זו שיטה שמבוססת על פסיכולוגיה צרכנית - מיקום אסטרטגי של מנות, היררכיה ויזואלית, ותמחור חכם שמכוון את העין של הסועד למנות שאתם רוצים שהוא יזמין. זה לא סתם עיצוב יפה - זה עיצוב שמוכר.' ),
                array( 'q' => 'כמה עולה עיצוב תפריט?', 'a' => 'תלוי בהיקף - כמה מנות, כמה שפות, דפוס או דיגיטלי. אנחנו מתאימים הצעה ספציפית אחרי שמבינים מה צריך. המחיר כולל עיצוב, Menu Engineering, ורביזיות.' ),
                array( 'q' => 'אתם גם מעדכנים את התפריט כשמשתנות מנות?', 'a' => 'כן. אנחנו מציעים שירות תחזוקה שוטף - כל פעם שמשתנה מנה, מחיר או עונה, אנחנו מעדכנים את התפריט הדיגיטלי. ככה הוא תמיד מדויק.' ),
                array( 'q' => 'מה עם תפריט QR?', 'a' => 'בהחלט. אנחנו מעצבים תפריט דיגיטלי שנפתח ב-QR, מותאם לנייד, נטען מהר, ונראה מעולה. אפשר לעדכן אותו בזמן אמת בלי להדפיס מחדש.' ),
            ),
        ),

        /* -- 10. בניית אתר למסעדה -- */
        array(
            'name'      => 'בניית אתר למסעדה',
            'slug'      => 'website',
            'category'  => 'branding-presence',
            'icon'      => 'website',
            'custom_icon' => '',
            'excerpt'   => 'עיצוב, פיתוח, SEO מובנה - מובייל-פירסט',
            'color'     => '#c9a84c',
            'order'     => 10,
            'status'    => 'publish',
            'hero_image' => '',
            'content'   => 'אתר למסעדה צריך לעשות שלושה דברים: להיראות מדהים, להיטען מהר, ולהמיר מבקרים ללקוחות. לא צריך 50 עמודים - צריך עמודים נכונים שעובדים קשה. אנחנו בונים אתרים שמותאמים ספציפית למסעדות - מובייל-פירסט כי שם הלקוחות שלכם, עם תפריט מעודכן שאפשר לשנות בקלות, אינטגרציה מלאה עם פלטפורמות הזמנות ומשלוחים, וקידום SEO מובנה שגורם לכם להופיע ב-Google כשמישהו מחפש מסעדה באזור שלכם. האתר שלנו לא סתם נכס דיגיטלי - הוא מכונת המרה שעובדת 24/7.',
            'video_url' => '',
            'cta_title' => 'מוכנים לאתר שעובד בשבילכם?',
            'cta_text'  => 'אתר מקצועי שמביא לקוחות ומגדיל הזמנות.',
            'cta_btn'   => 'דברו איתנו',
            'benefits'  => array(
                array( 'icon' => '🎨', 'title' => 'עיצוב ממותג',               'desc' => 'עיצוב ייחודי שמתאים לזהות המותגית של המסעדה' ),
                array( 'icon' => '📱', 'title' => 'פיתוח מובייל-פירסט',        'desc' => 'אתר שנראה ועובד מושלם בסלולר - כי שם הלקוחות' ),
                array( 'icon' => '🔍', 'title' => 'SEO מובנה',                 'desc' => 'קידום אורגני מובנה - כותרות, תיאורים, מהירות ומבנה נכון' ),
                array( 'icon' => '📋', 'title' => 'תפריט אונליין',             'desc' => 'תפריט דיגיטלי משולב באתר עם אפשרות לעדכון עצמאי' ),
                array( 'icon' => '🔗', 'title' => 'אינטגרציות',                'desc' => 'חיבור להזמנות שולחן, משלוחים, Google Maps ו-WhatsApp' ),
                array( 'icon' => '🛡️', 'title' => 'אחסון ותחזוקה',             'desc' => 'אחסון מהיר, גיבויים ותחזוקה שוטפת' ),
                array( 'icon' => '🚀', 'title' => 'דף נחיתה לקמפיינים',        'desc' => 'עמודי נחיתה ייעודיים למבצעים ולקמפיינים ממומנים' ),
                array( 'icon' => '📊', 'title' => 'אנליטיקס',                  'desc' => 'התקנת Google Analytics ו-Pixel לצורך מדידה ומעקב' ),
            ),
            'process'   => array(
                array( 'number' => '01', 'title' => 'אפיון',    'desc' => 'הבנת הצרכים, מבנה האתר, ודרישות טכניות' ),
                array( 'number' => '02', 'title' => 'עיצוב',    'desc' => 'עיצוב UI/UX מותאם לזהות המותגית' ),
                array( 'number' => '03', 'title' => 'פיתוח',    'desc' => 'בניית האתר, מערכות הזמנה, ואינטגרציות' ),
                array( 'number' => '04', 'title' => 'השקה',     'desc' => 'בדיקות, אופטימיזציה, והעלאה לאוויר' ),
            ),
            'metrics'   => array(
                array( 'number' => '+150%', 'desc' => 'גידול בלידים מהאתר' ),
                array( 'number' => '85%',   'desc' => 'מהגלישה מגיעה מהנייד' ),
            ),
            'gallery'   => array(),
            'closing_text' => '65% מהלקוחות הפוטנציאליים שלכם מחפשים אתכם ב-Google עכשיו. מה הם מוצאים? אם התשובה היא לא אתר שמפיל, אתם מפסידים לקוחות כל יום. בואו נתקן את זה.',
            'faqs' => array(
                array( 'q' => 'כמה זמן לוקח לבנות אתר?', 'a' => 'אתר למסעדה בדרך כלל מוכן תוך 3-5 שבועות - מעיצוב ועד עלייה לאוויר. אתרים מורכבים יותר עם הזמנות אונליין ואינטגרציות רבות יכולים לקחת 6-8 שבועות.' ),
                array( 'q' => 'האתר יהיה מותאם לנייד?', 'a' => 'כמובן. אנחנו בונים מובייל-פירסט - כלומר, מעצבים קודם כל לנייד ואז מרחיבים לדסקטופ. כי 70%+ מהגולשים שלכם מגיעים מהטלפון.' ),
                array( 'q' => 'אני יכול לעדכן תוכן בעצמי?', 'a' => 'כן. אנחנו בונים את האתר עם מערכת ניהול פשוטה שמאפשרת לכם לעדכן תפריט, תמונות ושעות פעילות בלי לדעת קוד. ואם תרצו - אנחנו מעדכנים בשבילכם.' ),
                array( 'q' => 'מה עם SEO?', 'a' => 'כל אתר שאנחנו בונים מגיע עם SEO מובנה - מבנה נכון, מטא-תגיות, סכמה, מהירות טעינה, ואופטימיזציה ל-Google Business. ככה אתם מתחילים במקום טוב מהיום הראשון.' ),
            ),
        ),

        /* -- 11. אופטימיזציית משלוחים -- */
        array(
            'name'      => 'אופטימיזציית משלוחים',
            'slug'      => 'delivery-optimization',
            'category'  => 'platform-management',
            'icon'      => 'delivery-optimization',
            'custom_icon' => '',
            'excerpt'   => 'Wolt, 10bis, Cibus - דירוג, תמונות, רווחיות',
            'color'     => '#c9a84c',
            'order'     => 11,
            'status'    => 'publish',
            'hero_image' => '',
            'content'   => 'פלטפורמות המשלוחים יכולות להיות מנוע צמיחה משמעותי - או בור כספי שבולע את הרווח. ההבדל הוא בניהול. תמונות מקצועיות של מנות שגורמות לאנשים ללחוץ, תיאורים שמוכרים ולא סתם מתארים, תמחור חכם שסופג עמלות בלי להבריח לקוחות, ודירוג גבוה שמציב אתכם בראש הרשימה כשמישהו פותח את Wolt בשעה 8 בערב. אנחנו מנהלים את הנוכחות שלכם ב-Wolt, 10bis ו-Cibus מקצה לקצה - ומוודאים שכל הזמנה שנכנסת שווה לכם יותר.',
            'video_url' => '',
            'cta_title' => 'רוצים למקסם הכנסות ממשלוחים?',
            'cta_text'  => 'אופטימיזציה מלאה שמגדילה הזמנות ומקטינה עמלות.',
            'cta_btn'   => 'דברו איתנו',
            'benefits'  => array(
                array( 'icon' => '📋', 'title' => 'ניהול פרופיל',               'desc' => 'עדכון תפריטים, תמונות, שעות פעילות ומידע בכל הפלטפורמות' ),
                array( 'icon' => '📸', 'title' => 'אופטימיזציית תמונות',        'desc' => 'צילום או עריכת תמונות מנות מותאמות לדרישות הפלטפורמה' ),
                array( 'icon' => '💰', 'title' => 'ניתוח עמלות ורווחיות',       'desc' => 'בדיקת רווחיות לכל מנה ולכל פלטפורמה - תמחור חכם' ),
                array( 'icon' => '📈', 'title' => 'שיפור דירוג',                'desc' => 'אסטרטגיה לשיפור הדירוג והנראות בתוצאות החיפוש' ),
                array( 'icon' => '🎉', 'title' => 'ניהול מבצעים',               'desc' => 'תכנון והפעלת מבצעים אסטרטגיים בפלטפורמות' ),
                array( 'icon' => '📊', 'title' => 'דוחות חודשיים',              'desc' => 'נתוני הזמנות, הכנסות, ביטולים ומגמות' ),
                array( 'icon' => '🚫', 'title' => 'ניהול ביטולים',              'desc' => 'צמצום ביטולים ושיפור שביעות רצון לקוחות המשלוחים' ),
                array( 'icon' => '🤝', 'title' => 'משא ומתן עם פלטפורמות',     'desc' => 'ניהול יחסים מול Wolt, 10bis ו-Cibus לשיפור תנאים' ),
            ),
            'process'   => array(
                array( 'number' => '01', 'title' => 'אודיט נוכחי',      'desc' => 'סקירת הפרופילים הקיימים בכל הפלטפורמות' ),
                array( 'number' => '02', 'title' => 'אופטימיזציה',      'desc' => 'שדרוג תפריט, תמונות, תיאורים ומחירים' ),
                array( 'number' => '03', 'title' => 'ניהול שוטף',       'desc' => 'עדכון מבצעים, מעקב דירוג, וניהול ביקורות' ),
                array( 'number' => '04', 'title' => 'דיווח ושיפור',     'desc' => 'דוחות חודשיים ואופטימיזציה מתמשכת' ),
            ),
            'metrics'   => array(
                array( 'number' => '+50%',  'desc' => 'גידול ממוצע בהכנסות ממשלוחים' ),
                array( 'number' => '-25%',  'desc' => 'הפחתה בעמלות אפקטיביות' ),
            ),
            'gallery'   => array(),
            'closing_text' => 'כל הזמנה שנכנסת דרך Wolt או 10bis יכולה להיות רווחית - או להפסיד לכם כסף. ההבדל הוא בניהול. תנו לנו להסתכל על המספרים שלכם - בחינם, בלי התחייבות.',
            'faqs' => array(
                array( 'q' => 'באיזה פלטפורמות אתם עובדים?', 'a' => 'Wolt, 10bis, Cibus, ופלטפורמות נוספות. אנחנו מנהלים את הפרופיל בכולן - תמונות, תיאורים, תמחור ומבצעים.' ),
                array( 'q' => 'איך אפשר להפחית עמלות?', 'a' => 'אנחנו מנתחים את מבנה העמלות, בודקים אילו מבצעים משתלמים ואילו לא, ומנהלים משא ומתן מול הפלטפורמות. בנוסף, אנחנו עוזרים להעביר לקוחות להזמנה ישירה כשזה אפשרי.' ),
                array( 'q' => 'התמונות באפליקציה לא נראות טוב. אפשר לשפר?', 'a' => 'בהחלט, וזה אחד הדברים הראשונים שאנחנו עושים. תמונות מקצועיות בפלטפורמות המשלוחים יכולות להכפיל את ההזמנות. אנחנו מצלמים ומעלים תמונות שמותאמות לפורמט של כל פלטפורמה.' ),
                array( 'q' => 'איך משפרים דירוג ב-Wolt?', 'a' => 'דירוג ב-Wolt מושפע מזמן הכנה, ביטולים, ביקורות, ומבצעים. אנחנו עובדים על כל הפרמטרים האלה - מייעלים תהליכי הכנה, מפחיתים ביטולים, ומנהלים מבצעים חכמים שמעלים את הדירוג.' ),
            ),
        ),

        /* -- 12. אופטימיזציית הזמנות שולחן -- */
        array(
            'name'      => 'אופטימיזציית הזמנות שולחן',
            'slug'      => 'reservation-optimization',
            'category'  => 'platform-management',
            'icon'      => 'reservation-optimization',
            'custom_icon' => '',
            'excerpt'   => 'Tabit, Eatbit, Google - תפוסה מקסימלית, מינימום No-shows',
            'color'     => '#c9a84c',
            'order'     => 12,
            'status'    => 'publish',
            'hero_image' => '',
            'content'   => 'שולחן ריק בערב שישי הוא כסף שהלך. מערכות ההזמנות הפכו לחלק בלתי נפרד מניהול מסעדה - אבל לא מספיק שיש מערכת. צריך לדעת לנצל אותה. מהגדרת שולחנות וסיבובים אופטימליים, דרך ניהול תפוסה חכם שממקסם כל ערב, ועד מניעת No-shows עם תזכורות אוטומטיות שחוסכות לכם אלפי שקלים בחודש. אנחנו עובדים עם Tabit, Eatbit, Google ופלטפורמות נוספות - ומוודאים שכל ערב, המסעדה שלכם מלאה ככל האפשר.',
            'video_url' => '',
            'cta_title' => 'רוצים שולחנות מלאים כל ערב?',
            'cta_text'  => 'אופטימיזציה של מערכת ההזמנות שמביאה תפוסה מלאה.',
            'cta_btn'   => 'דברו איתנו',
            'benefits'  => array(
                array( 'icon' => '⚙️', 'title' => 'הגדרת מערכת',                'desc' => 'הגדרת שולחנות, תפוסה, סיבובים וכללי הזמנה אופטימליים' ),
                array( 'icon' => '🔔', 'title' => 'הפחתת No-shows',             'desc' => 'מערכת תזכורות אוטומטיות ב-WhatsApp ו-SMS' ),
                array( 'icon' => '📸', 'title' => 'אופטימיזציית פרופיל',         'desc' => 'עדכון תמונות, תיאורים ומידע בפלטפורמות ההזמנה' ),
                array( 'icon' => '📊', 'title' => 'ניתוח תפוסה',                'desc' => 'דוחות תפוסה, שעות שיא ומגמות הזמנות' ),
                array( 'icon' => '📍', 'title' => 'חיבור ל-Google',              'desc' => 'סינכרון הזמנות עם Google Business Profile' ),
                array( 'icon' => '📋', 'title' => 'ניהול רשימת המתנה',           'desc' => 'הפעלת רשימת המתנה חכמה לערבים מלאים' ),
                array( 'icon' => '🔄', 'title' => 'אופטימיזציית סיבובים',       'desc' => 'שיפור זמני ישיבה ומעברים למקסום כיסאות לערב' ),
                array( 'icon' => '📈', 'title' => 'דוחות ותובנות',              'desc' => 'ניתוח חודשי של דפוסי הזמנות, ביטולים ושעות שיא' ),
            ),
            'process'   => array(
                array( 'number' => '01', 'title' => 'ניתוח מצב קיים',  'desc' => 'מיפוי מערכות, תפוסה ממוצעת, ושיעור ביטולים' ),
                array( 'number' => '02', 'title' => 'אופטימיזציה',      'desc' => 'שדרוג פרופילים, שיפור זרימת הזמנה' ),
                array( 'number' => '03', 'title' => 'אוטומציות',        'desc' => 'הגדרת תזכורות, רשימת המתנה, ומעקב' ),
                array( 'number' => '04', 'title' => 'ניתוח ושיפור',     'desc' => 'דוחות תפוסה שבועיים ואופטימיזציה מתמשכת' ),
            ),
            'metrics'   => array(
                array( 'number' => '+35%', 'desc' => 'גידול בהזמנות שולחן' ),
                array( 'number' => '-60%', 'desc' => 'הפחתה בשיעור ביטולים' ),
            ),
            'gallery'   => array(),
            'closing_text' => 'כמה שולחנות ריקים היו לכם השבוע שלא היו צריכים להיות ריקים? כמה No-shows? אנחנו יכולים להפחית את המספר הזה משמעותית. בואו נדבר.',
            'faqs' => array(
                array( 'q' => 'עם אילו מערכות הזמנות אתם עובדים?', 'a' => 'Tabit, Eatbit, Google Reservations ומערכות נוספות. אנחנו מתאימים את האופטימיזציה למערכת שלכם.' ),
                array( 'q' => 'איך מפחיתים No-shows?', 'a' => 'שילוב של תזכורות SMS אוטומטיות, אישור הזמנה, ומדיניות ביטול ברורה. לקוחות שלנו רואים ירידה של 40-60% ב-No-shows תוך החודש הראשון.' ),
                array( 'q' => 'אפשר להגדיל את מספר ההזמנות בימים חלשים?', 'a' => 'כן. אנחנו משתמשים בקמפיינים ממוקדים, מבצעים לימים חלשים, ואופטימיזציית פרופיל שמעודדת הזמנות בשעות שפל. בנוסף, חיבור לפרופיל Google עם כפתור הזמנה ישיר.' ),
                array( 'q' => 'כמה זמן לוקח לראות שיפור?', 'a' => 'שיפור בתפוסה וב-No-shows מורגש כבר בשבועות הראשונים. אופטימיזציה מלאה של המערכת לוקחת חודש-חודשיים, אבל תוצאות ראשונות מגיעות מהר.' ),
            ),
        ),

        /* -- 13. ניהול מועדון לקוחות -- */
        array(
            'name'      => 'ניהול מועדון לקוחות',
            'slug'      => 'loyalty',
            'category'  => 'platform-management',
            'icon'      => 'loyalty',
            'custom_icon' => '',
            'excerpt'   => 'נקודות, הטבות, WhatsApp - לקוחות שחוזרים שוב ושוב',
            'color'     => '#c9a84c',
            'order'     => 13,
            'status'    => 'publish',
            'hero_image' => '',
            'content'   => 'הלקוחות שכבר אכלו אצלכם ואהבו - הם הנכס הכי שווה שיש לכם. להביא לקוח חדש עולה פי 5 מלהחזיר לקוח קיים, ובכל זאת רוב המסעדות משקיעות 90% מהתקציב ברכישת לקוחות חדשים ומתעלמות מהקיימים. מועדון לקוחות דיגיטלי חכם מאפשר לכם להישאר בקשר, לתגמל נאמנות, ולהזכיר לאנשים שאתם כאן - בדיוק ברגע שהם שוקלים איפה לאכול הערב. אנחנו בונים מועדונים שעובדים - עם אוטומציות WhatsApp, הטבות שמרגישות אישיות, ודאטה שעוזרת לכם להבין מי הלקוחות הכי שווים שלכם.',
            'video_url' => '',
            'cta_title' => 'רוצים לקוחות שחוזרים?',
            'cta_text'  => 'מועדון לקוחות שמגדיל נאמנות וביקורים חוזרים.',
            'cta_btn'   => 'דברו איתנו',
            'benefits'  => array(
                array( 'icon' => '💳', 'title' => 'מערכת נקודות',               'desc' => 'בניית תוכנית צבירה ומימוש שמעודדת ביקורים חוזרים' ),
                array( 'icon' => '📱', 'title' => 'WhatsApp + SMS',             'desc' => 'קמפיינים ממוקדים בערוצים ישירים עם אחוזי פתיחה של 95%' ),
                array( 'icon' => '🤖', 'title' => 'אוטומציות',                  'desc' => 'הודעות אוטומטיות ליום הולדת, חגים ותקופות חוסר פעילות' ),
                array( 'icon' => '📊', 'title' => 'ניתוח התנהגות',              'desc' => 'הבנת דפוסי ביקור, ערך לקוח ופילוח קהלים חכם' ),
                array( 'icon' => '📈', 'title' => 'דוחות מועדון',               'desc' => 'סיכום חודשי - חברים חדשים, מימושים, ערך הטבות ו-ROI' ),
                array( 'icon' => '🎉', 'title' => 'קמפיינים עונתיים',           'desc' => 'מבצעים ייעודיים לחגים, עונות ואירועים מיוחדים' ),
                array( 'icon' => '⭐', 'title' => 'הטבות VIP',                  'desc' => 'בניית תוכנית הטבות לפי רמות - רגיל, כסף, זהב' ),
                array( 'icon' => '🔗', 'title' => 'אינטגרציה עם קופה',          'desc' => 'חיבור מועדון הלקוחות למערכת הקופה לזיהוי אוטומטי' ),
            ),
            'process'   => array(
                array( 'number' => '01', 'title' => 'הקמה',              'desc' => 'בחירת פלטפורמה, עיצוב, והגדרת מבנה הטבות' ),
                array( 'number' => '02', 'title' => 'גיוס חברים',        'desc' => 'אסטרטגיה לגיוס מהיר של חברים בנקודת המכירה' ),
                array( 'number' => '03', 'title' => 'ניהול שוטף',        'desc' => 'שליחת קמפיינים, ניהול הטבות, ומעורבות' ),
                array( 'number' => '04', 'title' => 'ניתוח וצמיחה',      'desc' => 'דוחות ביצועים, ניתוח ROI, ושיפור מתמשך' ),
            ),
            'metrics'   => array(
                array( 'number' => '+35%', 'desc' => 'גידול בתדירות ביקורים חוזרים' ),
                array( 'number' => '5x',   'desc' => 'ערך לקוח חוזר לעומת לקוח חדש' ),
                array( 'number' => '95%',  'desc' => 'אחוז פתיחה של הודעות WhatsApp' ),
            ),
            'gallery'   => array(),
            'closing_text' => 'יש לכם מאות לקוחות שאכלו אצלכם ונהנו - אבל לא חזרו. לא כי לא אהבו, אלא כי שכחו. מועדון לקוחות חכם מזכיר להם בדיוק ברגע הנכון. מוכנים להפסיק לאבד לקוחות?',
            'faqs' => array(
                array( 'q' => 'מה הפלטפורמה שאתם משתמשים בה?', 'a' => 'אנחנו עובדים עם מספר פלטפורמות ובוחרים את הכי מתאימה למסעדה שלכם - בהתאם לגודל, לתקציב ולמה שכבר קיים. לפעמים מספיק WhatsApp חכם, לפעמים צריך מערכת מלאה עם אפליקציה.' ),
                array( 'q' => 'כמה לקוחות צריך כדי שמועדון יהיה שווה?', 'a' => 'כבר מ-200-300 חברים אפשר לראות תוצאות. אבל הערך האמיתי מתחיל כש-1,000+ לקוחות רשומים. אנחנו בונים אסטרטגיה לגיוס חברים מהיום הראשון.' ),
                array( 'q' => 'הלקוחות לא יעצבנו מהודעות?', 'a' => 'לא אם עושים את זה נכון. אנחנו שולחים הודעות רלוונטיות, בתדירות סבירה, עם ערך אמיתי - הטבות, הזמנות לאירועים, ומבצעים שבאמת שווים. לקוח שמרגיש שהוא מקבל ערך לא מתנתק.' ),
                array( 'q' => 'איך מודדים את ההצלחה של מועדון לקוחות?', 'a' => 'מודדים כמה חברים חדשים הצטרפו, כמה חברים חזרו לביקור נוסף, מה ה-Lifetime Value הממוצע, ומה ה-ROI של כל קמפיין. הכל בדוח חודשי ברור.' ),
            ),
        ),

        /* -- 14. קידום אורגני - SEO -- */
        array(
            'name'      => 'קידום אורגני - SEO',
            'slug'      => 'seo',
            'category'  => 'growth-measurement',
            'icon'      => 'seo',
            'custom_icon' => '',
            'excerpt'   => 'דירוג ב-Google, Business Profile, חיפוש מקומי',
            'color'     => '#c9a84c',
            'order'     => 14,
            'status'    => 'publish',
            'hero_image' => '',
            'content'   => 'קידום אורגני למסעדות שונה לחלוטין מ-SEO רגיל. פה הכל סובב סביב חיפוש מקומי - Google Maps, Google Business Profile, ותוצאות שקשורות למיקום. כשגולש מחפש מסעדה איטלקית בתל אביב או מקום לברנץ\' בהרצליה - אנחנו רוצים שאתם תופיעו ראשונים, לא המתחרה מהרחוב השני. אנחנו עובדים על אופטימיזציית פרופיל Google Business, בניית תוכן שמשרת חיפושים אורגניים, ניהול קישורים מקומיים ושיפור ביקורות - כל מה שגורם ל-Google לבחור דווקא אתכם.',
            'video_url' => '',
            'cta_title' => 'רוצים להופיע ראשונים בגוגל?',
            'cta_text'  => 'קידום אורגני שמביא לקוחות בלי לשלם על כל קליק.',
            'cta_btn'   => 'דברו איתנו',
            'benefits'  => array(
                array( 'icon' => '📍', 'title' => 'אופטימיזציית Google Business', 'desc' => 'עדכון פרטים, תמונות, קטגוריות, שעות ומאפיינים' ),
                array( 'icon' => '📝', 'title' => 'תוכן אורגני',                  'desc' => 'כתיבת תוכן ממוקד מילות מפתח מקומיות לאתר' ),
                array( 'icon' => '🔗', 'title' => 'קישורים מקומיים',              'desc' => 'בניית פרופיל קישורים מאתרי מזון, מדריכים ועיתונות' ),
                array( 'icon' => '⚙️', 'title' => 'אופטימיזציה טכנית',            'desc' => 'מהירות אתר, מובייל, Schema ומבנה נכון' ),
                array( 'icon' => '📊', 'title' => 'ניתוח ביצועים',                'desc' => 'מעקב אחרי דירוגים, חשיפה ותנועה אורגנית' ),
                array( 'icon' => '🔍', 'title' => 'מחקר מילות מפתח',             'desc' => 'מיפוי חיפושים רלוונטיים באזור המסעדה' ),
                array( 'icon' => '🗺️', 'title' => 'אופטימיזציית מפות',            'desc' => 'שיפור נראות ודירוג ב-Google Maps' ),
                array( 'icon' => '📈', 'title' => 'ניתוח מתחרים',                'desc' => 'מעקב אחרי דירוגי מתחרים ואיתור הזדמנויות' ),
            ),
            'process'   => array(
                array( 'number' => '01', 'title' => 'אודיט SEO',        'desc' => 'ניתוח המצב הנוכחי - דירוגים, מתחרים, הזדמנויות' ),
                array( 'number' => '02', 'title' => 'אופטימיזציה',      'desc' => 'שדרוג פרופיל גוגל, תוכן אתר, ונתונים מובנים' ),
                array( 'number' => '03', 'title' => 'בניית סמכות',      'desc' => 'יצירת קישורים, ציטוטים, ותוכן שוטף' ),
                array( 'number' => '04', 'title' => 'מעקב ודיווח',      'desc' => 'דוחות דירוג חודשיים ואופטימיזציה מתמשכת' ),
            ),
            'metrics'   => array(
                array( 'number' => 'Top 3', 'desc' => 'דירוג בגוגל מפות' ),
                array( 'number' => '+320%', 'desc' => 'גידול בלידים אורגניים' ),
            ),
            'gallery'   => array(),
            'closing_text' => 'כשמישהו מחפש עכשיו ב-Google מסעדה באזור שלכם - אתם מופיעים? אם לא, מישהו אחר מופיע במקומכם ולוקח את הלקוחות שלכם. כל חודש שעובר בלי SEO הוא חודש שהמתחרים צוברים יתרון.',
            'faqs' => array(
                array( 'q' => 'כמה זמן לוקח SEO עד שרואים תוצאות?', 'a' => 'SEO הוא תהליך של 3-6 חודשים. בחודש הראשון עושים אופטימיזציה טכנית ו-Google Business. אחרי 2-3 חודשים מתחילים לראות עלייה בדירוג. אחרי 6 חודשים התוצאות כבר משמעותיות ונשארות.' ),
                array( 'q' => 'מספיק רק Google Business?', 'a' => 'Google Business Profile זה חובה ובסיס מעולה - אבל לבד הוא לא מספיק. צריך גם תוכן באתר, קישורים מקומיים, ביקורות, ואופטימיזציה טכנית. אנחנו עובדים על כל הרבדים ביחד.' ),
                array( 'q' => 'אתם מבטיחים מקום ראשון ב-Google?', 'a' => 'אף אחד לא יכול להבטיח מקום ראשון - ומי שמבטיח משקר. מה שאנחנו כן מבטיחים: עבודה מקצועית, שקיפות מלאה, ושיפור מתמיד. ורוב הלקוחות שלנו מגיעים ל-3 התוצאות הראשונות.' ),
                array( 'q' => 'מה ההבדל בין SEO לקמפיינים ממומנים?', 'a' => 'קמפיינים ממומנים נותנים תוצאות מיידיות אבל עולים כסף כל חודש. SEO לוקח יותר זמן אבל בטווח הארוך מביא תנועה בחינם. האסטרטגיה הכי טובה משלבת את שניהם.' ),
            ),
        ),

        /* -- 15. אנליטיקס ודוחות -- */
        array(
            'name'      => 'אנליטיקס ודוחות',
            'slug'      => 'analytics',
            'category'  => 'growth-measurement',
            'icon'      => 'analytics',
            'custom_icon' => '',
            'excerpt'   => 'מדידה מדויקת, דשבורדים, החלטות מבוססות דאטה',
            'color'     => '#c9a84c',
            'order'     => 15,
            'status'    => 'publish',
            'hero_image' => '',
            'content'   => 'הנתונים הם חמצן לקבלת החלטות נכונות. בלי מדידה אתם יורים בחושך - משקיעים כסף ומקווים לטוב. עם מדידה - אתם יודעים בדיוק מה עובד, מה לא, מאיפה מגיעים הלקוחות, ואיפה כל שקל הולך. אנחנו בונים דשבורדים מותאמים למסעדות שמרכזים את כל הנתונים במקום אחד - תוצאות קמפיינים, ביצועי רשתות חברתיות, נתוני משלוחים, הזמנות שולחן ומועדון לקוחות. כל חודש אתם מקבלים דוח ברור עם מסקנות והמלצות - לא 50 עמודים של גרפים שאף אחד לא קורא, אלא תובנות שאפשר לפעול לפיהן כבר מחר.',
            'video_url' => '',
            'cta_title' => 'רוצים לראות את המספרים?',
            'cta_text'  => 'דשבורדים ודוחות שמביאים בהירות.',
            'cta_btn'   => 'דברו איתנו',
            'benefits'  => array(
                array( 'icon' => '📊', 'title' => 'דשבורד מרכזי',               'desc' => 'דשבורד אחד שמרכז נתונים מכל הפלטפורמות' ),
                array( 'icon' => '📋', 'title' => 'דוח חודשי',                  'desc' => 'דוח ביצועים מפורט עם מסקנות והמלצות בשפה ברורה' ),
                array( 'icon' => '🎯', 'title' => 'מעקב KPIs',                  'desc' => 'הגדרת ומעקב אחרי מדדי הצלחה ייעודיים למסעדה' ),
                array( 'icon' => '💰', 'title' => 'ניתוח ROI',                  'desc' => 'חישוב החזר ההשקעה על כל ערוץ וכל פעילות' ),
                array( 'icon' => '🧠', 'title' => 'תובנות ואופטימיזציה',        'desc' => 'המלצות מבוססות דאטה לשיפור ביצועים מתמיד' ),
                array( 'icon' => '📈', 'title' => 'Google Analytics',            'desc' => 'הגדרה, ניהול ופרשנות של נתוני האתר' ),
                array( 'icon' => '🔍', 'title' => 'מעקב המרות',                'desc' => 'הגדרת מעקב אחרי פעולות מפתח - שיחות, הזמנות, טפסים' ),
                array( 'icon' => '📅', 'title' => 'דוח שנתי',                   'desc' => 'סיכום ביצועים שנתי עם תוכנית אסטרטגית לשנה הבאה' ),
            ),
            'process'   => array(
                array( 'number' => '01', 'title' => 'הגדרת מדידה',      'desc' => 'התקנת כלים, הגדרת מטרות, וחיבור פלטפורמות' ),
                array( 'number' => '02', 'title' => 'בניית דשבורד',     'desc' => 'עיצוב דשבורד מותאם עם כל הנתונים הרלוונטיים' ),
                array( 'number' => '03', 'title' => 'ניתוח שוטף',       'desc' => 'מעקב יומי, זיהוי מגמות, ואיתור הזדמנויות' ),
                array( 'number' => '04', 'title' => 'דיווח והמלצות',    'desc' => 'דוח חודשי עם תובנות ותוכנית פעולה' ),
            ),
            'metrics'   => array(
                array( 'number' => '+40%', 'desc' => 'שיפור ביצועים מבוסס דאטה' ),
                array( 'number' => '100%', 'desc' => 'שקיפות בהוצאות ותוצאות' ),
            ),
            'gallery'   => array(),
            'closing_text' => 'אתם משקיעים כסף בשיווק. השאלה היא - אתם יודעים בדיוק מה כל שקל מביא? אם לא, אתם כנראה מבזבזים חלק ממנו. בואו נראה לכם את המספרים האמיתיים.',
            'faqs' => array(
                array( 'q' => 'מה בדיוק אני מקבל בדוח החודשי?', 'a' => 'דוח ברור עם: ביצועי קמפיינים, נתוני רשתות חברתיות, ביקורות חדשות, נתוני משלוחים והזמנות, השוואה לחודש קודם, ומסקנות עם המלצות. לא 50 עמודים - אלא 3-5 עמודים עם מה שחשוב.' ),
                array( 'q' => 'אני צריך להבין במספרים?', 'a' => 'ממש לא. אנחנו מתרגמים את הנתונים לשפה פשוטה ולתובנות מעשיות. במקום להגיד CTR ירד ב-0.3%, נגיד הקמפיין צריך תמונה חדשה כי אנשים מפסיקים ללחוץ.' ),
                array( 'q' => 'אתם גם מציעים שינויים או רק מראים מספרים?', 'a' => 'כל דוח מגיע עם המלצות פעולה ספציפיות. לא רק מה קרה, אלא מה צריך לעשות עכשיו. ורוב ההמלצות אנחנו מיישמים בעצמנו - לא מחכים שתגידו.' ),
                array( 'q' => 'אפשר לראות נתונים בזמן אמת?', 'a' => 'כן. אנחנו בונים דשבורד מותאם שמראה נתונים חיים - כמה לידים היום, כמה הזמנות, כמה ביקורות חדשות. גישה 24/7, מכל מקום.' ),
            ),
        ),

    ); // end services array
}

/**
 * Seed default services and categories into plugin options.
 * Callable from activation hook or admin reset button.
 *
 * @param bool $force  If true, overwrite existing data; if false, only fill if empty.
 */
function freshm_seed_default_services( $force = false ) {
    if ( $force || empty( get_option( 'freshm_service_categories', array() ) ) ) {
        update_option( 'freshm_service_categories', freshm_get_default_service_cats() );
    }
    if ( $force || empty( get_option( 'freshm_services_data', array() ) ) ) {
        update_option( 'freshm_services_data', freshm_get_default_services() );
    }

    // Sync to taxonomy + CPT
    if ( function_exists( 'freshm_sync_service_cats' ) ) {
        freshm_sync_service_cats( freshm_get_default_service_cats() );
    }
    if ( function_exists( 'freshm_sync_services_to_cpt' ) ) {
        freshm_sync_services_to_cpt( freshm_get_default_services() );
    }
}

/**
 * Admin handler for "Reset services to defaults" button.
 */
function freshm_reset_services_handler() {
    if ( ! isset( $_POST['freshm_reset_services'] ) || ! current_user_can( 'manage_options' ) ) return;
    check_admin_referer( 'freshm_reset_services_action', 'freshm_reset_services_nonce' );

    freshm_seed_default_services( true );

    wp_safe_redirect( add_query_arg( array( 'freshm_reset' => '1', 'tab' => 'list' ) ) );
    exit;
}
add_action( 'admin_init', 'freshm_reset_services_handler' );
