# FRESH — WordPress Theme

תמת וורדפרס פרימיום עבור סוכנות FRESH לשיווק דיגיטלי למסעדות.

## מאפיינים
- 🎨 עיצוב דארק פרימיום עם אקסנטים בזהב
- 🔄 תמיכה מלאה ב-RTL (עברית)
- 🧩 תואם לחלוטין ל-Elementor (כולל Theme Builder)
- 📱 רספונסיבי לכל המכשירים
- ⚡ קל ומהיר — ללא תלויות חיצוניות
- 🔧 Custom Post Types: שירותים, מקרי בוחן, צוות

## התקנה

1. העלו את קובץ ה-ZIP דרך **מראה > ערכות נושא > הוסף חדש > העלאה**
2. הפעילו את התמה

## הגדרות לאחר התקנה

### דפים ליצירה
צרו את הדפים הבאים ב-וורדפרס והגדירו להם את הסלאג המתאים:

| דף | Slug | תבנית |
|---|---|---|
| דף הבית | (הגדירו כדף סטטי) | Front Page (אוטומטי) |
| מי אנחנו | `about` | ברירת מחדל |
| שירותים | `services` | ברירת מחדל |
| הצלחות לקוחות | `portfolio` | ברירת מחדל |
| צור קשר | `contact` | ברירת מחדל |
| בלוג | (הגדירו כדף פוסטים) | ברירת מחדל |

### הגדרות קריאה
**הגדרות > קריאה:**
- דף ראשי: הדף שיצרתם (דף הבית)
- דף פוסטים: הדף "בלוג"

### תפריט
**מראה > תפריטים:**
1. צרו תפריט חדש
2. הוסיפו: ראשי, מי אנחנו, שירותים, עבודות, בלוג
3. סמנו "Primary Menu" כמיקום
4. שמרו

### לוגו
**מראה > התאמה אישית > זהות האתר:**
- העלו לוגו (רקע שקוף, PNG מומלץ)
- גובה מומלץ: 40-50px

### שירותים (Custom Post Type)
**שירותים > הוסף חדש:**
- כותרת: שם השירות
- תוכן: תיאור מפורט
- אייקון: אימוג'י (בתיבה הצדדית)
- קטגוריה: בחרו קטגוריה
- תמונה ראשית: אופציונלי

### מקרי בוחן (Case Studies)
**מקרי בוחן > הוסף חדש:**
- כותרת: שם הפרויקט
- תוכן: תיאור מלא
- פרטי מקרה בוחן: שם לקוח, תעשייה, משך, תוצאות
- תמונה ראשית: תמונה של הפרויקט

### צוות
**צוות > הוסף חדש:**
- כותרת: שם חבר הצוות
- תפקיד: בתיבה הצדדית
- תמונה ראשית: תמונת פרופיל (400x400)

## שימוש עם Elementor

התמה תומכת ב-Elementor Theme Builder:

- **Header/Footer**: ניתן ליצור Header ו-Footer מותאמים דרך Elementor
- **תבנית Canvas**: דף ריק לחלוטין (ללא Header/Footer) — מתאים לדפי נחיתה
- **תבנית רוחב מלא**: עם Header/Footer אבל ללא מגבלות רוחב
- **Single Templates**: ניתן לעצב templates מותאמים לפוסטים, שירותים ומקרי בוחן

### דפים עם Elementor
לכל דף רגיל (page.php) — אם הדף נבנה עם Elementor, התמה מזהה זאת אוטומטית ומציגה את התוכן ללא wrapper נוסף.

## מבנה הקבצים

```
fresh-theme/
├── style.css              # סגנונות מלאים (2845+ שורות)
├── functions.php          # הגדרות, CPTs, meta boxes, AJAX
├── header.php             # ניווט ראשי
├── footer.php             # פוטר 4 עמודות
├── front-page.php         # דף הבית (11 סקשנים)
├── page-about.php         # עמוד מי אנחנו
├── page-services.php      # עמוד שירותים
├── page-contact.php       # עמוד צור קשר
├── page-portfolio.php     # עמוד הצלחות לקוחות
├── single-fresh_service.php     # שירות בודד
├── single-fresh_case_study.php  # מקרה בוחן בודד
├── home.php               # דף רשימת הבלוג
├── single.php             # פוסט בודד
├── archive.php            # ארכיון
├── 404.php                # דף שגיאה
├── page.php               # דף ברירת מחדל (+ Elementor)
├── index.php              # Fallback
├── screenshot.png         # תצוגה מקדימה
├── page-templates/
│   ├── canvas.php         # Elementor Canvas
│   └── full-width.php     # רוחב מלא
└── assets/
    └── js/main.js         # JavaScript ראשי
```

## גופנים
התמה טוענת אוטומטית מ-Google Fonts:
- **Heebo** — טקסט ראשי (עברית)
- **Secular One** — כותרות (עברית)
- **Playfair Display** — אקסנטים (אנגלית)

## טופס יצירת קשר
טופס AJAX מובנה בדף צור קשר. הטופס שולח מייל דרך `wp_mail()`.
ניתן להחליף בטופס Contact Form 7 או WPForms אם רוצים.

## רישיון
GPL v2 or later
