<?php
/**
 * Fallback template
 */
get_header();
?>

<section class="page-hero">
  <div class="container">
    <h1>FRESH</h1>
    <p class="subtitle">הסוכנות הדיגיטלית למסעדנות</p>
  </div>
</section>

<section class="blog-listing">
  <div class="container">
    <?php if ( have_posts() ) : ?>
    <div class="blog-grid">
      <?php while ( have_posts() ) : the_post(); ?>
      <div class="blog-card reveal">
        <a href="<?php the_permalink(); ?>">
          <div class="thumb">
            <?php if ( has_post_thumbnail() ) the_post_thumbnail( 'fresh-blog' ); ?>
          </div>
        </a>
        <div class="content">
          <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
          <p class="excerpt"><?php echo esc_html( get_the_excerpt() ); ?></p>
          <div class="meta"><span><?php echo get_the_date(); ?></span></div>
        </div>
      </div>
      <?php endwhile; ?>
    </div>
    <div class="pagination">
      <?php echo paginate_links( array( 'prev_text' => '→', 'next_text' => '←' ) ); ?>
    </div>
    <?php endif; ?>
  </div>
</section>

<?php get_footer(); ?>
