<?php
/**
 * Template Name: הצלחת לקוחות
 * Client Success Stories page — managed via FRESH Manager
 */
get_header();
$g = 'portfolio_settings';
?>

<!-- Hero -->
<section class="page-hero">
  <div class="container">
    <?php fresh_breadcrumb(); ?>
    <h1>
      <?php echo esc_html( fm( $g, 'hero_title', 'הצלחת' ) ); ?>
      <span class="gold"><?php echo esc_html( fm( $g, 'hero_title_gold', 'לקוחות' ) ); ?></span>
    </h1>
    <p class="subtitle"><?php echo esc_html( fm( $g, 'hero_subtitle', 'הנה כמה מהפרויקטים שאנחנו הכי גאים בהם.' ) ); ?></p>
    <p class="portfolio-invite-text">לחצו על כל פרויקט כדי לגלות את הסיפור המלא - מאיפה התחלנו, מה עשינו, ואיך הפכנו אתגרים לתוצאות.</p>
  </div>
</section>

<!-- Portfolio Listing -->
<section class="portfolio-listing">
  <div class="container">
    <?php
    // --- Plugin stories first → CPT fallback → hardcoded ---
    $plugin_stories = freshm_get_stories();
    ?>

    <?php if ( ! empty( $plugin_stories ) ) : ?>

    <div class="portfolio-listing-grid">
      <?php foreach ( $plugin_stories as $ps ) :
        $main_result = ! empty( $ps['metrics'][0] ) ? $ps['metrics'][0]['number'] . ' ' . $ps['metrics'][0]['label'] : '';
      ?>
      <a href="<?php echo esc_url( home_url( '/client-success/' . $ps['slug'] . '/' ) ); ?>" class="portfolio-card reveal">
        <div class="portfolio-image">
          <?php if ( ! empty( $ps['image'] ) ) : ?>
            <img src="<?php echo esc_url( $ps['image'] ); ?>" alt="<?php echo esc_attr( $ps['name'] ); ?>" loading="lazy">
          <?php else : ?>
            <div class="placeholder-img">📸</div>
          <?php endif; ?>
          <?php if ( ! empty( $ps['logo'] ) ) : ?>
            <span class="card-logo-badge"><img src="<?php echo esc_url( $ps['logo'] ); ?>" alt=""></span>
          <?php endif; ?>
        </div>
        <div class="portfolio-overlay">
          <div class="portfolio-meta"><?php echo esc_html( $ps['industry'] ?: 'הצלחת לקוח' ); ?></div>
          <h3><?php echo esc_html( $ps['name'] ); ?></h3>
          <?php if ( ! empty( $ps['excerpt'] ) ) : ?><p class="portfolio-excerpt"><?php echo esc_html( wp_trim_words( $ps['excerpt'], 12 ) ); ?></p><?php endif; ?>
          <?php if ( $main_result ) : ?><p class="portfolio-stat"><?php echo esc_html( $main_result ); ?></p><?php endif; ?>
        </div>
      </a>
      <?php endforeach; ?>
    </div>

    <?php else : ?>

    <div class="portfolio-listing-grid">
      <?php
      $per_page = intval( fm( $g, 'per_page', '12' ) ) ?: 12;
      $pq = new WP_Query( array(
          'post_type'      => 'fresh_case_study',
          'posts_per_page' => $per_page,
          'orderby'        => 'date',
          'order'          => 'DESC',
      ) );
      if ( $pq->have_posts() ) :
        while ( $pq->have_posts() ) : $pq->the_post();
          $industry    = get_post_meta( get_the_ID(), 'industry', true );
          $main_result = get_post_meta( get_the_ID(), 'main_result', true );
          $client      = get_post_meta( get_the_ID(), 'client_name', true );
      ?>
      <a href="<?php the_permalink(); ?>" class="portfolio-card reveal">
        <div class="portfolio-image">
          <?php if ( has_post_thumbnail() ) the_post_thumbnail( 'fresh-portfolio' ); else echo '<div class="placeholder-img">📸</div>'; ?>
        </div>
        <div class="portfolio-overlay">
          <div class="portfolio-meta"><?php echo esc_html( $industry ?: 'הצלחת לקוח' ); ?></div>
          <h3><?php echo esc_html( $client ?: get_the_title() ); ?></h3>
          <?php if ( $main_result ) : ?><p class="portfolio-stat"><?php echo esc_html( $main_result ); ?></p><?php endif; ?>
        </div>
      </a>
      <?php endwhile; wp_reset_postdata();
      else :
        $fallback = array(
            array( 'ROMA TLV', 'מסעדה איטלקית', '+280% בהזמנות אונליין' ),
            array( 'SAKURA', 'מסעדת סושי', '+450% עוקבים באינסטגרם' ),
            array( 'GREEN QUEEN', 'בריאות וטבעוני', '-40% בעמלות משלוחים' ),
            array( 'BURGER NATION', 'המבורגריה', '+180% בהכנסות חודשיות' ),
            array( 'NOIR CAFÉ', 'בית קפה', '+320% בלידים מגוגל' ),
            array( 'SWEET SPOT', 'קונדיטוריה', '+200% במכירות אונליין' ),
        );
        foreach ( $fallback as $fp ) :
      ?>
      <div class="portfolio-card reveal">
        <div class="portfolio-image"><div class="placeholder-img">📸</div></div>
        <div class="portfolio-overlay">
          <div class="portfolio-meta"><?php echo esc_html( $fp[1] ); ?></div>
          <h3><?php echo esc_html( $fp[0] ); ?></h3>
          <p class="portfolio-stat"><?php echo esc_html( $fp[2] ); ?></p>
        </div>
      </div>
      <?php endforeach; endif; ?>
    </div>
    <?php endif; ?>
  </div>
</section>

<!-- CTA -->
<section class="cta">
  <div class="container">
    <div class="section-label reveal"><?php echo esc_html( fm( $g, 'cta_label', 'רוצים להיות הבאים?' ) ); ?></div>
    <h2 class="reveal reveal-delay-1">
      <?php echo esc_html( fm( $g, 'cta_title', 'המסעדה שלכם' ) ); ?><br>
      <span class="gold"><?php echo esc_html( fm( $g, 'cta_title_gold', 'יכולה להיות כאן' ) ); ?></span>
    </h2>
    <p class="section-subtitle reveal reveal-delay-2"><?php echo esc_html( fm( $g, 'cta_subtitle', 'בואו נספר גם את הסיפור שלכם.' ) ); ?></p>
    <div class="cta-buttons reveal reveal-delay-3">
      <a href="#" class="btn-primary" data-popup="contact">קבעו שיחה ←</a>
      <a href="<?php echo esc_url( freshm_whatsapp_url() ); ?>" class="btn-outline">WhatsApp</a>
    </div>
  </div>
</section>

<?php get_footer(); ?>
