<?php
/**
 * Default page template
 * Works with Elementor — if the page is built with Elementor,
 * it will use the_content() which outputs the Elementor layout.
 */
get_header();
?>

<?php while ( have_posts() ) : the_post(); ?>

<?php
// Check if this page is built with Elementor
$is_elementor = false;
if ( class_exists( '\Elementor\Plugin' ) ) {
    $is_elementor = \Elementor\Plugin::$instance->documents->get( get_the_ID() ) &&
                    \Elementor\Plugin::$instance->documents->get( get_the_ID() )->is_built_with_elementor();
}
?>

<?php if ( $is_elementor ) : ?>
  <!-- Elementor-built page — output raw content -->
  <div class="elementor-page-content">
    <?php the_content(); ?>
  </div>
<?php else : ?>
  <!-- Standard WordPress page -->
  <section class="page-hero">
    <div class="container">
      <?php fresh_breadcrumb(); ?>
      <h1><?php the_title(); ?></h1>
    </div>
  </section>

  <section style="padding: 4rem 0 6rem;">
    <div class="container">
      <div class="post-body">
        <?php the_content(); ?>
      </div>
    </div>
  </section>
<?php endif; ?>

<?php endwhile; ?>

<?php get_footer(); ?>
