<?php
/**
 * Service Category Archive — managed via FRESH Manager
 * Each category has its own landing page with hero, problem, services grid, process, stats, FAQ, and CTA.
 */
get_header();

$term = get_queried_object();
$slug = $term->slug ?? '';
$data = function_exists( 'freshm_get_category_page_data' ) ? freshm_get_category_page_data( $slug ) : array();

// Defaults
$hero_icon     = $data['hero_icon'] ?? '';
$hero_title    = $data['hero_title'] ?? $term->name;
$hero_subtitle = $data['hero_subtitle'] ?? $term->description;
$hero_bg       = $data['hero_bg_image'] ?? '';

$problem_title   = $data['problem_title'] ?? 'הבעיה שאנחנו פותרים';
$problem_content = $data['problem_content'] ?? '';

$process = $data['process'] ?? array();
$stats   = $data['stats'] ?? array();
$faq     = $data['faq'] ?? array();

$cta_title    = $data['cta_title'] ?? 'מוכנים להתחיל?';
$cta_subtitle = $data['cta_subtitle'] ?? 'שיחת אפיון ראשונה ללא עלות.';
$cta_btn_text = $data['cta_btn_text'] ?? 'דברו איתנו ←';
$cta_btn_url  = $data['cta_btn_url'] ?? '#';
$cta_whatsapp = $data['cta_show_whatsapp'] ?? '1';
?>

<!-- 1. Hero Section -->
<section class="page-hero category-hero"<?php if ( $hero_bg ) echo ' style="background-image:url(' . esc_url( $hero_bg ) . ');background-size:cover;background-position:center;"'; ?>>
  <div class="container">
    <div class="breadcrumb">
      <a href="<?php echo esc_url( home_url() ); ?>">ראשי</a>
      <span class="separator">›</span>
      <a href="<?php echo esc_url( home_url( '/services/' ) ); ?>">שירותים</a>
      <span class="separator">›</span>
      <span><?php echo esc_html( $term->name ); ?></span>
    </div>
    <?php if ( $hero_icon ) : ?>
      <div class="category-hero-icon"><?php echo esc_html( $hero_icon ); ?></div>
    <?php endif; ?>
    <h1><?php echo esc_html( $hero_title ); ?></h1>
    <?php if ( $hero_subtitle ) : ?>
      <p class="subtitle"><?php echo wp_kses_post( $hero_subtitle ); ?></p>
    <?php endif; ?>
  </div>
</section>

<?php if ( $problem_content ) : ?>
<!-- 2. The Problem -->
<section class="category-problem">
  <div class="container">
    <div class="section-label reveal"><?php echo esc_html( $problem_title ); ?></div>
    <div class="category-problem-content reveal reveal-delay-1">
      <?php echo wp_kses_post( wpautop( $problem_content ) ); ?>
    </div>
  </div>
</section>
<?php endif; ?>

<!-- 3. Sub-Services Grid -->
<section class="category-subservices">
  <div class="container">
    <div class="section-label reveal">השירותים שלנו בתחום</div>
    <div class="services-grid">
      <?php
      $services = new WP_Query( array(
          'post_type'      => 'fresh_service',
          'posts_per_page' => 20,
          'orderby'        => 'menu_order',
          'order'          => 'ASC',
          'tax_query'      => array(
              array(
                  'taxonomy' => 'service_category',
                  'field'    => 'slug',
                  'terms'    => $slug,
              ),
          ),
      ) );
      if ( $services->have_posts() ) :
        while ( $services->have_posts() ) : $services->the_post();
          $svc_icon = get_post_meta( get_the_ID(), 'service_icon', true );
          $svc_slug = get_post_field( 'post_name', get_the_ID() );
      ?>
      <a href="<?php the_permalink(); ?>" class="service-card reveal">
        <div class="service-icon">
          <?php
          if ( function_exists( 'freshm_render_service_icon' ) ) {
              $svc_data = freshm_get_service_by_slug( $svc_slug );
              if ( $svc_data ) {
                  echo freshm_render_service_icon( $svc_data, 'default' );
              } elseif ( $svc_icon ) {
                  echo esc_html( $svc_icon );
              } else {
                  echo '🎯';
              }
          } elseif ( $svc_icon ) {
              echo esc_html( $svc_icon );
          } else {
              echo '🎯';
          }
          ?>
        </div>
        <h3><?php the_title(); ?></h3>
        <?php if ( has_excerpt() ) : ?>
          <p><?php echo esc_html( wp_trim_words( get_the_excerpt(), 20 ) ); ?></p>
        <?php endif; ?>
        <span class="arrow">←</span>
      </a>
      <?php endwhile; wp_reset_postdata();
      else : ?>
      <p class="category-no-services">שירותים בתחום זה יתווספו בקרוב.</p>
      <?php endif; ?>
    </div>
  </div>
</section>

<?php if ( ! empty( $process ) ) : ?>
<!-- 4. Work Process -->
<section class="process category-process">
  <div class="container">
    <div class="process-header">
      <div class="section-label reveal">איך זה עובד</div>
      <h2 class="reveal reveal-delay-1">תהליך העבודה</h2>
    </div>
    <div class="process-steps" style="grid-template-columns:repeat(<?php echo min( count( $process ), 5 ); ?>, 1fr);">
      <?php foreach ( $process as $i => $step ) : ?>
      <div class="process-step reveal reveal-delay-<?php echo min( $i + 1, 4 ); ?>">
        <div class="step-number"><?php echo $i + 1; ?></div>
        <h3><?php echo esc_html( $step['title'] ); ?></h3>
        <p><?php echo wp_kses_post( $step['description'] ); ?></p>
      </div>
      <?php endforeach; ?>
    </div>
  </div>
</section>
<?php endif; ?>

<!-- Statistics section removed -->

<?php if ( ! empty( $faq ) ) : ?>
<!-- 6. FAQ Section -->
<section class="category-faq">
  <div class="container">
    <div class="section-label reveal" style="justify-content:center;">שאלות נפוצות</div>
    <h2 class="reveal reveal-delay-1" style="text-align:center;margin-bottom:3rem;">שאלות ותשובות</h2>
    <div class="faq-list">
      <?php foreach ( $faq as $i => $item ) : ?>
      <div class="faq-item reveal">
        <button class="faq-question" aria-expanded="false" onclick="this.parentElement.classList.toggle('open');this.setAttribute('aria-expanded',this.parentElement.classList.contains('open'))">
          <span><?php echo esc_html( $item['question'] ); ?></span>
          <span class="faq-toggle">+</span>
        </button>
        <div class="faq-answer">
          <?php echo wp_kses_post( wpautop( $item['answer'] ) ); ?>
        </div>
      </div>
      <?php endforeach; ?>
    </div>
  </div>
</section>

<!-- FAQ JSON-LD Schema -->
<script type="application/ld+json">
<?php
$faq_schema = array(
    '@context'   => 'https://schema.org',
    '@type'      => 'FAQPage',
    'mainEntity' => array(),
);
foreach ( $faq as $item ) {
    $faq_schema['mainEntity'][] = array(
        '@type' => 'Question',
        'name'  => $item['question'],
        'acceptedAnswer' => array(
            '@type' => 'Answer',
            'text'  => wp_strip_all_tags( $item['answer'] ),
        ),
    );
}
echo wp_json_encode( $faq_schema, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT );
?>
</script>

<!-- BreadcrumbList Schema -->
<script type="application/ld+json">
<?php
echo wp_json_encode( array(
    '@context'        => 'https://schema.org',
    '@type'           => 'BreadcrumbList',
    'itemListElement' => array(
        array( '@type' => 'ListItem', 'position' => 1, 'name' => 'ראשי', 'item' => home_url() ),
        array( '@type' => 'ListItem', 'position' => 2, 'name' => 'שירותים', 'item' => home_url( '/services/' ) ),
        array( '@type' => 'ListItem', 'position' => 3, 'name' => $term->name ),
    ),
), JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT );
?>
</script>
<?php endif; ?>

<!-- 7. CTA Section -->
<section class="cta">
  <div class="container">
    <h2 class="reveal">
      <?php echo esc_html( $cta_title ); ?>
    </h2>
    <p class="section-subtitle reveal reveal-delay-1"><?php echo wp_kses_post( $cta_subtitle ); ?></p>
    <div class="cta-buttons reveal reveal-delay-2">
      <?php if ( $cta_btn_url === '#' || empty( $cta_btn_url ) ) : ?>
        <a href="#" class="btn-primary" data-popup="contact"><?php echo esc_html( $cta_btn_text ); ?></a>
      <?php else : ?>
        <a href="<?php echo esc_url( $cta_btn_url ); ?>" class="btn-primary"><?php echo esc_html( $cta_btn_text ); ?></a>
      <?php endif; ?>
      <?php if ( $cta_whatsapp === '1' && function_exists( 'freshm_whatsapp_url' ) ) : ?>
        <a href="<?php echo esc_url( freshm_whatsapp_url() ); ?>" class="btn-outline" target="_blank" rel="noopener">WhatsApp</a>
      <?php endif; ?>
    </div>
  </div>
</section>

<?php get_footer(); ?>
